# 图形子系统<a name="ZH-CN_TOPIC_0000001051979319"></a>

-   [简介](#section5243712115918)
-   [目录](#section99241319175914)
-   [约束](#section122137242350)
-   [说明](#section112385733715)
    -   [使用说明](#section1072312133813)

-   [相关仓](#section1371113476307)

## 简介<a name="section5243712115918"></a>

图形子系统主要包括UI组件、布局、动画、字体、输入事件、窗口管理、渲染绘制等模块，构建基于轻量OS的应用框架，满足硬件资源较小的物联网设备的OpenHarmony系统应用开发。

**图 1**  图形子系统架构图<a name="fig1415618517242"></a>  
![](figures/图形子系统架构图.png "图形子系统架构图")

各模块介绍：

-   View：应用组件，包括UIView、UIViewGoup、UIButton、UILabel、UILabelButton、UIList、UISlider等。
-   Animator：动画模块，开发者可以自定义动画。
-   Layout：布局控件，包括Flexlayout、GridLayout、ListLayout等。
-   Transform：图形变换模块，包括旋转、平移、缩放等。
-   Event：事件模块，包括click、press、drag、long press等基础事件。
-   Rendering engine：渲染绘制模块。
-   2D graphics library：2D绘制模块，包括直线、矩形、圆、弧、图片、文字等绘制。包括软件绘制和硬件加速能力对接。
-   Multi-language：多语言模块，用于处理不用不同语言文字的换行、整形等。
-   Image library：图片处理模块，用于解析和操作不同类型和格式的图片，例如png、jpeg、ARGB8888、ARGB565等
-   WindowManager：窗口管理模块，包括窗口创建、显示隐藏、合成等处理。
-   InputManager：输入事件管理模块。

## 目录<a name="section99241319175914"></a>

```
/foundation/graphic
├── surface  # 共享内存
├── ui       # UI模块，包括UI控件、动画、字体等功能
├── utils    # 图形基础库和硬件适配层
└── wms      # 窗口管理和输入事件管理
```

## 约束<a name="section122137242350"></a>

-   图形组件不支持多线程并发操作，建议相关操作都在ui线程中执行；
-   utils/interfaces/innerkits/graphic\_config.h文件列举了图形部分可配置功能的宏开关，需要在编译前配置，配置时需要注意部分宏开关是分平台配置的。

## 说明<a name="section112385733715"></a>

### 使用说明<a name="section1072312133813"></a>

参考各仓README以及test目录

## 相关仓<a name="section1371113476307"></a>

[graphic_utils](https://gitee.com/openharmony/graphic_utils/blob/master/README_zh.md)

[graphic_wms](https://gitee.com/openharmony/graphic_wms/blob/master/README_zh.md)

[graphic_surface](https://gitee.com/openharmony/graphic_surface/blob/master/README_zh.md)

[graphic_ui](https://gitee.com/openharmony/graphic_ui/blob/master/README_zh.md)