# 编译构建常见问题<a name="ZH-CN_TOPIC_0000001060804832"></a>

-   [由于ninja版本问题导致编译失败](#section1019152312222)
-   [由于ncurses库缺失导致编译失败](#section21449422618)
-   [由于未安装mcopy导致编译失败](#section12477184992615)
-   [由于权限问题导致编译失败](#section178451337202716)
-   [由于未安装Crypto导致编译失败](#section1241481172819)
-   [由于编译环境为shell导致编译失败](#section3691222152919)

## 由于ninja版本问题导致编译失败<a name="section1019152312222"></a>

-   **现象描述：**

    编译失败，提示“usr/sbin/ninja: invalid option -- w”。

-   **可能原因：**

    编译环境中ninja版本太低，不支持--w选项。

-   **解决办法：**

    卸载环境中ninja和gn，按照HarmonyOS官网[获取工具](../get-code/获取工具.md)。


## 由于ncurses库缺失导致编译失败<a name="section21449422618"></a>

-   **现象描述：**

    编译失败，提示“/usr/bin/ld: cannot find -lncurses”。

-   **可能原因：**

    编译环境ncurses库缺失。

-   **解决办法：**

    ```
    sudo apt-get install lib32ncurses5-dev
    ```


## 由于未安装mcopy导致编译失败<a name="section12477184992615"></a>

-   **现象描述：**

    ​编译失败，提示“line 77: mcopy: command not found”。

-   **可能原因：**

    编译环境未安装mcopy。

-   **解决办法：**

    ```
    ​sudo apt-get install dosfstools mtools
    ```


## 由于权限问题导致编译失败<a name="section178451337202716"></a>

-   **现象描述：**

    编译失败，提示“riscv32-unknown-elf-gcc: error trying to exec 'cc1': execvp: No such file or directory”。

-   ​**可能原因：**

    当前用户对riscv编译器路径下的文件访问权限不够。

-   ​**解决办法：**
    1.  查询hcc\_riscv32所在目录。

        ```
        which riscv32-unknown-elf-gcc
        ```

    2.  使用chmod命令修改目录权限为755。


## 由于未安装Crypto导致编译失败<a name="section1241481172819"></a>

-   **现象描述：**

    编译失败，提示“No module named 'Crypto'”。

-   **可能原因：**

    python3未安装Crypto。

-   **解决办法：**
    1.  查询Python版本号。

        ```
        python3 --version
        ```

    2.  需使用python3.7以上版本，然后安装pycryptodome。

        ```
        sudo pip3 install pycryptodome
        ```



## 由于编译环境为shell导致编译失败<a name="section3691222152919"></a>

-   **现象描述：**

    编译失败：“xx.sh \[: xx unexpected operator”。

-   **可能原因：**

    编译环境shell不是bash。

-   **解决办法：**

    ```
    sudo rm -rf /bin/sh
    sudo ln -s /bin/bash /bin/sh
    ```


