# 搭建系统基础环境<a name="ZH-CN_TOPIC_0000001121152509"></a>

-   [环境要求](#section466851916410)
    -   [软硬件要求](#section1595725202314)
    -   [Windows开发工具要求](#section2833173411317)
    -   [Linux构建工具要求](#section992619473117)

-   [安装Windows开发环境](#section1995840162515)
-   [安装Linux编译环境（方法一：Docker方式）](#section107932281315)
-   [安装Linux编译环境（方法二：安装包方式）](#section497484245614)
    -   [连接Linux服务器](#section723115618340)
    -   [将Linux shell改为bash](#section1715027152617)
    -   [安装Python环境](#section11255767343)
    -   [安装gn](#section9262166183410)
    -   [安装ninja](#section02645617348)
    -   [安装LLVM](#section149564754)
    -   [安装hb](#section6201103143120)

-   [获取源码](#section1545225464016)
-   [常见问题](#section19253140111619)
    -   [hb安装过程中出现乱码、段错误](#section347685141717)


在搭建各个开发板环境前，需要完成OpenHarmony系统基础环境搭建。系统基础环境主要是指OpenHarmony的编译环境和开发环境。系统基础环境搭建分为如下几种方式，请根据实际软硬件情况以及个人喜好选择以下任一方式。

-   **搭建方式一**

    Windows开发环境，Linux  Docker方式搭建的编译环境，请参考本文档如下章节：


1.  [环境要求](#section466851916410)
2.  [安装Windows开发环境](#section1995840162515)
3.  [安装Linux编译环境（方法一：Docker方式）](#section107932281315)

-   **搭建方式二**

    Windows开发环境，Linux 安装包方式搭建的编译环境，请参考本文档如下章节：


1.  [环境要求](#section466851916410)
2.  [安装Windows开发环境](#section1995840162515)
3.  [安装Linux编译环境（方法二：安装包方式）](#section497484245614)

-   **搭建方式三**

    Linux开发环境，Linux编译环境，请参考《HUAWEI DevEco Device Tool 使用指南》的[安装Linux开发和编译环境](https://device.harmonyos.com/cn/docs/ide/user-guides/install_ubuntu-0000001072959308)。


## 环境要求<a name="section466851916410"></a>

### 软硬件要求<a name="section1595725202314"></a>

**表 1**  开发平台要求

<a name="tc50585b2b3fe43f7835154789b0e25af"></a>
<table><thead align="left"><tr id="ra9df6acc53154b819d5f86d885d994de"><th class="cellrowborder" valign="top" width="14.63%" id="mcps1.2.5.1.1"><p id="a999bb40532eb4f74a7383e1e776bb94a"><a name="a999bb40532eb4f74a7383e1e776bb94a"></a><a name="a999bb40532eb4f74a7383e1e776bb94a"></a>硬件</p>
</th>
<th class="cellrowborder" valign="top" width="14.149999999999999%" id="mcps1.2.5.1.2"><p id="ae63cf791fbe348d3b907d20fc4927df8"><a name="ae63cf791fbe348d3b907d20fc4927df8"></a><a name="ae63cf791fbe348d3b907d20fc4927df8"></a>软件</p>
</th>
<th class="cellrowborder" valign="top" width="57.410000000000004%" id="mcps1.2.5.1.3"><p id="a54c4c80c43c84cb187342865a1d2b51e"><a name="a54c4c80c43c84cb187342865a1d2b51e"></a><a name="a54c4c80c43c84cb187342865a1d2b51e"></a>描述</p>
</th>
<th class="cellrowborder" valign="top" width="13.81%" id="mcps1.2.5.1.4"><p id="a11e8d096fb204378a63d8805cd6d1f88"><a name="a11e8d096fb204378a63d8805cd6d1f88"></a><a name="a11e8d096fb204378a63d8805cd6d1f88"></a>备注</p>
</th>
</tr>
</thead>
<tbody><tr id="row1136907203"><td class="cellrowborder" valign="top" width="14.63%" headers="mcps1.2.5.1.1 "><p id="a8e99fd0262cb4489b70cf86c2144c294"><a name="a8e99fd0262cb4489b70cf86c2144c294"></a><a name="a8e99fd0262cb4489b70cf86c2144c294"></a>Windows工作台（主机电脑）</p>
</td>
<td class="cellrowborder" valign="top" width="14.149999999999999%" headers="mcps1.2.5.1.2 "><p id="a44d6164ce2e9421f9ade362f600c2815"><a name="a44d6164ce2e9421f9ade362f600c2815"></a><a name="a44d6164ce2e9421f9ade362f600c2815"></a>操作系统</p>
</td>
<td class="cellrowborder" valign="top" width="57.410000000000004%" headers="mcps1.2.5.1.3 "><p id="a1c17349e334a44ada5c5f150457fe17d"><a name="a1c17349e334a44ada5c5f150457fe17d"></a><a name="a1c17349e334a44ada5c5f150457fe17d"></a>Windows XP/Windows7/Windows10</p>
</td>
<td class="cellrowborder" rowspan="2" valign="top" width="13.81%" headers="mcps1.2.5.1.4 "><p id="a4d0e2c8444484554ab58949ce322be32"><a name="a4d0e2c8444484554ab58949ce322be32"></a><a name="a4d0e2c8444484554ab58949ce322be32"></a>开发人员可以在Windows工作台中进行程序开发，或者远程登录到Linux服务器进行程序开发。</p>
</td>
</tr>
<tr id="row117591159175819"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="a0c1290183f2548898dbfc516a4db2c4b"><a name="a0c1290183f2548898dbfc516a4db2c4b"></a><a name="a0c1290183f2548898dbfc516a4db2c4b"></a>Linux编译服务器</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="a687efa8001f140488dc1da9a2ee8f6d1"><a name="a687efa8001f140488dc1da9a2ee8f6d1"></a><a name="a687efa8001f140488dc1da9a2ee8f6d1"></a>操作系统</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.3 "><p id="ace724e00c9094eccb8c600d6ad426ed8"><a name="ace724e00c9094eccb8c600d6ad426ed8"></a><a name="ace724e00c9094eccb8c600d6ad426ed8"></a>Ubuntu16.04及以上64位系统版本，Shell使用bash。</p>
<div class="note" id="note124531828194919"><a name="note124531828194919"></a><a name="note124531828194919"></a><span class="notetitle"> 说明： </span><div class="notebody"><p id="p1244243142810"><a name="p1244243142810"></a><a name="p1244243142810"></a>通常系统默认安装samba、vim等常用软件，需要做适当适配以支持linux文件共享。</p>
</div></div>
</td>
</tr>
</tbody>
</table>

### Windows开发工具要求<a name="section2833173411317"></a>

**表 2**  Windows工作台开发工具及获取途径

<a name="table1313323311274"></a>
<table><thead align="left"><tr id="row3133133312711"><th class="cellrowborder" valign="top" width="27.12%" id="mcps1.2.4.1.1"><p id="p16132203372716"><a name="p16132203372716"></a><a name="p16132203372716"></a>开发工具</p>
</th>
<th class="cellrowborder" valign="top" width="36.86%" id="mcps1.2.4.1.2"><p id="p1413219339278"><a name="p1413219339278"></a><a name="p1413219339278"></a>用途</p>
</th>
<th class="cellrowborder" valign="top" width="36.02%" id="mcps1.2.4.1.3"><p id="p17133183312711"><a name="p17133183312711"></a><a name="p17133183312711"></a>获取途径</p>
</th>
</tr>
</thead>
<tbody><tr id="row138432533451"><td class="cellrowborder" valign="top" width="27.12%" headers="mcps1.2.4.1.1 "><p id="p163612016916"><a name="p163612016916"></a><a name="p163612016916"></a>Visual Studio Code</p>
</td>
<td class="cellrowborder" valign="top" width="36.86%" headers="mcps1.2.4.1.2 "><p id="p1563690791"><a name="p1563690791"></a><a name="p1563690791"></a>代码编辑工具。</p>
</td>
<td class="cellrowborder" valign="top" width="36.02%" headers="mcps1.2.4.1.3 "><p id="p146361701097"><a name="p146361701097"></a><a name="p146361701097"></a><a href="https://code.visualstudio.com/" target="_blank" rel="noopener noreferrer">https://code.visualstudio.com/</a></p>
</td>
</tr>
<tr id="row12133123315277"><td class="cellrowborder" valign="top" width="27.12%" headers="mcps1.2.4.1.1 "><p id="p613393317271"><a name="p613393317271"></a><a name="p613393317271"></a>HUAWEI DevEco Device Tool</p>
</td>
<td class="cellrowborder" valign="top" width="36.86%" headers="mcps1.2.4.1.2 "><p id="p10133193310276"><a name="p10133193310276"></a><a name="p10133193310276"></a>IDE开发工具，支持WLAN模组的代码编写、远程编译、版本烧录、串口调试等功能。</p>
<div class="note" id="note7133193392718"><a name="note7133193392718"></a><a name="note7133193392718"></a><span class="notetitle"> 说明： </span><div class="notebody"><p id="p1133183310277"><a name="p1133183310277"></a><a name="p1133183310277"></a>HUAWEI DevEco Device Tool是<span id="text4133533192719"><a name="text4133533192719"></a><a name="text4133533192719"></a>OpenHarmony</span>面向智能设备开发者提供的一站式集成开发环境，支持<span id="text4133933162719"><a name="text4133933162719"></a><a name="text4133933162719"></a>OpenHarmony</span>的组件按需定制，支持C/C++语言，以插件的形式部署在Visual Studio Code上。</p>
</div></div>
</td>
<td class="cellrowborder" valign="top" width="36.02%" headers="mcps1.2.4.1.3 "><p id="p1240954393114"><a name="p1240954393114"></a><a name="p1240954393114"></a><a href="https://device.harmonyos.com/cn/ide" target="_blank" rel="noopener noreferrer">https://device.harmonyos.com/cn/ide</a></p>
</td>
</tr>
<tr id="row18342145821513"><td class="cellrowborder" valign="top" width="27.12%" headers="mcps1.2.4.1.1 "><p id="p123421958131517"><a name="p123421958131517"></a><a name="p123421958131517"></a>IPOP、PuTTY或其他超级终端（选其一）</p>
</td>
<td class="cellrowborder" valign="top" width="36.86%" headers="mcps1.2.4.1.2 "><p id="p18342658131511"><a name="p18342658131511"></a><a name="p18342658131511"></a>远程连接Linux编译服务器，连接模组串口工具。</p>
</td>
<td class="cellrowborder" valign="top" width="36.02%" headers="mcps1.2.4.1.3 "><p id="p17342125851518"><a name="p17342125851518"></a><a name="p17342125851518"></a>通过互联网获取（如：<a href="https://www.putty.org/" target="_blank" rel="noopener noreferrer">https://www.putty.org/</a>）</p>
</td>
</tr>
</tbody>
</table>

### Linux构建工具要求<a name="section992619473117"></a>

Linux服务器通用环境配置需要的工具及其获取途径如下表所示。

**表 3**  Linux服务器开发工具及获取途径

<a name="table6299192712513"></a>
<table><thead align="left"><tr id="row122993276512"><th class="cellrowborder" valign="top" width="25.562556255625562%" id="mcps1.2.4.1.1"><p id="p1829914271858"><a name="p1829914271858"></a><a name="p1829914271858"></a>开发工具</p>
</th>
<th class="cellrowborder" valign="top" width="20.7020702070207%" id="mcps1.2.4.1.2"><p id="p429918274517"><a name="p429918274517"></a><a name="p429918274517"></a>用途</p>
</th>
<th class="cellrowborder" valign="top" width="53.73537353735374%" id="mcps1.2.4.1.3"><p id="p12997271757"><a name="p12997271757"></a><a name="p12997271757"></a>获取途径</p>
</th>
</tr>
</thead>
<tbody><tr id="row430016273514"><td class="cellrowborder" valign="top" width="25.562556255625562%" headers="mcps1.2.4.1.1 "><p id="p330015271158"><a name="p330015271158"></a><a name="p330015271158"></a>Python3.7+</p>
</td>
<td class="cellrowborder" valign="top" width="20.7020702070207%" headers="mcps1.2.4.1.2 "><p id="p43003270510"><a name="p43003270510"></a><a name="p43003270510"></a>编译构建工具</p>
</td>
<td class="cellrowborder" valign="top" width="53.73537353735374%" headers="mcps1.2.4.1.3 "><p id="p18254155164617"><a name="p18254155164617"></a><a name="p18254155164617"></a><a href="https://www.python.org/ftp/python/3.8.5/Python-3.8.5.tgz" target="_blank" rel="noopener noreferrer">https://www.python.org/ftp/python/3.8.5/Python-3.8.5.tgz</a></p>
</td>
</tr>
<tr id="row42668197206"><td class="cellrowborder" valign="top" width="25.562556255625562%" headers="mcps1.2.4.1.1 "><p id="p426711912014"><a name="p426711912014"></a><a name="p426711912014"></a>bash</p>
</td>
<td class="cellrowborder" valign="top" width="20.7020702070207%" headers="mcps1.2.4.1.2 "><p id="p14267131962014"><a name="p14267131962014"></a><a name="p14267131962014"></a>命令处理器</p>
</td>
<td class="cellrowborder" valign="top" width="53.73537353735374%" headers="mcps1.2.4.1.3 "><p id="p14267101962014"><a name="p14267101962014"></a><a name="p14267101962014"></a>通过互联网获取</p>
</td>
</tr>
<tr id="row1711946154018"><td class="cellrowborder" valign="top" width="25.562556255625562%" headers="mcps1.2.4.1.1 "><p id="p15588165684216"><a name="p15588165684216"></a><a name="p15588165684216"></a>gn</p>
</td>
<td class="cellrowborder" valign="top" width="20.7020702070207%" headers="mcps1.2.4.1.2 "><p id="p4588135634213"><a name="p4588135634213"></a><a name="p4588135634213"></a>产生ninja编译脚本</p>
</td>
<td class="cellrowborder" valign="top" width="53.73537353735374%" headers="mcps1.2.4.1.3 "><p id="p14131813191712"><a name="p14131813191712"></a><a name="p14131813191712"></a><a href="https://repo.huaweicloud.com/harmonyos/compiler/gn/1717/linux/gn-linux-x86-1717.tar.gz" target="_blank" rel="noopener noreferrer">https://repo.huaweicloud.com/harmonyos/compiler/gn/1717/linux/gn-linux-x86-1717.tar.gz</a></p>
</td>
</tr>
<tr id="row16990164213404"><td class="cellrowborder" valign="top" width="25.562556255625562%" headers="mcps1.2.4.1.1 "><p id="p1858825613428"><a name="p1858825613428"></a><a name="p1858825613428"></a>ninja</p>
</td>
<td class="cellrowborder" valign="top" width="20.7020702070207%" headers="mcps1.2.4.1.2 "><p id="p15844174611816"><a name="p15844174611816"></a><a name="p15844174611816"></a>执行ninja编译脚本</p>
</td>
<td class="cellrowborder" valign="top" width="53.73537353735374%" headers="mcps1.2.4.1.3 "><p id="p1923373393515"><a name="p1923373393515"></a><a name="p1923373393515"></a><a href="https://repo.huaweicloud.com/harmonyos/compiler/ninja/1.9.0/linux/ninja.1.9.0.tar" target="_blank" rel="noopener noreferrer">https://repo.huaweicloud.com/harmonyos/compiler/ninja/1.9.0/linux/ninja.1.9.0.tar</a></p>
</td>
</tr>
<tr id="row7531362055"><td class="cellrowborder" valign="top" width="25.562556255625562%" headers="mcps1.2.4.1.1 "><p id="p15217227174016"><a name="p15217227174016"></a><a name="p15217227174016"></a>LLVM</p>
</td>
<td class="cellrowborder" valign="top" width="20.7020702070207%" headers="mcps1.2.4.1.2 "><p id="p122171727184019"><a name="p122171727184019"></a><a name="p122171727184019"></a>编译工具链</p>
</td>
<td class="cellrowborder" valign="top" width="53.73537353735374%" headers="mcps1.2.4.1.3 "><p id="p871055810226"><a name="p871055810226"></a><a name="p871055810226"></a><a href="https://repo.huaweicloud.com/harmonyos/compiler/clang/9.0.0-36191/linux/llvm-linux-9.0.0-36191.tar" target="_blank" rel="noopener noreferrer">https://repo.huaweicloud.com/harmonyos/compiler/clang/9.0.0-36191/linux/llvm-linux-9.0.0-36191.tar</a></p>
</td>
</tr>
<tr id="row1644079184919"><td class="cellrowborder" valign="top" width="25.562556255625562%" headers="mcps1.2.4.1.1 "><p id="p744115914493"><a name="p744115914493"></a><a name="p744115914493"></a>hb</p>
</td>
<td class="cellrowborder" valign="top" width="20.7020702070207%" headers="mcps1.2.4.1.2 "><p id="p1244114913492"><a name="p1244114913492"></a><a name="p1244114913492"></a>编译构建命令行工具</p>
</td>
<td class="cellrowborder" valign="top" width="53.73537353735374%" headers="mcps1.2.4.1.3 "><p id="p1244120916499"><a name="p1244120916499"></a><a name="p1244120916499"></a>HarmonyOS源码build_lite仓</p>
</td>
</tr>
</tbody>
</table>

## 安装Windows开发环境<a name="section1995840162515"></a>

OpenHarmony IDE工具DevEco Device Tool集成了终端工具的能力，工具的安装步骤请参考[DevEco Device Tool环境搭建](https://device.harmonyos.com/cn/docs/ide/user-guides/install_windows-0000001050164976)、[创建新工程](https://device.harmonyos.com/cn/docs/ide/user-guides/create_project-0000001072200151)等完成。

## 安装Linux编译环境（方法一：Docker方式）<a name="section107932281315"></a>

Linux编译环境可以通过Docker方式快速安装，具体请参见[Docker方式获取编译环境](../get-code/获取工具.md)的“搭建Docker环境”。

## 安装Linux编译环境（方法二：安装包方式）<a name="section497484245614"></a>

>![](public_sys-resources/icon-notice.gif) **须知：** 
>-   如果后续通过“HPM组件方式”或“HPM包管理器命令行工具方式”获取源码，不需要安装gn、ninja编译工具。
>-   （推荐）如果后续通过“镜像站点方式”或“代码仓库方式”获取源码，需要安装gn、ninja编译工具。安装gn、ninja编译工具时，请确保编译工具的环境变量路径唯一。

### 连接Linux服务器<a name="section723115618340"></a>

使用Windows远程登录Linux，以PUTTY工具为例：

1.  打开[PuTTY工具](https://www.putty.org/)，输入Linux服务器IP地址，后点击“open”，打开连接。

    **图 1**  PuTTY界面示例图<a name="f825e6d7569cc487db9b744e454c7157a"></a>  
    ![](figures/PuTTY界面示例图.png "PuTTY界面示例图")

2.  弹框告警选择“是\(Y\)”。
3.  弹出界面中输入帐号并按回车键，继续输入密码并回车键。

    **图 2**  登录界面图<a name="fe1428afffbdd45f9b4a39497691ff5ff"></a>  
    ![](figures/登录界面图.png "登录界面图")

4.  登录成功。

    **图 3**  登录成功界面<a name="f11bea69483e14bd39fef4a10b1ed1a3a"></a>  
    ![](figures/登录成功界面.png "登录成功界面")


### 将Linux shell改为bash<a name="section1715027152617"></a>

查看shell是否为bash，在终端运行如下命令

```
ls -l /bin/sh
```

如果显示为“/bin/sh -\> bash”则为正常，否则请按以下方式修改：

**方法一**：在终端运行如下命令，然后选择 no。

```
sudo dpkg-reconfigure dash
```

**方法二**：先删除sh，再创建软链接。

```
sudo rm -rf /bin/sh
sudo ln -s /bin/bash /bin/sh
```

### 安装Python环境<a name="section11255767343"></a>

1.  打开Linux编译服务器终端。
2.  输入如下命令，查看python版本号，需使用python3.7以上版本。

    ```
    python3 --version
    ```

    如果低于python3.7版本，不建议直接升级，请按照如下步骤重新安装。以python3.8为例，按照以下步骤安装python。

    1.  运行如下命令，查看Ubuntu版本：

    ```
    cat /etc/issue
    ```

    1.  根据Ubuntu不同版本，安装python。
        -   如果Ubuntu 版本为18+，运行如下命令。

            ```
            sudo apt-get install python3.8
            ```

        -   如果Ubuntu版本为16，请以下载包的方式安装python。

            1.  python安装环境依赖\(gcc, g++, make, zlib, libffi\)请运行如下命令：

            ```
            sudo apt-get install gcc && sudo apt-get install g++ && sudo apt-get install make && sudo apt-get install zlib* && sudo apt-get install libffi-dev
            ```

            1.  获取[python3.8.5安装包](https://www.python.org/ftp/python/3.8.5/Python-3.8.5.tgz)，将其放至linux服务器中，运行如下命令 ：

            ```
            tar -xvzf Python-3.8.5.tgz && cd Python-3.8.5 && sudo ./configure && sudo make && sudo make install
            ```



3.  确定python安装好后，将python路径链接到"/usr/bin/python"。

    输入如下命令，查看python是否正确软链接到python3.8。

    ```
    python --version
    ```

    如果回显不是python 3.8.5，则运行如下命令，查看python3.8所在目录：

    ```
    which python3.8
    ```

    将以下命令中的 "python3.8-path" 替换为 "which python3.8" 命令执行后的回显路径

    ```
    cd /usr/bin && sudo rm python && sudo rm python3 && sudo ln -s python3.8-path python && sudo ln -s python3.8-path python3 && python3 --version
    ```

4.  安装并升级Python包管理工具（pip3），任选如下一种方式。
    -   **命令行方式：**

        ```
        sudo apt-get install python3-setuptools python3-pip -y
        sudo pip3 install --upgrade pip
        ```

    -   **安装包方式：**

        ```
        curl https://bootstrap.pypa.io/get-pip.py -o get-pip.py
        python get-pip.py
        ```


5.  运行如下命令，安装python模块setuptools。

    ```
    pip3 install setuptools
    ```

6.  安装GUI menuconfig工具（Kconfiglib），建议安装Kconfiglib 13.2.0+版本，任选如下一种方式。
    -   **命令行方式：**

        ```
        sudo pip3 install kconfiglib
        ```


    -   **安装包方式：**
        1.  下载.whl文件（例如：kconfiglib-13.2.0-py2.py3-none-any.whl）。

            下载路径：“[https://pypi.org/project/kconfiglib\#files](https://pypi.org/project/kconfiglib#files)”


        1.  运行如下命令，安装.whl文件。

            ```
            sudo pip3 install kconfiglib-13.2.0-py2.py3-none-any.whl
            ```



7.  <a name="li195884268616"></a>安装pycryptodome，任选如下一种方式。

    >![](public_sys-resources/icon-notice.gif) **须知：** 
    >此[步骤7](#li195884268616)\~[步骤9](#li125926111510)仅Hi3861开发板需要安装，Hi3516、Hi3518开发板无需安装。

    安装升级文件签名依赖的Python组件包，包括：pycryptodome、six、ecdsa。安装ecdsa依赖six，请先安装six，再安装ecdsa。

    -   **命令行方式：**

        ```
        sudo pip3 install pycryptodome
        ```

    -   **安装包方式：**
        1.  下载.whl文件（例如：pycryptodome-3.9.9-cp38-cp38-manylinux1\_x86\_64.whl）。

            下载路径：“[https://pypi.org/project/pycryptodome/\#files](https://pypi.org/project/pycryptodome/#files)”。


        1.  运行如下命令，安装.whl文件。

            ```
            sudo pip3 install pycryptodome-3.9.9-cp38-cp38-manylinux1_x86_64.whl
            ```



8.  安装six，任选如下一种方式。
    -   **命令行方式：**

        ```
        sudo pip3 install six --upgrade --ignore-installed six
        ```


    -   **安装包方式：**
        1.  下载.whl文件（例如：six-1.12.0-py2.py3-none-any.whl）。

            下载路径：“[https://pypi.org/project/six/\#files](https://pypi.org/project/six/#files)”


        1.  运行如下命令，安装.whl文件。

            ```
            sudo pip3 install six-1.12.0-py2.py3-none-any.whl
            ```



9.  <a name="li125926111510"></a>安装ecdsa，任选如下一种方式。
    -   **命令行方式：**

        ```
        sudo pip3 install ecdsa
        ```

    -   **安装包方式：**
        1.  下载.whl文件（例如：ecdsa-0.14.1-py2.py3-none-any.whl）。

            下载路径：“[https://pypi.org/project/ecdsa/\#files](https://pypi.org/project/ecdsa/#files)”


        1.  运行如下命令，安装.whl文件。

            ```
            sudo pip3 install ecdsa-0.14.1-py2.py3-none-any.whl
            ```




### 安装gn<a name="section9262166183410"></a>

1.  打开Linux编译服务器终端。
2.  [下载gn工具](https://repo.huaweicloud.com/harmonyos/compiler/gn/1717/linux/gn-linux-x86-1717.tar.gz)。
3.  在根目录下创建gn文件夹。

    ```
    mkdir ~/gn
    ```

4.  解压gn安装包至\~/gn路径下。

    ```
    tar -xvf gn-linux-x86-1717.tar.gz -C ~/gn
    ```

5.  设置环境变量。

    ```
    vim ~/.bashrc
    ```

    将以下命令拷贝到.bashrc文件的最后一行，保存并退出。

    ```
    export PATH=~/gn:$PATH
    ```

6.  生效环境变量。

    ```
    source ~/.bashrc
    ```


### 安装ninja<a name="section02645617348"></a>

1.  打开Linux编译服务器终端。
2.  [下载ninja工具](https://repo.huaweicloud.com/harmonyos/compiler/ninja/1.9.0/linux/ninja.1.9.0.tar)。
3.  解压ninja安装包至\~/ninja路径下。

    ```
    tar -xvf ninja.1.9.0.tar -C ~/
    ```

4.  设置环境变量。

    ```
    vim ~/.bashrc
    ```

    将以下命令拷贝到.bashrc文件的最后一行，保存并退出。

    ```
    export PATH=~/ninja:$PATH
    ```

5.  生效环境变量。

    ```
    source ~/.bashrc
    ```


### 安装LLVM<a name="section149564754"></a>

1.  打开Linux编译服务器终端。
2.  [下载LLVM工具](https://repo.huaweicloud.com/harmonyos/compiler/clang/9.0.0-36191/linux/llvm-linux-9.0.0-36191.tar)。
3.  解压LLVM安装包至\~/llvm路径下。

    ```
    tar -xvf llvm-linux-9.0.0-36191.tar -C ~/
    ```

4.  设置环境变量。

    ```
    vim ~/.bashrc
    ```

    将以下命令拷贝到.bashrc文件的最后一行，保存并退出。

    ```
    export PATH=~/llvm/bin:$PATH
    ```

5.  生效环境变量。

    ```
    source ~/.bashrc
    ```


### 安装hb<a name="section6201103143120"></a>

**前提条件**

-   请先安装Python 3.7.4及以上，请见[安装Python环境](#section11255767343)步骤1\~4。
-   下载源码，请见[源码获取](../get-code/源码获取.md)。

**安装方法**

1.  在源码根目录下执行：

    ```
    python3 -m pip install --user build/lite
    ```

2.  设置环境变量

    ```
    vim ~/.bashrc
    ```

    将以下命令拷贝到.bashrc文件的最后一行，保存并退出。

    ```
    export PATH=~/.local/bin:$PATH
    ```

    执行如下命令更新环境变量。

    ```
    source ~/.bashrc
    ```

3.  执行hb -h有相关帮助信息，有打印信息即表示安装成功：

    ```
    usage: hb
    
    OHOS build system
    
    positional arguments:
      {build,set,env,clean}
        build               Build source code
        set                 OHOS build settings
        env                 Show OHOS build env
        clean               Clean output
    
    optional arguments:
      -h, --help            show this help message and exit
    ```


**卸载方法：**

```
python3 -m pip uninstall ohos-build
```

>![](public_sys-resources/icon-note.gif) **说明：** 
>如果安装hb的过程中遇到问题，请参见下文[常见问题](#section19253140111619)进行解决。

## 获取OpenHarmony源码<a name="section1545225464016"></a>

开发者需要在Linux服务器上下载并解压一套源代码，获取OpenHarmony 源码（[下载链接](https://repo.huaweicloud.com/harmonyos/os/1.0.1/code-1.0.1.tar.gz)）。更多源码获取方式，请见[源码获取](../get-code/源码获取.md)。

## 常见问题<a name="section19253140111619"></a>

### hb安装过程中出现乱码、段错误<a name="section347685141717"></a>

-   **现象描述**

    执行“python3 -m pip install --user build/lite”出现乱码、段错误（segmentation fault）。


-   **可能原因**

    pip版本过低。

-   **解决办法**

    执行如下命令升级pip。

    ```
    python3 -m pip install -U pip
    ```


