# 进程<a name="ZH-CN_TOPIC_0000001051612194"></a>

-   [基本概念](#section29197338383)
-   [使用场景](#section85513272398)
-   [功能](#section4517119124015)

## 基本概念<a name="section29197338383"></a>

从系统的角度看，进程是资源管理单元。进程可以使用或等待CPU、使用内存空间等系统资源，并独立于其它进程运行。

OpenHarmony内核的进程模块可以给用户提供多个进程，实现了进程之间的切换和通信，帮助用户管理业务程序流程。这样用户可以将更多的精力投入到业务功能的实现中。

OpenHarmony内核中的进程采用抢占式调度机制，支持时间片轮转调度方式。

OpenHarmony内核的进程一共有32个优先级\(0-31\)，用户进程可配置的优先级有22个\(10-31\)，最高优先级为10，最低优先级为31。

高优先级的进程可抢占低优先级进程，低优先级进程必须在高优先级进程阻塞或结束后才能得到调度。

每一个用户态进程均拥有自己独立的进程空间，相互之间不可见，实现进程间隔离。

用户态根进程init由内核态创建，其它用户态进程均由init进程fork而来。

**进程状态说明：**

-   初始化（Init）：该进程正在被创建。

-   就绪（Ready）：该进程在就绪列表中，等待CPU调度。

-   运行（Running）：该进程正在运行。

-   阻塞（Pending）：该进程被阻塞挂起。本进程内所有的线程均被阻塞时，进程被阻塞挂起。

-   僵尸态（Zombies）：该进程运行结束，等待父进程回收其控制块资源。


**图 1**  进程状态迁移示意图<a name="fig1877059202911"></a>  
![](figures/进程状态迁移示意图.png "进程状态迁移示意图")

**进程状态迁移说明：**

-   Init→Ready：

    进程创建或fork时，拿到该进程控制块后进入Init状态，处于进程初始化阶段，当进程初始化完成将进程插入调度队列，此时进程进入就绪状态。

-   Ready→Running：

    进程创建后进入就绪态，发生进程切换时，就绪列表中最高优先级的进程被执行，从而进入运行态。若此时该进程中已无其它线程处于就绪态，则该进程从就绪列表删除，只处于运行态；若此时该进程中还有其它线程处于就绪态，则该进程依旧在就绪队列，此时进程的就绪态和运行态共存。

-   Running→Pending：

    进程内所有的线程均处于阻塞态时，进程在最后一个线程转为阻塞态时，同步进入阻塞态，然后发生进程切换。

-   Pending→Ready：

    阻塞进程内的任意线程恢复就绪态时，进程被加入到就绪队列，同步转为就绪态，若此时发生进程切换，则进程状态由就绪态转为运行态。

-   Ready→Pending：

    进程内的最后一个就绪态线程处于阻塞态时，进程从就绪列表中删除，进程由就绪态转为阻塞态。

-   Running→Ready：

    进程由运行态转为就绪态的情况有以下两种：

    1.  有更高优先级的进程创建或者恢复后，会发生进程调度，此刻就绪列表中最高优先级进程变为运行态，那么原先运行的进程由运行态变为就绪态。
    2.  若进程的调度策略为SCHED\_RR，且存在同一优先级的另一个进程处于就绪态，则该进程的时间片消耗光之后，该进程由运行态转为就绪态，另一个同优先级的进程由就绪态转为运行态。

-   Running→Zombies：

    当进程的主线程或所有线程运行结束后，进程由运行态转为僵尸态，等待父进程回收资源。


## 使用场景<a name="section85513272398"></a>

进程创建后，用户只能操作自己进程空间的资源，无法操作其它进程的资源（共享资源除外）。 用户态允许进程挂起，恢复，延时等操作，同时也可以设置用户态进程调度优先级和调度策略，获取进程调度优先级和调度策略。进程结束的时候，进程会主动释放持有的进程资源，但持有的进程pid资源需要父进程通过wait/waitpid或父进程退出时回收。

## 功能<a name="section4517119124015"></a>

OpenHarmony内核系统中的进程管理模块为用户提供下面几种功能：

**表 1**  进程管理模块功能

<a name="table12130144215441"></a>
<table><thead align="left"><tr id="row630210427446"><th class="cellrowborder" valign="top" width="13.08%" id="mcps1.2.5.1.1"><p id="p1430244284410"><a name="p1430244284410"></a><a name="p1430244284410"></a>功能分类</p>
</th>
<th class="cellrowborder" valign="top" width="23.09%" id="mcps1.2.5.1.2"><p id="p9302164284416"><a name="p9302164284416"></a><a name="p9302164284416"></a>接口名</p>
</th>
<th class="cellrowborder" valign="top" width="28.82%" id="mcps1.2.5.1.3"><p id="p730211427445"><a name="p730211427445"></a><a name="p730211427445"></a>描述</p>
</th>
<th class="cellrowborder" valign="top" width="35.010000000000005%" id="mcps1.2.5.1.4"><p id="p1430214294419"><a name="p1430214294419"></a><a name="p1430214294419"></a>备注</p>
</th>
</tr>
</thead>
<tbody><tr id="row12302642134414"><td class="cellrowborder" rowspan="13" valign="top" width="13.08%" headers="mcps1.2.5.1.1 "><p id="p430213427443"><a name="p430213427443"></a><a name="p430213427443"></a>进程</p>
</td>
<td class="cellrowborder" valign="top" width="23.09%" headers="mcps1.2.5.1.2 "><p id="p10302154219449"><a name="p10302154219449"></a><a name="p10302154219449"></a>fork</p>
</td>
<td class="cellrowborder" valign="top" width="28.82%" headers="mcps1.2.5.1.3 "><p id="p930218420449"><a name="p930218420449"></a><a name="p930218420449"></a>创建一个新进程。</p>
</td>
<td class="cellrowborder" valign="top" width="35.010000000000005%" headers="mcps1.2.5.1.4 "><p id="p230224211440"><a name="p230224211440"></a><a name="p230224211440"></a>-</p>
</td>
</tr>
<tr id="row20302154218442"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="p130314204419"><a name="p130314204419"></a><a name="p130314204419"></a>exit</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="p53031426443"><a name="p53031426443"></a><a name="p53031426443"></a>终止进程。</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.3 "><p id="p113034423445"><a name="p113034423445"></a><a name="p113034423445"></a>-</p>
</td>
</tr>
<tr id="row930314421443"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="p13303124213442"><a name="p13303124213442"></a><a name="p13303124213442"></a>atexit</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="p1330324210442"><a name="p1330324210442"></a><a name="p1330324210442"></a>注册正常进程终止的回调函数。</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.3 "><p id="p3303144264414"><a name="p3303144264414"></a><a name="p3303144264414"></a>-</p>
</td>
</tr>
<tr id="row113039426449"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="p1630394220444"><a name="p1630394220444"></a><a name="p1630394220444"></a>abort</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="p133037421441"><a name="p133037421441"></a><a name="p133037421441"></a>中止进程执行。</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.3 "><p id="p1330334216449"><a name="p1330334216449"></a><a name="p1330334216449"></a>-</p>
</td>
</tr>
<tr id="row1330317422445"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="p113036427441"><a name="p113036427441"></a><a name="p113036427441"></a>getpid</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="p17303642194412"><a name="p17303642194412"></a><a name="p17303642194412"></a>获取进程ID。</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.3 "><p id="p14304942104420"><a name="p14304942104420"></a><a name="p14304942104420"></a>-</p>
</td>
</tr>
<tr id="row3304204254412"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="p1430404218442"><a name="p1430404218442"></a><a name="p1430404218442"></a>getppid</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="p9304134217443"><a name="p9304134217443"></a><a name="p9304134217443"></a>获取父进程ID。</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.3 "><p id="p1530418423449"><a name="p1530418423449"></a><a name="p1530418423449"></a>-</p>
</td>
</tr>
<tr id="row610863618327"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="p110811368324"><a name="p110811368324"></a><a name="p110811368324"></a>getpgrp</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="p51091436133217"><a name="p51091436133217"></a><a name="p51091436133217"></a>获取调用进程的进程组ID。</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.3 "><p id="p31094364326"><a name="p31094364326"></a><a name="p31094364326"></a>-</p>
</td>
</tr>
<tr id="row2379940183217"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="p1380184016329"><a name="p1380184016329"></a><a name="p1380184016329"></a>getpgid</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="p8121101872215"><a name="p8121101872215"></a><a name="p8121101872215"></a>获取进程的进程组ID。</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.3 "><p id="p63802401326"><a name="p63802401326"></a><a name="p63802401326"></a>-</p>
</td>
</tr>
<tr id="row1981395963412"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="p4814559123412"><a name="p4814559123412"></a><a name="p4814559123412"></a>setpgrp</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="p171226183225"><a name="p171226183225"></a><a name="p171226183225"></a>设置调用进程的进程组ID。</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.3 "><p id="p8814959123416"><a name="p8814959123416"></a><a name="p8814959123416"></a>-</p>
</td>
</tr>
<tr id="row194862793516"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="p5948162703511"><a name="p5948162703511"></a><a name="p5948162703511"></a>setpgid</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="p7122131852218"><a name="p7122131852218"></a><a name="p7122131852218"></a>设置进程的进程组ID。</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.3 "><p id="p1994915279352"><a name="p1994915279352"></a><a name="p1994915279352"></a>-</p>
</td>
</tr>
<tr id="row10304742114410"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="p530474264418"><a name="p530474264418"></a><a name="p530474264418"></a>kill</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="p2304174213441"><a name="p2304174213441"></a><a name="p2304174213441"></a>给进程发送信号。</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.3 "><a name="ul949915272011"></a><a name="ul949915272011"></a><ul id="ul949915272011"><li>仅支持1-30号信号的发送。</li><li>信号的默认行为不支持STOP及CONTINUE，无COREDUMP功能。</li><li>不能屏蔽SIGSTOP、SIGKILL、SIGCONT。</li><li>异步信号，发送信号给某进程后，直到该进程被调度后才会执行信号回调（为安全起见，杀死进程的动作是进程自己执行的，内核不能通过信号强制杀死对方）。</li><li>进程消亡会发送SIGCHLD给父进程，发送动作无法取消。</li><li>无法通过信号唤醒正在睡眠的进程。</li></ul>
</td>
</tr>
<tr id="row1430454210446"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="p830494212443"><a name="p830494212443"></a><a name="p830494212443"></a>wait</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="p230464294410"><a name="p230464294410"></a><a name="p230464294410"></a>等待任意子进程结束并回收子进程资源。</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.3 "><p id="p12512337347"><a name="p12512337347"></a><a name="p12512337347"></a>status的值可以由以下宏定义解析：</p>
<a name="ul13349201524417"></a><a name="ul13349201524417"></a><ul id="ul13349201524417"><li>WIFEXITED(status):如果子进程正常结束，它就返回真；否则返回假。</li><li>WEXITSTATUS(status):如果WIFEXITED(status)为真，则可以用该宏取得子进程exit()返回的退出码。</li><li>WTERMSIG(status) 仅支持以下情况：子进程触发异常结束后通过WTERMSIG获取的进程退出编号始终为SIGUSR2。</li><li>不支持的操作： WIFSTOPPED、WSTOPSIG、WCOREDUMP 、WIFCONTINUED。</li></ul>
</td>
</tr>
<tr id="row13041742134416"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="p1530434217444"><a name="p1530434217444"></a><a name="p1530434217444"></a>waitpid</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="p130564294420"><a name="p130564294420"></a><a name="p130564294420"></a>等待子进程结束并回收子进程资源。</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.3 "><p id="p969785263816"><a name="p969785263816"></a><a name="p969785263816"></a>options：不支持WUNTRACED，WCONTINUED；</p>
<p id="p8497151543715"><a name="p8497151543715"></a><a name="p8497151543715"></a>status的值可以由以下宏定义解析：</p>
<a name="ul7243133164416"></a><a name="ul7243133164416"></a><ul id="ul7243133164416"><li>WIFEXITED(status):如果子进程正常结束，它就返回真；否则返回假。</li><li>WEXITSTATUS(status):如果WIFEXITED(status)为真，则可以用该宏取得子进程exit()返回的退出码。</li><li>WTERMSIG(status)仅支持以下情况：子进程触发异常结束后通过WTERMSIG获取的进程退出编号始终为SIGUSR2。</li><li>不支持：WIFSTOPPED 、WSTOPSIG、WCOREDUMP 、WIFCONTINUED。</li></ul>
</td>
</tr>
<tr id="row4305194294417"><td class="cellrowborder" rowspan="10" valign="top" width="13.08%" headers="mcps1.2.5.1.1 "><p id="p5305194264419"><a name="p5305194264419"></a><a name="p5305194264419"></a>调度</p>
</td>
<td class="cellrowborder" valign="top" width="23.09%" headers="mcps1.2.5.1.2 "><p id="p630544224416"><a name="p630544224416"></a><a name="p630544224416"></a>getpriority</p>
</td>
<td class="cellrowborder" valign="top" width="28.82%" headers="mcps1.2.5.1.3 "><p id="p174915589591"><a name="p174915589591"></a><a name="p174915589591"></a>获取指定ID的静态优先级。</p>
</td>
<td class="cellrowborder" rowspan="2" valign="top" width="35.010000000000005%" headers="mcps1.2.5.1.4 "><a name="ul185518513478"></a><a name="ul185518513478"></a><ul id="ul185518513478"><li>不支持：PRIO_PGRP、PRIO_USER。</li></ul>
<a name="ul85091358174711"></a><a name="ul85091358174711"></a><ul id="ul85091358174711"><li>无动态优先级概念，用于设置静态优先级。</li></ul>
</td>
</tr>
<tr id="row930511425448"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="p1730524217448"><a name="p1730524217448"></a><a name="p1730524217448"></a>setpriority</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="p17750205817594"><a name="p17750205817594"></a><a name="p17750205817594"></a>设置指定ID的静态优先级。</p>
</td>
</tr>
<tr id="row2305174216445"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="p7305942104417"><a name="p7305942104417"></a><a name="p7305942104417"></a>sched_rr_get_interval</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="p1362018100165"><a name="p1362018100165"></a><a name="p1362018100165"></a>获取执行时间限制。</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.3 "><p id="p5306134212447"><a name="p5306134212447"></a><a name="p5306134212447"></a>-</p>
</td>
</tr>
<tr id="row33061042104416"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="p143061642164412"><a name="p143061642164412"></a><a name="p143061642164412"></a>sched_yield</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="p1262017102164"><a name="p1262017102164"></a><a name="p1262017102164"></a>系统调用运行进程主动让出执行权。</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.3 "><p id="p14306134220441"><a name="p14306134220441"></a><a name="p14306134220441"></a>-</p>
</td>
</tr>
<tr id="row11306134234417"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="p11306184264417"><a name="p11306184264417"></a><a name="p11306184264417"></a>sched_get_priority_max</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="p123062423446"><a name="p123062423446"></a><a name="p123062423446"></a>获取进程静态优先级取值范围的最大值。</p>
</td>
<td class="cellrowborder" rowspan="4" valign="top" headers="mcps1.2.5.1.3 "><p id="p11306154210440"><a name="p11306154210440"></a><a name="p11306154210440"></a>调度策略只支持：SCHED_RR。</p>
</td>
</tr>
<tr id="row15306242124413"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="p430612427448"><a name="p430612427448"></a><a name="p430612427448"></a>sched_get_priority_min</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="p430618428442"><a name="p430618428442"></a><a name="p430618428442"></a>获取进程静态优先级取值范围的最小值。</p>
</td>
</tr>
<tr id="row730610428448"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="p230684284419"><a name="p230684284419"></a><a name="p230684284419"></a>sched_getscheduler</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="p20306184224417"><a name="p20306184224417"></a><a name="p20306184224417"></a>获取调度策略。</p>
</td>
</tr>
<tr id="row630764215441"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="p1530719424444"><a name="p1530719424444"></a><a name="p1530719424444"></a>sched_setscheduler</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="p13072042104416"><a name="p13072042104416"></a><a name="p13072042104416"></a>设置调度策略。</p>
</td>
</tr>
<tr id="row3307184274411"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="p12307114274419"><a name="p12307114274419"></a><a name="p12307114274419"></a>sched_getparam</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="p9307104210441"><a name="p9307104210441"></a><a name="p9307104210441"></a>获取调度参数。</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.3 "><p id="p163071842194417"><a name="p163071842194417"></a><a name="p163071842194417"></a>-</p>
</td>
</tr>
<tr id="row18307104210449"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="p1230784264419"><a name="p1230784264419"></a><a name="p1230784264419"></a>sched_setparam</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="p1530784215445"><a name="p1530784215445"></a><a name="p1530784215445"></a>设置调度参数。</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.3 "><p id="p730714264415"><a name="p730714264415"></a><a name="p730714264415"></a>-</p>
</td>
</tr>
<tr id="row17412918306"><td class="cellrowborder" rowspan="6" valign="top" width="13.08%" headers="mcps1.2.5.1.1 "><p id="p8528162314312"><a name="p8528162314312"></a><a name="p8528162314312"></a>exec</p>
</td>
<td class="cellrowborder" valign="top" width="23.09%" headers="mcps1.2.5.1.2 "><p id="p1951498305"><a name="p1951498305"></a><a name="p1951498305"></a>execl</p>
</td>
<td class="cellrowborder" valign="top" width="28.82%" headers="mcps1.2.5.1.3 "><p id="p1612191842215"><a name="p1612191842215"></a><a name="p1612191842215"></a>执行指定的elf格式的用户程序文件。</p>
</td>
<td class="cellrowborder" valign="top" width="35.010000000000005%" headers="mcps1.2.5.1.4 "><p id="p11679610113215"><a name="p11679610113215"></a><a name="p11679610113215"></a>-</p>
</td>
</tr>
<tr id="row16964151163015"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="p1996413117300"><a name="p1996413117300"></a><a name="p1996413117300"></a>execle</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="p104059331261"><a name="p104059331261"></a><a name="p104059331261"></a>执行指定的elf格式的用户程序文件。</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.3 "><p id="p3209101117329"><a name="p3209101117329"></a><a name="p3209101117329"></a>-</p>
</td>
</tr>
<tr id="row9418101418309"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="p741881443010"><a name="p741881443010"></a><a name="p741881443010"></a>execlp</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="p493315383264"><a name="p493315383264"></a><a name="p493315383264"></a>执行指定的elf格式的用户程序文件。</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.3 "><p id="p8741121112325"><a name="p8741121112325"></a><a name="p8741121112325"></a>-</p>
</td>
</tr>
<tr id="row2058611176305"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="p155869170309"><a name="p155869170309"></a><a name="p155869170309"></a>execv</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="p1644334112613"><a name="p1644334112613"></a><a name="p1644334112613"></a>执行指定的elf格式的用户程序文件。</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.3 "><p id="p423311211323"><a name="p423311211323"></a><a name="p423311211323"></a>-</p>
</td>
</tr>
<tr id="row182359476306"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="p202351547163016"><a name="p202351547163016"></a><a name="p202351547163016"></a>execve</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="p13152444192616"><a name="p13152444192616"></a><a name="p13152444192616"></a>执行指定的elf格式的用户程序文件。</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.3 "><p id="p148072123324"><a name="p148072123324"></a><a name="p148072123324"></a>-</p>
</td>
</tr>
<tr id="row14242145013304"><td class="cellrowborder" valign="top" headers="mcps1.2.5.1.1 "><p id="p02437507305"><a name="p02437507305"></a><a name="p02437507305"></a>execvp</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.2 "><p id="p06334469262"><a name="p06334469262"></a><a name="p06334469262"></a>执行指定的elf格式的用户程序文件。</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.5.1.3 "><p id="p333161353217"><a name="p333161353217"></a><a name="p333161353217"></a>-</p>
</td>
</tr>
</tbody>
</table>

