# 获取工具<a name="ZH-CN_TOPIC_0000001055705774"></a>

-   [Docker方式获取编译环境](#zh-cn_topic_0000001055701144_section107932281315)
    -   [基于HPM的Docker环境](#zh-cn_topic_0000001055701144_section580016182283)
    -   [独立Docker环境](#zh-cn_topic_0000001055701144_section319412277287)
    -   [搭建Docker环境](#zh-cn_topic_0000001055701144_section436042904715)
    -   [编译源码](#zh-cn_topic_0000001055701144_section19121250134716)

-   [获取设备开发工具（HUAWEI DevEco Device Tool）](#zh-cn_topic_0000001055701144_section2452141120244)
-   [获取应用开发工具（HUAWEI DevEco Studio）](#zh-cn_topic_0000001055701144_section0904101019258)

## Docker方式获取编译环境<a name="zh-cn_topic_0000001055701144_section107932281315"></a>

OpenHarmony为开发者提供了两种Docker环境，以帮助开发者快速完成复杂的开发环境准备工作。两种Docker环境及适用场景如下：

-   基于HPM的Docker环境：适用于使用HPM工具进行发行版编译的场景。
-   独立Docker环境：适用于直接基于Ubuntu、Windows操作系统平台进行版本编译的场景。

    独立Docker环境目前容器化构建选项支持情况如下：

    **表 1**  Docker镜像介绍

    <a name="zh-cn_topic_0000001055701144_table2790164495315"></a>
    <table><thead align="left"><tr id="zh-cn_topic_0000001055701144_row3790644155317"><th class="cellrowborder" valign="top" width="35.5064493550645%" id="mcps1.2.4.1.1"><p id="zh-cn_topic_0000001055701144_p8789114445316"><a name="zh-cn_topic_0000001055701144_p8789114445316"></a><a name="zh-cn_topic_0000001055701144_p8789114445316"></a>Docker镜像仓库</p>
    </th>
    <th class="cellrowborder" valign="top" width="10.258974102589741%" id="mcps1.2.4.1.2"><p id="zh-cn_topic_0000001055701144_p17896448533"><a name="zh-cn_topic_0000001055701144_p17896448533"></a><a name="zh-cn_topic_0000001055701144_p17896448533"></a>标签</p>
    </th>
    <th class="cellrowborder" valign="top" width="54.23457654234577%" id="mcps1.2.4.1.3"><p id="zh-cn_topic_0000001055701144_p1278917444539"><a name="zh-cn_topic_0000001055701144_p1278917444539"></a><a name="zh-cn_topic_0000001055701144_p1278917444539"></a>说明</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="zh-cn_topic_0000001055701144_row167901244115315"><td class="cellrowborder" valign="top" width="35.5064493550645%" headers="mcps1.2.4.1.1 "><p id="zh-cn_topic_0000001055701144_p87901744185316"><a name="zh-cn_topic_0000001055701144_p87901744185316"></a><a name="zh-cn_topic_0000001055701144_p87901744185316"></a>swr.cn-south-1.myhuaweicloud.com/openharmony-docker/openharmony-docker</p>
    </td>
    <td class="cellrowborder" valign="top" width="10.258974102589741%" headers="mcps1.2.4.1.2 "><p id="zh-cn_topic_0000001055701144_p15790184410536"><a name="zh-cn_topic_0000001055701144_p15790184410536"></a><a name="zh-cn_topic_0000001055701144_p15790184410536"></a>0.0.3</p>
    </td>
    <td class="cellrowborder" valign="top" width="54.23457654234577%" headers="mcps1.2.4.1.3 "><p id="zh-cn_topic_0000001055701144_p15790124416531"><a name="zh-cn_topic_0000001055701144_p15790124416531"></a><a name="zh-cn_topic_0000001055701144_p15790124416531"></a>已经预安装<span id="zh-cn_topic_0000001055701144_text6790444135318"><a name="zh-cn_topic_0000001055701144_text6790444135318"></a><a name="zh-cn_topic_0000001055701144_text6790444135318"></a>OpenHarmony</span>版本的编译环境，支持Hi3861/Hi3516/Hi3518三种平台的版本构建。</p>
    </td>
    </tr>
    </tbody>
    </table>


### 基于HPM的Docker环境<a name="zh-cn_topic_0000001055701144_section580016182283"></a>

docker\_dist是一个[HPM](https://hpm.harmonyos.com/)系统中的模板组件，能够帮助用户快速初始化HPM工程，利用docker镜像来快速编译OpenHarmony发行版，在很大程度上简化了编译前的环境配置。开发者在配置好Ubuntu和[hpm-cli](https://device.harmonyos.com/cn/docs/develop/bundles/oem_bundle_guide_prepare-0000001050129846)开发环境后，可以通过以下步骤来使用我们提供的Docker环境。

**搭建Docker环境**

1.  初始化安装模板。在任意工作目录中执行以下命令。

    ```
    hpm init -t @ohos/docker_dist
    ```

2.  修改publishAs。

    因为获取到的是模板类型的包，要把包的类型改为需要的类型。 在当前目录下打开bundle.json文件，把"publishAs"字段的值由"template"改为"distribution"。

3.  选择解决方案。设置解决方案发行版的环境变量。

    -   **Linux环境**

    ip\_camera\_hi3516dv300:

    ```
    export solution=@ohos/ip_camera_hi3516dv300 
    ```

    ip\_camera\_hi3518ev300:

    ```
    export solution=@ohos/ip_camera_hi3518ev300 
    ```

    wifiiot:

    ```
    export solution=@ohos/wifi_iot 
    ```

    -   **Windows环境**

    使用cmd设置：

    ```
    set solution=发行版名称 
    ```


**编译源码**

执行编译，以ip\_camera\_hi3518ev300为例。自动安装docker只能在Ubuntu环境下执行，如果其他环境，需要用户自行安装docker，然后拉取镜像，执行编译。

-   **自动安装docker（Ubuntu环境）**

    以下命令可以帮助用户自动安装docker, 拉取镜像，并且在容器中开始运行对应解决方案的拉取和编译。

    ```
    hpm run docker 
    ```

    执行成功结果如下：

    ```
    ......
    ohos ipcamera_hi3518 build success!
    @ohos/ip_camera_hi3518ev300: distribution building completed.
    ```


-   **自行安装docker（非Ubuntu环境）**

    自行安装docker相关操作如下：

    ```
    # 拉取镜像 
    docker pull swr.cn-south-1.myhuaweicloud.com/openharmony-docker/openharmony-docker:0.0.2
    # linux环境下的编译 
    hpm run distWithDocker 
    # windows下的编译，需要配置gitbash 
    hpm config set shellPath "gitbash路径"
    hpm run distWithDocker
    ```


### 独立Docker环境<a name="zh-cn_topic_0000001055701144_section319412277287"></a>

OpenHarmony的Docker镜像托管在[HuaweiCloud SWR](https://console.huaweicloud.com/swr/?region=cn-south-1#/app/warehouse/warehouseMangeDetail/goldensir/openharmony-docker/openharmony-docker?type=ownImage)上。开发者可以通过该镜像在很大程度上简化编译前的环境配置。开发者在配置好开发环境后，通过以下步骤来使用Docker环境。本Docker支持Ubuntu/Windows平台，下文将以Ubuntu系统为例进行使用介绍。

### 搭建Docker环境-轻量系统类设备（参考内存≥128KB）和小型系统类设备（参考内存≥1MB）<a name="zh-cn_topic_0000001055701144_section436042904715"></a>

**方式一：从HuaweiCloud SWR上直接获取Docker镜像进行构建：**

1.  获取Docker镜像。

    ```
    docker pull swr.cn-south-1.myhuaweicloud.com/openharmony-docker/openharmony-docker:0.0.3
    ```

2.  进入OpenHarmony代码根目录执行如下命令，从而进入Docker构建环境。

    ```
    docker run -it -v $(pwd):/home/openharmony swr.cn-south-1.myhuaweicloud.com/openharmony-docker/openharmony-docker:0.0.3
    ```


**方式二：通过Dockerfile 构建本地Docker镜像进行构建**

1.  获取Dockerfile脚本文件，用来构建本地Docker镜像。

    ```
    git clone https://gitee.com/openharmony/docs.git
    ```

2.  进入Dockerfile代码目录路径执行Docker镜像构建命令。

    ```
    cd docs/docker
    ./build.sh
    ```

3.  进入OpenHarmony代码根目录执行如下命令，从而进入Docker构建环境。

    ```
    docker run -it -v $(pwd):/home/openharmony openharmony-docker:0.0.3
    ```


### 编译源码-轻量系统类设备（参考内存≥128KB）和小型系统类设备（参考内存≥1MB）<a name="zh-cn_topic_0000001055701144_section19121250134716"></a>

通过如下编译脚本启动轻量系统类设备（参考内存≥128KB）和小型系统类设备（参考内存≥1MB）的编译。下文以Hi3516平台为例说明具体编译步骤。

1.  在源码的根目录执行如下命令安装hb。

    ```
    python3 -m pip install --user build/lite
    ```

2.  设置编译路径，选择当前路径。

    ```
    hb set
     .
    ```

    **图 1**  设置编译界面<a name="zh-cn_topic_0000001055701144_fig18712183616135"></a>  
    

    ![](figures/zh-cn_image_0000001084080634.png)

    >![](public_sys-resources/icon-note.gif) **说明：** 
    >当前开发板平台和编译界面的对应关系如下：
    >-   Hi3861：wifiiot\_hispark\_pegasus@hisilicon
    >-   Hi3516：ipcamera\_hispark\_taurus@hisilicon
    >-   Hi3518：ipcamera\_hispark\_aries@hisilicon

3.  选择ipcamera\_hispark\_taurus@hisilicon并回车。
4.  执行编译。

    ```
    hb build -f
    ```

5.  查看编译结果。

    编译结果文件生成在out/hispark\_taurus/ipcamera\_hispark\_taurus目录下。


## 获取设备开发工具（HUAWEI DevEco Device Tool）<a name="zh-cn_topic_0000001055701144_section2452141120244"></a>

HUAWEI DevEco Device Tool是HarmonyOS面向智能设备开发者提供的一站式集成开发环境，支持HarmonyOS的组件按需定制，支持代码编辑、编译、烧录、调试等功能，支持C/C++语言，以插件的形式部署在Visual Studio Code上。具体可参见[获取工具](https://device.harmonyos.com/cn/ide)和[工具使用指南](https://device.harmonyos.com/cn/docs/ide/user-guides/service_introduction-0000001050166905)**。**

## 获取应用开发工具（HUAWEI DevEco Studio）<a name="zh-cn_topic_0000001055701144_section0904101019258"></a>

HUAWEI DevEco Studio（以下简称DevEco Studio）是面向华为终端全场景多设备的一站式集成开发环境（IDE），为开发者提供工程模板创建、开发、编译、调试、发布等E2E的HarmonyOS应用开发服务。通过使用DevEco Studio，开发者可以更高效的开发具备HarmonyOS分布式能力的应用，进而提升创新效率。具体可参见[获取工具](https://developer.harmonyos.com/cn/develop/deveco-studio)和[工具使用指南](https://developer.harmonyos.com/cn/docs/documentation/doc-guides/tools_overview-0000001053582387)。

