# Compilation and Building Subsystem<a name="EN-US_TOPIC_0000001052340730"></a>

-   [Overview](#section11660541593)
-   [Directory Structure](#section1464106163817)
-   [Constraints](#section1718733212019)
-   [Usage](#section641210360552)
-   [Repositories Involved](#section6299103515474)

## Overview<a name="section11660541593"></a>

The compilation and building subsystem provides a compilation and building framework based on GN and Ninja. Using this subsystem, you can perform the following operations:

1.  Build products with different chip platforms. For example, you can build IP camera products on the Hi3518EV300 and Hi3516DV300 development boards and WLAN module product on the Hi3861 development board.
2.  Build a customized product generated by HPM configurations.

## Directory Structure<a name="section1464106163817"></a>

```
build/lite                          # Compile and build a primary directory.
├── config                       # Compile related configuration items.
│   ├── boards                  # Define variables related to a development board, including its name, target architecture, and target CPU.
│   ├── component               # Define templates related to OpenHarmony components, including static libraries, dynamic libraries, extended components, and simulator libraries.
│   ├── kernel                  # Define compilation variables of OpenHarmony kernel and configuration parameters.
│   └── subsystem               # OpenHarmony subsystem lists
├── ndk                          # Define NDK-related compilation scripts and configuration parameters.
├── platform                     # Platform-related configuration files
│   ├── hi3516dv300_liteos_a    # HI3516DV300 and LiteOS_A platforms, including the platform full configuration table and boot file.
│   ├── hi3518ev300_liteos_a    # HI3518EV300 and LiteOS_A platforms, including the platform full configuration table and boot file.
│   └── hi3861v100_liteos_riscv # HI3861V100 and LiteOS_RISCV platforms, including the platform full configuration table and boot file.
├── product                      # Product full configuration table, including the configuration unit, subsystem list, and compiler
├── toolchain                    # Compilation toolchain, including the compiler path, compilation options, and link options.
└── tools                         # Tools on which compilation and building depend, including mkfs.
```

## Constraints<a name="section1718733212019"></a>

You must preinstall GN and Ninja and add them to environment variables.

## Usage<a name="section641210360552"></a>

-   Compile an existing product.

```
# Compile the WLAN platform.
python build.py wifiiot

# Compile the IP camera based on Hi3518EV300.
python build.py ipcamera_hi3518ev300

# Compile the IP camera based on Hi3516DV300.
python build.py ipcamera_hi3516dv300
```

-   Compile components.

    This section uses a customized component as an example to describe how to compile a component, a library, and an executable file.

    The example component consists of two functions:  **feature1**  and  **feature2**.  **feature1**  is a dynamic library, and  **feature2**  is an executable file.

    The complete directory structure of the example component is as follows:

    ```
    example                        # Customized component
    ├── BUILD.gn                # GN script of a customized component. BUILD.gn is a fixed name.
    ├── feature1                # Customized unit 1
    │   ├── BUILD.gn           # GN script of the customized unit 1. BUILD.gn is a fixed name.
    │   ├── include            # Header file folder
    │   │   └── helloworld1.h # Header file 1
    │   └── src                # Source file folder
    │       └── helloworld1.c  # Source file 1
    ├── feature2                # Customized unit 2
    │   ├── BUILD.gn           # GN script of the customized unit 2. BUILD.gn is a fixed name.
    │   ├── include            # Header file folder
    │   │   └── helloworld2.h # Header file 2
    │   └── src                # Source file folder
    │       └── helloworld2.c  # Source file 2
    ├── build.sh                # build.sh script of the customized component, which is optional
    └── Makefile                # Makefile script of the customized component, which is optional
    ```

    Step 1: Compile the  **BUILD.gn**  script of a dynamic library in the  **example/feature1**  directory.

    The  **lite\_library**  template can be used to compile dynamic and static libraries. The following is an example:

    ```
    # Example of compiling the helloworld dynamic library
    # Build.gn file of helloworld
    lite_library("helloworld_lib") {
        target_type = "shared_library" # Compile a dynamic library.
        #target_type = "static_library" # Compile a static library.
        sources = [
            "src/helloworld1.c"
        ]
        include_dirs = [
            "include",
            "../feature2_example/include" # If feature2_example is required, add it to this include.
        ]
    }
    ```

    Step 2: Compile the  **BUILD.gn**  script of an executable file in the  **example/feature2**  directory.

    The executable template provided by GN can be used to compile an executable file. The following is an example:

    ```
    # Compile the executable .bin file.
    executable("hello_world_bin") {
        sources = [
            "src/helloworld.c"
        ]
        include_dirs = [
            "include",
            #"../feature2_example/include" # If feature2_example is required, add it to this include.
        ]
        # If feature1_example is required, add it to this deps.
        #deps = [
        #    "../feature1_example:helloworld1"
        #]
    }
    ```

    Step 3: Compile the  **BUILD.gn**  script of a component in the  **example/BUILD.gn**  directory.

    ```
    import("//build/lite/config/component/lite_component.gni")
    # Use the BUILD.gn script to compile the entire project.
    lite_component("example_gn") {
        features = [
            "feature_example1:helloworld_lib",
            "feature_example2:hello_world_bin",
        ]
    }
    # Integrate the built-in build.sh or Makefile project and use the gn script to call the hybrid compilation.
    build_ext_component("example_mk") {
        exec_path = rebase_path(rebase_path(".", root_build_dir))
        outdir = rebase_path(get_path_info(".", "out_dir"))
        prebuilts = "sh build.sh"
        command = "make clean && make"
    }
    ```

-   Available compilation and building variables

    The variables that can be referenced globally are defined in  **//build/lite/ohos\_var.gni**.

    [Table 1](#table3296103714372)  describes the common variables of users.

    **Table  1** 

    <a name="table3296103714372"></a>
    <table><thead align="left"><tr id="row529623712377"><th class="cellrowborder" valign="top" width="16.89%" id="mcps1.2.4.1.1"><p id="p1629723723717"><a name="p1629723723717"></a><a name="p1629723723717"></a>Variable</p>
    </th>
    <th class="cellrowborder" valign="top" width="32.98%" id="mcps1.2.4.1.2"><p id="p13297137163720"><a name="p13297137163720"></a><a name="p13297137163720"></a>Value Range</p>
    </th>
    <th class="cellrowborder" valign="top" width="50.129999999999995%" id="mcps1.2.4.1.3"><p id="p1423425618374"><a name="p1423425618374"></a><a name="p1423425618374"></a>Description</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="row14297437193710"><td class="cellrowborder" valign="top" width="16.89%" headers="mcps1.2.4.1.1 "><p id="p62978371374"><a name="p62978371374"></a><a name="p62978371374"></a>ohos_kernel_type</p>
    </td>
    <td class="cellrowborder" valign="top" width="32.98%" headers="mcps1.2.4.1.2 "><p id="p1229716378376"><a name="p1229716378376"></a><a name="p1229716378376"></a>"liteos_a", "liteos_riscv"</p>
    </td>
    <td class="cellrowborder" valign="top" width="50.129999999999995%" headers="mcps1.2.4.1.3 "><p id="p17234105673718"><a name="p17234105673718"></a><a name="p17234105673718"></a>Kernel type</p>
    </td>
    </tr>
    <tr id="row8722028184617"><td class="cellrowborder" valign="top" width="16.89%" headers="mcps1.2.4.1.1 "><p id="p773182820463"><a name="p773182820463"></a><a name="p773182820463"></a>board_name</p>
    </td>
    <td class="cellrowborder" valign="top" width="32.98%" headers="mcps1.2.4.1.2 "><p id="p20731128124612"><a name="p20731128124612"></a><a name="p20731128124612"></a>"hi3516dv300", "hi3518ev300", "hi3861v100"</p>
    </td>
    <td class="cellrowborder" valign="top" width="50.129999999999995%" headers="mcps1.2.4.1.3 "><p id="p2737281461"><a name="p2737281461"></a><a name="p2737281461"></a>Development board type</p>
    </td>
    </tr>
    <tr id="row1813718203473"><td class="cellrowborder" valign="top" width="16.89%" headers="mcps1.2.4.1.1 "><p id="p1813715200473"><a name="p1813715200473"></a><a name="p1813715200473"></a>ohos_build_compiler</p>
    </td>
    <td class="cellrowborder" valign="top" width="32.98%" headers="mcps1.2.4.1.2 "><p id="p1913713206476"><a name="p1913713206476"></a><a name="p1913713206476"></a>"gcc", "clang"</p>
    </td>
    <td class="cellrowborder" valign="top" width="50.129999999999995%" headers="mcps1.2.4.1.3 "><p id="p013732013476"><a name="p013732013476"></a><a name="p013732013476"></a>Compilation toolchain type</p>
    </td>
    </tr>
    </tbody>
    </table>

    Example: Ohos\_kernel\_type usage, component\_example/feature2\_example/BUILD.gn

    ```
    lite_library("helloworld") {
        if (ohos_kernel_type == "liteos_a") {
            target_type = "shared_library"
        }
        else if (ohos_kernel_type == "liteos_riscv") {
            target_type = "static_library"
        }
        sources = [
            "src/helloworld1.c"
        ]
        include_dirs = [
            "include"
        ]
    }
    ```


-   Solution

    After a template is downloaded from HPM, the customized full template is stored in the  **//build/lite/product**  directory.

    For example, ipcamera\_hi3516dv300.json. This file that contains the configurations of all customized subsystems and components is read.


-   Compilation output

    All files generated during compilation are stored in the  **out**  directory.

    In the directory where the code is located, run  **python build.py wifiiot**. After the WLAN compilation is complete, the following results are generated.

    ```
    out/
    └── wifiiot                                   # Product name
        ├── args.gn                               # Customized variable for gn compilation
        ├── build.log                             # Compilation log
        ├── build.ninja
        ├── build.ninja.d
        ├── gen
        ├── Hi3861_boot_signed_B.bin              # Signed bootloader backup file
        ├── Hi3861_boot_signed.bin                # Signed bootloader file
        ├── Hi3861_loader_signed.bin              # Loading file used by the burning tool
        ├── Hi3861_wifiiot_app_allinone.bin       # Production line tool burning file, including the independent burning program and loader program
        ├── Hi3861_wifiiot_app.asm                # Kernel asm file
        ├── Hi3861_wifiiot_app_burn.bin           # Burning file
        ├── Hi3861_wifiiot_app_flash_boot_ota.bin # Flash boot upgrade file
        ├── Hi3861_wifiiot_app.map               # Kernel map file
        ├── Hi3861_wifiiot_app_ota.bin           # Kernel upgrade file
        ├── Hi3861_wifiiot_app.out               # Kernel output file
        ├── Hi3861_wifiiot_app_vercfg.bin         # The boot and kernel version numbers are configured for secure boot to prevent version rollback.
        ├── libs                                  # Library folder
        ├── NOTICE_FILE
        ├── obj
        ├── suites
        └── toolchain.ninja
    Note: You are advised to use Hi3861_wifiiot_app_allinone.bin to burn files.
    ```


Run  **python build.py ipcamera\_hi3518ev300**. After IP camera\_HI3518EV300 is compiled, the following result is generated \(the same as IP camera\_HI3516DV300\).

```
out/
└── ipcamera_hi3518ev300                # Product name
    ├── args.gn                         # Customized variable for gn compilation
    ├── bin                             # Link to the folder where the bin file is located.
    ├── bm_tool.map                     # map file
    ├── build.log                      # Compilation log
    ├── build.ninja
    ├── build.ninja.d
    ├── bundle_daemon_tool.map          # map file
    ├── data                            # Configuration file of underlying resources on which the media camera depends.
    ├── dev_tools                       # R&D self-testing
    ├── foundation.map                  # map file
    ├── gen
    ├── libaudio_api.so
    ├── libs                            # Library files contained in an image
    ├── liteos.bin                      # bin file of the LiteOS basic kernel
    ├── media_server.map                # map file
    ├── NOTICE_FILE
    ├── obj                             # Binary file, which is the compilation result folder
    ├── OHOS_Image                      # .bin file for the LiteOS package without strip
    ├── OHOS_Image.asm                  # Assembly code
    ├── OHOS_Image.bin                  # Burning the .bin file for the LiteOS package
    ├── OHOS_Image.map                  # map file
    ├── rootfs.img                      # Compiled library and app image
    ├── rootfs.tar                      # Compress rootfs.tar.
    ├── suites                          # xts compilation result
    ├── test                            # Test case compilation result
    ├── toolchain.ninja
    ├── userfs                          # User-readable and writable partition
    ├── userfs.img                      # User-readable and writable partition in .img format, corresponding to the /storage directory after startup
    └── vendor                          # Firmware file and configuration file of the chip
```

## Repositories Involved<a name="section6299103515474"></a>

build\_lite

