# Application Development

- [Application Development Overview](application-dev-guide.md)
- Quick Start
  - [Getting Started with Application Development](quick-start/Readme-EN.md)
    - DevEco Studio (OpenHarmony) User Guide
      - [Overview](quick-start/deveco-studio-overview.md)
      - [Version Change History](quick-start/deveco-studio-release-notes.md)
      - [Configuring the OpenHarmony SDK](quick-start/configuring-openharmony-sdk.md)
      - [Creating an OpenHarmony Project](quick-start/create-openharmony-project.md)
        - [Using the Project Wizard to Create a Project](quick-start/use-wizard-to-create-project.md)
        - [Importing a Sample to Create a Project](quick-start/import-sample-to-create-project.md)
      - [Configuring the OpenHarmony App Signature](quick-start/configuring-openharmony-app-signature.md)
      - [Installing and Running Your OpenHarmony App](quick-start/installing-openharmony-app.md)
  - [Directory Structure](quick-start/package-structure.md)
- Development
  - UI
    - JavaScript-based Web-Like Development Paradigm
      - [Overview](ui/ui-js-overview.md)
      - Framework
        - [File Organization](ui/js-framework-file.md)
        - ["js" Tag](ui/js-framework-js-tag.md)
        - [app.js](ui/js-framework-js-file.md)
        - Syntax
          - [HML](ui/js-framework-syntax-hml.md)
          - [CSS](ui/js-framework-syntax-css.md)
          - [JavaScript](ui/js-framework-syntax-js.md)
        - [Lifecycle](ui/js-framework-lifecycle.md)
        - [Resource Limitations and Access](ui/js-framework-resource-restriction.md)
        - [Multi-Language Capability](ui/js-framework-multiple-languages.md)
      - Building the UI
        - [Component Overview](ui/ui-js-building-ui-component.md)
        - Building the Layout
          - [Layout Description](ui/ui-js-building-ui-layout-intro.md)
          - [Adding Title and Paragraph Text](ui/ui-js-building-ui-layout-text.md)
          - [Adding an Image](ui/ui-js-building-ui-layout-image.md)
          - [Adding a Comment](ui/ui-js-building-ui-layout-comment.md)
          - [Adding a Container](ui/ui-js-building-ui-layout-external-container.md)
        - [Adding Interactions](ui/ui-js-building-ui-interactions.md)
        - [Developing Animations](ui/ui-js-building-ui-animation.md)
        - [Defining Events](ui/ui-js-building-ui-event.md)
        - [Defining Page Routes](ui/ui-js-building-ui-routes.md)
      - Common Component Development Guidelines
        - [Text](ui/ui-js-components-text.md)
        - [Input](ui/ui-js-components-input.md)
        - [Button](ui/ui-js-components-button.md)
        - [List](ui/ui-js-components-list.md)
        - [Picker](ui/ui-js-components-picker.md)
        - [Dialog](ui/ui-js-components-dialog.md)
        - [Form](ui/ui-js-components-form.md)
        - [Stepper](ui/ui-js-components-stepper.md)
        - [Tabs](ui/ui-js-component-tabs.md)
        - [Image](ui/ui-js-components-images.md)
      - Animation Development Guidelines
        - CSS Animation
          - [Defining Attribute Style Animations](ui/ui-js-animate-attribute-style.md)
          - [Defining Animations with the transform Attribute](ui/ui-js-animate-transform.md)
          - [Defining Animations with the background-position Attribute](ui/ui-js-animate-background-position-style.md)
        - JS Animation
          - [Component Animation](ui/ui-js-animate-component.md)
          - Interpolator Animation
            - [Animation Effect](ui/ui-js-animate-dynamic-effects.md)
            - [Animation Frame](ui/ui-js-animate-frame.md)
      - [Custom Components](ui/ui-js-custom-components.md)
    - TypeScript-based Declarative Development Paradigm
      - [Overview](ui/ui-ts-overview.md)
      - Framework Overview
        - File Organization
          - [Directory Structure](ui/ts-framework-directory.md)
          - [Rules for Accessing Application Code Files](ui/ts-framework-file-access-rules.md)
        - ["js" Tag](ui/ts-framework-js-tag.md)
        - Resource Access
          - [Media Resource Types](ui/ts-media-resource-type.md)
        - [Pixel Units](ui/ts-pixel-units.md)
        - [Types](ui/ts-types.md)
      - Declarative Syntax
        - [Overview](ui/ts-syntax-intro.md)
        - General UI Description Specifications
          - [Basic Concepts](ui/ts-general-ui-concepts.md)
          - Declarative UI Description Specifications
            - [Parameterless Configuration](ui/ts-parameterless-configuration.md)
            - [Configuration with Mandatory Parameters](ui/ts-configuration-with-mandatory-parameters.md)
            - [Attribution Configuration](ui/ts-attribution-configuration.md)
            - [Event Configuration](ui/ts-event-configuration.md)
            - [Child Component Configuration](ui/ts-child-component-configuration.md)
          - Componentization
            - [@Component](ui/ts-component-based-component.md)
            - [@Entry](ui/ts-component-based-entry.md)
            - [@Preview](ui/ts-component-based-preview.md)
            - [@Builder](ui/ts-component-based-builder.md)
            - [@Extend](ui/ts-component-based-extend.md)
            - [@CustomDialog](ui/ts-component-based-customdialog.md)
        - About UI State Management
          - [Basic Concepts](ui/ts-ui-state-mgmt-concepts.md)
          - Managing Component States
            - [@State](ui/ts-component-states-state.md)
            - [@Prop](ui/ts-component-states-prop.md)
            - [@Link](ui/ts-component-states-link.md)
          - Managing Application States
            - [AppStorage](ui/ts-application-states-appstorage.md)
            - [PersistentStorage](ui/ts-application-states-apis-persistentstorage.md)
            - [Environment](ui/ts-application-states-apis-environment.md)
          - Managing Other States
            - [@observed and @objectLink](ui/ts-other-states-observed-objectlink.md)
            - [@Consume and @Provide](ui/ts-other-states-consume-provide.md)
            - [@Watch](ui/ts-other-states-watch.md)
        - About Rendering Control Syntax
          - [if/else](ui/ts-rending-control-syntax-if-else.md)
          - [ForEach](ui/ts-rending-control-syntax-foreach.md)
          - [LazyForEach](ui/ts-rending-control-syntax-lazyforeach.md)
        - About @Component
          - [build Function](ui/ts-function-build.md)
          - [Custom Component Initialization](ui/ts-custom-component-initialization.md)
          - [Custom Component Lifecycle Callbacks](ui/ts-custom-component-lifecycle-callbacks.md)
          - [Example: Component Creation and Re-Initialization](ui/ts-component-creation-re-initialization.md)
        - [Syntactic Sugar](ui/ts-syntactic-sugar.md)
      - Experiencing the Declarative UI
        - [Creating a Declarative UI Project](ui/ui-ts-creating-project.md)
        - [Getting to Know Components](ui/ui-ts-components.md)
        - [Creating a Simple Page](ui/ui-ts-creating-simple-page.md)
      - Defining Page Layout and Connection
        - [Building a Food Data Model](ui/ui-ts-building-data-model.md)
        - [Building a Food Category List Layout](ui/ui-ts-building-category-list-layout.md)
        - [Building a Food Category Grid Layout](ui/ui-ts-building-category-grid-layout.md)
        - [Implementing Page Redirection and Data Transmission](ui/ui-ts-page-redirection-data-transmission.md)
  - Basic Functions
    - Agent-Powered Scheduled Reminders
      - [Overview](background-agent-scheduled-reminder/background-agent-scheduled-reminder-overview.md)
      - [Development Guidelines](background-agent-scheduled-reminder/background-agent-scheduled-reminder-guide.md)
    - Background Task Management
      - [Background Task Management Overview](background-task-management/background-task-overview.md)
      - [Background Task Management Development](background-task-management/background-task-dev-guide.md)
    - WebGL
      - [WebGL Overview](webgl/webgl-overview.md)
      - [WebGL Development](webgl/webgl-guidelines.md)
    - Media
      - Audio
        - [Audio Overview](media/audio-overview.md)
        - [Audio Playback Development](media/audio-playback.md)
        - [Audio Playback Development Using AudioRenderer](media/audio-renderer.md)
        - [Audio Recording Development](media/audio-recorder.md)
        - [Audio Recorder Development Using AudioCapturer](media/audio-capturer)
      - Video
        - [Video Playback Development](media/video-playback.md)
        - [Video Recording Development](media/video-recorder.md)
    - Security
      - User Authentication
        - [User Authentication Overview](security/userauth-overview.md)
        - [User Authentication Development](security/userauth-guidelines.md)
    - Connectivity
      - IPC & RPC
        - [IPC & RPC Overview](connectivity/ipc-rpc-overview.md)
        - [IPC & RPC Development Guidelines](connectivity/ipc-rpc-development-guideline.md)
        - [Subscribing to State Changes of a Remote Object](connectivity/subscribe-remote-state.md)
    - Data Management
      - Distributed Data Service
        - [Distributed Data Service Overview](database/database-mdds-overview.md)
        - [Distributed Data Service Development](database/database-mdds-guidelines.md)
      - Relational Database Overview
        - [RDB Overview](database/database-relational-overview.md)
        - [RDB Development](database/database-relational-guidelines.md)
      - Lightweight Data Store
        - [Lightweight Data Store Overview](database/database-preference-overview.md)
        - [Lightweight Data Store Development](database/database-preference-guidelines.md)
    - Device
      - USB Service
        - [USB Service Overview](device/usb-overview.md)
        - [USB Service Development](device/usb-guidelines.md)
      - Location
        - [Location Overview](device/device-location-overview.md)
        - [Obtaining Device Location Information](device/device-location-info.md)
        - [Geocoding and Reverse Geocoding Capabilities](device/device-location-geocoding.md)
    - DFX
      - Application Event Logging
        - [Overview of Application Event Logging](dfx/hiappevent-overview.md)
        - [Development Guidelines on Application Event Logging](dfx/hiappevent-guidelines.md)
- Tools
  - DevEco Studio (OpenHarmony) User Guide
    - [Overview](quick-start/deveco-studio-overview.md)
    - [Version Change History](quick-start/deveco-studio-release-notes.md)
    - [Configuring the OpenHarmony SDK](quick-start/configuring-openharmony-sdk.md)
    - [Creating an OpenHarmony Project](quick-start/create-openharmony-project.md)
    - [Configuring the OpenHarmony App Signature](quick-start/configuring-openharmony-app-signature.md)
    - [Installing and Running Your OpenHarmony App](quick-start/installing-openharmony-app.md)
- Hands-On Tutorials
  - [Samples](https://gitee.com/openharmony/app_samples/blob/master/README.md)
- API References
  - Compent Reference (JavaScript-based Web-like Development Paradigm)
    - [Components](reference/arkui-js/js-components.md)
      - [Common](reference/arkui-js/js-components-common.md)
        - [Universal Attributes](reference/arkui-js/js-components-common-attributes.md)
        - [Universal Styles](reference/arkui-js/js-components-common-styles.md)
        - [Universal Events](reference/arkui-js/js-components-common-events.md)
        - [Universal Methods](reference/arkui-js/js-components-common-methods.md)
        - [Animation Styles](reference/arkui-js/js-components-common-animation.md)
        - [Gradient Styles](reference/arkui-js/js-components-common-gradient.md)
        - [Transition Styles](reference/arkui-js/js-components-common-transition.md)
        - [Custom Font Styles](reference/arkui-js/js-components-common-customizing-font.md)
        - [Atomic Layout](reference/arkui-js/js-components-common-atomic-layout.md)
      - [Container Component](reference/arkui-js/js-components-container.md)
        - [badge](reference/arkui-js/js-components-container-badge.md)
        - [dialog](reference/arkui-js/js-components-container-dialog.md)
        - [div](reference/arkui-js/js-components-container-div.md)
        - [form](reference/arkui-js/js-components-container-form.md)
        - [list](reference/arkui-js/js-components-container-list.md)
        - [list-item](reference/arkui-js/js-components-container-list-item.md)
        - [list-item-group](reference/arkui-js/js-components-container-list-item-group.md)
        - [panel](reference/arkui-js/js-components-container-panel.md)
        - [popup](reference/arkui-js/js-components-container-popup.md)
        - [refresh](reference/arkui-js/js-components-container-refresh.md)
        - [stack](reference/arkui-js/js-components-container-stack.md)
        - [stepper](reference/arkui-js/js-components-container-stepper.md)
        - [stepper-item](reference/arkui-js/js-components-container-stepper-item.md)
        - [swiper](reference/arkui-js/js-components-container-swiper.md)
        - [tabs](reference/arkui-js/js-components-container-tabs.md)
        - [tab-bar](reference/arkui-js/js-components-container-tab-bar.md)
        - [tab-content](reference/arkui-js/js-components-container-tab-content.md)
      - [Basic Components](reference/arkui-js/js-components-basic.md)
        - [button](reference/arkui-js/js-components-basic-button.md)
        - [chart](reference/arkui-js/js-components-basic-chart.md)
        - [divider](reference/arkui-js/js-components-basic-divider.md)
        - [image](reference/arkui-js/js-components-basic-image.md)
        - [image-animator](reference/arkui-js/js-components-basic-image-animator.md)
        - [input](reference/arkui-js/js-components-basic-input.md)
        - [label](reference/arkui-js/js-components-basic-label.md)
        - [marquee](reference/arkui-js/js-components-basic-marquee.md)
        - [menu](reference/arkui-js/js-components-basic-menu.md)
        - [option](reference/arkui-js/js-components-basic-option.md)
        - [picker](reference/arkui-js/js-components-basic-picker.md)
        - [picker-view](reference/arkui-js/js-components-basic-picker-view.md)
        - [piece](reference/arkui-js/js-components-basic-piece.md)
        - [progress](reference/arkui-js/js-components-basic-progress.md)
        - [qrcode](reference/arkui-js/js-components-basic-qrcode.md)
        - [rating](reference/arkui-js/js-components-basic-rating.md)
        - [richtext](reference/arkui-js/js-components-basic-richtext.md)
        - [search](reference/arkui-js/js-components-basic-search.md)
        - [select](reference/arkui-js/js-components-basic-select.md)
        - [slider](reference/arkui-js/js-components-basic-slider.md)
        - [span](reference/arkui-js/js-components-basic-span.md)
        - [switch](reference/arkui-js/js-components-basic-switch.md)
        - [text](reference/arkui-js/js-components-basic-text.md)
        - [textarea](reference/arkui-js/js-components-basic-textarea.md)
        - [toolbar](reference/arkui-js/js-components-basic-toolbar.md)
        - [toolbar-item](reference/arkui-js/js-components-basic-toolbar-item.md)
        - [toggle](reference/arkui-js/js-components-basic-toggle.md)
      - [Media Components](reference/arkui-js/js-components-media.md)
        - [video](reference/arkui-js/js-components-media-video.md)
      - [Canvas Components](reference/arkui-js/js-components-canvas.md)
        - [canvas](reference/arkui-js/js-components-canvas-canvas.md)
        - [CanvasRenderingContext2D](reference/arkui-js/js-components-canvas-canvasrenderingcontext2d.md)
        - [Image](reference/arkui-js/js-components-canvas-image.md)
        - [CanvasGradient](reference/arkui-js/js-components-canvas-canvasgradient.md)
        - [ImageData](reference/arkui-js/js-components-canvas-imagedata.md)
        - [Path2D](reference/arkui-js/js-components-canvas-path2d.md)
        - [ImageBitmap](reference/arkui-js/js-components-canvas-imagebitmap.md)
        - [OffscreenCanvas](reference/arkui-js/js-components-canvas-offscreencanvas.md)
        - [OffscreenCanvasRenderingContext2D](reference/arkui-js/js-offscreencanvasrenderingcontext2d.md)
      - [Grid](reference/arkui-js/js-components-grid.md)
        - [Basic Concepts](reference/arkui-js/js-components-grid-basic-concepts.md)
        - [grid-container](reference/arkui-js/js-components-grid-container.md)
        - [grid-row](reference/arkui-js/js-components-grid-row.md)
        - [grid-col](reference/arkui-js/js-components-grid-col.md)
      - [SVG Components](reference/arkui-js/js-svg.md)
        - [Universal Attributes](reference/arkui-js/js-components-svg-common-attributes.md)
        - [svg](reference/arkui-js/js-components-svg.md)
        - [rect](reference/arkui-js/js-components-svg-rect.md)
        - [circle](reference/arkui-js/js-components-svg-circle.md)
        - [ellipse](reference/arkui-js/js-components-svg-ellipse.md)
        - [path](reference/arkui-js/js-components-svg-path.md)
        - [line](reference/arkui-js/js-components-svg-line.md)
        - [polyline](reference/arkui-js/js-components-svg-polyline.md)
        - [polygon](reference/arkui-js/js-components-svg-polygon.md)
        - [text](reference/arkui-js/js-components-svg-text.md)
        - [tspan](reference/arkui-js/js-components-svg-tspan.md)
        - [textPath](reference/arkui-js/js-components-svg-textpath.md)
        - [animate](reference/arkui-js/js-components-svg-animate.md)
        - [animateMotion](reference/arkui-js/js-components-svg-animatemotion.md)
        - [animateTransform](reference/arkui-js/js-components-svg-animatetransform.md)
    - [Custom Components](reference/arkui-js/js-components-custom.md)
      - [Basic Usage](reference/arkui-js/js-components-custom-basic-usage.md)
      - [Custom Events](reference/arkui-js/js-components-custom-events.md)
      - [props](reference/arkui-js/js-components-custom-props.md)
      - [Event Parameter](reference/arkui-js/js-components-custom-event-parameter.md)
      - [slot](reference/arkui-js/js-components-custom-slot.md)
      - [Lifecycle Definition](reference/arkui-js/js-components-custom-lifecycle.md)
    - [Appendix](reference/arkui-js/js-appendix.md)
      - [Type Attributes](reference/arkui-js/js-appendix-types.md)
  - Compent Reference (TypeScript-based Declarative Development Paradigm)
    - [Components](reference/arkui-ts/ts-components.md)
      - [Universal Components](reference/arkui-ts/ts-universal-components.md)
        - [Universal Events](reference/arkui-ts/ts-universal-events.md)
          - [Click Event](reference/arkui-ts/ts-universal-events-click.md)
          - [Touch](reference/arkui-ts/ts-universal-events-touch.md)
          - [Show/Hide Event](reference/arkui-ts/ts-universal-events-show-hide.md)
          - [Key Event](reference/arkui-ts/ts-universal-events-key.md)
          - [Component Area Change Event](reference/arkui-ts/ts-universal-events-component-area-change.md)
        - [Universal Attributes](reference/arkui-ts/ts-universal-attributes.md)
          - [Size](reference/arkui-ts/ts-universal-attributes-size.md)
          - [Location](reference/arkui-ts/ts-universal-attributes-location.md)
          - [Layout Constraints](reference/arkui-ts/ts-universal-attributes-layout-constraints.md)
          - [Flex Layout](reference/arkui-ts/ts-universal-attributes-flex-layout.md)
          - [Border Configuration](reference/arkui-ts/ts-universal-attributes-border.md)
          - [Background](reference/arkui-ts/ts-universal-attributes-background.md)
          - [Opacity](reference/arkui-ts/ts-universal-attributes-opacity.md)
          - [Visibility](reference/arkui-ts/ts-universal-attributes-visibility.md)
          - [Enable/Disable](reference/arkui-ts/ts-universal-attributes-enable.md)
          - [Overlay](reference/arkui-ts/ts-universal-attributes-overlay.md)
          - [Z-order Control](reference/arkui-ts/ts-universal-attributes-z-order.md)
          - [Transformation](reference/arkui-ts/ts-universal-attributes-transformation.md)
          - [Image Effect Configuration](reference/arkui-ts/ts-universal-attributes-image-effect.md)
          - [Shape Clipping](reference/arkui-ts/ts-universal-attributes-sharp-clipping.md)
          - [Text Style](reference/arkui-ts/ts-universal-attributes-text-style.md)
          - [Grid](reference/arkui-ts/ts-universal-attributes-grid.md)
          - [Gradient Color](reference/arkui-ts/ts-universal-attributes-gradient-color.md)
          - [Popup Control](reference/arkui-ts/ts-universal-attributes-popup.md)
          - [Menu Control](reference/arkui-ts/ts-universal-attributes-menu.md)
          - [Click Control](reference/arkui-ts/ts-universal-attributes-touchable.md)
          - [Touch Target](reference/arkui-ts/ts-universal-attributes-response-region.md)
        - [Gesture Processing](reference/arkui-ts/ts-gesture-processing.md)
          - [Gesture Binding Methods](reference/arkui-ts/ts-gesture-settings.md)
          - [Basic Gestures](reference/arkui-ts/ts-basic-gestures.md)
            - [TapGesture](reference/arkui-ts/ts-basic-gestures-tapgesture.md)
            - [LongPressGesture](reference/arkui-ts/ts-basic-gestures-longpressgesture.md)
            - [PanGesture](reference/arkui-ts/ts-basic-gestures-pangesture.md)
            - [PinchGesture](reference/arkui-ts/ts-basic-gestures-pinchgesture.md)
            - [RotationGesture](reference/arkui-ts/ts-basic-gestures-rotationgesture.md)
            - [SwipeGesture](reference/arkui-ts/ts-basic-gestures-swipegesture.md)
          - [Combined Gestures](reference/arkui-ts/ts-combined-gestures.md)
      - [Basic Components](reference/arkui-ts/ts-basic-components.md)
        - [Blank](reference/arkui-ts/ts-basic-components-blank.md)
        - [Button](reference/arkui-ts/ts-basic-components-button.md)
        - [DataPanel](reference/arkui-ts/ts-basic-components-datapanel.md)
        - [Divider](reference/arkui-ts/ts-basic-components-divider.md)
        - [Gauge](reference/arkui-ts/ts-basic-components-gauge.md)
        - [Image](reference/arkui-ts/ts-basic-components-image.md)
        - [ImageAnimator](reference/arkui-ts/ts-basic-components-imageanimator.md)
        - [LoadingProgress](reference/arkui-ts/ts-basic-components-loadingprogress.md)
        - [Marquee](reference/arkui-ts/ts-basic-components-marquee.md)
        - [Progress](reference/arkui-ts/ts-basic-components-progress.md)
        - [QRCode](reference/arkui-ts/ts-basic-components-qrcode.md)
        - [Rating](reference/arkui-ts/ts-basic-components-rating.md)
        - [Select](reference/arkui-ts/ts-basic-components-select.md)
        - [Slider](reference/arkui-ts/ts-basic-components-slider.md)
        - [Span](reference/arkui-ts/ts-basic-components-span.md)
        - [Text](reference/arkui-ts/ts-basic-components-text.md)
        - [TextArea](reference/arkui-ts/ts-basic-components-textarea.md)
        - [TextInput](reference/arkui-ts/ts-basic-components-textinput.md)
        - [Toggle](reference/arkui-ts/ts-basic-components-toggle.md)
        - [TextClock](reference/arkui-ts/ts-basic-components-textclock.md)
      - [Container Components](reference/arkui-ts/ts-components-container.md)
        - [AlphabetIndexer](reference/arkui-ts/ts-container-alphabet-indexer.md)
        - [Badge](reference/arkui-ts/ts-container-badge.md)
        - [Column](reference/arkui-ts/ts-container-column.md)
        - [ColumnSplit](reference/arkui-ts/ts-container-columnsplit.md)
        - [Counter](reference/arkui-ts/ts-container-counter.md)
        - [Flex](reference/arkui-ts/ts-container-flex.md)
        - [GridContainer](reference/arkui-ts/ts-container-gridcontainer.md)
        - [Grid](reference/arkui-ts/ts-container-grid.md)
        - [GridItem](reference/arkui-ts/ts-container-griditem.md)
        - [List](reference/arkui-ts/ts-container-list.md)
        - [ListItem](reference/arkui-ts/ts-container-listitem.md)
        - [Navigator](reference/arkui-ts/ts-container-navigator.md)
        - [Navigation](reference/arkui-ts/ts-container-navigation.md)
        - [Panel](reference/arkui-ts/ts-container-panel.md)
        - [Row](reference/arkui-ts/ts-container-row.md)
        - [RowSplit](reference/arkui-ts/ts-container-rowsplit.md)
        - [Scroll](reference/arkui-ts/ts-container-scroll.md)
        - [ScrollBar](reference/arkui-ts/ts-container-scrollbar.md)
        - [Stack](reference/arkui-ts/ts-container-stack.md)
        - [Swiper](reference/arkui-ts/ts-container-swiper.md)
        - [Tabs](reference/arkui-ts/ts-container-tabs.md)
        - [TabContent](reference/arkui-ts/ts-container-tabcontent.md)
        - [Refresh](reference/arkui-ts/ts-container-refresh.md)
      - [Drawing Components](reference/arkui-ts/ts-drawing-components.md)
        - [Circle](reference/arkui-ts/ts-drawing-components-circle.md)
        - [Ellipse](reference/arkui-ts/ts-drawing-components-ellipse.md)
        - [Line](reference/arkui-ts/ts-drawing-components-line.md)
        - [Polyline](reference/arkui-ts/ts-drawing-components-polyline.md)
        - [Polygon](reference/arkui-ts/ts-drawing-components-polygon.md)
      - [Path](reference/arkui-ts/ts-drawing-components-path.md)
        - [Rect](reference/arkui-ts/ts-drawing-components-rect.md)
        - [Shape](reference/arkui-ts/ts-drawing-components-shape.md)
      - [Canvas Components](reference/arkui-ts/ts-components-canvas.md)
        - [Canvas](reference/arkui-ts/ts-components-canvas-canvas.md)
        - [CanvasRenderingContext2D](reference/arkui-ts/ts-canvasrenderingcontext2d.md)
        - [OffscreenCanvasRenderingConxt2D](reference/arkui-ts/ts-offscreencanvasrenderingcontext2d.md)
        - [Lottie](reference/arkui-ts/ts-components-canvas-lottie.md)
        - [Path2D](reference/arkui-ts/ts-components-canvas-path2d.md)
      - [CanvasGradient](reference/arkui-ts/ts-components-canvas-canvasgradient.md)
        - [ImageBitmap](reference/arkui-ts/ts-components-canvas-imagebitmap.md)
        - [ImageData](reference/arkui-ts/ts-components-canvas-imagedata.md)
    - [Animation](reference/arkui-ts/ts-animation.md)
      - [Attribute Animation](reference/arkui-ts/ts-animatorproperty.md)
      - [Explicit Animation](reference/arkui-ts/ts-explicit-animation.md)
      - [Transition Animation](reference/arkui-ts/ts-transition-animation.md)
        - [Page Transition](reference/arkui-ts/ts-page-transition-animation.md)
        - [Component Transition](reference/arkui-ts/ts-transition-animation-component.md)
        - [Transition of Shared Elements](reference/arkui-ts/ts-transition-animation-shared-elements.md)
      - [Motion Path Animation](reference/arkui-ts/ts-motion-path-animation.md)
      - [Matrix Transformation](reference/arkui-ts/ts-matrix-transformation.md)
      - [Interpolation Calculation](reference/arkui-ts/ts-interpolation-calculation.md)
    - [Global UI Methods](reference/arkui-ts/ts-global-ui-methods.md)
      - [Alert Dialog Box](reference/arkui-ts/ts-methods-alert-dialog-box.md)
      - [Custom Dialog box](reference/arkui-ts/ts-methods-custom-dialog-box.md)
      - [Image Cache](reference/arkui-ts/ts-methods-image-cache.md)
      - [Media Query](reference/arkui-ts/ts-methods-media-query.md)
      - [List Selection Dialog Box](reference/arkui-ts/ts-methods-action-sheet.md)
    - [Appendix](reference/arkui-ts/ts-appendix.md)
      - [Built-in Enums](reference/arkui-ts/ts-appendix-enums.md)
  - APIs
    - Ability Framework
      - [FeatureAbility Module](reference/apis/js-apis-featureAbility.md)
      - [ParticleAbility Module](reference/apis/js-apis-particleAbility.md)
      - [DataAbilityHelper Module](reference/apis/js-apis-dataAbilityHelper.md)
      - [DataUriUtils Module](reference/apis/js-apis-DataUriUtils.md)
      - [Bundle Module](reference/apis/js-apis-Bundle.md)
      - [Context Module](reference/apis/js-apis-Context.md)
    - Event Notification
      - [CommonEvent Module](reference/apis/js-apis-commonEvent.md)
      - [Notification Module](reference/apis/js-apis-notification.md)
      - [Reminder Agent](reference/apis/js-apis-reminderAgent.md)
    - Resource Management
      - [Resource Manager](reference/apis/js-apis-resource-manager.md)
      - [Internationalization (intl)](reference/apis/js-apis-intl.md)
      - [Internationalization (i18n)](reference/apis/js-apis-i18n.md)
    - Media
      - [Audio Management](reference/apis/js-apis-audio.md)
      - [Media](reference/apis/js-apis-media.md)
    - Security
      - [User Authentication](reference/apis/js-apis-useriam-userauth.md)
      - [Access Control](reference/apis/js-apis-abilityAccessCtrl.md)
    - Data Management
      - [Lightweight Storage (deprecated since 8)](reference/apis/js-apis-data-storage.md)
      - [Distributed Data Management](reference/apis/js-apis-distributed-data.md)
      - [Relational Database](reference/apis/js-apis-data-rdb.md)
      - [Result Set](reference/apis/js-apis-data-resultset.md)
      - [DataAbilityPredicates](reference/apis/js-apis-data-ability.md)
      - [Settings](reference/apis/js-apis-settings.md)
    - File Management
      - [File Management](reference/apis/js-apis-fileio.md)
      - [Statfs](reference/apis/js-apis-statfs.md)
      - [Environment](reference/apis/js-apis-environment.md)
      - [Public File Access and Management](reference/apis/js-apis-filemanager.md)
      - [App Storage Statistics](reference/apis/js-apis-storage-statistics.md)
      - [Volume Management](reference/apis/js-apis-volumemanager.md)
    - Account Management
      - [Distributed Account Management](reference/apis/js-apis-distributed-account.md)
      - [App Account Management](reference/apis/js-apis-appAccount.md)
    - Telephony Service
      - [Call](reference/apis/js-apis-call.md)
      - [SMS](reference/apis/js-apis-sms.md)
      - [SIM Management](reference/apis/js-apis-sim.md)
      - [Radio](reference/apis/js-apis-radio.md)
      - [observer](reference/apis/js-apis-observer.md)
      - [Cellular Data](reference/apis/js-apis-telephony-data.md)
    - Network and Connectivity
      - [WLAN](reference/apis/js-apis-wifi.md)
      - [Bluetooth](reference/apis/js-apis-bluetooth.md)
      - [RPC](reference/apis/js-apis-rpc.md)
    - Device Management
      - [Sensor](reference/apis/js-apis-sensor.md)
      - [Vibrator](reference/apis/js-apis-vibrator.md)
      - [Brightness](reference/apis/js-apis-brightness.md)
      - [Battery Info](reference/apis/js-apis-battery-info.md)
      - [Power Management](reference/apis/js-apis-power.md)
      - [Thermal Management](reference/apis/js-apis-thermal.md)
      - [Running Lock](reference/apis/js-apis-runninglock.md)
      - [Device Info](reference/apis/js-apis-device-info.md)
      - [systemParameter](reference/apis/js-apis-system-parameter.md)
      - [Device Management](reference/apis/js-apis-device-manager.md)
      - [Window](reference/apis/js-apis-window.md)
      - [Display](reference/apis/js-apis-display.md)
      - [Update](reference/apis/js-apis-update.md)
      - [USB](reference/apis/js-apis-usb.md)
      - [Location](reference/apis/js-apis-geolocation.md)
    - Basic Features
      - [Application Context](reference/apis/js-apis-basic-features-app-context.md)
      - [Console Logs](reference/apis/js-apis-basic-features-logs.md)
      - [Page Routing](reference/apis/js-apis-basic-features-routes.md)
      - [Pop-up Window](reference/apis/js-apis-basic-features-pop-up.md)
      - [Application Configuration](reference/apis/js-apis-basic-features-configuration.md)
      - [Timer](reference/apis/js-apis-basic-features-timer.md)
      - [Setting the System Time](reference/apis/js-apis-system-time.md)
      - [Animation](reference/apis/js-apis-basic-features-animator.md)
      - [WebGL](reference/apis/js-apis-webgl.md)
      - [WebGL2](reference/apis/js-apis-webgl2.md)
      - [Screenshot](reference/apis/js-apis-screenshot.md)
    - DFX
      - [HiAppEvent](reference/apis/js-apis-hiappevent.md)
      - [Performance Tracing](reference/apis/js-apis-hitracemeter.md)
      - [Fault Logger](reference/apis/js-apis-faultLogger.md)
      - [Distributed Call Chain Tracing](reference/apis/js-apis-hitracechain.md)
      - [HiLog](reference/apis/js-apis-hilog.md)
      - [HiChecker](reference/apis/js-apis-hichecker.md)
      - [HiDebug](reference/apis/js-apis-hidebug.md)
    - Language Base Class Library
      - [Obtaining Process Information](reference/apis/js-apis-process.md)
      - [URL String Parsing](reference/apis/js-apis-url.md)
      - [URI String Parsing](reference/apis/js-apis-uri.md)
      - [Util](reference/apis/js-apis-util.md)
      - [XML Parsing and Generation](reference/apis/js-apis-xml.md)
      - [XML-to-JavaScript Conversion](reference/apis/js-apis-convertxml.md)
      - [Worker Startup](reference/apis/js-apis-worker.md)
      - [Linear Container ArrayList](reference/apis/js-apis-arraylist.md)
      - [Linear Container Deque](reference/apis/js-apis-deque.md)
      - [Linear Container List](reference/apis/js-apis-list.md)
      - [Linear Container LinkedList](reference/apis/js-apis-linkedlist.md)
      - [Linear Container Queue](reference/apis/js-apis-queue.md)
      - [Linear Container Stack](reference/apis/js-apis-stack.md)
      - [Linear Container Vector](reference/apis/js-apis-vector.md)
      - [Nonlinear Container HashSet](reference/apis/js-apis-hashset.md)
      - [Nonlinear Container HashMap](reference/apis/js-apis-hashmap.md)
      - [Nonlinear Container PlainArray](reference/apis/js-apis-plainarray.md)
      - [Nonlinear Container TreeMap](reference/apis/js-apis-treemap.md)
      - [Nonlinear Container TreeSet](reference/apis/js-apis-treeset.md)
      - [Nonlinear Container LightWeightMap](reference/apis/js-apis-lightweightmap.md)
      - [Nonlinear Container LightWeightSet](reference/apis/js-apis-lightweightset.md)