# divider<a name="EN-US_TOPIC_0000001127125060"></a>

The  **<divider\>**  component is used to separate content blocks and content elements. It can be used for the list or UI layout.

## Required Permissions<a name="section11257113618419"></a>

None

## Child Components<a name="section9288143101012"></a>

Not supported

## Attributes<a name="section2907183951110"></a>

In addition to the attributes in  [Universal Attributes](js-components-common-attributes.md), the following attributes are supported.

<a name="table20633101642315"></a>
<table><thead align="left"><tr id="row663331618238"><th class="cellrowborder" valign="top" width="23.119999999999997%" id="mcps1.1.6.1.1"><p id="aa872998ac2d84843a3c5161889afffef"><a name="aa872998ac2d84843a3c5161889afffef"></a><a name="aa872998ac2d84843a3c5161889afffef"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="23.119999999999997%" id="mcps1.1.6.1.2"><p id="ab2111648ee0e4f6d881be8954e7acaab"><a name="ab2111648ee0e4f6d881be8954e7acaab"></a><a name="ab2111648ee0e4f6d881be8954e7acaab"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="10.48%" id="mcps1.1.6.1.3"><p id="ab377d1c90900478ea4ecab51e9a058af"><a name="ab377d1c90900478ea4ecab51e9a058af"></a><a name="ab377d1c90900478ea4ecab51e9a058af"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="7.5200000000000005%" id="mcps1.1.6.1.4"><p id="p824610360217"><a name="p824610360217"></a><a name="p824610360217"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="35.76%" id="mcps1.1.6.1.5"><p id="a1d574a0044ed42ec8a2603bc82734232"><a name="a1d574a0044ed42ec8a2603bc82734232"></a><a name="a1d574a0044ed42ec8a2603bc82734232"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row14446349178"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p15694934121713"><a name="p15694934121713"></a><a name="p15694934121713"></a>vertical</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p0694434171720"><a name="p0694434171720"></a><a name="p0694434171720"></a>boolean</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p2694103415179"><a name="p2694103415179"></a><a name="p2694103415179"></a>false</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p13694103471711"><a name="p13694103471711"></a><a name="p13694103471711"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p1769433401719"><a name="p1769433401719"></a><a name="p1769433401719"></a>Whether to use the vertical divider. The default value is <strong id="b8204122145214"><a name="b8204122145214"></a><a name="b8204122145214"></a>false</strong>, indicating that the horizontal divider is used.</p>
</td>
</tr>
</tbody>
</table>

>![](../../public_sys-resources/icon-note.gif) **NOTE:** 
>The  **focusable**  and  **disabled**  attributes are not supported.

## Styles<a name="section5775351116"></a>

Only the following style attributes are supported.

<a name="table156669187471"></a>
<table><thead align="left"><tr id="row966601820476"><th class="cellrowborder" valign="top" width="18.209640397857694%" id="mcps1.1.6.1.1"><p id="p1366616188472"><a name="p1366616188472"></a><a name="p1366616188472"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="14.135424636572303%" id="mcps1.1.6.1.2"><p id="p26661418194711"><a name="p26661418194711"></a><a name="p26661418194711"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="22.083014537107886%" id="mcps1.1.6.1.3"><p id="p36661718194710"><a name="p36661718194710"></a><a name="p36661718194710"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="6.7999234889058915%" id="mcps1.1.6.1.4"><p id="p16666141812475"><a name="p16666141812475"></a><a name="p16666141812475"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="38.77199693955624%" id="mcps1.1.6.1.5"><p id="p16667718174712"><a name="p16667718174712"></a><a name="p16667718174712"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row186671218144718"><td class="cellrowborder" valign="top" width="18.209640397857694%" headers="mcps1.1.6.1.1 "><p id="p666720180479"><a name="p666720180479"></a><a name="p666720180479"></a>margin</p>
</td>
<td class="cellrowborder" valign="top" width="14.135424636572303%" headers="mcps1.1.6.1.2 "><p id="p666714189478"><a name="p666714189478"></a><a name="p666714189478"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="22.083014537107886%" headers="mcps1.1.6.1.3 "><p id="p18667181834719"><a name="p18667181834719"></a><a name="p18667181834719"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="6.7999234889058915%" headers="mcps1.1.6.1.4 "><p id="p9667171834720"><a name="p9667171834720"></a><a name="p9667171834720"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="38.77199693955624%" headers="mcps1.1.6.1.5 "><p id="p8667191824717"><a name="p8667191824717"></a><a name="p8667191824717"></a>Shorthand attribute to set all margins in a declaration. You can set 1 to 4 values.</p>
</td>
</tr>
<tr id="row1758549135917"><td class="cellrowborder" valign="top" width="18.209640397857694%" headers="mcps1.1.6.1.1 "><p id="a70939a36b2b04dd8bec21f5bddc8637e"><a name="a70939a36b2b04dd8bec21f5bddc8637e"></a><a name="a70939a36b2b04dd8bec21f5bddc8637e"></a>margin-[left|top|right|bottom]</p>
</td>
<td class="cellrowborder" valign="top" width="14.135424636572303%" headers="mcps1.1.6.1.2 "><p id="ae53ac9ac370d483990e04ea9789c1e49"><a name="ae53ac9ac370d483990e04ea9789c1e49"></a><a name="ae53ac9ac370d483990e04ea9789c1e49"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="22.083014537107886%" headers="mcps1.1.6.1.3 "><p id="a180cd037e6174e5c82f35a3a66b6f2ec"><a name="a180cd037e6174e5c82f35a3a66b6f2ec"></a><a name="a180cd037e6174e5c82f35a3a66b6f2ec"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="6.7999234889058915%" headers="mcps1.1.6.1.4 "><p id="a487d09add6e54c5c89fa4f22e9318271"><a name="a487d09add6e54c5c89fa4f22e9318271"></a><a name="a487d09add6e54c5c89fa4f22e9318271"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="38.77199693955624%" headers="mcps1.1.6.1.5 "><p id="p696123114464"><a name="p696123114464"></a><a name="p696123114464"></a>Shorthand attribute of the length type to set left, top, right, and bottom margins attributes. Its unit is px and default value is <strong id="b115244118529"><a name="b115244118529"></a><a name="b115244118529"></a>0</strong>.</p>
</td>
</tr>
<tr id="row1487514596294"><td class="cellrowborder" valign="top" width="18.209640397857694%" headers="mcps1.1.6.1.1 "><p id="p71673109308"><a name="p71673109308"></a><a name="p71673109308"></a>color</p>
</td>
<td class="cellrowborder" valign="top" width="14.135424636572303%" headers="mcps1.1.6.1.2 "><p id="p516781011309"><a name="p516781011309"></a><a name="p516781011309"></a>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="22.083014537107886%" headers="mcps1.1.6.1.3 "><p id="p416718104300"><a name="p416718104300"></a><a name="p416718104300"></a>#08000000</p>
</td>
<td class="cellrowborder" valign="top" width="6.7999234889058915%" headers="mcps1.1.6.1.4 "><p id="p1016741053017"><a name="p1016741053017"></a><a name="p1016741053017"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="38.77199693955624%" headers="mcps1.1.6.1.5 "><p id="p116711013301"><a name="p116711013301"></a><a name="p116711013301"></a>Color of the divider.</p>
</td>
</tr>
<tr id="row1055218083014"><td class="cellrowborder" valign="top" width="18.209640397857694%" headers="mcps1.1.6.1.1 "><p id="p10167710193019"><a name="p10167710193019"></a><a name="p10167710193019"></a>stroke-width</p>
</td>
<td class="cellrowborder" valign="top" width="14.135424636572303%" headers="mcps1.1.6.1.2 "><p id="p6167121093018"><a name="p6167121093018"></a><a name="p6167121093018"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="22.083014537107886%" headers="mcps1.1.6.1.3 "><p id="p31671010113017"><a name="p31671010113017"></a><a name="p31671010113017"></a>1</p>
</td>
<td class="cellrowborder" valign="top" width="6.7999234889058915%" headers="mcps1.1.6.1.4 "><p id="p3167181019303"><a name="p3167181019303"></a><a name="p3167181019303"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="38.77199693955624%" headers="mcps1.1.6.1.5 "><p id="p13167101016307"><a name="p13167101016307"></a><a name="p13167101016307"></a>Width of the divider.</p>
</td>
</tr>
<tr id="row56167193020"><td class="cellrowborder" valign="top" width="18.209640397857694%" headers="mcps1.1.6.1.1 "><p id="p161695103305"><a name="p161695103305"></a><a name="p161695103305"></a>display</p>
</td>
<td class="cellrowborder" valign="top" width="14.135424636572303%" headers="mcps1.1.6.1.2 "><p id="p34141720115716"><a name="p34141720115716"></a><a name="p34141720115716"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="22.083014537107886%" headers="mcps1.1.6.1.3 "><p id="p17169310133020"><a name="p17169310133020"></a><a name="p17169310133020"></a>flex</p>
</td>
<td class="cellrowborder" valign="top" width="6.7999234889058915%" headers="mcps1.1.6.1.4 "><p id="p3169101019308"><a name="p3169101019308"></a><a name="p3169101019308"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="38.77199693955624%" headers="mcps1.1.6.1.5 "><p id="p1416912102303"><a name="p1416912102303"></a><a name="p1416912102303"></a>Type of the bounding box generated by the divider. The value can be <strong id="b54008818310"><a name="b54008818310"></a><a name="b54008818310"></a>flex</strong> or <strong id="b12400188103111"><a name="b12400188103111"></a><a name="b12400188103111"></a>none</strong>. The default value is <strong id="b134003817319"><a name="b134003817319"></a><a name="b134003817319"></a>flex</strong>.</p>
</td>
</tr>
<tr id="row1836619303"><td class="cellrowborder" valign="top" width="18.209640397857694%" headers="mcps1.1.6.1.1 "><p id="p81691410143017"><a name="p81691410143017"></a><a name="p81691410143017"></a>visibility</p>
</td>
<td class="cellrowborder" valign="top" width="14.135424636572303%" headers="mcps1.1.6.1.2 "><p id="p51691710173018"><a name="p51691710173018"></a><a name="p51691710173018"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="22.083014537107886%" headers="mcps1.1.6.1.3 "><p id="p14169101053017"><a name="p14169101053017"></a><a name="p14169101053017"></a>visible</p>
</td>
<td class="cellrowborder" valign="top" width="6.7999234889058915%" headers="mcps1.1.6.1.4 "><p id="p1016919104306"><a name="p1016919104306"></a><a name="p1016919104306"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="38.77199693955624%" headers="mcps1.1.6.1.5 "><p id="p13169101011309"><a name="p13169101011309"></a><a name="p13169101011309"></a>Whether to display the divider. Invisible dividers also occupy space. <strong id="b9290124115011"><a name="b9290124115011"></a><a name="b9290124115011"></a>visible</strong> indicates that the divider is displayed, and <strong id="b571315351925"><a name="b571315351925"></a><a name="b571315351925"></a>hidden</strong> indicates that the divider is not displayed.</p>
</td>
</tr>
<tr id="row19262114111135"><td class="cellrowborder" valign="top" width="18.209640397857694%" headers="mcps1.1.6.1.1 "><p id="p1126317411138"><a name="p1126317411138"></a><a name="p1126317411138"></a>line-cap</p>
</td>
<td class="cellrowborder" valign="top" width="14.135424636572303%" headers="mcps1.1.6.1.2 "><p id="p13140171172312"><a name="p13140171172312"></a><a name="p13140171172312"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="22.083014537107886%" headers="mcps1.1.6.1.3 "><p id="p926310414130"><a name="p926310414130"></a><a name="p926310414130"></a>butt</p>
</td>
<td class="cellrowborder" valign="top" width="6.7999234889058915%" headers="mcps1.1.6.1.4 "><p id="p172631041181314"><a name="p172631041181314"></a><a name="p172631041181314"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="38.77199693955624%" headers="mcps1.1.6.1.5 "><p id="p1826374117137"><a name="p1826374117137"></a><a name="p1826374117137"></a>Cap style of the divider. The default value is <strong id="b11938171773415"><a name="b11938171773415"></a><a name="b11938171773415"></a>butt</strong>. Available values are as follows:</p>
<a name="ul169886211615"></a><a name="ul169886211615"></a><ul id="ul169886211615"><li><strong id="b097794943310"><a name="b097794943310"></a><a name="b097794943310"></a>butt</strong>: The ends of the divider are squared off.</li><li><strong id="b579115410335"><a name="b579115410335"></a><a name="b579115410335"></a>round</strong>: A rounded cap is added to each end of the divider.</li><li><strong id="b196977590336"><a name="b196977590336"></a><a name="b196977590336"></a>square</strong>: A square cap is added to each end of the divider.</li></ul>
<div class="note" id="note46927357715"><a name="note46927357715"></a><a name="note46927357715"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p126922351571"><a name="p126922351571"></a><a name="p126922351571"></a>If the value is <strong id="b11815103163413"><a name="b11815103163413"></a><a name="b11815103163413"></a>round</strong> or <strong id="b31272793415"><a name="b31272793415"></a><a name="b31272793415"></a>square</strong>, the line length increases by the line width.</p>
</div></div>
</td>
</tr>
<tr id="row3222184412411"><td class="cellrowborder" valign="top" width="18.209640397857694%" headers="mcps1.1.6.1.1 "><p id="ad74a6a48aca7439e9344c18c26b4177e"><a name="ad74a6a48aca7439e9344c18c26b4177e"></a><a name="ad74a6a48aca7439e9344c18c26b4177e"></a>flex</p>
</td>
<td class="cellrowborder" valign="top" width="14.135424636572303%" headers="mcps1.1.6.1.2 "><p id="a2e6e5192a1534872be5fcfd9f83e3fdc"><a name="a2e6e5192a1534872be5fcfd9f83e3fdc"></a><a name="a2e6e5192a1534872be5fcfd9f83e3fdc"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="22.083014537107886%" headers="mcps1.1.6.1.3 "><p id="a8512eda38e25410685be8a8992890257"><a name="a8512eda38e25410685be8a8992890257"></a><a name="a8512eda38e25410685be8a8992890257"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="6.7999234889058915%" headers="mcps1.1.6.1.4 "><p id="p14201322964"><a name="p14201322964"></a><a name="p14201322964"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="38.77199693955624%" headers="mcps1.1.6.1.5 "><p id="p368291715615"><a name="p368291715615"></a><a name="p368291715615"></a>How to divide available space of the parent component for each child component. This is a shorthand attribute to set the <strong id="b065931874612"><a name="b065931874612"></a><a name="b065931874612"></a>flex-grow</strong> attribute.</p>
<div class="note" id="note1368217171461"><a name="note1368217171461"></a><a name="note1368217171461"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p76821817460"><a name="p76821817460"></a><a name="p76821817460"></a>This attribute takes effect only when the parent component is <strong id="b11480192416462"><a name="b11480192416462"></a><a name="b11480192416462"></a>&lt;div&gt;</strong>, <strong id="b4481624124614"><a name="b4481624124614"></a><a name="b4481624124614"></a>&lt;list-item&gt;</strong>, or <strong id="b448116241468"><a name="b448116241468"></a><a name="b448116241468"></a>&lt;tabs&gt;</strong>.</p>
</div></div>
</td>
</tr>
<tr id="row879744718418"><td class="cellrowborder" valign="top" width="18.209640397857694%" headers="mcps1.1.6.1.1 "><p id="a5d88cacaaf5c4f6a87390ab916b695c6"><a name="a5d88cacaaf5c4f6a87390ab916b695c6"></a><a name="a5d88cacaaf5c4f6a87390ab916b695c6"></a>flex-grow</p>
</td>
<td class="cellrowborder" valign="top" width="14.135424636572303%" headers="mcps1.1.6.1.2 "><p id="a2c379e3af283446da446f1631e572efd"><a name="a2c379e3af283446da446f1631e572efd"></a><a name="a2c379e3af283446da446f1631e572efd"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="22.083014537107886%" headers="mcps1.1.6.1.3 "><p id="aa374f6c7415a4ee48a06930d76c55be7"><a name="aa374f6c7415a4ee48a06930d76c55be7"></a><a name="aa374f6c7415a4ee48a06930d76c55be7"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="6.7999234889058915%" headers="mcps1.1.6.1.4 "><p id="p1335271877"><a name="p1335271877"></a><a name="p1335271877"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="38.77199693955624%" headers="mcps1.1.6.1.5 "><p id="p13246193876"><a name="p13246193876"></a><a name="p13246193876"></a>How much a child component will grow. The value specifies allocation of the remaining space on the main axis of the parent component. Size of available space = Container size - Total size of all child components. Value <strong id="b13294279468"><a name="b13294279468"></a><a name="b13294279468"></a>0</strong> indicates that the child component does not grow.</p>
<div class="note" id="note62462313719"><a name="note62462313719"></a><a name="note62462313719"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p1324610312715"><a name="p1324610312715"></a><a name="p1324610312715"></a>This attribute takes effect only when the parent component is <strong id="b1949597674"><a name="b1949597674"></a><a name="b1949597674"></a>&lt;div&gt;</strong>, <strong id="b1228816217"><a name="b1228816217"></a><a name="b1228816217"></a>&lt;list-item&gt;</strong>, or <strong id="b184212334"><a name="b184212334"></a><a name="b184212334"></a>&lt;tabs&gt;</strong>.</p>
</div></div>
<p id="p14246435713"><a name="p14246435713"></a><a name="p14246435713"></a></p>
</td>
</tr>
<tr id="row187966501419"><td class="cellrowborder" valign="top" width="18.209640397857694%" headers="mcps1.1.6.1.1 "><p id="ac65ef7e2b1f24a13b09c495f643168c9"><a name="ac65ef7e2b1f24a13b09c495f643168c9"></a><a name="ac65ef7e2b1f24a13b09c495f643168c9"></a>flex-shrink</p>
</td>
<td class="cellrowborder" valign="top" width="14.135424636572303%" headers="mcps1.1.6.1.2 "><p id="a98e7d367f0e649699892ae5bad6ade37"><a name="a98e7d367f0e649699892ae5bad6ade37"></a><a name="a98e7d367f0e649699892ae5bad6ade37"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="22.083014537107886%" headers="mcps1.1.6.1.3 "><p id="a422d978368814d12a33201cb839060ee"><a name="a422d978368814d12a33201cb839060ee"></a><a name="a422d978368814d12a33201cb839060ee"></a>1</p>
</td>
<td class="cellrowborder" valign="top" width="6.7999234889058915%" headers="mcps1.1.6.1.4 "><p id="p164884516713"><a name="p164884516713"></a><a name="p164884516713"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="38.77199693955624%" headers="mcps1.1.6.1.5 "><p id="p13640114214710"><a name="p13640114214710"></a><a name="p13640114214710"></a>How much a child component will shrink. The shrink occurs only when the sum of default element widths is greater than that of the parent component. Value <strong id="b618802815466"><a name="b618802815466"></a><a name="b618802815466"></a>0</strong> indicates that the child component does not shrink.</p>
<div class="note" id="note364074212713"><a name="note364074212713"></a><a name="note364074212713"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p186406427711"><a name="p186406427711"></a><a name="p186406427711"></a>This attribute takes effect only when the parent component is <strong id="b97929801"><a name="b97929801"></a><a name="b97929801"></a>&lt;div&gt;</strong>, <strong id="b1772326374"><a name="b1772326374"></a><a name="b1772326374"></a>&lt;list-item&gt;</strong>, or <strong id="b397489204"><a name="b397489204"></a><a name="b397489204"></a>&lt;tabs&gt;</strong>.</p>
</div></div>
</td>
</tr>
<tr id="row438316531843"><td class="cellrowborder" valign="top" width="18.209640397857694%" headers="mcps1.1.6.1.1 "><p id="a82c323a994634032963169eeee1a55e4"><a name="a82c323a994634032963169eeee1a55e4"></a><a name="a82c323a994634032963169eeee1a55e4"></a>flex-basis</p>
</td>
<td class="cellrowborder" valign="top" width="14.135424636572303%" headers="mcps1.1.6.1.2 "><p id="p1148910787"><a name="p1148910787"></a><a name="p1148910787"></a>&lt;length&gt;</p>
<p id="a43613cf0c2184c0d8b44e8d292f6edb7"><a name="a43613cf0c2184c0d8b44e8d292f6edb7"></a><a name="a43613cf0c2184c0d8b44e8d292f6edb7"></a></p>
</td>
<td class="cellrowborder" valign="top" width="22.083014537107886%" headers="mcps1.1.6.1.3 "><p id="ab9e1c7dc25f840e58993af05c1d32109"><a name="ab9e1c7dc25f840e58993af05c1d32109"></a><a name="ab9e1c7dc25f840e58993af05c1d32109"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="6.7999234889058915%" headers="mcps1.1.6.1.4 "><p id="p124162561774"><a name="p124162561774"></a><a name="p124162561774"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="38.77199693955624%" headers="mcps1.1.6.1.5 "><p id="p192811541574"><a name="p192811541574"></a><a name="p192811541574"></a>Initial length of a child component on the main axis</p>
<div class="note" id="note162817541279"><a name="note162817541279"></a><a name="note162817541279"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p1928115418713"><a name="p1928115418713"></a><a name="p1928115418713"></a>This attribute takes effect only when the parent component is <strong id="b103138373466"><a name="b103138373466"></a><a name="b103138373466"></a>&lt;div&gt;</strong>, <strong id="b831417371468"><a name="b831417371468"></a><a name="b831417371468"></a>&lt;list-item&gt;</strong>, or <strong id="b13314153715462"><a name="b13314153715462"></a><a name="b13314153715462"></a>&lt;tabs&gt;</strong>.</p>
</div></div>
</td>
</tr>
</tbody>
</table>

## Events<a name="section1944813319536"></a>

Not supported

## Methods<a name="section163401342195315"></a>

Not supported

## Example<a name="section230641814493"></a>

```
<!-- xxx.hml -->
<div class="container">   
  <div class="content">        
    <divider class="divider" vertical="false"></divider>    
  </div>
</div>
```

```
/* xxx.css */
.container {    
  margin: 20px;
  flex-direction:column;
  width:100%;
  height:100%;
  align-items:center;
}
.content{    
  width:80%;
  height:40%;
  border:1px solid #000000;
  align-items: center;
  justify-content: center;
  flex-direction:column;
}
.divider {    
  margin: 10px;
  color: #ff0000ff;
  stroke-width: 3px;
  line-cap: round;
}
```

![](figures/1-1.jpg)

