# 用户认证开发概述

提供用户认证能力，可应用于设备解锁、支付、应用登录等身份认证场景。

当前用户认证能力提供2D人脸识别、3D人脸识别两种人脸识别能力，设备具备哪种识别能力，取决于设备的硬件能力和技术实现。

3D人脸识别技术识别率、防伪能力都优于2D人脸识别技术，但具有3D人脸能力（比如3D结构光、3D TOF等）的设备才可以使用3D人脸识别技术。

## 基本概念

人脸识别：基于人的脸部特征信息进行身份识别的一种生物特征识别技术，用摄像机或摄像头采集含有人脸的图像或视频流，并自动在图像中检测和跟踪人脸，进而对检测到的人脸进行脸部识别，通常也叫做人像识别、面部识别、人脸认证。

## 运作机制

人脸识别会在摄像头和TEE（Trusted Execution Environment）之间建立安全通道，人脸图像信息通过安全通道传递到TEE中，由于人脸图像信息从REE（Rich Execution Environment）侧无法获取，从而避免了恶意软件从REE侧进行攻击。对人脸图像采集、特征提取、活体检测、特征比对等处理完全在TEE中，基于TrustZone进行安全隔离，外部的人脸框架只负责人脸的认证发起和处理认证结果等数据，不涉及人脸数据本身。

人脸特征数据通过TEE的安全存储区进行存储，采用高强度的密码算法对人脸特征数据进行加密和完整性保护，外部无法获取到加密人脸特征数据的密钥，保证用户的人脸特征数据不会泄露。本能力采集和存储的人脸特征数据不会在用户未授权的情况下被传出TEE，这意味着，用户未授权时，无论是系统应用还是三方应用都无法获得人脸特征数据，也无法将人脸特征数据传送或备份到任何外部存储介质。

## 约束与限制

- 当前版本提供的用户认证能力只包含人脸识别，且只支持本地认证，不提供认证界面。
- 要求设备上具备摄像器件，且人脸图像像素大于100*100。
- 要求设备上具有TEE安全环境，人脸特征信息高强度加密保存在TEE中。
- 对于面部特征相似的人、面部特征不断发育的儿童，人脸特征匹配率有所不同。如果对此担忧，可考虑其他认证方式。