# 弹窗

> ![icon-note.gif](public_sys-resources/icon-note.gif) **说明：**
>
> - 从API Version 8 开始，该接口不再维护，推荐使用新接口[`@ohos.prompt`](js-apis-prompt.md)。
>
>
> - 本模块首批接口从API version 3开始支持。后续版本的新增接口，采用上角标单独标记接口的起始版本。


## 导入模块


```js
import prompt from '@system.prompt';
```

## prompt.showToast

showToast(options: ShowToastOptions): void

显示文本弹窗。

**系统能力：** SystemCapability.ArkUI.ArkUI.Full

**参数：**

| 参数名     | 类型                                    | 必填   | 说明              |
| ------- | ------------------------------------- | ---- | --------------- |
| options | [ShowToastOptions](#showtoastoptions) | 是    | 定义ShowToast的选项。 |

**示例：** 

```js
export default {    
  showToast() {        
    prompt.showToast({            
      message: 'Message Info',            
      duration: 2000,        
    });    
  }
}
```


## prompt.showDialog

showDialog(options: ShowDialogOptions): void

显示对话框。

**系统能力：** SystemCapability.ArkUI.ArkUI.Full

**参数：**

| 参数名     | 类型                                      | 必填   | 说明          |
| ------- | --------------------------------------- | ---- | ----------- |
| options | [ShowDialogOptions](#showdialogoptions) | 是    | 定义显示对话框的选项。 |


**示例：**

```js
export default {    
  showDialog() {       
    prompt.showDialog({           
      title: 'Title Info',            
      message: 'Message Info',           
      buttons: [                
        {                    
           text: 'button',                   
           color: '#666666',                
         },            
       ],            
       success: function(data) {                
         console.log('dialog success callback，click button : ' + data.index);            
       },            
       cancel: function() {                
         console.log('dialog cancel callback');            
       },
     });    
  }
}
```

## prompt.showActionMenu<sup>6+</sup>

showActionMenu(options: ShowActionMenuOptions): void

显示操作菜单。

**系统能力：** SystemCapability.ArkUI.ArkUI.Full

**参数：**

| 参数名     | 类型                                       | 必填   | 说明                   |
| ------- | ---------------------------------------- | ---- | -------------------- |
| options | [ShowActionMenuOptions](#showactionmenuoptions) | 是    | 定义ShowActionMenu的选项。 |


**示例：**

```js
export default {    
  showActionMenu() {        
    prompt.showActionMenu({            
      title: 'Title Info',            
      buttons: [                
        {                    
          text: 'item1',                    
          color: '#666666',                
        },                
        {                    
           text: 'item2',                    
           color: '#000000',                
        },            
      ],            
      success: function(tapIndex) {                
        console.log('dialog success callback，click button : ' + tapIndex);            
      },            
      fail: function(errMsg) {                
        console.log('dialog fail callback' + errMsg);            
      },       
    });    
  }
}
```
## ShowToastOptions

定义ShowToast的选项。

**系统能力：** 以下各项对应的系统能力均为SystemCapability.ArkUI.ArkUI.Full

| 名称                  | 参数类型           | 必填   | 说明                                       |
| ------------------- | -------------- | ---- | ---------------------------------------- |
| message             | string         | 是    | 显示的文本信息。                                 |
| duration            | number         | 否    | 默认值1500ms，建议区间：1500ms-10000ms。若小于1500ms则取默认值，最大取值为10000ms。 |
| bottom<sup>5+</sup> | string\|number | 否    | 设置弹窗边框距离屏幕底部的位置。                         |

## Button

定义按钮的提示信息。

**系统能力：** 以下各项对应的系统能力均为SystemCapability.ArkUI.ArkUI.Full

| 名称    | 参数类型   | 必填   | 说明      |
| ----- | ------ | ---- | ------- |
| text  | string | 是    | 定义按钮信息。 |
| color | string | 是    | 定义按钮颜色。 |

## ShowDialogSuccessResponse

定义ShowDialog的响应。

**系统能力：** 以下各项对应的系统能力均为SystemCapability.ArkUI.ArkUI.Full

| 名称    | 参数类型   | 必填   | 说明         |
| ----- | ------ | ---- | ---------- |
| index | number | 是    | 定义数据的索引信息。 |

## ShowDialogOptions

定义显示对话框的选项。

**系统能力：** 以下各项对应的系统能力均为SystemCapability.ArkUI.ArkUI.Full

| 名称       | 参数类型                                     | 必填   | 说明                                       |
| -------- | ---------------------------------------- | ---- | ---------------------------------------- |
| title    | string                                   | 否    | 标题文本。                                    |
| message  | string                                   | 否    | 文本内容。                                    |
| buttons  | [[Button](#button), [Button](#button)?, [Button](#button)?] | 否    | 对话框中按钮的数组，结构为：{text:'button', color: '\#666666'}，支持1-6个按钮。大于6个按钮时弹窗不显示。 |
| success  | (data: [ShowDialogSuccessResponse](#showdialogsuccessresponse)) => void | 否    | 接口调用成功的回调函数。                             |
| cancel   | (data: string, code: string) => void     | 否    | 接口调用失败的回调函数。                             |
| complete | (data: string) => void                   | 否    | 接口调用结束的回调函数。                             |

## ShowActionMenuOptions<sup>6+</sup>

定义ShowActionMenu的选项。

**系统能力：** 以下各项对应的系统能力均为SystemCapability.ArkUI.ArkUI.Full

| 名称       | 参数类型                                     | 必填   | 说明                                       |
| -------- | ---------------------------------------- | ---- | ---------------------------------------- |
| title    | string                                   | 否    | 标题文本。                                    |
| buttons  | [[Button](#button), [Button](#button)?, [Button](#button)?, [Button](#button)?, [Button](#button)?, [Button](#button)?] | 是    | 对话框中按钮的数组，结构为：{text:'button', color: '\#666666'}，支持1-6个按钮。 |
| success  | (tapIndex: number, errMsg: string) => void | 否    | 弹出对话框时调用。                                |
| fail     | (errMsg: string) => void                 | 否    | 接口调用失败的回调函数。                             |
| complete | (data: string) => void                   | 否    | 关闭对话框时调用。                                |
