# Application Development

- [Application Development Overview](application-dev-guide.md)
- About OpenHarmony
    - [OpenHarmony Project](../OpenHarmony-Overview.md)
    - [Glossary](../glossary.md)
    - [OpenHarmony Release Notes](../release-notes/Readme.md)
- Quick Start
    - Getting Started
      - [Preparations](quick-start/start-overview.md)
      - [Getting Started with eTS in the Traditional Coding Approach](quick-start/start-with-ets.md)
      - [Getting Started with eTS in the Low-Code Approach](quick-start/start-with-ets-low-code.md)
      - [Getting Started with JavaScript in the Traditional Coding Approach](quick-start/start-with-js.md)
      - [Getting Started with JavaScript in the Low-Code Approach](quick-start/start-with-js-low-code.md)
    - Development Fundamentals
      - [Application Package Structure Configuration File (FA Model)](quick-start/package-structure.md)
      - [Application Package Structure Configuration File (Stage Model)](quick-start/stage-structure.md)
      - [Resource File Categories](quick-start/basic-resource-file-categories.md)
      - [SysCap](quick-start/syscap.md)
- Development
    - [Ability Development](ability/Readme-EN.md)
    - [UI Development](ui/Readme-EN.md)
    - [Common Event and Notification](notification/Readme-EN.md)
    - [Window Manager](windowmanager/Readme-EN.md)
    - [WebGL](webgl/Readme-EN.md)
    - [Media](media/Readme-EN.md)
    - [Security](security/Readme-EN.md)
    - [Connectivity](connectivity/Readme-EN.md)
    - [Data Management](database/Readme-EN.md)
    - [Telephony](telephony/Readme-EN.md)
    - [Task Management](task-management/Readme-EN.md)
    - [Device Management](device/Readme-EN.md)
    - [Device Usage Statistics](device-usage-statistics/Readme-EN.md)
    - [DFX](dfx/Readme-EN.md)
    - [Internationalization](internationalization/Readme-EN.md)
    - [Native APIs](napi/Readme-EN.md)
- Tools
    - [DevEco Studio (OpenHarmony) User Guide](quick-start/deveco-studio-user-guide-for-openharmony.md)
- Hands-On Tutorials
    - [Samples](https://gitee.com/openharmony/app_samples/blob/master/README.md)
    - [Codelabs](https://gitee.com/openharmony/codelabs/blob/master)
- API References
    - [Component Reference (JavaScript-based Web-like Development Paradigm)](reference/arkui-js/Readme-EN.md)
    - [Component Reference (TypeScript-based Declarative Development Paradigm)](reference/arkui-ts/Readme-EN.md)
    - APIs
      - [JS and TS APIs](reference/apis/Readme-EN.md)
      - Native APIs
        -   [Standard Libraries](reference/native-lib/third_party_libc/musl.md)
        -   [Node_API](reference/native-lib/third_party_napi/napi.md)
- Contribution
    - [How to Contribute](../contribute/documentation-contribution.md)

