# 内核子系统<a name="ZH-CN_TOPIC_0000001077309884"></a>

-   [简介](#section11660541593)
-   [LiteOS](#section6253122153515)
-   [Linux](#section143373618411)
-   [目录](#section21571344112)
-   [约束](#section19647171710417)
-   [使用](#section1393789267)
    -   [LiteOS使用说明](#section118811457303)
    -   [linux使用说明](#section1352114469620)

-   [构建说明](#section19369206113115)
-   [相关仓](#section27639463106)

## 简介<a name="section11660541593"></a>

OpenHarmony针对不同量级的系统，分别使用了不同形态的内核，分别为LiteOS和Linux。在轻量系统、小型系统可以选用LiteOS；在小型系统和标准系统上可以选用Linux。

<a name="table91002058194612"></a>
<table><thead align="left"><tr id="row010015589464"><th class="cellrowborder" valign="top" width="25%" id="mcps1.2.5.1.1"><p id="p310015824612"><a name="p310015824612"></a><a name="p310015824612"></a>系统级别</p>
</th>
<th class="cellrowborder" valign="top" width="25%" id="mcps1.2.5.1.2"><p id="p910013586463"><a name="p910013586463"></a><a name="p910013586463"></a>轻量系统</p>
</th>
<th class="cellrowborder" valign="top" width="25%" id="mcps1.2.5.1.3"><p id="p14100858164615"><a name="p14100858164615"></a><a name="p14100858164615"></a>小型系统</p>
</th>
<th class="cellrowborder" valign="top" width="25%" id="mcps1.2.5.1.4"><p id="p191001158154610"><a name="p191001158154610"></a><a name="p191001158154610"></a>标准系统</p>
</th>
</tr>
</thead>
<tbody><tr id="row18100165894619"><td class="cellrowborder" valign="top" width="25%" headers="mcps1.2.5.1.1 "><p id="p110055824611"><a name="p110055824611"></a><a name="p110055824611"></a>LiteOS</p>
</td>
<td class="cellrowborder" valign="top" width="25%" headers="mcps1.2.5.1.2 "><p id="p3100175815461"><a name="p3100175815461"></a><a name="p3100175815461"></a>√</p>
</td>
<td class="cellrowborder" valign="top" width="25%" headers="mcps1.2.5.1.3 "><p id="p15762194124714"><a name="p15762194124714"></a><a name="p15762194124714"></a>√</p>
</td>
<td class="cellrowborder" valign="top" width="25%" headers="mcps1.2.5.1.4 "><p id="p647872125416"><a name="p647872125416"></a><a name="p647872125416"></a>×</p>
</td>
</tr>
<tr id="row15104331164711"><td class="cellrowborder" valign="top" width="25%" headers="mcps1.2.5.1.1 "><p id="p15104163120477"><a name="p15104163120477"></a><a name="p15104163120477"></a>Linux</p>
</td>
<td class="cellrowborder" valign="top" width="25%" headers="mcps1.2.5.1.2 "><p id="p15762194124714"><a name="p15762194124714"></a><a name="p15762194124714"></a>×</p>
<td class="cellrowborder" valign="top" width="25%" headers="mcps1.2.5.1.3 "><p id="p15762194124714"><a name="p15762194124714"></a><a name="p15762194124714"></a>√</p>
<td class="cellrowborder" valign="top" width="25%" headers="mcps1.2.5.1.4 "><p id="p4251543134711"><a name="p4251543134711"></a><a name="p4251543134711"></a>√</p>
</td>
</tr>
</tbody>
</table>

## LiteOS<a name="section6253122153515"></a>

OpenHarmony LiteOS内核是面向IoT领域的实时操作系统内核，它同时具备RTOS轻快和Linux易用的特点。

OpenHarmony LiteOS内核主要包括进程和线程调度、内存管理、IPC机制、timer管理等内核基本功能。

OpenHarmony LiteOS内核的源代码分为 kernel\_liteos\_a 和 kernel\_liteos\_m 这2个代码仓库，其中kernel\_liteos\_a主要针对小型系统（small system）和标准系统（standard system），而kernel\_liteos\_m则主要针对轻量系统（mini system），下面主要针对kernel\_liteos\_a代码仓库进行介绍。图1为OpenHarmony LiteOS-A内核架构图：

**图 1**  OpenHarmony LiteOS-A内核架构图<a name="fig225412228353"></a>  
![](figures/OpenHarmony-LiteOS-A内核架构图.png "OpenHarmony-LiteOS-A内核架构图")

## Linux<a name="section143373618411"></a>

OpenHarmony的Linux内核基于开源Linux内核LTS **4.19.y / 5.10.y** 分支演进，在此基线基础上，回合CVE补丁及OpenHarmony特性，作为OpenHarmony Common Kernel基线。针对不同的芯片，各厂商合入对应的板级驱动补丁，完成对OpenHarmony的基线适配。

Linux社区LTS 4.19.y分支信息请查看[kernel官网](https://git.kernel.org/pub/scm/linux/kernel/git/stable/linux.git/log/?h=linux-4.19.y)；

Linux社区LTS 5.10.y分支信息请查看[kernel官网](https://git.kernel.org/pub/scm/linux/kernel/git/stable/linux.git/log/?h=linux-5.10.y)。

内核的Patch组成模块，在编译构建流程中，针对具体芯片平台，合入对应的架构驱动代码，进行编译对应的内核镜像。所有补丁来源均遵守GPL-2.0协议。

## 目录<a name="section21571344112"></a>

```
kernel/
├── linux
│	├── linux-4.19						# OpenHarmony linux-4.19 Common kernel
│	├── linux-5.10						# OpenHarmony linux-5.10 Common kernel
│	├── build
│	│	├── BUILD.gn					# 编译框架GN文件
│	│	├── kernel.mk					# 内核编译文件
│	│	└── ohos.build					# 内核编译组件文件
│	├── patches
│	│	├── linux-4.19					# linux-4.19 相关patch
│	│	│   └── hi3516dv300_patch
│	│	│   		├── hi3516dv300.patch	# linux-4.19 hi3516dv300 SOC patch
│	│	│   		└── hdf.patch			# linux-4.19 hi3516dv300 hdf patch
│	│	└── linux-5.10
│	│	    └── hi3516dv300_patch
│	│	    		├── hi3516dv300.patch	# linux-5.10 hi3516dv300 SOC patch
│	│	    		└── hdf.patch			# linux-5.10 hi3516dv300 hdf patch
│	└── config
│		├── linux-4.19
│		│   └── arch
│		│       └── arm
│		│           └── configs
│		│               ├── hi3516dv300_small_defconfig       # 厂商Hisilicon对应的开源开发板Hi3516dv300小型系统的defconfig
│		│               ├── hi3516dv300_standard_defconfig    # 厂商Hisilicon对应的开源开发板Hi3516dv300标准系统的defconfig
│		│               ├── small_common_defconfig            # 小型系统的内核的common defconfig
│		│               └── standard_common_defconfig         # 标准系统的内核的common defconfig
│		└── linux-5.10
│		    └── arch
│		        └── arm
│		            └── configs
│		                ├── hi3516dv300_small_defconfig       # 厂商Hisilicon对应的开源开发板Hi3516dv300小型系统的defconfig
│		                ├── hi3516dv300_standard_defconfig    # 厂商Hisilicon对应的开源开发板Hi3516dv300标准系统的defconfig
│		                ├── small_common_defconfig            # 小型系统的内核的common defconfig
│		                └── standard_common_defconfig         # 标准系统的内核的common defconfig
└── liteos_a                    # liteos内核基线代码
     ├── apps                   # 用户态的init和shell应用程序
     ├── arch                   # 体系架构的目录，如arm等
     │   └── arm                # arm架构代码
     ├── bsd                    # freebsd相关的驱动和适配层模块代码引入，例如USB等
     ├── compat                 # 内核接口兼容性目录
     │   └── posix              # posix相关接口
     ├── drivers                # 内核驱动
     │   └── char               # 字符设备
     │       ├── mem            # 访问物理IO设备驱动
     │       ├── quickstart     # 系统快速启动接口目录
     │       ├── random         # 随机数设备驱动
     │       └── video          # framebuffer驱动框架
     ├── fs                     # 文件系统模块，主要来源于NuttX开源项目
     │   ├── fat                # fat文件系统
     │   ├── jffs2              # jffs2文件系统
     │   ├── include            # 对外暴露头文件存放目录
     │   ├── nfs                # nfs文件系统
     │   ├── proc               # proc文件系统
     │   ├── ramfs              # ramfs文件系统
     │   └── vfs                # vfs层
     ├── kernel                 # 进程、内存、IPC等模块
     │   ├── base               # 基础内核，包括调度、内存等模块
     │   ├── common             # 内核通用组件
     │   ├── extended           # 扩展内核，包括动态加载、vdso、liteipc等模块
     │   ├── include            # 对外暴露头文件存放目录
     │   └── user               # 加载init进程
     ├── lib                    # 内核的lib库
     ├── net                    # 网络模块，主要来源于lwip开源项目
     ├── platform               # 支持不同的芯片平台代码，如Hi3516DV300等
     │   ├── hw                 # 时钟与中断相关逻辑代码
     │   ├── include            # 对外暴露头文件存放目录
     │   └── uart               # 串口相关逻辑代码
     ├── platform               # 支持不同的芯片平台代码，如Hi3516DV300等
     ├── security               # 安全特性相关的代码，包括进程权限管理和虚拟id映射管理
     ├── syscall                # 系统调用
     └── tools                  # 构建工具及相关配置和代码
```

## 约束<a name="section19647171710417"></a>

LiteOS：

Hi3518EV300默认使用jffs2文件系统，Hi3516DV300默认使用FAT文件系统。若要使用其他文件系统，需要新增适配。

## 使用<a name="section1393789267"></a>

### LiteOS使用说明<a name="section118811457303"></a>

参见LiteOS-A内核[README](https://gitee.com/openharmony/kernel_liteos_a/blob/master/README_zh.md)和LiteOS-M内核[README](https://gitee.com/openharmony/kernel_liteos_m/blob/master/README_zh.md)的“使用说明”章节。

### linux使用说明<a name="section1352114469620"></a>

1. 合入HDF补丁

	在kernel/linux/build仓中，按照kernel.mk中HDF的补丁合入方法，合入不同内核版本对应的HDF内核补丁：
	
	```
	$(OHOS_BUILD_HOME)/drivers/adapter/khdf/linux/patch_hdf.sh $(OHOS_BUILD_HOME) $(KERNEL_SRC_TMP_PATH) $(HDF_PATCH_FILE)
	```

2. 合入芯片平台驱动补丁

	以Hi3516DV300为例：
	
	在kernel/linux/build仓中，按照kernel.mk中的芯片组件所对应的patch路径规则及命名规则，将对应的芯片组件patch放到对应路径下：
	
	```
	DEVICE_PATCH_DIR := $(OHOS_BUILD_HOME)/kernel/linux/patches/${KERNEL_VERSION}/$(DEVICE_NAME)_patch
	DEVICE_PATCH_FILE := $(DEVICE_PATCH_DIR)/$(DEVICE_NAME).patch
	```

3. 修改自己所需要编译的config

	在kernel/linux/build仓中，按照kernel.mk中的芯片组件所对应的patch路径规则及命名规则，将对应的芯片组件config放到对应路径下：
	
	```
	KERNEL_CONFIG_PATH := $(OHOS_BUILD_HOME)/kernel/linux/config/${KERNEL_VERSION}
	DEFCONFIG_FILE := $(DEVICE_NAME)_$(BUILD_TYPE)_defconfig
	```

	> **须知：**
	>
	>由于OpenHarmony工程的编译构建流程中会拷贝kernel/linux/linux-\*\.\*的代码环境后进行打补丁动作，在使用OpenHarmony的版本级编译命令前，需要kernel/linux/linux-\*\.\*原代码环境。
	>
	>根据不同系统工程，编译完成后会在out目录下的kernel目录中生成对应实际编译的内核，基于此目录的内核，进行对应的config修改，将最后生成的\.config文件cp到config仓对应的路径文件里，即可生效。

## 构建说明<a name="section19369206113115"></a>

以hi3516dv300开源开发板+ubuntu x86主机开发环境为例

使用工程的全量编译命令，编译生成uImage内核镜像

```
./build.sh --product-name Hi3516DV300              # 编译hi3516dv300镜像
    --build-target build_kernel                    # 编译hi3516dv300的uImage内核镜像
    --gn-args linux_kernel_version=\"linux-5.10\"  # 编译指定内核版本
```

## 相关仓<a name="section27639463106"></a>

**内核子系统**

LiteOS：

[drivers\_liteos](https://gitee.com/openharmony/drivers_liteos/blob/master/README_zh.md)

[kernel\_liteos\_a](https://gitee.com/openharmony/kernel_liteos_a/blob/master/README_zh.md)

[kernel\_liteos\_m](https://gitee.com/openharmony/kernel_liteos_m/blob/master/README_zh.md)

[device\_qemu](https://gitee.com/openharmony/device_qemu/blob/master/README_zh.md)

[prebuilts\_lite\_sysroot](https://gitee.com/openharmony/prebuilts_lite_sysroot/blob/master/README_zh.md)

Linux：

[kernel\_linux\_patches](https://gitee.com/openharmony/kernel_linux_patches/blob/master/README_zh.md)

[kernel\_linux\_config](https://gitee.com/openharmony/kernel_linux_config/blob/master/README_zh.md)

[kernel\_linux\_build](https://gitee.com/openharmony/kernel_linux_build/blob/master/README_zh.md)

[kernel\_linux\_4.19](https://gitee.com/openharmony/kernel_linux_4.19/blob/master/README)

[kernel\_linux\_5.10](https://gitee.com/openharmony/kernel_linux_5.10/blob/master/README)
