# 文件系统

M核的文件系统子系统当前支持的文件系统有FATFS与LittleFS。同A核一样，通过VFS层提供了POSIX标准的操作，保持了接口的一致性，但是因为M核的资源非常紧张，VFS层非常轻薄，没有提供类似A核的高级功能（如pagecache等），主要是接口的标准化和适配工作，具体的事务由各个文件系统实际承载。M核文件系统支持的功能如下表所示：


**表1** 功能列表

| 功能分类 | 接口名 | 描述 | FATFS | LITTLEFS | 
| -------- | -------- | -------- | -------- | -------- |
| 文件操作 | open | 打开文件 | 支持 | 支持 | 
| | close | 关闭文件 | 支持 | 支持 | 
| | read | 读取文件内容 | 支持 | 支持 | 
| | write | 往文件写入内容 | 支持 | 支持 | 
| | lseek | 设置文件偏移位置 | 支持 | 支持 | 
| | unlink | 删除文件 | 支持 | 支持 | 
| | rename | 重命名文件 | 支持 | 支持 | 
| | fstat | 通过文件句柄获取文件信息 | 支持 | 支持 | 
| | stat | 通过文件路径名获取文件信息 | 支持 | 支持 | 
| | fsync | 文件内容刷入存储设备 | 支持 | 支持 | 
| 目录操作 | mkdir | 创建目录 | 支持 | 支持 | 
| | opendir | 打开目录 | 支持 | 支持 | 
| | readdir | 读取目录项内容 | 支持 | 支持 | 
| | closedir | 关闭目录 | 支持 | 支持 | 
| | rmdir | 删除目录 | 支持 | 支持 | 
| 分区操作 | mount | 分区挂载 | 支持 | 支持 | 
| | umount | 分区卸载 | 支持 | 支持 | 
| | umount2 | 分区卸载，可通过MNT_FORCE参数进行强制卸载 | 支持 | 不支持 | 
| | statfs | 获取分区信息 | 支持 | 不支持 | 


- **[FAT](kernel-mini-extend-file-fat.md)**

- **[LittleFS](kernel-mini-extend-file-lit.md)**