# Volume Management

> ![icon-note.gif](public_sys-resources/icon-note.gif) **NOTE**<br/>
>
> - The initial APIs of this module are supported since API version 8. Newly added APIs will be marked with a superscript to indicate their earliest API version.
> - This is a system API and cannot be called by third-party applications.

## Modules to Import

```js
import volumemanager from "@ohos.volumeManager";
```

## volumemanager.getAllVolumes<sup>9+</sup>

getAllVolumes(): Promise&lt;Array&lt;Volume&gt;&gt;

Asynchronously obtains information about all available volumes. This method uses a promise to return the result.

**System capability**: SystemCapability.FileManagement.StorageService.Volume

- Return value

  | Type                              | Description                      |
  | ---------------------------------- | -------------------------- |
  | Promise&lt;[Volume](#volume)[]&gt; | Promise used to return the execution result.|

- Example

  ```js
  volumemanager.getAllVolumes().then(function(volumes){
      // do something
  });
  ```

## volumemanager.getAllVolumes<sup>9+</sup>

getAllVolumes(callback: AsyncCallback&lt;Array&lt;Volume&gt;&gt;): void

Asynchronously obtains information about all available volumes. This method uses a callback to return the result.

**System capability**: SystemCapability.FileManagement.StorageService.Volume

- Parameters

  | Name  | Type                                             | Mandatory| Description                                |
  | -------- | ------------------------------------------------- | ---- | ------------------------------------ |
  | callback | callback:AsyncCallback&lt;[Volume](#volume)[]&gt; | Yes  | Callback invoked to return the volume information obtained.|
  
- Example

  ```js
  let uuid = "";
  volumemanager.getAllVolumes(uuid, function(error, volumes){
      // do something
  });
  ```


## volumemanager.mount<sup>9+</sup>

mount(volumeId: string): Promise&lt;boolean&gt;

Asynchronously mounts a volume. This method uses a promise to return the result.

**System capability**: SystemCapability.FileManagement.StorageService.Volume

- Parameters

  | Name  | Type  | Mandatory| Description|
  | -------- | ------ | ---- | ---- |
  | volumeId | string | Yes  | Volume ID.|

- Return value

  | Type                  | Description      |
  | ---------------------- | ---------- |
  | Promise&lt;boolean&gt; | Promise used to return the execution result.|

- Example

  ```js
  let volumeId = "";
  volumemanager.mount(volumeId).then(function(flag){
      // do something
  });
  ```

## volumemanager.mount<sup>9+</sup>

mount(volumeId: string, callback:AsyncCallback&lt;boolean&gt;):void

Asynchronously obtains the available space of the specified volume. This method uses a callback to return the result.

**System capability**: SystemCapability.FileManagement.StorageService.Volume

- Parameters

  | Name  | Type                                 | Mandatory| Description                |
  | -------- | ------------------------------------- | ---- | -------------------- |
  | volumeId | string                                | Yes  | Volume ID.                |
  | callback | callback:AsyncCallback&lt;boolean&gt; | Yes  | Callback invoked to return the execution result.|

- Example

  ```js
  let volumeId = "";
  volumemanager.mount(volumeId, function(error, flag){
      // do something
  });
  ```

## volumemanager.unmount<sup>9+</sup>

unmount(volumeId: string): Promise&lt;boolean&gt;

Asynchronously unmounts a volume. This method uses a promise to return the result.

**System capability**: SystemCapability.FileManagement.StorageService.Volume

- Parameters

  | Name  | Type  | Mandatory| Description|
  | -------- | ------ | ---- | ---- |
  | volumeId | string | Yes  | Volume ID.|

- Return value

  | Type                  | Description      |
  | ---------------------- | ---------- |
  | Promise&lt;boolean&gt; | Promise used to return the execution result.|

- Example

  ```js
  let volumeId = "";
  volumemanager.unmount(volumeId).then(function(flag){
      // do something
  });
  ```

## volumemanager.unmount<sup>9+</sup>

unmount(volumeId: string, callback:AsyncCallback&lt;boolean&gt;):void

Asynchronously unmounts a volume. This method uses a callback to return the result.

**System capability**: SystemCapability.FileManagement.StorageService.Volume

- Parameters

  | Name  | Type                                 | Mandatory| Description                |
  | -------- | ------------------------------------- | ---- | -------------------- |
  | volumeId | string                                | Yes  | Volume ID.                |
  | callback | callback:AsyncCallback&lt;boolean&gt; | Yes  | Callback invoked to return the execution result.|

- Example

  ```js
  let volumeId = "";
  volumemanager.unmount(volumeId, function(error, flag){
      // do something
  });
  ```

## Volume<sup>9+</sup>

**System capability**: SystemCapability.FileManagement.StorageService.Volume

### Attributes

| Name       | Type   | Description                |
| ----------- | ------- | -------------------- |
| id<sup>9+</sup>          | number  | Volume ID.                |
| uuid<sup>9+</sup>        | string  | Universally unique identifier (UUID) of the volume.              |
| description<sup>9+</sup> | string  | Description of the volume.          |
| removable<sup>9+</sup> | boolean | Whether the volume is a removable storage device.|
| state<sup>9+</sup>       | int     | Current volume status.          |
| path<sup>9+</sup>        | string  | Mount address of the volume.        |
