# 基本概念<a name="ZH-CN_TOPIC_0000001124074751"></a>

-   [运行机制](#section070665816719)
    -   [定时器状态](#section115453813506)
    -   [定时器模式](#section137521353175010)


软件定时器，是基于系统Tick时钟中断且由软件来模拟的定时器，当经过设定的Tick时钟计数值后会触发用户定义的回调函数。定时精度与系统Tick时钟的周期有关。

硬件定时器受硬件的限制，数量上不足以满足用户的实际需求，因此为了满足用户需求，提供更多的定时器，OpenHarmony LiteOS-M内核提供软件定时器功能。软件定时器扩展了定时器的数量，允许创建更多的定时业务。

软件定时器功能上支持：

-   静态裁剪：能通过宏关闭软件定时器功能。
-   软件定时器创建。
-   软件定时器启动。
-   软件定时器停止。
-   软件定时器删除。
-   软件定时器剩余Tick数获取。

## 运行机制<a name="section070665816719"></a>

软件定时器是系统资源，在模块初始化的时候已经分配了一块连续的内存，系统支持的最大定时器个数由los\_config.h中的LOSCFG\_BASE\_CORE\_SWTMR\_LIMIT宏配置。

软件定时器使用了系统的一个队列和一个任务资源，软件定时器的触发遵循队列规则，先进先出。定时时间短的定时器总是比定时时间长的靠近队列头，满足优先被触发的准则。

软件定时器以Tick为基本计时单位，当用户创建并启动一个软件定时器时，OpenHarmony LiteOS-M内核会根据当前系统Tick时间及用户设置的定时间隔确定该定时器的到期Tick时间，并将该定时器控制结构挂入计时全局链表。

当Tick中断到来时，在Tick中断处理函数中扫描软件定时器的计时全局链表，看是否有定时器超时，若有则将超时的定时器记录下来。

Tick中断处理函数结束后，软件定时器任务（优先级为最高）被唤醒，在该任务中调用之前记录下来的定时器的超时回调函数。

### 定时器状态<a name="section115453813506"></a>

-   OS\_SWTMR\_STATUS\_UNUSED（未使用）

系统在定时器模块初始化的时候将系统中所有定时器资源初始化成该状态。

-   OS\_SWTMR\_STATUS\_CREATED（创建未启动/停止）

在未使用状态下调用LOS\_SwtmrCreate接口或者启动后调用LOS\_SwtmrStop接口后，定时器将变成该状态。

-   OS\_SWTMR\_STATUS\_TICKING（计数）

在定时器创建后调用LOS\_SwtmrStart接口，定时器将变成该状态，表示定时器运行时的状态。

### 定时器模式<a name="section137521353175010"></a>

OpenHarmony LiteOS-M内核的软件定时器提供三类定时器机制：

-   第一类是单次触发定时器，这类定时器在启动后只会触发一次定时器事件，然后定时器自动删除。
-   第二类是周期触发定时器，这类定时器会周期性的触发定时器事件，直到用户手动地停止定时器，否则将永远持续执行下去。
-   第三类也是单次触发定时器，但与第一类不同之处在于这类定时器超时后不会自动删除，需要调用定时器删除接口删除定时器。

