# UI

- 方舟开发框架（ArkUI）
    - [方舟开发框架概述](arkui-overview.md)
    - 基于JS扩展的类Web开发范式
        - [概述](ui-js-overview.md)
        - 框架说明
            - [文件组织](js-framework-file.md)
            - [js标签配置](js-framework-js-tag.md)
            - [app.js](js-framework-js-file.md)
            - 语法
                - [HML语法参考](js-framework-syntax-hml.md)
                - [CSS语法参考](js-framework-syntax-css.md)
                - [JS语法参考](js-framework-syntax-js.md)
            - [生命周期](js-framework-lifecycle.md)
            - [资源限定与访问](js-framework-resource-restriction.md)
            - [多语言支持](js-framework-multiple-languages.md)
        - 构建用户界面
            - [组件介绍](ui-js-building-ui-component.md)
            - 构建布局
                - [布局说明](ui-js-building-ui-layout-intro.md)
                - [添加标题行和文本区域](ui-js-building-ui-layout-text.md)
                - [添加图片区域](ui-js-building-ui-layout-image.md)
                - [添加留言区域](ui-js-building-ui-layout-comment.md)
                - [添加容器](ui-js-building-ui-layout-external-container.md)
            - [添加交互](ui-js-building-ui-interactions.md)
            - [动画](ui-js-building-ui-animation.md)
            - [事件](ui-js-building-ui-event.md)
            - [页面路由](ui-js-building-ui-routes.md)
        - 常见组件开发指导
            - [Text](ui-js-components-text.md)
            - [Input](ui-js-components-input.md)
            - [Button](ui-js-components-button.md)
            - [List](ui-js-components-list.md)
            - [Picker](ui-js-components-picker.md)
            - [Dialog](ui-js-components-dialog.md)
            - [Form](ui-js-components-form.md)
            - [Stepper](ui-js-components-stepper.md)
            - [Tabs](ui-js-component-tabs.md)
            - [Image](ui-js-components-images.md)
        - 动效开发指导
            - CSS动画
                - [属性样式动画](ui-js-animate-attribute-style.md)
                - [transform样式动画](ui-js-animate-transform.md)
                - [background-position样式动画](ui-js-animate-background-position-style.md)
            - JS动画
                - [组件动画](ui-js-animate-component.md)
                - 插值器动画
                    - [动画动效](ui-js-animate-dynamic-effects.md)
                    - [动画帧](ui-js-animate-frame.md)
        - [自定义组件](ui-js-custom-components.md)
    - 基于TS扩展的声明式开发范式
        - [概述](ui-ts-overview.md)
        - 框架说明
            - 文件组织
                - [目录结构](ts-framework-directory.md)
                - [应用代码文件访问规则](ts-framework-file-access-rules.md)
            - [js标签配置](ts-framework-js-tag.md)
            - 资源访问
                - [媒体资源类型说明](ts-media-resource-type.md)
            - [像素单位](ts-pixel-units.md)
            - [类型定义](ts-types.md)
        - 声明式语法
            - [描述规范使用说明](ts-syntax-intro.md)
            - 通用UI描述规范
                - [基本概念](ts-general-ui-concepts.md)
                - 声明式UI描述规范
                    - [无构造参数配置](ts-parameterless-configuration.md)
                    - [必选参数构造配置](ts-configuration-with-mandatory-parameters.md)
                    - [属性配置](ts-attribution-configuration.md)
                    - [事件配置](ts-event-configuration.md)
                    - [子组件配置](ts-child-component-configuration.md)
                - 组件化
                    - [@Component](ts-component-based-component.md)
                    - [@Entry](ts-component-based-entry.md)
                    - [@Preview](ts-component-based-preview.md)
                    - [@Builder](ts-component-based-builder.md)
                    - [@Extend](ts-component-based-extend.md)
                    - [@CustomDialog](ts-component-based-customdialog.md)
            - UI状态管理
                - [基本概念](ts-ui-state-mgmt-concepts.md)
                - 管理组件拥有的状态
                    - [@State](ts-component-states-state.md)
                    - [@Prop](ts-component-states-prop.md)
                    - [@Link](ts-component-states-link.md)
                - 管理应用程序的状态
                    - 接口
                        - [应用程序的数据存储](ts-application-states-appstorage.md)
                        - [持久化数据管理](ts-application-states-apis-persistentstorage.md)
                        - [环境变量](ts-application-states-apis-environment.md)
                    - [AppStorage与组件同步](ts-application-states-storagelink-storageprop.md)
                - 其他类目的状态管理
                    - [Observed和ObjectLink数据管理](ts-other-states-observed-objectlink.md)
                    - [@Consume和@Provide数据管理](ts-other-states-consume-provide.md)
                    - [@Watch](ts-other-states-watch.md)
            - 渲染控制语法
                - [条件渲染](ts-rending-control-syntax-if-else.md)
                - [循环渲染](ts-rending-control-syntax-foreach.md)
                - [数据懒加载](ts-rending-control-syntax-lazyforeach.md)
            - 深入理解组件化
                - [build函数](ts-function-build.md)
                - [自定义组件初始化](ts-custom-component-initialization.md)
                - [自定义组件生命周期回调函数](ts-custom-component-lifecycle-callbacks.md)
                - [组件创建和重新初始化示例](ts-component-creation-re-initialization.md)
            - 语法糖
                - [装饰器](ts-syntactic-sugar-decorator.md)
                - [链式调用](ts-syntactic-sugar-chaining.md)
                - [struct对象](ts-syntactic-sugar-struct.md)
                - [在实例化过程中省略"new"](ts-instantiating-a-struct-without-new-keyword.md)
                - [组件创建使用独立一行](ts-using-a-separate-line-for-new-component.md)
                - [生成器函数内使用TS语言的限制](ts-restrictions-for-generators.md)
        - 体验声明式UI
            - [创建声明式UI工程](ui-ts-creating-project.md)
            - [初识Component](ui-ts-components.md)
            - [创建简单视图](ui-ts-creating-simple-page.md)
        - 页面布局与连接
            - [构建食物数据模型](ui-ts-building-data-model.md)
            - [构建食物列表List布局](ui-ts-building-category-list-layout.md)
            - [构建食物分类Grid布局](ui-ts-building-category-grid-layout.md)
            - [页面跳转与数据传递](ui-ts-page-redirection-data-transmission.md)
