# 通用样式<a name="ZH-CN_TOPIC_0000001173324679"></a>

组件普遍支持的可以在style或css中设置组件外观样式。

<table><thead align="left"><tr><th class="cellrowborder" valign="top" width="27.04270427042704%" id="mcps1.1.5.1.1"><p>名称</p>
</th>
<th class="cellrowborder" valign="top" width="20.402040204020402%" id="mcps1.1.5.1.2"><p>类型</p>
</th>
<th class="cellrowborder" valign="top" width="11.601160116011602%" id="mcps1.1.5.1.3"><p>默认值</p>
</th>
<th class="cellrowborder" valign="top" width="40.954095409540955%" id="mcps1.1.5.1.4"><p>描述</p>
</th>
</tr>
</thead>
<tbody><tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>width</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>&lt;length&gt; | &lt;percentage&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>设置组件自身的宽度。</p>
<p>缺省时使用元素自身内容需要的宽度。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>height</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>&lt;length&gt;<span></span> | &lt;percentage&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>设置组件自身的高度。</p>
<p>缺省时使用元素自身内容需要的高度。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>min-width<sup><span>5+</span></sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>&lt;length&gt; | &lt;percentage&gt;<sup><span>6+</span></sup></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>设置元素的最小宽度。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>min-height<sup>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>&lt;length&gt; | &lt;percentage&gt;<sup><span>6+</span></sup></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>设置元素的最小高度。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>max-width<sup><span>5+</span></sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>&lt;length&gt; | &lt;percentage&gt;<sup><span>6+</span></sup></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>设置元素的最大宽度。默认无限制。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>max-height<sup>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>&lt;length&gt; | &lt;percentage&gt;<sup><span>6+</span></sup></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>设置元素的最大高度。默认无限制。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>padding</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>&lt;length&gt; | &lt;percentage&gt;<sup><span>5+</span></sup></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>使用简写属性设置所有的内边距属性。</p>
<div class="p">该属性可以有1到4个值：<ul><li><p>指定一个值时，该值指定四个边的内边距。</p>
</li><li><p>指定两个值时，第一个值指定上下两边的内边距，第二个指定左右两边的内边距。</p>
</li><li><p>指定三个值时，第一个指定上边的内边距，第二个指定左右两边的内边距，第三个指定下边的内边距。</p>
</li><li><p>指定四个值时分别为上、右、下、左边的内边距（顺时针顺序）。</p>
</li></ul>
</div>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>padding-[left|top|right|bottom]</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>&lt;length&gt; | &lt;percentage&gt;<sup><span>5+</span></sup></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>设置左、上、右、下内边距属性。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>padding-[start|end]</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>&lt;length&gt; | &lt;percentage&gt;<sup><span>5+</span></sup></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>设置起始和末端内边距属性。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>margin</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>&lt;length&gt; | &lt;percentage&gt;<sup>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>使用简写属性设置所有的外边距属性，该属性可以有1到4个值。</p>
<ul><li><p>只有一个值时，这个值会被指定给全部的四个边。</p>
</li><li><p>两个值时，第一个值被匹配给上和下，第二个值被匹配给左和右。</p>
</li><li><p>三个值时，第一个值被匹配给上, 第二个值被匹配给左和右，第三个值被匹配给下。</p>
</li><li><p>四个值时，会依次按上、右、下、左的顺序匹配 (即顺时针顺序)。</p>
</li></ul>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>margin-[left|top|right|bottom]</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>&lt;length&gt; | &lt;percentage&gt;<sup><span>5+</span></sup></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>设置左、上、右、下外边距属性。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>margin-[start|end]</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>&lt;length&gt; | &lt;percentage&gt;<sup><span>5+</span></sup></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>设置起始和末端外边距属性。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>border</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>-</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>使用简写属性设置所有的边框属性，包含边框的宽度，样式，颜色属性，顺序设置为border-width、border-style、border-color，不设置时，各属性值为默认值。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>border-style</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>string</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>solid</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>使用简写属性设置所有边框的样式，可选值为：</p>
<ul><li>dotted：显示为一系列圆点，圆点半径为border-width的一半。</li><li>dashed：显示为一系列短的方形虚线。</li></ul>
<ul><li>solid：显示为一条实线。</li></ul>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>border-[left|top|right|bottom]-style</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>string</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>solid</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>分别设置左、上、右、下四个边框的样式，可选值为dotted、dashed、solid。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>border-[left|top|right|bottom]</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>-</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>使用简写属性设置对应位置的边框属性，包含边框的宽度，样式，颜色属性，顺序设置为border-width、border-style、border-color，不设置的值为默认值。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>border-width</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>使用简写属性设置元素的所有边框宽度<span>，或者单独为各边边框设置宽度</span>。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>border-[left|top|right|bottom]-width</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>分别设置左、上、右、下四个边框的宽度。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>border-color</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>black</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>使用简写属性设置元素的所有边框颜色<span>，或者单独为各边边框设置颜色</span>。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>border-[left|top|right|bottom]-color</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>black</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>分别设置左、上、右、下四个边框的颜色。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>border-radius</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>border-radius属性设置元素的外边框圆角半径。<span>设置border-radius时不能单独设置某一个方向的border-[left|top|right|bottom]-width，border-[left|top|right|bottom]-color ，border-[left|top|right|bottom]-style，如果要设置color、width和style，需要将四个方向一起设置（border-width、border-color、border-style）。</span></p>
<div class="note"><span class="notetitle"> 说明： </span><div class="notebody"><p>顺序为左下、右下、左上和右上。</p>
</div></div>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>border-[top|bottom]-[left|right]-radius</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>分别设置左上，右上，右下和左下四个角的圆角半径。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>background</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>&lt;linear-gradient&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>仅支持设置<a href="js-components-common-gradient.md">渐变样式</a>，与background-color、background-image不兼容。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>background-color</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>设置背景颜色。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>background-image</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>string</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>设置背景图片。与background-color、background不兼容，支持本地图片资源地址。</p>
<p>示例：</p>
<ul><li>background-image: url("/common/background.png")<div class="note"><span class="notetitle"> 说明： </span><div class="notebody"><p>不支持svg格式图片。</p>
</div></div>
</li></ul>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>background-size</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><ul><li>string</li><li>&lt;length&gt; &lt;length&gt;</li><li>&lt;percentage&gt; &lt;percentage&gt;</li></ul>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>auto</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>设置背景图片的大小。</p>
<ul><li>string可选值：<ul><li>contain：把图片扩展至最大尺寸，以使其高度和宽度完全适用内容区域。</li><li>cover：把背景图片扩展至足够大，以使背景图片完全覆盖背景区域；背景图片的某些部分也许无法显示在背景定位区域中。</li><li>auto：保持原图的比例不变。</li></ul>
</li><li>length值参数方式：<p>设置背景图片的高度和宽度。第一个值设置宽度，第二个值设置高度。如果只设置一个值，则第二个值会被设置为 "auto"。</p>
</li><li>百分比参数方式：<p>以父元素的百分比来设置背景图片的宽度和高度。第一个值设置宽度，第二个值设置高度。如果只设置一个值，则第二个值会被设置为 "auto"。</p>
</li></ul>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>background-repeat</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>string</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>repeat</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>针对重复背景图片样式进行设置，背景图片默认在水平和垂直方向上重复。</p>
<ul><li>repeat：在水平轴和竖直轴上同时重复绘制图片。</li><li>repeat-x：只在水平轴上重复绘制图片。</li><li>repeat-y：只在竖直轴上重复绘制图片。</li><li>no-repeat：不会重复绘制图片。</li></ul>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>background-position</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><ul><li>string string</li><li>&lt;length&gt; &lt;length&gt;</li><li>&lt;percentage&gt; &lt;percentage&gt;</li></ul>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>0px 0px</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><ul><li>关键词方式：如果仅规定了一个关键词，那么第二个值为"center"。两个值分别定义水平方向位置和竖直方向位置。<ul><li>left：水平方向上最左侧。</li><li>right：水平方向上最右侧。</li><li>top：竖直方向上最顶部。</li><li>bottom：竖直方向上最底部。</li><li>center：水平方向或竖直方向上中间位置。</li></ul>
</li></ul>
<ul><li>length值参数方式：第一个值是水平位置，第二个值是垂直位置。 左上角是 0 0。单位是像素 (0px 0px)  。如果仅规定了一个值，另外一个值将是50%。</li><li>百分比参数方式：第一个值是水平位置，第二个值是垂直位置。左上角是 0% 0%。右下角是 100% 100%。如果仅规定了一个值，另外一个值为50%。</li><li>可以混合使用&lt;percentage&gt;和&lt;length&gt;。</li></ul>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>box-shadow<sup><span>5+</span></sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>string</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>语法：box-shadow: h-shadow v-shadow blur spread color</p>
<p>通过这个样式可以设置当前组件的阴影样式，包括水平位置(必填)、垂直位置(必填)、模糊半径(可选，默认值为0)、阴影延展距离(可选，默认值为0)、阴影颜色(可选，默认值为黑色)。</p>
<p>示例：</p>
<ul><li>box-shadow :10px 20px 5px 10px #888888</li><li>box-shadow :100px 100px 30px red</li><li>box-shadow :-100px -100px 0px 40px</li></ul>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>filter<sup><span>5+</span></sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>string</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>语法：filter: blur(px)</p>
<p>通过这个样式可以设置当前组件布局范围的内容模糊，参数用于指定模糊半径，如果没有设置值，则默认是0(不模糊)，不支持百分比。</p>
<p>示例：</p>
<ul><li>filter: blur(10px)</li></ul>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>backdrop-filter<sup><span>5+</span></sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>string</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>语法：backdrop-filter: blur(px)</p>
<p>通过这个样式可以设置当前组件布局范围的背景模糊，参数用于指定模糊半径，如果没有设置值，则默认是0(不模糊)，不支持百分比。</p>
<p>示例：</p>
<ul><li>backdrop-filter: blur(10px)</li></ul>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>opacity</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>number</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>1</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>元素的透明度，取值范围为0到1，1表示为不透明，0表示为完全透明。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>display</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>string</p>
<p></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>flex</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>确定一个元素所产生的框的类型，可选值为：</p>
<ul><li>flex：弹性布局。</li><li>none：不渲染此元素。</li></ul>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>visibility</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>string</p>
<p></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>visible</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>是否显示元素所产生的框。不可见的框会占用布局（将'display'属性设置为'none'来完全去除框），可选值为：</p>
<ul><li>visible：元素正常显示。</li><li>hidden：隐藏元素，但是其他元素的布局不改变，相当于此元素变成透明。</li></ul>
<div class="note"><span class="notetitle"> 说明： </span><div class="notebody"><p>visibility和display样式都设置时，仅display生效。</p>
</div></div>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>flex</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>number | string</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>规定当前组件如何适应父组件中的可用空间。</p>
<p>flex可以指定1个、2个<sup>5+</sup>或3个<sup>5+</sup>值。</p>
<p>单值语法：</p>
<ul><li>一个无单位数：用来设置组件的flex-grow。</li><li>一个有效的宽度值<sup>5+</sup>：用来设置组件的flex-basis。</li></ul>
<p>双值语法<sup>5+</sup>：</p>
<p>第一个值必须是无单位数，用来设置组件的flex-grow。第二个值是以下之一：</p>
<ul><li>一个无单位数：用来设置组件的flex-shrink。</li><li>一个有效的宽度值：用来设置组件的flex-basis。</li></ul>
<p>三值语法<sup>5+</sup>：</p>
<p>第一个值必须是无单位数，用来设置组件的flex-grow；第二个值必须是无单位数，用来设置组件的flex-shrink；第三个值必须是一个有效的宽度值，用来设置组件的flex-basis。</p>
<div class="note"><span class="notetitle"> 说明： </span><div class="notebody"><p>仅父容器为&lt;div&gt;、&lt;list-item&gt;、&lt;tabs&gt;、&lt;refresh&gt;、&lt;stepper-item&gt;<sup><span>5+</span></sup>时生效。</p>
</div></div>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>flex-grow</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>number</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>设置组件的拉伸样式，指定父组件容器主轴方向上剩余空间（容器本身大小减去所有flex子元素占用的大小）的分配权重。0为不伸展。</p>
<div class="note"><span class="notetitle"> 说明： </span><div class="notebody"><p>仅父容器为&lt;div&gt;、&lt;list-item&gt;、&lt;tabs&gt;、&lt;refresh&gt;、&lt;stepper-item&gt;<sup><span>5+</span></sup>时生效。</p>
</div></div>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>flex-shrink</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>number</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>1</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>设置组件的收缩样式，元素仅在默认宽度之和大于容器的时候才会发生收缩，0为不收缩。</p>
<div class="note"><span class="notetitle"> 说明： </span><div class="notebody"><p>仅父容器为&lt;div&gt;、&lt;list-item&gt;、&lt;tabs&gt;、&lt;refresh&gt;、&lt;stepper-item&gt;<sup><span>5+</span></sup>时生效。</p>
</div></div>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>flex-basis</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>&lt;length&gt;</p>
<p></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>设置组件在主轴方向上的初始大小。</p>
<div class="note"><span class="notetitle"> 说明： </span><div class="notebody"><p>仅父容器为&lt;div&gt;、&lt;list-item&gt;、&lt;tabs&gt;、&lt;refresh&gt;、&lt;stepper-item&gt;<sup><span>5+</span></sup>时生效。</p>
</div></div>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>align-self<sup>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>string</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>设置自身在父元素交叉轴上的对齐方式，该样式会覆盖父元素的align-items样式，仅在父容器为div、list。可选值为：</p>
<ul><li>stretch 弹性元素被在交叉轴方向被拉伸到与容器相同的高度或宽度。</li><li>flex-start 元素向交叉轴起点对齐。</li><li>flex-end 元素向交叉轴终点对齐。</li><li>center 元素在交叉轴居中。</li><li>baseline 元素在交叉轴基线对齐。</li></ul>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>position</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>string</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>relative</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>设置元素的定位类型，不支持动态变更。</p>
<ul><li>fixed：相对与整个界面进行定位。</li><li>absolute：相对于父元素进行定位。</li><li>relative：相对于其正常位置进行定位。</li></ul>
<div class="note"><span class="notetitle"> 说明： </span><div class="notebody"><p>absolute属性仅在父容器为&lt;div&gt;、&lt;stack&gt;时生效。</p>
</div></div>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>[left|top<span>|right|bottom</span>]</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>&lt;length&gt; | &lt;percentage&gt;<sup><span>6</span><span>+</span></sup></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>left|top<span>|right|bottom</span>需要配合position样式使用，来确定元素的偏移位置。</p>
<ul><li>left属性规定元素的左边缘。该属性定义了定位元素左外边距边界与其包含块左边界之间的偏移。</li><li>top属性规定元素的顶部边缘。该属性定义了一个定位元素的上外边距边界与其包含块上边界之间的偏移。</li><li>right属性规定元素的右边缘。该属性定义了定位元素右外边距边界与其包含块右边界之间的偏移。</li><li>bottom属性规定元素的底部边缘。该属性定义了一个定位元素的下外边距边界与其包含块下边界之间的偏移。</li></ul>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>[start | end]<sup><span>6+</span></sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>&lt;length&gt; | &lt;percentage&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>start | end需要配合position样式使用，来确定元素的偏移位置。</p>
<ul><li>start属性规定元素的起始边缘。该属性定义了定位元素起始外边距边界与其包含块起始边界之间的偏移。</li><li>end属性规定元素的结尾边缘。该属性定义了一个定位元素的结尾边距边界与其包含块结尾边界之间的偏移。</li></ul>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>z-index<sup><span>6+</span></sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>number</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>表示对于同一父节点其子节点的渲染顺序。数值越大，渲染数据越靠后。</p>
<div class="note"><span class="notetitle"> 说明： </span><div class="notebody"><p>z-index不支持auto，并且opacity等其他样式不会影响z-index的渲染顺序。</p>
</div></div>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>image-fill<sup>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>为svg图片填充颜色，支持组件范围（与设置图片资源的属性）：button（icon属性）、piece（icon属性）、search（icon属性）、input（headericon属性）、textarea（headericon属性）、image（src属性）、toolbar-item(icon属性)。</p>
<p>svg图片文件内的fill属性颜色值在渲染时将被替换为image-fill所配的颜色值，且仅对svg图片内显示声明的fill属性生效。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>clip-path<sup>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>[ &lt;geometry-box&gt; || &lt;basic-shape&gt; ] | none</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>设置组件的裁剪区域。区域内的部分显示，区域外的不显示。</p>
<p>&lt;geometry-box&gt;：表示裁剪区域的作用范围，默认为border-box。可选值为：</p>
<ul><li>margin-box：margin计算入长宽尺寸内。</li><li>border-box：border计算入长宽尺寸内。</li><li>padding-box：padding计算入长宽尺寸内。</li><li>content-box：margin/border/padding不计算入长宽尺寸内。</li></ul>
<p>&lt;basic-shape&gt;：表示裁剪的形状。包含以下类型：</p>
<ul><li>inset，格式为：inset( &lt;percentage&gt;{1,4} [ round &lt;'border-radius'&gt; ]? )。</li><li>circle，格式为：circle( [ &lt;percentage&gt; ]? [ at &lt;percentage&gt; &lt;percentage&gt; ]? )。</li><li>ellipse，格式为：ellipse( [ &lt;percentage&gt;{2} ]? [ at &lt;percentage&gt; &lt;percentage&gt; ]? )。</li><li>polygon，格式为：polygon( [ &lt;percentage&gt; &lt;percentage&gt; ]# )</li><li>path，格式为：path( &lt;string&gt; )。</li></ul>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>mask-image<sup>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><ul><li>&lt;linear-gradient&gt;</li><li>string</li></ul>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>设置渐变色遮罩或本地图片设置。</p>
<p>设置渐变色遮罩，示例：</p>
<p>linear-gradient(to left, black, white)</p>
<p>设置纯色遮罩，示例：</p>
<p>linear-gradient(to right, grey , grey)</p>
<p>设置本地svg图片为遮罩，示例：url(common/mask.svg)</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>mask-size<sup>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><ul><li>string</li><li>&lt;length&gt;&lt;length&gt;</li><li>&lt;percentage&gt; &lt;percentage&gt;</li></ul>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>auto</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>设置遮罩图片显示大小，仅当mask-image为图片资源时有效。</p>
<p>string可选值：</p>
<ul><li>contain：把图像扩展至最大尺寸，以使其高度和宽度完全适用内容区域。</li><li>cover：把图像扩展至足够大，以使背景图像完全覆盖背景区域；背景图像的某些部分也许无法显示在背景定位区域中。</li><li>auto：保持原图的比例不变。</li></ul>
<p>length值参数方式：设置图像的高度和宽度。第一个值设置宽度，第二个值设置高度。如果只设置一个值，则第二个值会被设置为 "auto"。</p>
<p>百分比参数方式：以原图宽高的百分比来设置图像的宽度和高度。第一个值设置宽度，第二个值设置高度。如果只设置一个值，则第二个值会被设置为 "auto"。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>mask-position<sup>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><ul><li>string string</li><li>&lt;length&gt; &lt;length&gt;</li><li>&lt;percentage&gt; &lt;percentage&gt;</li></ul>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>0px 0px</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>设置遮罩图片显示位置，仅当mask-image为图片资源时有效。关键词方式：如果仅规定了一个关键词，那么第二个值为"center"。两个值分别定义水平方向位置和竖直方向位置。</p>
<p>string可选值：</p>
<ul><li>left：水平方向上最左侧。</li><li>right：水平方向上最右侧。</li><li>top：竖直方向上最顶部。</li><li>bottom：竖直方向上最底部。</li><li>center：水平方向或竖直方向上中间位置。</li></ul>
<p>length值参数方式：第一个值是水平位置，第二个值是垂直位置。 左上角是 0 0。单位是像素 (0px 0px)  。如果仅规定了一个值，另外一个值将是50%。</p>
<p>百分比参数方式：第一个值是水平位置，第二个值是垂直位置。左上角是 0% 0%。右下角是 100% 100%。如果仅规定了一个值，另外一个值为50%。</p>
<p>可以混合使用&lt;percentage&gt;和&lt;length&gt;。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>border-image-source<sup>7+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>string</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>指定元素的边框图片。</p>
<p>示例：</p>
<p>border-image-source: url("/common/images/border.png")</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>border-image-slice<sup>7+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>&lt;length&gt; | &lt;percentage&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>指定图片的边界内向偏移。</p>
<p>该属性可以有1到4个值：</p>
<p>指定一个值时，该值指定四个边的内偏移。</p>
<p>指定两个值时，第一个值指定上下两边的内偏移，第二个指定左右两边的内偏移。</p>
<p>指定三个值时，第一个指定上边的内偏移，第二个指定左右两边的内偏移，第三个指定下边的内偏移。</p>
<p>指定四个值时分别为上、右、下、左边的内偏移（顺时针顺序）。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>border-image-width<sup>7+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>&lt;length&gt; | &lt;percentage&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>指定图片边界的宽度。</p>
<p>指定一个值时，该值指定四个边的宽度。</p>
<p>指定两个值时，第一个值指定上下两边的宽度 ，第二个指定左右两边的宽度。</p>
<p>指定三个值时，第一个指定上边的宽度 ，第二个指定左右两边的宽度 ，第三个指定下边的宽度。</p>
<p>指定四个值时分别为上、右、下、左边的宽度 （顺时针顺序）。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>border-image-outset<sup>7+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>&lt;length&gt; | &lt;percentage&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>指定边框图像可超出边框的大小。</p>
<p>指定一个值时，边框图像在四个方向超出边框的距离。</p>
<p>指定两个值时，第一个值指定上下两边的边框图像超出边框的距离，第二个指定左右两边的 。</p>
<p>指定三个值时，第一个指定上边的边框图像超出边框的距离 ，第二个指定左右两边的边框图像超出边框的距离 ，第三个指定下边的边框图像超出边框的距离 。</p>
<p>指定四个值时分别为上、右、下、左边的边框图像超出边框的距离 （顺时针顺序）。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>border-image-repeat<sup>7+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>string</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>stretch</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>定义图片如何填充边框。</p>
<p>stretch: 拉伸图片以填充边框。</p>
<p>repeat：平铺图片以填充边框。</p>
<p>round：平铺图像。当不能整数次平铺时，根据情况放大或缩小图像。</p>
</td>
</tr>
<tr><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p>border-image<sup>7+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p>string</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p>简写属性，可以选择以下两种设置方式：</p>
<ul><li>设置图片边框的每个属性。包含图像的边界向内偏移，图像边界的宽度，边框图像可超出边框盒的大小，图片如何填充边框，顺序设置为 border-image-source ,border-image-slice,border-image-width,border-image-outset,border-image-repeat，不设置的值为默认值。<p>语法参考:<a href="https://developer.mozilla.org/zh-CN/docs/Web/CSS/border-image-source" target="_blank" rel="noopener noreferrer">&lt;'border-image-source'&gt;</a> <a href="https://developer.mozilla.org/zh-CN/docs/Web/CSS/Value_definition_syntax#double_bar" target="_blank" rel="noopener noreferrer">||</a> <a href="https://developer.mozilla.org/zh-CN/docs/Web/CSS/border-image-slice" target="_blank" rel="noopener noreferrer">&lt;'border-image-slice'&gt;</a> <a href="https://developer.mozilla.org/zh-CN/docs/Web/CSS/Value_definition_syntax#brackets" target="_blank" rel="noopener noreferrer">[</a> / <a href="https://developer.mozilla.org/zh-CN/docs/Web/CSS/border-image-width" target="_blank" rel="noopener noreferrer">&lt;'border-image-width'&gt;</a> <a href="https://developer.mozilla.org/zh-CN/docs/Web/CSS/Value_definition_syntax#single_bar" target="_blank" rel="noopener noreferrer">|</a> / <a href="https://developer.mozilla.org/zh-CN/docs/Web/CSS/border-image-width" target="_blank" rel="noopener noreferrer">&lt;'border-image-width'&gt;</a><a href="https://developer.mozilla.org/zh-CN/docs/Web/CSS/Value_definition_syntax#question_mark" target="_blank" rel="noopener noreferrer">?</a> / <a href="https://developer.mozilla.org/zh-CN/docs/Web/CSS/border-image-outset" target="_blank" rel="noopener noreferrer">&lt;'border-image-outset'&gt;</a> <a href="https://developer.mozilla.org/zh-CN/docs/Web/CSS/Value_definition_syntax#brackets" target="_blank" rel="noopener noreferrer">]</a><a href="https://developer.mozilla.org/zh-CN/docs/Web/CSS/Value_definition_syntax#question_mark" target="_blank" rel="noopener noreferrer">?</a> <a href="https://developer.mozilla.org/zh-CN/docs/Web/CSS/Value_definition_syntax#double_bar" target="_blank" rel="noopener noreferrer">||</a> <a href="https://developer.mozilla.org/zh-CN/docs/Web/CSS/border-image-repeat" target="_blank" rel="noopener noreferrer">&lt;'border-image-repeat'&gt;</a></p>
</li></ul>
<ul><li>渐变色边框<p>示例:</p>
<p>border-image: linear-gradient(red, yellow) 10px</p>
</li></ul>
</td>
</tr>
</tbody>
</table>

>![](../../public_sys-resources/icon-note.gif) **说明：** 
>通用样式都不是必填项。

