# 概述

对于有用户交互的OS来说，资源优先分配给与用户交互的业务进程，换句话说，在支撑OS运行的进程以外，用户能感知到的业务进程优先级最高，所以后台任务管理的范围是用户感知不到的业务进程。


## 后台任务类型

本文描述的后台任务特指应用或业务模块处于后台（无可见界面）时，有需要继续执行或者后续执行的业务。对这些应用不可见但要继续或者将要执行的业务动作，为避免后台任务管理对业务执行的影响，OpenHarmony将后台任务分为三种类型：

1. 无后台业务：退后台后，无任务需要处理。

2. 短时任务：退后台后，如果有紧急不可推迟且短时间能完成的任务，如应用退后台要进行数据压缩，不可中断，则使用短时任务申请延迟进入挂起（Suspend）状态。

3. 长时任务：如果是用户发起的可感知业务需要长时间后台运行的，如后台播放音乐、导航、上传下载、设备连接、VoIP等，则使用长时任务避免进入挂起（Suspend）状态。


## 短时任务

退到后台的应用有不可中断且短时间能完成的任务时，可以使用短时任务机制，该机制允许应用在后台短时间内完成任务，保障应用业务运行不受后台生命周期管理的影响。

> ![icon-note.gif](public_sys-resources/icon-note.gif) **说明：**
> 短时任务仅针对应用的临时任务提供资源使用生命周期保障，限制单次最大使用时长为3分钟，全天使用配额默认为10分钟（具体时长系统根据应用场景和系统状态智能调整）。


### 短时任务使用约束

短时任务的使用需要遵从如下约束和规则：

- **申请时机**：允许应用在前台时，或退后台在被挂起之前（应用退到后台默认有6~12秒的运行时长，具体时长由系统根据具体场景决定）申请延迟挂起，否则可能被挂起（Suspend），导致申请失败。

- **超时**：延迟挂起超时（Timeout），系统通过回调知会应用，应用需要取消对应的延迟挂起，或再次申请延迟挂起。超期不取消或不处理，该应用会被强制取消延迟挂起。

- **取消时机**：任务完成后申请方应用主动取消延时申请，不要等到超时后被系统取消，否则会影响该应用的后台允许运行时长配额。

- **配额机制**：为了防止应用滥用保活，或者申请后不取消，每个应用每天都会有一定配额（会根据用户的使用习惯动态调整），配额消耗完就不再允许申请短时任务，所以应用完成短时任务后立刻取消延时申请，避免消耗配额。（注，这个配额指的是申请的时长，系统默认应用在后台运行的时间不计算在内）。
