# Setting Up a Ubuntu Development Environment in Docker Mode<a name="EN-US_TOPIC_0000001119805112"></a>

-   [Obtaining Standard-System Source Code](#section8761819202511)
    -   [Prerequisites](#section102871547153314)
    -   [Procedure](#section429012478331)

-   [Running prebuilts](#section0495320152619)
-   [Obtaining the Docker Environment](#section181431248132513)
-   [Building Source Code](#section92391739152318)

The standard OpenHarmony system provides a Docker environment which encapsulates build tools.

>![](../public_sys-resources/icon-note.gif) **NOTE:** 
>-   Before using Docker, install it by following instructions in  [Install Docker Engine on Ubuntu](https://docs.docker.com/engine/install/ubuntu/).
>-   You can also use the  [installation package](quickstart-standard-package-environment.md)  to set up the Ubuntu development environment.

## Obtaining Standard-System Source Code<a name="section8761819202511"></a>

### Prerequisites<a name="section102871547153314"></a>

1.  Register your account with Gitee.
2.  Register an SSH public key for access to Gitee.
3.  Install the  [git client](https://git-scm.com/book/en/v2/Getting-Started-Installing-Git)  and  [git-lfs](https://gitee.com/vcs-all-in-one/git-lfs?_from=gitee_search#downloading), and configure basic user information.

    ```
    git config --global user.name "yourname"
    git config --global user.email "your-email-address"
    git config --global credential.helper store
    ```

4.  Run the following commands to install the  **repo**  tool:

    ```
    curl -s https://gitee.com/oschina/repo/raw/fork_flow/repo-py3 > /usr/local/bin/repo  # If you do not have the access permission to this directory, download the tool to any other accessible directory and configure the directory to the environment variable.
    chmod a+x /usr/local/bin/repo
    pip3 install -i https://repo.huaweicloud.com/repository/pypi/simple requests
    ```


### Procedure<a name="section429012478331"></a>

Two methods are provided for you to obtain the OpenHarmony master code. You are advised to create a new folder and run the related commands in this folder to download the source code. This folder will then be the root directory of the source code.

Method 1 \(recommended\): Use the  **repo**  tool to download the source code over SSH. \(You must have registered an SSH public key for access to Gitee.\)

```
repo init -u git@gitee.com:openharmony/manifest.git -b master --no-repo-verify
repo sync -c
repo forall -c 'git lfs pull'
```

Method 2: Use the  **repo**  tool to download the source code over HTTPS.

```
repo init -u https://gitee.com/openharmony/manifest.git -b master --no-repo-verify
repo sync -c
repo forall -c 'git lfs pull'
```

## Running prebuilts<a name="section0495320152619"></a>

Go to the root directory of the source code and run the following script to install the compiler and binary tool:

```
bash build/prebuilts_download.sh
```

By default, the downloaded prebuilts binary file is stored in  **OpenHarmony\_2.0\_canary\_prebuilts**  \(which is in the same directory as  **OpenHarmony**\).

## Obtaining the Docker Environment<a name="section181431248132513"></a>

**Method 1: Obtaining the Docker image from HUAWEI CLOUD SWR**

1.  Obtain the Docker image.

    ```
    docker pull swr.cn-south-1.myhuaweicloud.com/openharmony-docker/openharmony-docker-standard:0.0.7
    ```

2.  Go to the root directory of source code and run the following command to access the Docker build environment:

    ```
    docker run -it -v $(pwd):/home/openharmony swr.cn-south-1.myhuaweicloud.com/openharmony-docker/openharmony-docker-standard:0.0.7
    ```


**Method 2: Using the Dockerfile to Build a Local Docker Image**

1.  Obtain the Dockerfile script for a local Docker image.

    ```
    git clone https://gitee.com/openharmony/docs.git
    ```

2.  Go to the directory of the Dockerfile code and run the following command to build the Docker image:

    ```
    cd docs/docker/standard
    ./build.sh
    ```

3.  Go to the root directory of source code and run the following command to access the Docker build environment:

    ```
    docker run -it -v $(pwd):/home/openharmony openharmony-docker-standard:0.0.7
    ```


## Building Source Code<a name="section92391739152318"></a>

1.  Run the following script to start building for standard-system devices \(reference memory ≥ 128 MB\).

    ```
    ./build.sh --product-name {product_name} --ccache
    ```

    **product\_name**  indicates the platform supported by the current distribution, for example, Hi3516D V300, rk3568.

    Files generated during building are stored in the  **out/{device_name}/**  directory, and the generated image is stored in the  **out/{device_name}/packages/phone/images/**  directory.

2.  Burn the image. For details, see  [Burning Images](quickstart-standard-burn.md).

>![](../public_sys-resources/icon-note.gif) **NOTE:** 
>You can exit Docker by simply running the  **exit**  command.

