# Development Guidelines<a name="EN-US_TOPIC_0000001079036458"></a>

-   [Available APIs](#section158501652121514)
-   [How to Develop](#section11841123033618)
-   [Development Example](#section460018317164)
    -   [Verification](#section1048572415182)


When an interrupt request is generated by a peripheral, the CPU suspends the current task and responds to the interrupt request. You need to register the interrupt handler and specify the operation to be performed by the CPU.

## Available APIs<a name="section158501652121514"></a>

The following table describes APIs available for the OpenHarmony LiteOS-M interrupt module. For more details about the APIs, see the API reference.

**Table  1**  APIs of the interrupt module

<a name="table1415203765610"></a>
<table><thead align="left"><tr id="row134151837125611"><th class="cellrowborder" valign="top" width="12.85128512851285%" id="mcps1.2.4.1.1"><p id="p16415637105612"><a name="p16415637105612"></a><a name="p16415637105612"></a>Category</p>
</th>
<th class="cellrowborder" valign="top" width="29.8029802980298%" id="mcps1.2.4.1.2"><p id="p11415163718562"><a name="p11415163718562"></a><a name="p11415163718562"></a>API</p>
</th>
<th class="cellrowborder" valign="top" width="57.34573457345735%" id="mcps1.2.4.1.3"><p id="p1641533755612"><a name="p1641533755612"></a><a name="p1641533755612"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row0415737175610"><td class="cellrowborder" rowspan="2" valign="top" width="12.85128512851285%" headers="mcps1.2.4.1.1 "><p id="p4917132105710"><a name="p4917132105710"></a><a name="p4917132105710"></a>Creating or deleting interrupts</p>
</td>
<td class="cellrowborder" valign="top" width="29.8029802980298%" headers="mcps1.2.4.1.2 "><p id="p341513372561"><a name="p341513372561"></a><a name="p341513372561"></a>HalHwiCreate</p>
</td>
<td class="cellrowborder" valign="top" width="57.34573457345735%" headers="mcps1.2.4.1.3 "><p id="p74151037185617"><a name="p74151037185617"></a><a name="p74151037185617"></a>Creates an interrupt and registers the interrupt ID, interrupt triggering mode, interrupt priority, and interrupt handler. When an interrupt is triggered, the interrupt handler will be called.</p>
</td>
</tr>
<tr id="row1841519376561"><td class="cellrowborder" valign="top" headers="mcps1.2.4.1.1 "><p id="p64151837155618"><a name="p64151837155618"></a><a name="p64151837155618"></a>HalHwiDelete</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.4.1.2 "><p id="p441516379562"><a name="p441516379562"></a><a name="p441516379562"></a>Deletes an interrupt based on the specified interrupt ID.</p>
</td>
</tr>
<tr id="row1141513373562"><td class="cellrowborder" rowspan="3" valign="top" width="12.85128512851285%" headers="mcps1.2.4.1.1 "><p id="p956643365710"><a name="p956643365710"></a><a name="p956643365710"></a>Enabling or disabling interrupts</p>
</td>
<td class="cellrowborder" valign="top" width="29.8029802980298%" headers="mcps1.2.4.1.2 "><p id="p17765212416"><a name="p17765212416"></a><a name="p17765212416"></a>LOS_IntUnLock</p>
</td>
<td class="cellrowborder" valign="top" width="57.34573457345735%" headers="mcps1.2.4.1.3 "><p id="p1972971913115"><a name="p1972971913115"></a><a name="p1972971913115"></a>Enables the CPU to respond to all interrupt requests.</p>
</td>
</tr>
<tr id="row1541513745611"><td class="cellrowborder" valign="top" headers="mcps1.2.4.1.1 "><p id="p1332013246116"><a name="p1332013246116"></a><a name="p1332013246116"></a>LOS_IntLock</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.4.1.2 "><p id="p1692710331219"><a name="p1692710331219"></a><a name="p1692710331219"></a>Disables the CPU from responding to interrupt requests.</p>
</td>
</tr>
<tr id="row14167379561"><td class="cellrowborder" valign="top" headers="mcps1.2.4.1.1 "><p id="p1438619410117"><a name="p1438619410117"></a><a name="p1438619410117"></a>LOS_IntRestore</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.4.1.2 "><p id="p254691522"><a name="p254691522"></a><a name="p254691522"></a>Restores the interrupt status before the <strong id="b12851162254619"><a name="b12851162254619"></a><a name="b12851162254619"></a>LOS_IntLock</strong> and <strong id="b19635152734617"><a name="b19635152734617"></a><a name="b19635152734617"></a>LOS_IntUnLock</strong> operations are performed.</p>
</td>
</tr>
</tbody>
</table>

## How to Develop<a name="section11841123033618"></a>

1.  Create an interrupt by calling  **HalHwiCreate**.
2.  Call  **TestHwiTrigger**  to trigger the specified interrupt. \(This API is defined in the test suite. It simulates an external interrupt by writing the related register of the interrupt controller. Skip this step for common peripheral devices.\)
3.  Call  **HalHwiDelete**  to delete the specified interrupt. Use this API based on actual requirements.

>![](../public_sys-resources/icon-note.gif) **NOTE:** 
>-   Configure the maximum number of interrupts supported and the number of configurable interrupt priorities based on the specific hardware.
>-   If the interrupt handler takes long time, the CPU cannot respond to interrupt requests in a timely manner.
>-   Functions that trigger  **LOS\_Schedule**  cannot be directly or indirectly executed during interrupt response process.
>-   The input parameter of  **LOS\_IntRestore\(\)**  must be the return value of  **LOS\_IntLock\(\)**, that is, the current program status register \(CPSR\) value before the interrupt is disabled. Interrupts 0 to 15 in the Cortex-M series processors are for internal use. You are advised not to apply for or create interrupts 0 to 15.

## Development Example<a name="section460018317164"></a>

This example implements the following:

1.  Create an interrupt.
2.  Trigger an interrupt.
3.  Delete an interrupt.

The following sample code shows how to create and delete an interrupt. When the interrupt  **HWI\_NUM\_TEST**  is generated, the interrupt handler function will be called.

```
#include "los_interrupt.h"

/* Create an interrupt.*/
#define HWI_NUM_TEST 7

STATIC VOID HwiUsrIrq(VOID)
{
    printf("in the func HwiUsrIrq \n"); 
}

static UINT32 Example_Interrupt(VOID)
{
    UINT32 ret;
    HWI_PRIOR_T hwiPrio = 3;
    HWI_MODE_T mode = 0;
    HWI_ARG_T arg = 0;

    /* Create an interrupt. */
    ret = HalHwiCreate(HWI_NUM_TEST, hwiPrio, mode, (HWI_PROC_FUNC)HwiUsrIrq, arg);
    if(ret == LOS_OK){
        printf("Hwi create success!\n");
    } else {
        printf("Hwi create failed!\n");
        return LOS_NOK;
    }

    /* Delay 50 ticks. When a hardware interrupt occurs, the HwiUsrIrq function will be called.*/
    LOS_TaskDelay(50);

    /* Delete an interrupt./
    ret = HalHwiDelete(HWI_NUM_TEST);    
    if(ret == LOS_OK){
        printf("Hwi delete success!\n");
    } else {
        printf("Hwi delete failed!\n");
        return LOS_NOK;
    }
    return LOS_OK;
}
```

### Verification<a name="section1048572415182"></a>

The development is successful if the return result is as follows:

```
Hwi create success!
Hwi delete success!
```

