# Text Style<a name="EN-US_TOPIC_0000001111681086"></a>

The attributes described in this topic are used to set the text style for a component that contains text.

<a name="table1272794482110"></a>
<table><thead align="left"><tr id="row1672764492111"><th class="cellrowborder" valign="top" width="13.15%" id="mcps1.1.5.1.1"><p id="p187274444211"><a name="p187274444211"></a><a name="p187274444211"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="18.3%" id="mcps1.1.5.1.2"><p id="p5727104415214"><a name="p5727104415214"></a><a name="p5727104415214"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="11.28%" id="mcps1.1.5.1.3"><p id="p127277445216"><a name="p127277445216"></a><a name="p127277445216"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="57.269999999999996%" id="mcps1.1.5.1.4"><p id="p11727114417217"><a name="p11727114417217"></a><a name="p11727114417217"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1272884442111"><td class="cellrowborder" valign="top" width="13.15%" headers="mcps1.1.5.1.1 "><p id="p872874419212"><a name="p872874419212"></a><a name="p872874419212"></a>fontColor</p>
</td>
<td class="cellrowborder" valign="top" width="18.3%" headers="mcps1.1.5.1.2 "><p id="p3728744192114"><a name="p3728744192114"></a><a name="p3728744192114"></a>Color</p>
</td>
<td class="cellrowborder" valign="top" width="11.28%" headers="mcps1.1.5.1.3 "><p id="p1372816447214"><a name="p1372816447214"></a><a name="p1372816447214"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="57.269999999999996%" headers="mcps1.1.5.1.4 "><p id="p97281344132120"><a name="p97281344132120"></a><a name="p97281344132120"></a>Text color.</p>
</td>
</tr>
<tr id="row0728144152115"><td class="cellrowborder" valign="top" width="13.15%" headers="mcps1.1.5.1.1 "><p id="p5728134411218"><a name="p5728134411218"></a><a name="p5728134411218"></a>fontSize</p>
</td>
<td class="cellrowborder" valign="top" width="18.3%" headers="mcps1.1.5.1.2 "><p id="p77284448214"><a name="p77284448214"></a><a name="p77284448214"></a>Length</p>
</td>
<td class="cellrowborder" valign="top" width="11.28%" headers="mcps1.1.5.1.3 "><p id="p67281844112112"><a name="p67281844112112"></a><a name="p67281844112112"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="57.269999999999996%" headers="mcps1.1.5.1.4 "><p id="p20728544112119"><a name="p20728544112119"></a><a name="p20728544112119"></a>Text size. If the value is of the number type, the unit fp is used.</p>
</td>
</tr>
<tr id="row117281144172120"><td class="cellrowborder" valign="top" width="13.15%" headers="mcps1.1.5.1.1 "><p id="p272864422118"><a name="p272864422118"></a><a name="p272864422118"></a>fontStyle</p>
</td>
<td class="cellrowborder" valign="top" width="18.3%" headers="mcps1.1.5.1.2 "><p id="p207281044182117"><a name="p207281044182117"></a><a name="p207281044182117"></a><a href="#li6906111945316">FontStyle</a></p>
</td>
<td class="cellrowborder" valign="top" width="11.28%" headers="mcps1.1.5.1.3 "><p id="p072854416211"><a name="p072854416211"></a><a name="p072854416211"></a>Normal</p>
</td>
<td class="cellrowborder" valign="top" width="57.269999999999996%" headers="mcps1.1.5.1.4 "><p id="p19180235236"><a name="p19180235236"></a><a name="p19180235236"></a>Font style of the text.</p>
</td>
</tr>
<tr id="row19728154413218"><td class="cellrowborder" valign="top" width="13.15%" headers="mcps1.1.5.1.1 "><p id="p9728244122117"><a name="p9728244122117"></a><a name="p9728244122117"></a>fontWeight</p>
</td>
<td class="cellrowborder" valign="top" width="18.3%" headers="mcps1.1.5.1.2 "><p id="p9471820103010"><a name="p9471820103010"></a><a name="p9471820103010"></a>number | <a href="#li24391125115311">FontWeight</a></p>
</td>
<td class="cellrowborder" valign="top" width="11.28%" headers="mcps1.1.5.1.3 "><p id="p9728144419218"><a name="p9728144419218"></a><a name="p9728144419218"></a>Normal</p>
</td>
<td class="cellrowborder" valign="top" width="57.269999999999996%" headers="mcps1.1.5.1.4 "><p id="p1422814610347"><a name="p1422814610347"></a><a name="p1422814610347"></a>Font weight. For the number type, the value ranges from 100 to 900, at an interval of 100. The default value is <strong id="b89916571465"><a name="b89916571465"></a><a name="b89916571465"></a>400</strong>. A larger value indicates a larger font weight.</p>
<p id="p5728184432119"><a name="p5728184432119"></a><a name="p5728184432119"></a>For details on the common enumerated values, see <a href="#li24391125115311">FontWeight enums</a>.</p>
</td>
</tr>
<tr id="row18318204813215"><td class="cellrowborder" valign="top" width="13.15%" headers="mcps1.1.5.1.1 "><p id="p2319348153210"><a name="p2319348153210"></a><a name="p2319348153210"></a>fontFamily</p>
</td>
<td class="cellrowborder" valign="top" width="18.3%" headers="mcps1.1.5.1.2 "><p id="p73191748103218"><a name="p73191748103218"></a><a name="p73191748103218"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="11.28%" headers="mcps1.1.5.1.3 "><p id="p10319144823214"><a name="p10319144823214"></a><a name="p10319144823214"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="57.269999999999996%" headers="mcps1.1.5.1.4 "><p id="p9319164810326"><a name="p9319164810326"></a><a name="p9319164810326"></a>Font family of the text. Use commas (,) to separate multiple fonts. The priority the fonts is the sequence in which they are placed. An example value is <strong id="b178133520810"><a name="b178133520810"></a><a name="b178133520810"></a>Arial, sans-serif</strong>.</p>
</td>
</tr>
</tbody>
</table>

-   <a name="li6906111945316"></a>FontStyle enums

    <a name="table3452114216394"></a>
    <table><thead align="left"><tr id="row245219426397"><th class="cellrowborder" valign="top" width="25.2%" id="mcps1.1.3.1.1"><p id="p545244283914"><a name="p545244283914"></a><a name="p545244283914"></a>Name</p>
    </th>
    <th class="cellrowborder" valign="top" width="74.8%" id="mcps1.1.3.1.2"><p id="p2452114203917"><a name="p2452114203917"></a><a name="p2452114203917"></a>Description</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="row6452144218390"><td class="cellrowborder" valign="top" width="25.2%" headers="mcps1.1.3.1.1 "><p id="p34529427398"><a name="p34529427398"></a><a name="p34529427398"></a>Normal</p>
    </td>
    <td class="cellrowborder" valign="top" width="74.8%" headers="mcps1.1.3.1.2 "><p id="p1245211421393"><a name="p1245211421393"></a><a name="p1245211421393"></a>Standard font style.</p>
    </td>
    </tr>
    <tr id="row12452184217398"><td class="cellrowborder" valign="top" width="25.2%" headers="mcps1.1.3.1.1 "><p id="p54523425398"><a name="p54523425398"></a><a name="p54523425398"></a>Italic</p>
    </td>
    <td class="cellrowborder" valign="top" width="74.8%" headers="mcps1.1.3.1.2 "><p id="p745215426391"><a name="p745215426391"></a><a name="p745215426391"></a>Italic font style.</p>
    </td>
    </tr>
    </tbody>
    </table>


-   <a name="li24391125115311"></a>FontWeight enums

    <a name="table1840481341616"></a>
    <table><thead align="left"><tr id="row1540401313169"><th class="cellrowborder" valign="top" width="25.2%" id="mcps1.1.3.1.1"><p id="p11404101319164"><a name="p11404101319164"></a><a name="p11404101319164"></a>Name</p>
    </th>
    <th class="cellrowborder" valign="top" width="74.8%" id="mcps1.1.3.1.2"><p id="p240461331619"><a name="p240461331619"></a><a name="p240461331619"></a>Description</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="row940412136164"><td class="cellrowborder" valign="top" width="25.2%" headers="mcps1.1.3.1.1 "><p id="p8404131313162"><a name="p8404131313162"></a><a name="p8404131313162"></a>Lighter</p>
    </td>
    <td class="cellrowborder" valign="top" width="74.8%" headers="mcps1.1.3.1.2 "><p id="p18404151391615"><a name="p18404151391615"></a><a name="p18404151391615"></a>The font weight is lighter.</p>
    </td>
    </tr>
    <tr id="row84041113121615"><td class="cellrowborder" valign="top" width="25.2%" headers="mcps1.1.3.1.1 "><p id="p164047136166"><a name="p164047136166"></a><a name="p164047136166"></a>Normal</p>
    </td>
    <td class="cellrowborder" valign="top" width="74.8%" headers="mcps1.1.3.1.2 "><p id="p17404813161612"><a name="p17404813161612"></a><a name="p17404813161612"></a>The font weight is normal.</p>
    </td>
    </tr>
    <tr id="row740412136162"><td class="cellrowborder" valign="top" width="25.2%" headers="mcps1.1.3.1.1 "><p id="p1040413132166"><a name="p1040413132166"></a><a name="p1040413132166"></a>Regular</p>
    </td>
    <td class="cellrowborder" valign="top" width="74.8%" headers="mcps1.1.3.1.2 "><p id="p2404171314163"><a name="p2404171314163"></a><a name="p2404171314163"></a>The font weight is regular.</p>
    </td>
    </tr>
    <tr id="row4404013161612"><td class="cellrowborder" valign="top" width="25.2%" headers="mcps1.1.3.1.1 "><p id="p1740414136168"><a name="p1740414136168"></a><a name="p1740414136168"></a>Medium</p>
    </td>
    <td class="cellrowborder" valign="top" width="74.8%" headers="mcps1.1.3.1.2 "><p id="p4404191313165"><a name="p4404191313165"></a><a name="p4404191313165"></a>The font weight is medium.</p>
    </td>
    </tr>
    <tr id="row1353733241814"><td class="cellrowborder" valign="top" width="25.2%" headers="mcps1.1.3.1.1 "><p id="p35383322189"><a name="p35383322189"></a><a name="p35383322189"></a>Bold</p>
    </td>
    <td class="cellrowborder" valign="top" width="74.8%" headers="mcps1.1.3.1.2 "><p id="p16538173212187"><a name="p16538173212187"></a><a name="p16538173212187"></a>The font weight is bold.</p>
    </td>
    </tr>
    <tr id="row19186440141814"><td class="cellrowborder" valign="top" width="25.2%" headers="mcps1.1.3.1.1 "><p id="p6186340151810"><a name="p6186340151810"></a><a name="p6186340151810"></a>Bolder</p>
    </td>
    <td class="cellrowborder" valign="top" width="74.8%" headers="mcps1.1.3.1.2 "><p id="p1818615400189"><a name="p1818615400189"></a><a name="p1818615400189"></a>The font weight is bolder.</p>
    </td>
    </tr>
    </tbody>
    </table>


## Example<a name="section17655814153017"></a>

```
@Entry
@Component
struct TextStyleExample {
  build() {
    Column({ space: 5 }) {
      Text('default text')

      Text('text font color red')
        .fontColor(Color.Red)

      Text('text font size 20')
        .fontSize(20)

      Text('text font style Italic')
        .fontStyle(FontStyle.Italic)

      Text('text fontWeight bold')
        .fontWeight(700)

      Text('text fontFamily sans-serif')
        .fontFamily('sans-serif')

      Text('red 20 Italic bold cursive text')
        .fontColor(Color.Red)
        .fontSize(20)
        .fontStyle(FontStyle.Italic)
        .fontWeight(700)
        .fontFamily('cursive')
        .textAlign(TextAlign.Center)
        .width('90%')

      Text('Orange 18 Normal source-sans-pro text')
        .fontColor(Color.Orange)
        .fontSize(18)
        .fontStyle(FontStyle.Normal)
        .fontWeight(400)
        .fontFamily('source-sans-pro,cursive,sans-serif')
    }.width('100%')
  }
}
```

![](figures/textstyle.png)

