# Border Configuration<a name="EN-US_TOPIC_0000001158261223"></a>

This section describes the settings of border styles.

<a name="table444mcpsimp"></a>
<table><thead align="left"><tr id="row451mcpsimp"><th class="cellrowborder" valign="top" width="16%" id="mcps1.1.5.1.1"><p id="p453mcpsimp"><a name="p453mcpsimp"></a><a name="p453mcpsimp"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="27.79%" id="mcps1.1.5.1.2"><p id="p455mcpsimp"><a name="p455mcpsimp"></a><a name="p455mcpsimp"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="12.57%" id="mcps1.1.5.1.3"><p id="p457mcpsimp"><a name="p457mcpsimp"></a><a name="p457mcpsimp"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="43.64%" id="mcps1.1.5.1.4"><p id="p459mcpsimp"><a name="p459mcpsimp"></a><a name="p459mcpsimp"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row460mcpsimp"><td class="cellrowborder" valign="top" width="16%" headers="mcps1.1.5.1.1 "><p id="p462mcpsimp"><a name="p462mcpsimp"></a><a name="p462mcpsimp"></a>border</p>
</td>
<td class="cellrowborder" valign="top" width="27.79%" headers="mcps1.1.5.1.2 "><p id="p69540314713"><a name="p69540314713"></a><a name="p69540314713"></a>{</p>
<p id="p82011074712"><a name="p82011074712"></a><a name="p82011074712"></a>width?: Length,</p>
<p id="p1731310109716"><a name="p1731310109716"></a><a name="p1731310109716"></a>color?: Color,</p>
<p id="p1978101210718"><a name="p1978101210718"></a><a name="p1978101210718"></a>radius?: Length,</p>
<p id="p1358418161679"><a name="p1358418161679"></a><a name="p1358418161679"></a>style?: <a href="#li5617903594">BorderStyle</a></p>
<p id="p464mcpsimp"><a name="p464mcpsimp"></a><a name="p464mcpsimp"></a>}</p>
</td>
<td class="cellrowborder" valign="top" width="12.57%" headers="mcps1.1.5.1.3 "><p id="p469mcpsimp"><a name="p469mcpsimp"></a><a name="p469mcpsimp"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="43.64%" headers="mcps1.1.5.1.4 "><p id="p471mcpsimp"><a name="p471mcpsimp"></a><a name="p471mcpsimp"></a>Sets a unified border style.</p>
</td>
</tr>
<tr id="row472mcpsimp"><td class="cellrowborder" valign="top" width="16%" headers="mcps1.1.5.1.1 "><p id="p474mcpsimp"><a name="p474mcpsimp"></a><a name="p474mcpsimp"></a>borderStyle</p>
</td>
<td class="cellrowborder" valign="top" width="27.79%" headers="mcps1.1.5.1.2 "><p id="p476mcpsimp"><a name="p476mcpsimp"></a><a name="p476mcpsimp"></a><a href="#li5617903594">BorderStyle</a></p>
</td>
<td class="cellrowborder" valign="top" width="12.57%" headers="mcps1.1.5.1.3 "><p id="p478mcpsimp"><a name="p478mcpsimp"></a><a name="p478mcpsimp"></a>Solid</p>
</td>
<td class="cellrowborder" valign="top" width="43.64%" headers="mcps1.1.5.1.4 "><p id="p480mcpsimp"><a name="p480mcpsimp"></a><a name="p480mcpsimp"></a>Sets the border style of an element.</p>
</td>
</tr>
<tr id="row481mcpsimp"><td class="cellrowborder" valign="top" width="16%" headers="mcps1.1.5.1.1 "><p id="p483mcpsimp"><a name="p483mcpsimp"></a><a name="p483mcpsimp"></a>borderWidth</p>
</td>
<td class="cellrowborder" valign="top" width="27.79%" headers="mcps1.1.5.1.2 "><p id="p485mcpsimp"><a name="p485mcpsimp"></a><a name="p485mcpsimp"></a>Length</p>
</td>
<td class="cellrowborder" valign="top" width="12.57%" headers="mcps1.1.5.1.3 "><p id="p487mcpsimp"><a name="p487mcpsimp"></a><a name="p487mcpsimp"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="43.64%" headers="mcps1.1.5.1.4 "><p id="p489mcpsimp"><a name="p489mcpsimp"></a><a name="p489mcpsimp"></a>Sets the border width of an element.</p>
</td>
</tr>
<tr id="row490mcpsimp"><td class="cellrowborder" valign="top" width="16%" headers="mcps1.1.5.1.1 "><p id="p492mcpsimp"><a name="p492mcpsimp"></a><a name="p492mcpsimp"></a>borderColor</p>
</td>
<td class="cellrowborder" valign="top" width="27.79%" headers="mcps1.1.5.1.2 "><p id="p494mcpsimp"><a name="p494mcpsimp"></a><a name="p494mcpsimp"></a>Color</p>
</td>
<td class="cellrowborder" valign="top" width="12.57%" headers="mcps1.1.5.1.3 "><p id="p496mcpsimp"><a name="p496mcpsimp"></a><a name="p496mcpsimp"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="43.64%" headers="mcps1.1.5.1.4 "><p id="p498mcpsimp"><a name="p498mcpsimp"></a><a name="p498mcpsimp"></a>Sets the border color of an element.</p>
</td>
</tr>
<tr id="row499mcpsimp"><td class="cellrowborder" valign="top" width="16%" headers="mcps1.1.5.1.1 "><p id="p501mcpsimp"><a name="p501mcpsimp"></a><a name="p501mcpsimp"></a>borderRadius</p>
</td>
<td class="cellrowborder" valign="top" width="27.79%" headers="mcps1.1.5.1.2 "><p id="p503mcpsimp"><a name="p503mcpsimp"></a><a name="p503mcpsimp"></a>Length</p>
</td>
<td class="cellrowborder" valign="top" width="12.57%" headers="mcps1.1.5.1.3 "><p id="p505mcpsimp"><a name="p505mcpsimp"></a><a name="p505mcpsimp"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="43.64%" headers="mcps1.1.5.1.4 "><p id="p507mcpsimp"><a name="p507mcpsimp"></a><a name="p507mcpsimp"></a>Sets the border radius of an element.</p>
</td>
</tr>
</tbody>
</table>

-   <a name="li5617903594"></a>BorderStyle enums

    <a name="table3452114216394"></a>
    <table><thead align="left"><tr id="row245219426397"><th class="cellrowborder" valign="top" width="25.2%" id="mcps1.1.3.1.1"><p id="p545244283914"><a name="p545244283914"></a><a name="p545244283914"></a>Name</p>
    </th>
    <th class="cellrowborder" valign="top" width="74.8%" id="mcps1.1.3.1.2"><p id="p2452114203917"><a name="p2452114203917"></a><a name="p2452114203917"></a>Description</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="row6452144218390"><td class="cellrowborder" valign="top" width="25.2%" headers="mcps1.1.3.1.1 "><p id="p34529427398"><a name="p34529427398"></a><a name="p34529427398"></a>Dotted</p>
    </td>
    <td class="cellrowborder" valign="top" width="74.8%" headers="mcps1.1.3.1.2 "><p id="p1245211421393"><a name="p1245211421393"></a><a name="p1245211421393"></a>Dotted border. The radius of a dot is half of <strong id="b08584301617"><a name="b08584301617"></a><a name="b08584301617"></a>borderWidth</strong>.</p>
    </td>
    </tr>
    <tr id="row12452184217398"><td class="cellrowborder" valign="top" width="25.2%" headers="mcps1.1.3.1.1 "><p id="p54523425398"><a name="p54523425398"></a><a name="p54523425398"></a>Dashed</p>
    </td>
    <td class="cellrowborder" valign="top" width="74.8%" headers="mcps1.1.3.1.2 "><p id="p745215426391"><a name="p745215426391"></a><a name="p745215426391"></a>Dashed border.</p>
    </td>
    </tr>
    <tr id="row9452134213392"><td class="cellrowborder" valign="top" width="25.2%" headers="mcps1.1.3.1.1 "><p id="p510719111403"><a name="p510719111403"></a><a name="p510719111403"></a>Solid</p>
    </td>
    <td class="cellrowborder" valign="top" width="74.8%" headers="mcps1.1.3.1.2 "><p id="p154533425394"><a name="p154533425394"></a><a name="p154533425394"></a>Solid border.</p>
    </td>
    </tr>
    </tbody>
    </table>


## Example<a name="section1976245813394"></a>

```
@Entry
@Component
struct BorderExample {
  build() {
    Flex({ justifyContent: FlexAlign.SpaceAround, alignItems: ItemAlign.Center }) {
      // Line segment
      Text('dashed')
        .borderStyle(BorderStyle.Dashed).borderWidth(5).borderColor(0xAFEEEE).borderRadius(10)
        .width(120).height(120).textAlign(TextAlign.Center).fontSize(16)
      // Dotted line
      Text('dotted')
        .border({ width: 5, color: 0x317AF7, radius: 10, style: BorderStyle.Dotted })
        .width(120).height(120).textAlign(TextAlign.Center).fontSize(16)
    }.width('100%').height(150)
  }
}
```

![](figures/border.gif)

