# Types<a name="EN-US_TOPIC_0000001158349321"></a>

## Length Type<a name="section15406175012255"></a>

<a name="table726mcpsimp"></a>
<table><thead align="left"><tr id="row732mcpsimp"><th class="cellrowborder" valign="top" width="13.309999999999999%" id="mcps1.1.4.1.1"><p id="p734mcpsimp"><a name="p734mcpsimp"></a><a name="p734mcpsimp"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="26.35%" id="mcps1.1.4.1.2"><p id="p736mcpsimp"><a name="p736mcpsimp"></a><a name="p736mcpsimp"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="60.34%" id="mcps1.1.4.1.3"><p id="p738mcpsimp"><a name="p738mcpsimp"></a><a name="p738mcpsimp"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row739mcpsimp"><td class="cellrowborder" valign="top" width="13.309999999999999%" headers="mcps1.1.4.1.1 "><p id="p741mcpsimp"><a name="p741mcpsimp"></a><a name="p741mcpsimp"></a>Length</p>
</td>
<td class="cellrowborder" valign="top" width="26.35%" headers="mcps1.1.4.1.2 "><p id="p743mcpsimp"><a name="p743mcpsimp"></a><a name="p743mcpsimp"></a>string | number</p>
</td>
<td class="cellrowborder" valign="top" width="60.34%" headers="mcps1.1.4.1.3 "><p id="p745mcpsimp"><a name="p745mcpsimp"></a><a name="p745mcpsimp"></a>Length unit. If the input is a number, use <strong id="b1995533113315"><a name="b1995533113315"></a><a name="b1995533113315"></a>vp</strong>. If the input is a string, explicitly specify the unit, for example, <strong id="b7956133143315"><a name="b7956133143315"></a><a name="b7956133143315"></a>10px</strong>, or specify the length in percentage, for example, <strong id="b1195613123314"><a name="b1195613123314"></a><a name="b1195613123314"></a>100%</strong>.</p>
</td>
</tr>
</tbody>
</table>

## Angle Type<a name="section1530915545289"></a>

<a name="table6309125452810"></a>
<table><thead align="left"><tr id="row15309155482814"><th class="cellrowborder" valign="top" width="13.62136213621362%" id="mcps1.1.4.1.1"><p id="p130975418289"><a name="p130975418289"></a><a name="p130975418289"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="18.971897189718973%" id="mcps1.1.4.1.2"><p id="p1030935410283"><a name="p1030935410283"></a><a name="p1030935410283"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="67.40674067406741%" id="mcps1.1.4.1.3"><p id="p93095541285"><a name="p93095541285"></a><a name="p93095541285"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row173098548287"><td class="cellrowborder" valign="top" width="13.62136213621362%" headers="mcps1.1.4.1.1 "><p id="p1230965410285"><a name="p1230965410285"></a><a name="p1230965410285"></a>Angle</p>
</td>
<td class="cellrowborder" valign="top" width="18.971897189718973%" headers="mcps1.1.4.1.2 "><p id="p18309154112810"><a name="p18309154112810"></a><a name="p18309154112810"></a>string | number</p>
</td>
<td class="cellrowborder" valign="top" width="67.40674067406741%" headers="mcps1.1.4.1.3 "><p id="p10844175013312"><a name="p10844175013312"></a><a name="p10844175013312"></a>Angle unit. If the input is a number, use <strong id="b171831045227"><a name="b171831045227"></a><a name="b171831045227"></a>deg</strong>. If the input is a string, use either of the following angle units:</p>
<a name="ul1663455543315"></a><a name="ul1663455543315"></a><ul id="ul1663455543315"><li><strong id="b134871561436"><a name="b134871561436"></a><a name="b134871561436"></a>deg</strong>, for example, <strong id="b134888560317"><a name="b134888560317"></a><a name="b134888560317"></a>100deg</strong>.</li><li><strong id="b1912412212420"><a name="b1912412212420"></a><a name="b1912412212420"></a>rad</strong>, for example, <strong id="b111251221244"><a name="b111251221244"></a><a name="b111251221244"></a>3.14rad</strong>.</li></ul>
</td>
</tr>
</tbody>
</table>

## Point Type<a name="section177417431277"></a>

<a name="table25265581277"></a>
<table><thead align="left"><tr id="row652695852720"><th class="cellrowborder" valign="top" width="13.62136213621362%" id="mcps1.1.4.1.1"><p id="p5526135819278"><a name="p5526135819278"></a><a name="p5526135819278"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="18.971897189718973%" id="mcps1.1.4.1.2"><p id="p175261158182715"><a name="p175261158182715"></a><a name="p175261158182715"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="67.40674067406741%" id="mcps1.1.4.1.3"><p id="p852725815278"><a name="p852725815278"></a><a name="p852725815278"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row18527125812718"><td class="cellrowborder" valign="top" width="13.62136213621362%" headers="mcps1.1.4.1.1 "><p id="p152713589270"><a name="p152713589270"></a><a name="p152713589270"></a>Point</p>
</td>
<td class="cellrowborder" valign="top" width="18.971897189718973%" headers="mcps1.1.4.1.2 "><p id="p1715962313287"><a name="p1715962313287"></a><a name="p1715962313287"></a>[Length, Length]</p>
</td>
<td class="cellrowborder" valign="top" width="67.40674067406741%" headers="mcps1.1.4.1.3 "><p id="p12798132712281"><a name="p12798132712281"></a><a name="p12798132712281"></a>Coordinates of a point. The first value is the x-axis coordinate, and the second value is the y-axis coordinate.</p>
</td>
</tr>
</tbody>
</table>

## Color Type<a name="section1326744510818"></a>

The  **Color**  used by the component attribute method is described as follows:

<a name="table112670450819"></a>
<table><thead align="left"><tr id="row11267545288"><th class="cellrowborder" valign="top" width="13.309999999999999%" id="mcps1.1.4.1.1"><p id="p326754519814"><a name="p326754519814"></a><a name="p326754519814"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="26.35%" id="mcps1.1.4.1.2"><p id="p1267045184"><a name="p1267045184"></a><a name="p1267045184"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="60.34%" id="mcps1.1.4.1.3"><p id="p626714451182"><a name="p626714451182"></a><a name="p626714451182"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row17267745782"><td class="cellrowborder" valign="top" width="13.309999999999999%" headers="mcps1.1.4.1.1 "><p id="p126711451816"><a name="p126711451816"></a><a name="p126711451816"></a>Color</p>
</td>
<td class="cellrowborder" valign="top" width="26.35%" headers="mcps1.1.4.1.2 "><p id="p10267245383"><a name="p10267245383"></a><a name="p10267245383"></a>string | number | Color</p>
</td>
<td class="cellrowborder" valign="top" width="60.34%" headers="mcps1.1.4.1.3 "><p id="p11674615417"><a name="p11674615417"></a><a name="p11674615417"></a>Color information. If the input is a string, use <strong id="b196195148488"><a name="b196195148488"></a><a name="b196195148488"></a>rgb</strong> or <strong id="b7743118134810"><a name="b7743118134810"></a><a name="b7743118134810"></a>rgba</strong> to describe the color. If the input is a number, describe the color in HEX format. If the input is of a color type, use a color value.</p>
<p id="p10116112546"><a name="p10116112546"></a><a name="p10116112546"></a>Example:</p>
<a name="ul609mcpsimp"></a><a name="ul609mcpsimp"></a><ul id="ul609mcpsimp"><li>rgb(255, 255, 255)</li><li>rgba(255, 255, 255, 1.0)</li><li>HEX format: 0xrrggbb, 0xaarrggbb, or #FFFFFF</li><li>Enumerated color format: Color.Black or Color.White</li></ul>
</td>
</tr>
</tbody>
</table>

The following colors are supported.

<a name="table141385933518"></a>
<table><thead align="left"><tr id="row313259183513"><th class="cellrowborder" valign="top" width="33.33333333333333%" id="mcps1.1.4.1.1"><p id="p1913259133517"><a name="p1913259133517"></a><a name="p1913259133517"></a>Color</p>
</th>
<th class="cellrowborder" valign="top" width="33.33333333333333%" id="mcps1.1.4.1.2"><p id="p81345913357"><a name="p81345913357"></a><a name="p81345913357"></a>Value</p>
</th>
<th class="cellrowborder" valign="top" width="33.33333333333333%" id="mcps1.1.4.1.3"><p id="p1414115915359"><a name="p1414115915359"></a><a name="p1414115915359"></a>Illustration</p>
</th>
</tr>
</thead>
<tbody><tr id="row2141859193520"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.1 "><p id="p14141859193513"><a name="p14141859193513"></a><a name="p14141859193513"></a>Black</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.2 "><p id="p12141759113517"><a name="p12141759113517"></a><a name="p12141759113517"></a>0x000000</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.3 "><p id="p161415592351"><a name="p161415592351"></a><a name="p161415592351"></a><a name="image1826213162617"></a><a name="image1826213162617"></a><span><img id="image1826213162617" src="figures/000000-49.png"></span></p>
</td>
</tr>
<tr id="row19148591359"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.1 "><p id="p1214859143520"><a name="p1214859143520"></a><a name="p1214859143520"></a>Blue</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.2 "><p id="p15141159203517"><a name="p15141159203517"></a><a name="p15141159203517"></a>0x0000ff</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.3 "><p id="p2014105933511"><a name="p2014105933511"></a><a name="p2014105933511"></a><a name="image48472485425"></a><a name="image48472485425"></a><span><img id="image48472485425" src="figures/blue-50.png"></span></p>
</td>
</tr>
<tr id="row714659133515"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.1 "><p id="p1414959143514"><a name="p1414959143514"></a><a name="p1414959143514"></a>Brown</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.2 "><p id="p1714165933518"><a name="p1714165933518"></a><a name="p1714165933518"></a>0xa52a2a</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.3 "><p id="p151445915354"><a name="p151445915354"></a><a name="p151445915354"></a><a name="image1141521144311"></a><a name="image1141521144311"></a><span><img id="image1141521144311" src="figures/brown-51.png"></span></p>
</td>
</tr>
<tr id="row814165933512"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.1 "><p id="p1514195933511"><a name="p1514195933511"></a><a name="p1514195933511"></a>Gray</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.2 "><p id="p31413592352"><a name="p31413592352"></a><a name="p31413592352"></a>0x808080</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.3 "><p id="p414145913353"><a name="p414145913353"></a><a name="p414145913353"></a><a name="image101063411564"></a><a name="image101063411564"></a><span><img id="image101063411564" src="figures/grey-52.png"></span></p>
</td>
</tr>
<tr id="row414155973512"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.1 "><p id="p71415917350"><a name="p71415917350"></a><a name="p71415917350"></a>Green</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.2 "><p id="p111475915354"><a name="p111475915354"></a><a name="p111475915354"></a>0x008000</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.3 "><p id="p13149596357"><a name="p13149596357"></a><a name="p13149596357"></a><a name="image17894132211567"></a><a name="image17894132211567"></a><span><img id="image17894132211567" src="figures/green-53.png"></span></p>
</td>
</tr>
<tr id="row9305120105713"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.1 "><p id="p1730570115714"><a name="p1730570115714"></a><a name="p1730570115714"></a>Orange</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.2 "><p id="p530540145713"><a name="p530540145713"></a><a name="p530540145713"></a>0xffa500</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.3 "><p id="p1530615014576"><a name="p1530615014576"></a><a name="p1530615014576"></a><a name="image57231425662"></a><a name="image57231425662"></a><span><img id="image57231425662" src="figures/orange-54.png"></span></p>
</td>
</tr>
<tr id="row4313524571"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.1 "><p id="p153131026570"><a name="p153131026570"></a><a name="p153131026570"></a>Pink</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.2 "><p id="p631316212575"><a name="p631316212575"></a><a name="p631316212575"></a>0xffc0cb</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.3 "><p id="p1131316219574"><a name="p1131316219574"></a><a name="p1131316219574"></a><a name="image14330155414221"></a><a name="image14330155414221"></a><span><img id="image14330155414221" src="figures/pink-55.png"></span></p>
</td>
</tr>
<tr id="row43041415719"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.1 "><p id="p173051147574"><a name="p173051147574"></a><a name="p173051147574"></a>Red</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.2 "><p id="p1030520475714"><a name="p1030520475714"></a><a name="p1030520475714"></a>0xff0000</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.3 "><p id="p730510415573"><a name="p730510415573"></a><a name="p730510415573"></a><a name="image19292173182417"></a><a name="image19292173182417"></a><span><img id="image19292173182417" src="figures/red-56.png"></span></p>
</td>
</tr>
<tr id="row9107406587"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.1 "><p id="p41074035812"><a name="p41074035812"></a><a name="p41074035812"></a>White</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.2 "><p id="p191017409582"><a name="p191017409582"></a><a name="p191017409582"></a>0xffffff</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.3 "><p id="p1510164055811"><a name="p1510164055811"></a><a name="p1510164055811"></a><a name="image693584014283"></a><a name="image693584014283"></a><span><img id="image693584014283" src="figures/white-57.png"></span></p>
</td>
</tr>
<tr id="row1447644675811"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.1 "><p id="p94779461585"><a name="p94779461585"></a><a name="p94779461585"></a>Yellow</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.2 "><p id="p5477546135812"><a name="p5477546135812"></a><a name="p5477546135812"></a>0xffff00</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.3 "><p id="p74775466585"><a name="p74775466585"></a><a name="p74775466585"></a><a name="image038713915415"></a><a name="image038713915415"></a><span><img id="image038713915415" src="figures/yellow-58.png"></span></p>
</td>
</tr>
</tbody>
</table>

## ColorStop Type<a name="section5633640161413"></a>

**ColorStop**  is used to describe the progressive color stop.

<a name="table6277163655117"></a>
<table><thead align="left"><tr id="row727853615518"><th class="cellrowborder" valign="top" width="12.811281128112812%" id="mcps1.1.4.1.1"><p id="p1927833625111"><a name="p1927833625111"></a><a name="p1927833625111"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="20.262026202620262%" id="mcps1.1.4.1.2"><p id="p72781936135110"><a name="p72781936135110"></a><a name="p72781936135110"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="66.92669266926693%" id="mcps1.1.4.1.3"><p id="p19278193618515"><a name="p19278193618515"></a><a name="p19278193618515"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row11278193665119"><td class="cellrowborder" valign="top" width="12.811281128112812%" headers="mcps1.1.4.1.1 "><p id="p927853618514"><a name="p927853618514"></a><a name="p927853618514"></a>ColorStop</p>
</td>
<td class="cellrowborder" valign="top" width="20.262026202620262%" headers="mcps1.1.4.1.2 "><p id="p20278153685112"><a name="p20278153685112"></a><a name="p20278153685112"></a>[Color, number]</p>
</td>
<td class="cellrowborder" valign="top" width="66.92669266926693%" headers="mcps1.1.4.1.3 "><p id="p1127933675115"><a name="p1127933675115"></a><a name="p1127933675115"></a>Type of the progressive color stop. The first parameter specifies the color value, and the second parameter specifies the ratio of 0 to 1.</p>
</td>
</tr>
</tbody>
</table>

## Example<a name="section83351227165714"></a>

```
@Entry
@Component
struct dataTypeExample {
  build() {
    Column({ space: 5 }) {
      Text('Length').fontColor(0xCCCCCC).fontSize(9).width('90%')
      Text('90%').width('90%').height(40).backgroundColor(0xF9CF93)
        .textAlign(TextAlign.Center).fontColor(Color.White)
      Text('320').width(320).height(40).backgroundColor(0xF9CF93)
        .textAlign(TextAlign.Center).fontColor(Color.White)
      Text('1000px').width('1000px').height(40).backgroundColor(0xF9CF93)
        .textAlign(TextAlign.Center).fontColor(Color.White)

      Text('Angle').fontColor(0xCCCCCC).fontSize(9).width('90%')
      Text('45deg')
        .width(40).height(40)
        .rotate({ x: 0, y: 0, z: 1, angle: 45, centerX: '50%', centerY: '50%' })
        .fontColor(Color.White)
        .backgroundColor(0xF9CF93).textAlign(TextAlign.Center)

      Text('45rad')
        .width(40).height(40)
        .rotate({ x: 0, y: 0, z: 1, angle: '45rad', centerX: '50%', centerY: '50%' })
        .fontColor(Color.White)
        .backgroundColor(0xF9CF93).textAlign(TextAlign.Center).margin({ top: 30 })

      Text('Point').fontColor(0xCCCCCC).fontSize(9).width('90%')
      Line().width(300).height(40).startPoint([0, 20]).endPoint([300, 20])

      Text('Color').fontColor('#CCCCCC').fontSize(9).width('90%')
      Text('0xF9CF93')
        .fontColor(Color.White).textAlign(TextAlign.Center)
        .width('90%').height(40).backgroundColor(0xF9CF93)

      Text('#F9CF93')
        .fontColor(Color.White).textAlign(TextAlign.Center)
        .width('90%').height(40).backgroundColor('#F9CF93')

      Text('rgb(249, 207, 147)')
        .fontColor(Color.White).textAlign(TextAlign.Center)
        .width('90%').height(40).backgroundColor('rgb(249, 207, 147)')

      Text('rgba(249, 207, 147, 1.0)')
        .fontColor(Color.White).textAlign(TextAlign.Center)
        .width('90%').height(40).backgroundColor('rgba(249, 207, 147, 1.0)')

      Text('Color.Yellow')
        .textAlign(TextAlign.Center)
        .width('90%').height(40).backgroundColor(Color.Yellow)
    }
    .width('100%').margin({ top: 5 })
  }
}
```

![](figures/datatype.png)

