# Alert Dialog Box<a name="EN-US_TOPIC_0000001174326045"></a>

You can set the text content and response callback for an alert dialog box.

## Attributes<a name="section04482591607"></a>

<a name="table1140mcpsimp"></a>
<table><thead align="left"><tr id="row1147mcpsimp"><th class="cellrowborder" valign="top" width="16.59%" id="mcps1.1.5.1.1"><p id="p1149mcpsimp"><a name="p1149mcpsimp"></a><a name="p1149mcpsimp"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="30.15%" id="mcps1.1.5.1.2"><p id="p1151mcpsimp"><a name="p1151mcpsimp"></a><a name="p1151mcpsimp"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="17.89%" id="mcps1.1.5.1.3"><p id="p1153mcpsimp"><a name="p1153mcpsimp"></a><a name="p1153mcpsimp"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="35.370000000000005%" id="mcps1.1.5.1.4"><p id="p1155mcpsimp"><a name="p1155mcpsimp"></a><a name="p1155mcpsimp"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1156mcpsimp"><td class="cellrowborder" valign="top" width="16.59%" headers="mcps1.1.5.1.1 "><p id="p1158mcpsimp"><a name="p1158mcpsimp"></a><a name="p1158mcpsimp"></a>show</p>
</td>
<td class="cellrowborder" valign="top" width="30.15%" headers="mcps1.1.5.1.2 "><p id="p8684433112810"><a name="p8684433112810"></a><a name="p8684433112810"></a>options: { <a href="#li132561452141616">paramObject1</a>| <a href="#li45381332179">paramObject2</a>}</p>
</td>
<td class="cellrowborder" valign="top" width="17.89%" headers="mcps1.1.5.1.3 "><p id="p1162mcpsimp"><a name="p1162mcpsimp"></a><a name="p1162mcpsimp"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="35.370000000000005%" headers="mcps1.1.5.1.4 "><p id="p1164mcpsimp"><a name="p1164mcpsimp"></a><a name="p1164mcpsimp"></a>Defines and displays the <strong id="b1333743135220"><a name="b1333743135220"></a><a name="b1333743135220"></a>&lt;AlertDialog&gt;</strong> component.</p>
</td>
</tr>
</tbody>
</table>

-   <a name="li132561452141616"></a>paramObject1 parameters

    <a name="table816913216616"></a>
    <table><thead align="left"><tr id="row016972667"><th class="cellrowborder" valign="top" width="12.31%" id="mcps1.1.6.1.1"><p id="p101691221267"><a name="p101691221267"></a><a name="p101691221267"></a>Name</p>
    </th>
    <th class="cellrowborder" valign="top" width="32.61%" id="mcps1.1.6.1.2"><p id="p616916211613"><a name="p616916211613"></a><a name="p616916211613"></a>Type</p>
    </th>
    <th class="cellrowborder" valign="top" width="5.01%" id="mcps1.1.6.1.3"><p id="p21691725613"><a name="p21691725613"></a><a name="p21691725613"></a>Mandatory</p>
    </th>
    <th class="cellrowborder" valign="top" width="22.68%" id="mcps1.1.6.1.4"><p id="p4169221969"><a name="p4169221969"></a><a name="p4169221969"></a>Default Value</p>
    </th>
    <th class="cellrowborder" valign="top" width="27.389999999999997%" id="mcps1.1.6.1.5"><p id="p616922465"><a name="p616922465"></a><a name="p616922465"></a>Description</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="row617013216610"><td class="cellrowborder" valign="top" width="12.31%" headers="mcps1.1.6.1.1 "><p id="p11170822063"><a name="p11170822063"></a><a name="p11170822063"></a>title</p>
    </td>
    <td class="cellrowborder" valign="top" width="32.61%" headers="mcps1.1.6.1.2 "><p id="p1483117481135"><a name="p1483117481135"></a><a name="p1483117481135"></a>string | Resource</p>
    </td>
    <td class="cellrowborder" valign="top" width="5.01%" headers="mcps1.1.6.1.3 "><p id="p19393124211313"><a name="p19393124211313"></a><a name="p19393124211313"></a>No</p>
    </td>
    <td class="cellrowborder" valign="top" width="22.68%" headers="mcps1.1.6.1.4 "><p id="p51702216617"><a name="p51702216617"></a><a name="p51702216617"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="27.389999999999997%" headers="mcps1.1.6.1.5 "><p id="p479412426512"><a name="p479412426512"></a><a name="p479412426512"></a>Title of a dialog box.</p>
    </td>
    </tr>
    <tr id="row4170723612"><td class="cellrowborder" valign="top" width="12.31%" headers="mcps1.1.6.1.1 "><p id="p171709214610"><a name="p171709214610"></a><a name="p171709214610"></a>message</p>
    </td>
    <td class="cellrowborder" valign="top" width="32.61%" headers="mcps1.1.6.1.2 "><p id="p1517018210613"><a name="p1517018210613"></a><a name="p1517018210613"></a>string | Resource</p>
    </td>
    <td class="cellrowborder" valign="top" width="5.01%" headers="mcps1.1.6.1.3 "><p id="p141701022068"><a name="p141701022068"></a><a name="p141701022068"></a>Yes</p>
    </td>
    <td class="cellrowborder" valign="top" width="22.68%" headers="mcps1.1.6.1.4 "><p id="p20170429614"><a name="p20170429614"></a><a name="p20170429614"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="27.389999999999997%" headers="mcps1.1.6.1.5 "><p id="p17931042651"><a name="p17931042651"></a><a name="p17931042651"></a>Content of the dialog box.</p>
    </td>
    </tr>
    <tr id="row7170625613"><td class="cellrowborder" valign="top" width="12.31%" headers="mcps1.1.6.1.1 "><p id="p11170627619"><a name="p11170627619"></a><a name="p11170627619"></a>autoCancel</p>
    </td>
    <td class="cellrowborder" valign="top" width="32.61%" headers="mcps1.1.6.1.2 "><p id="p71701121661"><a name="p71701121661"></a><a name="p71701121661"></a>boolean</p>
    </td>
    <td class="cellrowborder" valign="top" width="5.01%" headers="mcps1.1.6.1.3 "><p id="p8170192564"><a name="p8170192564"></a><a name="p8170192564"></a>No</p>
    </td>
    <td class="cellrowborder" valign="top" width="22.68%" headers="mcps1.1.6.1.4 "><p id="p3714415149"><a name="p3714415149"></a><a name="p3714415149"></a>true</p>
    </td>
    <td class="cellrowborder" valign="top" width="27.389999999999997%" headers="mcps1.1.6.1.5 "><p id="p2792194217516"><a name="p2792194217516"></a><a name="p2792194217516"></a>Whether to close the dialog box when the overlay is clicked.</p>
    </td>
    </tr>
    <tr id="row4619154917209"><td class="cellrowborder" valign="top" width="12.31%" headers="mcps1.1.6.1.1 "><p id="p15281132516419"><a name="p15281132516419"></a><a name="p15281132516419"></a>confirm</p>
    </td>
    <td class="cellrowborder" valign="top" width="32.61%" headers="mcps1.1.6.1.2 "><p id="p1867614501417"><a name="p1867614501417"></a><a name="p1867614501417"></a>{</p>
    <p id="p8676115020415"><a name="p8676115020415"></a><a name="p8676115020415"></a>value: string | Resource,</p>
    <p id="p1743134451513"><a name="p1743134451513"></a><a name="p1743134451513"></a>fontColor?: Color | number | string | Resource,</p>
    <p id="p18233112112177"><a name="p18233112112177"></a><a name="p18233112112177"></a>backgroundColor?: Color | number | string | Resource,</p>
    <p id="p1767616508415"><a name="p1767616508415"></a><a name="p1767616508415"></a>action: () =&gt; void</p>
    <p id="p0676250345"><a name="p0676250345"></a><a name="p0676250345"></a>}</p>
    </td>
    <td class="cellrowborder" valign="top" width="5.01%" headers="mcps1.1.6.1.3 "><p id="p1161910499207"><a name="p1161910499207"></a><a name="p1161910499207"></a>No</p>
    </td>
    <td class="cellrowborder" valign="top" width="22.68%" headers="mcps1.1.6.1.4 "><p id="p65590225511"><a name="p65590225511"></a><a name="p65590225511"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="27.389999999999997%" headers="mcps1.1.6.1.5 "><p id="p1479224217510"><a name="p1479224217510"></a><a name="p1479224217510"></a>Text content, text color, background color, and click callback of the confirm button.</p>
    </td>
    </tr>
    <tr id="row1212812822210"><td class="cellrowborder" valign="top" width="12.31%" headers="mcps1.1.6.1.1 "><p id="p11128181222"><a name="p11128181222"></a><a name="p11128181222"></a>cancel</p>
    </td>
    <td class="cellrowborder" valign="top" width="32.61%" headers="mcps1.1.6.1.2 "><p id="p38813406419"><a name="p38813406419"></a><a name="p38813406419"></a>() =&gt; void</p>
    </td>
    <td class="cellrowborder" valign="top" width="5.01%" headers="mcps1.1.6.1.3 "><p id="p312819882214"><a name="p312819882214"></a><a name="p312819882214"></a>No</p>
    </td>
    <td class="cellrowborder" valign="top" width="22.68%" headers="mcps1.1.6.1.4 "><p id="p1128158112211"><a name="p1128158112211"></a><a name="p1128158112211"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="27.389999999999997%" headers="mcps1.1.6.1.5 "><p id="p678919421452"><a name="p678919421452"></a><a name="p678919421452"></a>Callback invoked when the dialog box is closed after the overlay is clicked.</p>
    </td>
    </tr>
    <tr id="row1842942319416"><td class="cellrowborder" valign="top" width="12.31%" headers="mcps1.1.6.1.1 "><p id="p11429192314412"><a name="p11429192314412"></a><a name="p11429192314412"></a>alignment</p>
    </td>
    <td class="cellrowborder" valign="top" width="32.61%" headers="mcps1.1.6.1.2 "><p id="p1542910231744"><a name="p1542910231744"></a><a name="p1542910231744"></a><a href="ts-methods-custom-dialog-box.md#li46304184186">DialogAlignment</a></p>
    </td>
    <td class="cellrowborder" valign="top" width="5.01%" headers="mcps1.1.6.1.3 "><p id="p842914239415"><a name="p842914239415"></a><a name="p842914239415"></a>No</p>
    </td>
    <td class="cellrowborder" valign="top" width="22.68%" headers="mcps1.1.6.1.4 "><p id="p842916234416"><a name="p842916234416"></a><a name="p842916234416"></a><a href="ts-methods-custom-dialog-box.md#li46304184186">DialogAlignment</a>.Default</p>
    </td>
    <td class="cellrowborder" valign="top" width="27.389999999999997%" headers="mcps1.1.6.1.5 "><p id="p1342922318415"><a name="p1342922318415"></a><a name="p1342922318415"></a>Alignment mode of the dialog box in the vertical direction.</p>
    </td>
    </tr>
    <tr id="row164541242866"><td class="cellrowborder" valign="top" width="12.31%" headers="mcps1.1.6.1.1 "><p id="p745414424612"><a name="p745414424612"></a><a name="p745414424612"></a>offset</p>
    </td>
    <td class="cellrowborder" valign="top" width="32.61%" headers="mcps1.1.6.1.2 "><p id="p15886722116"><a name="p15886722116"></a><a name="p15886722116"></a>{</p>
    <p id="p450717617111"><a name="p450717617111"></a><a name="p450717617111"></a>dx: Length | Resource,</p>
    <p id="p383151220115"><a name="p383151220115"></a><a name="p383151220115"></a>dy: Length  | Resource</p>
    <p id="p41289862216"><a name="p41289862216"></a><a name="p41289862216"></a>}</p>
    </td>
    <td class="cellrowborder" valign="top" width="5.01%" headers="mcps1.1.6.1.3 "><p id="p64540421767"><a name="p64540421767"></a><a name="p64540421767"></a>No</p>
    </td>
    <td class="cellrowborder" valign="top" width="22.68%" headers="mcps1.1.6.1.4 "><p id="p8454124215613"><a name="p8454124215613"></a><a name="p8454124215613"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="27.389999999999997%" headers="mcps1.1.6.1.5 "><p id="p44541142362"><a name="p44541142362"></a><a name="p44541142362"></a>Offset of the dialog box relative to the alignment position.</p>
    </td>
    </tr>
    <tr id="row07688549148"><td class="cellrowborder" valign="top" width="12.31%" headers="mcps1.1.6.1.1 "><p id="p8768125419148"><a name="p8768125419148"></a><a name="p8768125419148"></a>gridCount</p>
    </td>
    <td class="cellrowborder" valign="top" width="32.61%" headers="mcps1.1.6.1.2 "><p id="p1976845416140"><a name="p1976845416140"></a><a name="p1976845416140"></a>number</p>
    </td>
    <td class="cellrowborder" valign="top" width="5.01%" headers="mcps1.1.6.1.3 "><p id="p1176845471411"><a name="p1176845471411"></a><a name="p1176845471411"></a>No</p>
    </td>
    <td class="cellrowborder" valign="top" width="22.68%" headers="mcps1.1.6.1.4 "><p id="p16768954111413"><a name="p16768954111413"></a><a name="p16768954111413"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="27.389999999999997%" headers="mcps1.1.6.1.5 "><p id="p16768954151416"><a name="p16768954151416"></a><a name="p16768954151416"></a>Number of grid columns occupied by the width of the dialog box.</p>
    </td>
    </tr>
    </tbody>
    </table>


-   <a name="li45381332179"></a>paramObject2 parameters

    <a name="table1413716501059"></a>
    <table><thead align="left"><tr id="row3137105018516"><th class="cellrowborder" valign="top" width="16.76%" id="mcps1.1.6.1.1"><p id="p313711500510"><a name="p313711500510"></a><a name="p313711500510"></a>Name</p>
    </th>
    <th class="cellrowborder" valign="top" width="37.53%" id="mcps1.1.6.1.2"><p id="p8137145019516"><a name="p8137145019516"></a><a name="p8137145019516"></a>Type</p>
    </th>
    <th class="cellrowborder" valign="top" width="8.25%" id="mcps1.1.6.1.3"><p id="p101371850657"><a name="p101371850657"></a><a name="p101371850657"></a>Mandatory</p>
    </th>
    <th class="cellrowborder" valign="top" width="16.32%" id="mcps1.1.6.1.4"><p id="p2137150952"><a name="p2137150952"></a><a name="p2137150952"></a>Default Value</p>
    </th>
    <th class="cellrowborder" valign="top" width="21.14%" id="mcps1.1.6.1.5"><p id="p51371250658"><a name="p51371250658"></a><a name="p51371250658"></a>Description</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="row201373501056"><td class="cellrowborder" valign="top" width="16.76%" headers="mcps1.1.6.1.1 "><p id="p51381150057"><a name="p51381150057"></a><a name="p51381150057"></a>title</p>
    </td>
    <td class="cellrowborder" valign="top" width="37.53%" headers="mcps1.1.6.1.2 "><p id="p1713819501354"><a name="p1713819501354"></a><a name="p1713819501354"></a>string | Resource</p>
    </td>
    <td class="cellrowborder" valign="top" width="8.25%" headers="mcps1.1.6.1.3 "><p id="p121381350056"><a name="p121381350056"></a><a name="p121381350056"></a>No</p>
    </td>
    <td class="cellrowborder" valign="top" width="16.32%" headers="mcps1.1.6.1.4 "><p id="p1113812501857"><a name="p1113812501857"></a><a name="p1113812501857"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="21.14%" headers="mcps1.1.6.1.5 "><p id="p8138650853"><a name="p8138650853"></a><a name="p8138650853"></a>Title of a dialog box.</p>
    </td>
    </tr>
    <tr id="row1713814502520"><td class="cellrowborder" valign="top" width="16.76%" headers="mcps1.1.6.1.1 "><p id="p191384508512"><a name="p191384508512"></a><a name="p191384508512"></a>message</p>
    </td>
    <td class="cellrowborder" valign="top" width="37.53%" headers="mcps1.1.6.1.2 "><p id="p1413811502052"><a name="p1413811502052"></a><a name="p1413811502052"></a>string | Resource</p>
    </td>
    <td class="cellrowborder" valign="top" width="8.25%" headers="mcps1.1.6.1.3 "><p id="p3138155016516"><a name="p3138155016516"></a><a name="p3138155016516"></a>Yes</p>
    </td>
    <td class="cellrowborder" valign="top" width="16.32%" headers="mcps1.1.6.1.4 "><p id="p1913895010510"><a name="p1913895010510"></a><a name="p1913895010510"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="21.14%" headers="mcps1.1.6.1.5 "><p id="p1713816501555"><a name="p1713816501555"></a><a name="p1713816501555"></a>Content of the dialog box.</p>
    </td>
    </tr>
    <tr id="row31384507513"><td class="cellrowborder" valign="top" width="16.76%" headers="mcps1.1.6.1.1 "><p id="p31384501513"><a name="p31384501513"></a><a name="p31384501513"></a>autoCancel</p>
    </td>
    <td class="cellrowborder" valign="top" width="37.53%" headers="mcps1.1.6.1.2 "><p id="p131387501352"><a name="p131387501352"></a><a name="p131387501352"></a>boolean</p>
    </td>
    <td class="cellrowborder" valign="top" width="8.25%" headers="mcps1.1.6.1.3 "><p id="p91387501455"><a name="p91387501455"></a><a name="p91387501455"></a>No</p>
    </td>
    <td class="cellrowborder" valign="top" width="16.32%" headers="mcps1.1.6.1.4 "><p id="p11285115693215"><a name="p11285115693215"></a><a name="p11285115693215"></a>true</p>
    </td>
    <td class="cellrowborder" valign="top" width="21.14%" headers="mcps1.1.6.1.5 "><p id="p151389505513"><a name="p151389505513"></a><a name="p151389505513"></a>Whether to close the dialog box when the overlay is clicked.</p>
    </td>
    </tr>
    <tr id="row11138125012513"><td class="cellrowborder" valign="top" width="16.76%" headers="mcps1.1.6.1.1 "><p id="p1713855013519"><a name="p1713855013519"></a><a name="p1713855013519"></a>primaryButton</p>
    </td>
    <td class="cellrowborder" valign="top" width="37.53%" headers="mcps1.1.6.1.2 "><p id="p111386501559"><a name="p111386501559"></a><a name="p111386501559"></a>{</p>
    <p id="p1313895016513"><a name="p1313895016513"></a><a name="p1313895016513"></a>value: string | Resource,</p>
    <p id="p1195891562018"><a name="p1195891562018"></a><a name="p1195891562018"></a>fontColor?: Color | number | string | Resource,</p>
    <p id="p169591154206"><a name="p169591154206"></a><a name="p169591154206"></a>backgroundColor?: Color | number | string | Resource,</p>
    <p id="p813875017511"><a name="p813875017511"></a><a name="p813875017511"></a>action: () =&gt; void;</p>
    <p id="p5138950457"><a name="p5138950457"></a><a name="p5138950457"></a>}</p>
    </td>
    <td class="cellrowborder" valign="top" width="8.25%" headers="mcps1.1.6.1.3 "><p id="p713818501351"><a name="p713818501351"></a><a name="p713818501351"></a>No</p>
    </td>
    <td class="cellrowborder" valign="top" width="16.32%" headers="mcps1.1.6.1.4 "><p id="p121388500514"><a name="p121388500514"></a><a name="p121388500514"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="21.14%" headers="mcps1.1.6.1.5 "><p id="p6138165018511"><a name="p6138165018511"></a><a name="p6138165018511"></a>Text content, text color, background color, and click callback of the primary button.</p>
    </td>
    </tr>
    <tr id="row1813817501255"><td class="cellrowborder" valign="top" width="16.76%" headers="mcps1.1.6.1.1 "><p id="p1813818501759"><a name="p1813818501759"></a><a name="p1813818501759"></a>secondaryButton</p>
    </td>
    <td class="cellrowborder" valign="top" width="37.53%" headers="mcps1.1.6.1.2 "><p id="p1813825016510"><a name="p1813825016510"></a><a name="p1813825016510"></a></p>
    <p id="p1326717114213"><a name="p1326717114213"></a><a name="p1326717114213"></a>{</p>
    <p id="p172671316214"><a name="p172671316214"></a><a name="p172671316214"></a>value: string | Resource,</p>
    <p id="p1426720111211"><a name="p1426720111211"></a><a name="p1426720111211"></a>fontColor?: Color | number | string | Resource,</p>
    <p id="p1526751152118"><a name="p1526751152118"></a><a name="p1526751152118"></a>backgroundColor?: Color | number | string | Resource,</p>
    <p id="p1426751112112"><a name="p1426751112112"></a><a name="p1426751112112"></a>action: () =&gt; void;</p>
    <p id="p1526712132115"><a name="p1526712132115"></a><a name="p1526712132115"></a>}</p>
    </td>
    <td class="cellrowborder" valign="top" width="8.25%" headers="mcps1.1.6.1.3 "><p id="p161381350458"><a name="p161381350458"></a><a name="p161381350458"></a>No</p>
    </td>
    <td class="cellrowborder" valign="top" width="16.32%" headers="mcps1.1.6.1.4 "><p id="p613810501858"><a name="p613810501858"></a><a name="p613810501858"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="21.14%" headers="mcps1.1.6.1.5 "><p id="p1581685133016"><a name="p1581685133016"></a><a name="p1581685133016"></a>Text content, text color, background color, and click callback of the secondary button.</p>
    </td>
    </tr>
    <tr id="row10728118864"><td class="cellrowborder" valign="top" width="16.76%" headers="mcps1.1.6.1.1 "><p id="p177412291610"><a name="p177412291610"></a><a name="p177412291610"></a>cancel</p>
    </td>
    <td class="cellrowborder" valign="top" width="37.53%" headers="mcps1.1.6.1.2 "><p id="p142893345617"><a name="p142893345617"></a><a name="p142893345617"></a>() =&gt; void</p>
    </td>
    <td class="cellrowborder" valign="top" width="8.25%" headers="mcps1.1.6.1.3 "><p id="p172819183620"><a name="p172819183620"></a><a name="p172819183620"></a>No</p>
    </td>
    <td class="cellrowborder" valign="top" width="16.32%" headers="mcps1.1.6.1.4 "><p id="p972871816610"><a name="p972871816610"></a><a name="p972871816610"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="21.14%" headers="mcps1.1.6.1.5 "><p id="p10319101012301"><a name="p10319101012301"></a><a name="p10319101012301"></a>Callback invoked when the dialog box is closed after the overlay is clicked.</p>
    </td>
    </tr>
    <tr id="row6796114516715"><td class="cellrowborder" valign="top" width="16.76%" headers="mcps1.1.6.1.1 "><p id="p1579711451677"><a name="p1579711451677"></a><a name="p1579711451677"></a>alignment</p>
    </td>
    <td class="cellrowborder" valign="top" width="37.53%" headers="mcps1.1.6.1.2 "><p id="p1179718455715"><a name="p1179718455715"></a><a name="p1179718455715"></a><a href="ts-methods-custom-dialog-box.md#li46304184186">DialogAlignment</a></p>
    </td>
    <td class="cellrowborder" valign="top" width="8.25%" headers="mcps1.1.6.1.3 "><p id="p207971445474"><a name="p207971445474"></a><a name="p207971445474"></a>No</p>
    </td>
    <td class="cellrowborder" valign="top" width="16.32%" headers="mcps1.1.6.1.4 "><p id="p1279715451072"><a name="p1279715451072"></a><a name="p1279715451072"></a><a href="ts-methods-custom-dialog-box.md#li46304184186">DialogAlignment</a>.Default</p>
    </td>
    <td class="cellrowborder" valign="top" width="21.14%" headers="mcps1.1.6.1.5 "><p id="p1379716450716"><a name="p1379716450716"></a><a name="p1379716450716"></a>Alignment mode of the dialog box in the vertical direction.</p>
    </td>
    </tr>
    <tr id="row14479315916"><td class="cellrowborder" valign="top" width="16.76%" headers="mcps1.1.6.1.1 "><p id="p9471431998"><a name="p9471431998"></a><a name="p9471431998"></a>offset</p>
    </td>
    <td class="cellrowborder" valign="top" width="37.53%" headers="mcps1.1.6.1.2 "><p id="p1207111213915"><a name="p1207111213915"></a><a name="p1207111213915"></a>{</p>
    <p id="p162079129914"><a name="p162079129914"></a><a name="p162079129914"></a>dx: Length | Resource,</p>
    <p id="p220712121799"><a name="p220712121799"></a><a name="p220712121799"></a>dy: Length  | Resource</p>
    <p id="p132071612996"><a name="p132071612996"></a><a name="p132071612996"></a>}</p>
    </td>
    <td class="cellrowborder" valign="top" width="8.25%" headers="mcps1.1.6.1.3 "><p id="p4471331396"><a name="p4471331396"></a><a name="p4471331396"></a>No</p>
    </td>
    <td class="cellrowborder" valign="top" width="16.32%" headers="mcps1.1.6.1.4 "><p id="p1471231591"><a name="p1471231591"></a><a name="p1471231591"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="21.14%" headers="mcps1.1.6.1.5 "><p id="p24818311919"><a name="p24818311919"></a><a name="p24818311919"></a>Offset of the dialog box relative to the alignment position.</p>
    </td>
    </tr>
    <tr id="row15396103710486"><td class="cellrowborder" valign="top" width="16.76%" headers="mcps1.1.6.1.1 "><p id="p11396133724819"><a name="p11396133724819"></a><a name="p11396133724819"></a>gridCount</p>
    </td>
    <td class="cellrowborder" valign="top" width="37.53%" headers="mcps1.1.6.1.2 "><p id="p1939614372489"><a name="p1939614372489"></a><a name="p1939614372489"></a>number</p>
    </td>
    <td class="cellrowborder" valign="top" width="8.25%" headers="mcps1.1.6.1.3 "><p id="p11396113784811"><a name="p11396113784811"></a><a name="p11396113784811"></a>No</p>
    </td>
    <td class="cellrowborder" valign="top" width="16.32%" headers="mcps1.1.6.1.4 "><p id="p83968379480"><a name="p83968379480"></a><a name="p83968379480"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="21.14%" headers="mcps1.1.6.1.5 "><p id="p2396203734812"><a name="p2396203734812"></a><a name="p2396203734812"></a>Number of grid columns occupied by the width of the dialog box.</p>
    </td>
    </tr>
    </tbody>
    </table>


## Example<a name="section1110113275912"></a>

```
@Entry
@Component
struct AlertDialogExample {
  build() {
    Column({ space: 5 }) {
      Button('one button dialog')
        .onClick(() => {
          AlertDialog.show(
            {
              title: 'title',
              message: 'text',
              confirm: {
                value: 'button',
                action: () => {
                  console.info('Button-clicking callback')
                }
              },
              cancel: () => {
                console.info('Closed callbacks')
              }
            }
          )
      })
        .backgroundColor(0x317aff)
      Button('two button dialog')
        .onClick(() => {
          AlertDialog.show(
            {
              title: 'title',
              message: 'text',
              primaryButton: {
                value: 'cancel',
                action: () => {
                  console.info('Callback when the first button is clicked')
                }
              },
              secondaryButton: {
                value: 'ok',
                action: () => {
                  console.info('Callback when the second button is clicked')
                }
              },
              cancel: () => {
                console.info('Closed callbacks')
              }
            }
          )
      }).backgroundColor(0x317aff)
    }.width('100%').margin({ top: 5 })
  }
}
```

![](figures/alertdialog.gif)

