# "js" Tag<a name="EN-US_TOPIC_0000001158141247"></a>

Configure the  **"js"**  tag in the  [config.json](https://developer.harmonyos.com/en/docs/documentation/doc-guides/basic-config-file-overview-0000000000011951)  file of your application. The  **"js"**  tag contains the instance name, page route, and window configuration information.

<a name="table155mcpsimp"></a>
<table><thead align="left"><tr id="row163mcpsimp"><th class="cellrowborder" valign="top" width="16.831683168316832%" id="mcps1.1.6.1.1"><p id="p165mcpsimp"><a name="p165mcpsimp"></a><a name="p165mcpsimp"></a>Tag</p>
</th>
<th class="cellrowborder" valign="top" width="16.831683168316832%" id="mcps1.1.6.1.2"><p id="p167mcpsimp"><a name="p167mcpsimp"></a><a name="p167mcpsimp"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="14.52145214521452%" id="mcps1.1.6.1.3"><p id="p169mcpsimp"><a name="p169mcpsimp"></a><a name="p169mcpsimp"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="14.19141914191419%" id="mcps1.1.6.1.4"><p id="p171mcpsimp"><a name="p171mcpsimp"></a><a name="p171mcpsimp"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="37.62376237623762%" id="mcps1.1.6.1.5"><p id="p173mcpsimp"><a name="p173mcpsimp"></a><a name="p173mcpsimp"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row174mcpsimp"><td class="cellrowborder" valign="top" width="16.831683168316832%" headers="mcps1.1.6.1.1 "><p id="p176mcpsimp"><a name="p176mcpsimp"></a><a name="p176mcpsimp"></a>name</p>
</td>
<td class="cellrowborder" valign="top" width="16.831683168316832%" headers="mcps1.1.6.1.2 "><p id="p178mcpsimp"><a name="p178mcpsimp"></a><a name="p178mcpsimp"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="14.52145214521452%" headers="mcps1.1.6.1.3 "><p id="p180mcpsimp"><a name="p180mcpsimp"></a><a name="p180mcpsimp"></a>default</p>
</td>
<td class="cellrowborder" valign="top" width="14.19141914191419%" headers="mcps1.1.6.1.4 "><p id="p182mcpsimp"><a name="p182mcpsimp"></a><a name="p182mcpsimp"></a>Yes</p>
</td>
<td class="cellrowborder" valign="top" width="37.62376237623762%" headers="mcps1.1.6.1.5 "><p id="p184mcpsimp"><a name="p184mcpsimp"></a><a name="p184mcpsimp"></a>Name of the ETS instance.</p>
</td>
</tr>
<tr id="row185mcpsimp"><td class="cellrowborder" valign="top" width="16.831683168316832%" headers="mcps1.1.6.1.1 "><p id="p187mcpsimp"><a name="p187mcpsimp"></a><a name="p187mcpsimp"></a>pages</p>
</td>
<td class="cellrowborder" valign="top" width="16.831683168316832%" headers="mcps1.1.6.1.2 "><p id="p189mcpsimp"><a name="p189mcpsimp"></a><a name="p189mcpsimp"></a>Array</p>
</td>
<td class="cellrowborder" valign="top" width="14.52145214521452%" headers="mcps1.1.6.1.3 "><p id="p191mcpsimp"><a name="p191mcpsimp"></a><a name="p191mcpsimp"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="14.19141914191419%" headers="mcps1.1.6.1.4 "><p id="p193mcpsimp"><a name="p193mcpsimp"></a><a name="p193mcpsimp"></a>Yes</p>
</td>
<td class="cellrowborder" valign="top" width="37.62376237623762%" headers="mcps1.1.6.1.5 "><p id="p195mcpsimp"><a name="p195mcpsimp"></a><a name="p195mcpsimp"></a>Page route information. For details, see <a href="#section58191020141212">"pages"</a>.</p>
</td>
</tr>
<tr id="row1470193511315"><td class="cellrowborder" valign="top" width="16.831683168316832%" headers="mcps1.1.6.1.1 "><p id="p8471103518319"><a name="p8471103518319"></a><a name="p8471103518319"></a>window</p>
</td>
<td class="cellrowborder" valign="top" width="16.831683168316832%" headers="mcps1.1.6.1.2 "><p id="p8471163515311"><a name="p8471163515311"></a><a name="p8471163515311"></a>Object</p>
</td>
<td class="cellrowborder" valign="top" width="14.52145214521452%" headers="mcps1.1.6.1.3 "><p id="p194719356314"><a name="p194719356314"></a><a name="p194719356314"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="14.19141914191419%" headers="mcps1.1.6.1.4 "><p id="p13471193511316"><a name="p13471193511316"></a><a name="p13471193511316"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="37.62376237623762%" headers="mcps1.1.6.1.5 "><p id="p2047153583114"><a name="p2047153583114"></a><a name="p2047153583114"></a>Window configuration information. For details, see <a href="#section051216429126">"window"</a>.</p>
</td>
</tr>
<tr id="row9971103313451"><td class="cellrowborder" valign="top" width="16.831683168316832%" headers="mcps1.1.6.1.1 "><p id="p397173317458"><a name="p397173317458"></a><a name="p397173317458"></a>mode</p>
</td>
<td class="cellrowborder" valign="top" width="16.831683168316832%" headers="mcps1.1.6.1.2 "><p id="p18971183318456"><a name="p18971183318456"></a><a name="p18971183318456"></a>Object</p>
</td>
<td class="cellrowborder" valign="top" width="14.52145214521452%" headers="mcps1.1.6.1.3 "><p id="p497283354510"><a name="p497283354510"></a><a name="p497283354510"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="14.19141914191419%" headers="mcps1.1.6.1.4 "><p id="p597212332456"><a name="p597212332456"></a><a name="p597212332456"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="37.62376237623762%" headers="mcps1.1.6.1.5 "><p id="p19555836124"><a name="p19555836124"></a><a name="p19555836124"></a>Running type and syntax style of the JS component. For details, see <a href="#section187397018139">"mode"</a>.</p>
</td>
</tr>
</tbody>
</table>

## pages<a name="section58191020141212"></a>

The  **"pages"**  defines the route information of each page's entry component. Each page consists of the page path and page name. The following is an example:

```
{
    "pages": [
        "pages/index",
        "pages/detail"
    ]
}
```

>![](../../public_sys-resources/icon-note.gif) **NOTE:** 
>-   The first page in the  **"pages"**  list is the home page of the application.
>-   The page name must not be a component name, for example,  **Text.ets**  or  **Button.ets**.
>-   Each page file must contain the  [page entry component](ts-component-based-entry.md)  \(with the @Entry decoration\).

## window<a name="section051216429126"></a>

The  **"window"**  configures the view window. The following attributes can be configured:

<a name="table12744175911317"></a>
<table><thead align="left"><tr id="row13744259131317"><th class="cellrowborder" valign="top" width="15.4015401540154%" id="mcps1.1.4.1.1"><p id="p574413592132"><a name="p574413592132"></a><a name="p574413592132"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="12.56125612561256%" id="mcps1.1.4.1.2"><p id="p11745115916131"><a name="p11745115916131"></a><a name="p11745115916131"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="72.03720372037205%" id="mcps1.1.4.1.3"><p id="p874513594137"><a name="p874513594137"></a><a name="p874513594137"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row157461359131320"><td class="cellrowborder" valign="top" width="15.4015401540154%" headers="mcps1.1.4.1.1 "><p id="p774614598137"><a name="p774614598137"></a><a name="p774614598137"></a>designWidth</p>
</td>
<td class="cellrowborder" valign="top" width="12.56125612561256%" headers="mcps1.1.4.1.2 "><p id="p77461359141312"><a name="p77461359141312"></a><a name="p77461359141312"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="72.03720372037205%" headers="mcps1.1.4.1.3 "><p id="p3740171951611"><a name="p3740171951611"></a><a name="p3740171951611"></a>Logical width of the view. The default value is <strong id="b171419193421"><a name="b171419193421"></a><a name="b171419193421"></a>720</strong>. (The default value is <strong id="b7750142412424"><a name="b7750142412424"></a><a name="b7750142412424"></a>454</strong> for wearables.) The logical width of the view determines the unit size of lpx. For example, if <strong id="b170015367467"><a name="b170015367467"></a><a name="b170015367467"></a>designWidth</strong> is <strong id="b1985740184615"><a name="b1985740184615"></a><a name="b1985740184615"></a>720</strong> and the view width is 1440 physical pixels, 1 lpx is 2 physical pixels. For details, see <a href="ts-pixel-units.md">lpx</a>.</p>
</td>
</tr>
</tbody>
</table>

```
{
  ...
  "window": {
    "designWidth": 720
  }
  ...
}
```

## mode<a name="section187397018139"></a>

The  **"mode"**  configures the running type and syntax style of a JS component. The following attributes are supported:

<a name="table0991613141319"></a>
<table><thead align="left"><tr id="row399151341313"><th class="cellrowborder" valign="top" width="14.041404140414041%" id="mcps1.1.4.1.1"><p id="p599171361314"><a name="p599171361314"></a><a name="p599171361314"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="8.700870087008699%" id="mcps1.1.4.1.2"><p id="p16991313151310"><a name="p16991313151310"></a><a name="p16991313151310"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="77.25772577257726%" id="mcps1.1.4.1.3"><p id="p14991813151318"><a name="p14991813151318"></a><a name="p14991813151318"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1799112131130"><td class="cellrowborder" valign="top" width="14.041404140414041%" headers="mcps1.1.4.1.1 "><p id="p4991191321313"><a name="p4991191321313"></a><a name="p4991191321313"></a>type</p>
</td>
<td class="cellrowborder" valign="top" width="8.700870087008699%" headers="mcps1.1.4.1.2 "><p id="p299261331320"><a name="p299261331320"></a><a name="p299261331320"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="77.25772577257726%" headers="mcps1.1.4.1.3 "><p id="p3992121312135"><a name="p3992121312135"></a><a name="p3992121312135"></a>Running type of the JS component. The options are as follows:</p>
<a name="ul1937861914577"></a><a name="ul1937861914577"></a><ul id="ul1937861914577"><li><strong id="b75081241041"><a name="b75081241041"></a><a name="b75081241041"></a>pageAbility</strong>: Run the JS component in ability mode.</li><li><strong id="b168910358411"><a name="b168910358411"></a><a name="b168910358411"></a>form</strong>: Run the JS component as a service widget.</li></ul>
</td>
</tr>
<tr id="row123561551181712"><td class="cellrowborder" valign="top" width="14.041404140414041%" headers="mcps1.1.4.1.1 "><p id="p335605114177"><a name="p335605114177"></a><a name="p335605114177"></a>syntax</p>
</td>
<td class="cellrowborder" valign="top" width="8.700870087008699%" headers="mcps1.1.4.1.2 "><p id="p2356951151718"><a name="p2356951151718"></a><a name="p2356951151718"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="77.25772577257726%" headers="mcps1.1.4.1.3 "><p id="p435617515178"><a name="p435617515178"></a><a name="p435617515178"></a>Syntax type of the JS component. The options are as follows:</p>
<a name="ul12256182612583"></a><a name="ul12256182612583"></a><ul id="ul12256182612583"><li><strong id="b2366192115510"><a name="b2366192115510"></a><a name="b2366192115510"></a>hml</strong>: compiled in the .hml, .css, or .js style.</li><li><strong id="b144835462511"><a name="b144835462511"></a><a name="b144835462511"></a>ets</strong>: compiled in the declarative syntax style.</li></ul>
</td>
</tr>
</tbody>
</table>

>![](../../public_sys-resources/icon-note.gif) **NOTE:** 
>-   If  **type**  is set to  **form**,  **syntax**  cannot be  **ets**.

## Example<a name="section5306141614133"></a>

config.json:

```
{
    "app": {
        "bundleName": "com.example.player",
        "version": {
            "code": 1,
            "name": "1.0"
        },
        "vendor": "example"
    },
    "module": {
        "js": [{
            "name": "default",
            "pages": [
                "pages/index",
                "pages/detail"
            ],
            "window": {
                "designWidth": 720
            },
            "mode": {
                "type": "pageAbility",
                "syntax": "ets"
            },
        }],
        "abilities": [{
            ... 
        }]
    }
}
```

