# Polyline<a name="EN-US_TOPIC_0000001119767800"></a>

The  **<Polyline\>**  component is used to draw a polyline.

## Child Components<a name="section29916914716"></a>

None

## APIs<a name="section19864224475"></a>

Polyline\(options?: \{width: Length, height: Length\}\)

-   Parameters

    <a name="table193606194544"></a>
    <table><thead align="left"><tr id="row536071910541"><th class="cellrowborder" valign="top" width="15.47%" id="mcps1.1.6.1.1"><p id="p436112199544"><a name="p436112199544"></a><a name="p436112199544"></a>Name</p>
    </th>
    <th class="cellrowborder" valign="top" width="17.22%" id="mcps1.1.6.1.2"><p id="p19361319115410"><a name="p19361319115410"></a><a name="p19361319115410"></a>Type</p>
    </th>
    <th class="cellrowborder" valign="top" width="12.49%" id="mcps1.1.6.1.3"><p id="p9361201975417"><a name="p9361201975417"></a><a name="p9361201975417"></a>Mandatory</p>
    </th>
    <th class="cellrowborder" valign="top" width="18.6%" id="mcps1.1.6.1.4"><p id="p43611199542"><a name="p43611199542"></a><a name="p43611199542"></a>Default Value</p>
    </th>
    <th class="cellrowborder" valign="top" width="36.22%" id="mcps1.1.6.1.5"><p id="p1136141975419"><a name="p1136141975419"></a><a name="p1136141975419"></a>Description</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="row10361101915545"><td class="cellrowborder" valign="top" width="15.47%" headers="mcps1.1.6.1.1 "><p id="p1361119155417"><a name="p1361119155417"></a><a name="p1361119155417"></a>options</p>
    </td>
    <td class="cellrowborder" valign="top" width="17.22%" headers="mcps1.1.6.1.2 "><p id="p8361181913548"><a name="p8361181913548"></a><a name="p8361181913548"></a>Object</p>
    </td>
    <td class="cellrowborder" valign="top" width="12.49%" headers="mcps1.1.6.1.3 "><p id="p153611119195411"><a name="p153611119195411"></a><a name="p153611119195411"></a>No</p>
    </td>
    <td class="cellrowborder" valign="top" width="18.6%" headers="mcps1.1.6.1.4 "><p id="p1436114193546"><a name="p1436114193546"></a><a name="p1436114193546"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="36.22%" headers="mcps1.1.6.1.5 "><p id="p328155017218"><a name="p328155017218"></a><a name="p328155017218"></a>For details, see the <a href="#li67915428493">options parameters</a>.</p>
    </td>
    </tr>
    </tbody>
    </table>

-   <a name="li67915428493"></a>options parameters

    <a name="table180964214919"></a>
    <table><thead align="left"><tr id="row980984284918"><th class="cellrowborder" valign="top" width="16.11%" id="mcps1.1.6.1.1"><p id="p5808194218498"><a name="p5808194218498"></a><a name="p5808194218498"></a>Name</p>
    </th>
    <th class="cellrowborder" valign="top" width="14.01%" id="mcps1.1.6.1.2"><p id="p138088424493"><a name="p138088424493"></a><a name="p138088424493"></a>Type</p>
    </th>
    <th class="cellrowborder" valign="top" width="14.499999999999998%" id="mcps1.1.6.1.3"><p id="p1180915420491"><a name="p1180915420491"></a><a name="p1180915420491"></a>Mandatory</p>
    </th>
    <th class="cellrowborder" valign="top" width="13.170000000000002%" id="mcps1.1.6.1.4"><p id="p168091242154910"><a name="p168091242154910"></a><a name="p168091242154910"></a>Default Value</p>
    </th>
    <th class="cellrowborder" valign="top" width="42.21%" id="mcps1.1.6.1.5"><p id="p15809442194914"><a name="p15809442194914"></a><a name="p15809442194914"></a>Description</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="row148095424499"><td class="cellrowborder" valign="top" width="16.11%" headers="mcps1.1.6.1.1 "><p id="p48092042184915"><a name="p48092042184915"></a><a name="p48092042184915"></a>width</p>
    </td>
    <td class="cellrowborder" valign="top" width="14.01%" headers="mcps1.1.6.1.2 "><p id="p10809342174912"><a name="p10809342174912"></a><a name="p10809342174912"></a>Length</p>
    </td>
    <td class="cellrowborder" valign="top" width="14.499999999999998%" headers="mcps1.1.6.1.3 "><p id="p4809154211492"><a name="p4809154211492"></a><a name="p4809154211492"></a>Yes</p>
    </td>
    <td class="cellrowborder" valign="top" width="13.170000000000002%" headers="mcps1.1.6.1.4 "><p id="p198093423492"><a name="p198093423492"></a><a name="p198093423492"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="42.21%" headers="mcps1.1.6.1.5 "><p id="p1980919423499"><a name="p1980919423499"></a><a name="p1980919423499"></a>Width.</p>
    </td>
    </tr>
    <tr id="row880916420497"><td class="cellrowborder" valign="top" width="16.11%" headers="mcps1.1.6.1.1 "><p id="p8809942124916"><a name="p8809942124916"></a><a name="p8809942124916"></a>height</p>
    </td>
    <td class="cellrowborder" valign="top" width="14.01%" headers="mcps1.1.6.1.2 "><p id="p1280934254916"><a name="p1280934254916"></a><a name="p1280934254916"></a>Length</p>
    </td>
    <td class="cellrowborder" valign="top" width="14.499999999999998%" headers="mcps1.1.6.1.3 "><p id="p980934214497"><a name="p980934214497"></a><a name="p980934214497"></a>Yes</p>
    </td>
    <td class="cellrowborder" valign="top" width="13.170000000000002%" headers="mcps1.1.6.1.4 "><p id="p118091642154910"><a name="p118091642154910"></a><a name="p118091642154910"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="42.21%" headers="mcps1.1.6.1.5 "><p id="p1180916424498"><a name="p1180916424498"></a><a name="p1180916424498"></a>Height.</p>
    </td>
    </tr>
    </tbody>
    </table>


## Attributes<a name="section1181110508478"></a>

<a name="table17670173353614"></a>
<table><thead align="left"><tr id="row870911333365"><th class="cellrowborder" valign="top" width="20%" id="mcps1.1.6.1.1"><p id="p17709933163616"><a name="p17709933163616"></a><a name="p17709933163616"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="20%" id="mcps1.1.6.1.2"><p id="p9709193383620"><a name="p9709193383620"></a><a name="p9709193383620"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="20%" id="mcps1.1.6.1.3"><p id="p19709143373619"><a name="p19709143373619"></a><a name="p19709143373619"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="16.12%" id="mcps1.1.6.1.4"><p id="p20709183316369"><a name="p20709183316369"></a><a name="p20709183316369"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="23.880000000000003%" id="mcps1.1.6.1.5"><p id="p1470911339367"><a name="p1470911339367"></a><a name="p1470911339367"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1770915332362"><td class="cellrowborder" valign="top" width="20%" headers="mcps1.1.6.1.1 "><p id="p77091833143615"><a name="p77091833143615"></a><a name="p77091833143615"></a>width</p>
</td>
<td class="cellrowborder" valign="top" width="20%" headers="mcps1.1.6.1.2 "><p id="p17091933163610"><a name="p17091933163610"></a><a name="p17091933163610"></a>Length</p>
</td>
<td class="cellrowborder" valign="top" width="20%" headers="mcps1.1.6.1.3 "><p id="p177091433113610"><a name="p177091433113610"></a><a name="p177091433113610"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="16.12%" headers="mcps1.1.6.1.4 "><p id="p187091533133612"><a name="p187091533133612"></a><a name="p187091533133612"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="23.880000000000003%" headers="mcps1.1.6.1.5 "><p id="p77091033113617"><a name="p77091033113617"></a><a name="p77091033113617"></a>Width of the rectangle where the polyline is located.</p>
</td>
</tr>
<tr id="row67091033133615"><td class="cellrowborder" valign="top" width="20%" headers="mcps1.1.6.1.1 "><p id="p370993363620"><a name="p370993363620"></a><a name="p370993363620"></a>height</p>
</td>
<td class="cellrowborder" valign="top" width="20%" headers="mcps1.1.6.1.2 "><p id="p270943303619"><a name="p270943303619"></a><a name="p270943303619"></a>Length</p>
</td>
<td class="cellrowborder" valign="top" width="20%" headers="mcps1.1.6.1.3 "><p id="p6709113393613"><a name="p6709113393613"></a><a name="p6709113393613"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="16.12%" headers="mcps1.1.6.1.4 "><p id="p2070913318368"><a name="p2070913318368"></a><a name="p2070913318368"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="23.880000000000003%" headers="mcps1.1.6.1.5 "><p id="p1070920331362"><a name="p1070920331362"></a><a name="p1070920331362"></a>Height of the rectangle where the polyline is located.</p>
</td>
</tr>
<tr id="row17091333143615"><td class="cellrowborder" valign="top" width="20%" headers="mcps1.1.6.1.1 "><p id="p14709433173611"><a name="p14709433173611"></a><a name="p14709433173611"></a>points</p>
</td>
<td class="cellrowborder" valign="top" width="20%" headers="mcps1.1.6.1.2 "><p id="p57091933123612"><a name="p57091933123612"></a><a name="p57091933123612"></a>Array&lt;Point&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="20%" headers="mcps1.1.6.1.3 "><p id="p370903363612"><a name="p370903363612"></a><a name="p370903363612"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="16.12%" headers="mcps1.1.6.1.4 "><p id="p670916335367"><a name="p670916335367"></a><a name="p670916335367"></a>Yes</p>
</td>
<td class="cellrowborder" valign="top" width="23.880000000000003%" headers="mcps1.1.6.1.5 "><p id="p8710133317366"><a name="p8710133317366"></a><a name="p8710133317366"></a>List of coordinates that the polyline passes through.</p>
</td>
</tr>
</tbody>
</table>

## Example<a name="section4459736105512"></a>

```
@Entry
@Component
struct PolylineExample {
  build() {
    Column({ space: 5 }) {
      Flex({ justifyContent: FlexAlign.SpaceAround }) {
        // Draw a polyline in a 100 x 100 rectangle. The start point is (0, 0), the end point is (100, 100), and the passing point is (20,60).
        Polyline({ width: 100, height: 100 }).points([[0, 0], [20, 60], [100, 100]])
        // Draw a polyline in a 100 x 100 rectangle. The start point is (0, 0), the end point is (100, 100), and the passing point is (0,100).
        Polyline().width(100).height(100).points([[0, 0], [0, 100], [100, 100]])
      }.width('100%')
    }.margin({ top: 5 })
  }
}
```

![](figures/polyline.gif)

