# Polygon<a name="EN-US_TOPIC_0000001166727519"></a>

The  **<Polygon\>**  component is used to draw a polygon.

## Child Components<a name="section095923464810"></a>

None

## APIs<a name="section19993104611483"></a>

Polygon\(value:\{options?: \{width: Length, height: Length\}\}\)

-   Parameters

    <a name="table193606194544"></a>
    <table><thead align="left"><tr id="row536071910541"><th class="cellrowborder" valign="top" width="15.47%" id="mcps1.1.6.1.1"><p id="p436112199544"><a name="p436112199544"></a><a name="p436112199544"></a>Name</p>
    </th>
    <th class="cellrowborder" valign="top" width="17.22%" id="mcps1.1.6.1.2"><p id="p19361319115410"><a name="p19361319115410"></a><a name="p19361319115410"></a>Type</p>
    </th>
    <th class="cellrowborder" valign="top" width="12.49%" id="mcps1.1.6.1.3"><p id="p9361201975417"><a name="p9361201975417"></a><a name="p9361201975417"></a>Mandatory</p>
    </th>
    <th class="cellrowborder" valign="top" width="18.6%" id="mcps1.1.6.1.4"><p id="p43611199542"><a name="p43611199542"></a><a name="p43611199542"></a>Default Value</p>
    </th>
    <th class="cellrowborder" valign="top" width="36.22%" id="mcps1.1.6.1.5"><p id="p1136141975419"><a name="p1136141975419"></a><a name="p1136141975419"></a>Description</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="row10361101915545"><td class="cellrowborder" valign="top" width="15.47%" headers="mcps1.1.6.1.1 "><p id="p1361119155417"><a name="p1361119155417"></a><a name="p1361119155417"></a>options</p>
    </td>
    <td class="cellrowborder" valign="top" width="17.22%" headers="mcps1.1.6.1.2 "><p id="p8361181913548"><a name="p8361181913548"></a><a name="p8361181913548"></a>Object</p>
    </td>
    <td class="cellrowborder" valign="top" width="12.49%" headers="mcps1.1.6.1.3 "><p id="p153611119195411"><a name="p153611119195411"></a><a name="p153611119195411"></a>No</p>
    </td>
    <td class="cellrowborder" valign="top" width="18.6%" headers="mcps1.1.6.1.4 "><p id="p1436114193546"><a name="p1436114193546"></a><a name="p1436114193546"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="36.22%" headers="mcps1.1.6.1.5 "><p id="p328155017218"><a name="p328155017218"></a><a name="p328155017218"></a>For details, see the <a href="#li28952213507">options parameters</a>.</p>
    </td>
    </tr>
    </tbody>
    </table>

-   <a name="li28952213507"></a>options parameters

    <a name="table491262125020"></a>
    <table><thead align="left"><tr id="row129111425500"><th class="cellrowborder" valign="top" width="16.11%" id="mcps1.1.6.1.1"><p id="p99112212504"><a name="p99112212504"></a><a name="p99112212504"></a>Name</p>
    </th>
    <th class="cellrowborder" valign="top" width="14.01%" id="mcps1.1.6.1.2"><p id="p1491112135015"><a name="p1491112135015"></a><a name="p1491112135015"></a>Type</p>
    </th>
    <th class="cellrowborder" valign="top" width="14.499999999999998%" id="mcps1.1.6.1.3"><p id="p491152175017"><a name="p491152175017"></a><a name="p491152175017"></a>Mandatory</p>
    </th>
    <th class="cellrowborder" valign="top" width="13.170000000000002%" id="mcps1.1.6.1.4"><p id="p169118217502"><a name="p169118217502"></a><a name="p169118217502"></a>Default Value</p>
    </th>
    <th class="cellrowborder" valign="top" width="42.21%" id="mcps1.1.6.1.5"><p id="p49117211504"><a name="p49117211504"></a><a name="p49117211504"></a>Description</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="row191112165012"><td class="cellrowborder" valign="top" width="16.11%" headers="mcps1.1.6.1.1 "><p id="p99115255014"><a name="p99115255014"></a><a name="p99115255014"></a>width</p>
    </td>
    <td class="cellrowborder" valign="top" width="14.01%" headers="mcps1.1.6.1.2 "><p id="p169114218509"><a name="p169114218509"></a><a name="p169114218509"></a>Length</p>
    </td>
    <td class="cellrowborder" valign="top" width="14.499999999999998%" headers="mcps1.1.6.1.3 "><p id="p11911152135018"><a name="p11911152135018"></a><a name="p11911152135018"></a>Yes</p>
    </td>
    <td class="cellrowborder" valign="top" width="13.170000000000002%" headers="mcps1.1.6.1.4 "><p id="p891110255019"><a name="p891110255019"></a><a name="p891110255019"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="42.21%" headers="mcps1.1.6.1.5 "><p id="p1391113214504"><a name="p1391113214504"></a><a name="p1391113214504"></a>Width.</p>
    </td>
    </tr>
    <tr id="row179124219504"><td class="cellrowborder" valign="top" width="16.11%" headers="mcps1.1.6.1.1 "><p id="p691117214500"><a name="p691117214500"></a><a name="p691117214500"></a>height</p>
    </td>
    <td class="cellrowborder" valign="top" width="14.01%" headers="mcps1.1.6.1.2 "><p id="p391111265011"><a name="p391111265011"></a><a name="p391111265011"></a>Length</p>
    </td>
    <td class="cellrowborder" valign="top" width="14.499999999999998%" headers="mcps1.1.6.1.3 "><p id="p17911182135014"><a name="p17911182135014"></a><a name="p17911182135014"></a>Yes</p>
    </td>
    <td class="cellrowborder" valign="top" width="13.170000000000002%" headers="mcps1.1.6.1.4 "><p id="p109114295014"><a name="p109114295014"></a><a name="p109114295014"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="42.21%" headers="mcps1.1.6.1.5 "><p id="p1891232165015"><a name="p1891232165015"></a><a name="p1891232165015"></a>Height.</p>
    </td>
    </tr>
    </tbody>
    </table>


## Attributes<a name="section2072419166493"></a>

<a name="table108951213183716"></a>
<table><thead align="left"><tr id="row14933131313373"><th class="cellrowborder" valign="top" width="20%" id="mcps1.1.6.1.1"><p id="p209331313163716"><a name="p209331313163716"></a><a name="p209331313163716"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="15.02%" id="mcps1.1.6.1.2"><p id="p3933113133719"><a name="p3933113133719"></a><a name="p3933113133719"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="11.39%" id="mcps1.1.6.1.3"><p id="p59331113113710"><a name="p59331113113710"></a><a name="p59331113113710"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="12.709999999999999%" id="mcps1.1.6.1.4"><p id="p1793351316378"><a name="p1793351316378"></a><a name="p1793351316378"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="40.88%" id="mcps1.1.6.1.5"><p id="p293311323720"><a name="p293311323720"></a><a name="p293311323720"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2093341312372"><td class="cellrowborder" valign="top" width="20%" headers="mcps1.1.6.1.1 "><p id="p9933313103716"><a name="p9933313103716"></a><a name="p9933313103716"></a>width</p>
</td>
<td class="cellrowborder" valign="top" width="15.02%" headers="mcps1.1.6.1.2 "><p id="p393381311371"><a name="p393381311371"></a><a name="p393381311371"></a>Length</p>
</td>
<td class="cellrowborder" valign="top" width="11.39%" headers="mcps1.1.6.1.3 "><p id="p3933171313373"><a name="p3933171313373"></a><a name="p3933171313373"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="12.709999999999999%" headers="mcps1.1.6.1.4 "><p id="p1393311138378"><a name="p1393311138378"></a><a name="p1393311138378"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.88%" headers="mcps1.1.6.1.5 "><p id="p1693311133379"><a name="p1693311133379"></a><a name="p1693311133379"></a>Width of the rectangle where the polygon is located.</p>
</td>
</tr>
<tr id="row593341313711"><td class="cellrowborder" valign="top" width="20%" headers="mcps1.1.6.1.1 "><p id="p3933181319375"><a name="p3933181319375"></a><a name="p3933181319375"></a>height</p>
</td>
<td class="cellrowborder" valign="top" width="15.02%" headers="mcps1.1.6.1.2 "><p id="p89335131376"><a name="p89335131376"></a><a name="p89335131376"></a>Length</p>
</td>
<td class="cellrowborder" valign="top" width="11.39%" headers="mcps1.1.6.1.3 "><p id="p293321319376"><a name="p293321319376"></a><a name="p293321319376"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="12.709999999999999%" headers="mcps1.1.6.1.4 "><p id="p1493361313374"><a name="p1493361313374"></a><a name="p1493361313374"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.88%" headers="mcps1.1.6.1.5 "><p id="p1933161363710"><a name="p1933161363710"></a><a name="p1933161363710"></a>Height of the rectangle where the polygon is located.</p>
</td>
</tr>
<tr id="row6933151313374"><td class="cellrowborder" valign="top" width="20%" headers="mcps1.1.6.1.1 "><p id="p193371323713"><a name="p193371323713"></a><a name="p193371323713"></a>points</p>
</td>
<td class="cellrowborder" valign="top" width="15.02%" headers="mcps1.1.6.1.2 "><p id="p109331113103719"><a name="p109331113103719"></a><a name="p109331113103719"></a>Array&lt;Point&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.39%" headers="mcps1.1.6.1.3 "><p id="p99331613193715"><a name="p99331613193715"></a><a name="p99331613193715"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="12.709999999999999%" headers="mcps1.1.6.1.4 "><p id="p6933171316376"><a name="p6933171316376"></a><a name="p6933171316376"></a>Yes</p>
</td>
<td class="cellrowborder" valign="top" width="40.88%" headers="mcps1.1.6.1.5 "><p id="p10933161311378"><a name="p10933161311378"></a><a name="p10933161311378"></a>Vertex coordinates of the polygon.</p>
</td>
</tr>
</tbody>
</table>

## Example<a name="section4459736105512"></a>

```
@Entry
@Component
struct PolygonExample {
  build() {
    Column({ space: 5 }) {
      Flex({ justifyContent: FlexAlign.SpaceAround }) {
        // Draw a triangle in a 100 x 100 rectangle. The start point is (0, 0), the end point is (100, 0), and the passing point is (50, 100).
        Polygon({ width: 100, height: 100 }).points([[0, 0], [50, 100], [100, 0]])
        // Draw a quadrilateral in a 100 x 100 rectangle. The start point is (0, 0), the end point is (100, 0), and the passing point is (100, 100).
        Polygon().width(100).height(100).points([[0, 0], [0, 100], [100, 100], [100, 0]])
        // Draw a pentagon in a 100 x 100 rectangle. The start point is (50, 0), the end point is (100, 50), and the passing points are (0, 50), (20, 100), and (80, 100).
        Polygon().width(100).height(100).points([[50, 0], [0, 50], [20, 100], [80, 100], [100, 50]])
      }.width('100%')
    }.margin({ top: 5 })
  }
}
```

![](figures/polygon.gif)

