# Divider<a name="EN-US_TOPIC_0000001111421406"></a>

The  **<Divider\>**  component is used to separate content blocks and content elements.

## Required Permissions<a name="section781125411508"></a>

None

## Child Components<a name="section171053164519"></a>

None

## APIs<a name="section314622835214"></a>

Divider\(\)

## Attributes<a name="section065712415316"></a>

<a name="table1166mcpsimp"></a>
<table><thead align="left"><tr id="row1173mcpsimp"><th class="cellrowborder" valign="top" width="14.540000000000001%" id="mcps1.1.5.1.1"><p id="p1175mcpsimp"><a name="p1175mcpsimp"></a><a name="p1175mcpsimp"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="14.82%" id="mcps1.1.5.1.2"><p id="p1177mcpsimp"><a name="p1177mcpsimp"></a><a name="p1177mcpsimp"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="9.64%" id="mcps1.1.5.1.3"><p id="p1179mcpsimp"><a name="p1179mcpsimp"></a><a name="p1179mcpsimp"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="61%" id="mcps1.1.5.1.4"><p id="p1181mcpsimp"><a name="p1181mcpsimp"></a><a name="p1181mcpsimp"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1182mcpsimp"><td class="cellrowborder" valign="top" width="14.540000000000001%" headers="mcps1.1.5.1.1 "><p id="p1184mcpsimp"><a name="p1184mcpsimp"></a><a name="p1184mcpsimp"></a>vertical</p>
</td>
<td class="cellrowborder" valign="top" width="14.82%" headers="mcps1.1.5.1.2 "><p id="p1186mcpsimp"><a name="p1186mcpsimp"></a><a name="p1186mcpsimp"></a>boolean</p>
</td>
<td class="cellrowborder" valign="top" width="9.64%" headers="mcps1.1.5.1.3 "><p id="p1188mcpsimp"><a name="p1188mcpsimp"></a><a name="p1188mcpsimp"></a>false</p>
</td>
<td class="cellrowborder" valign="top" width="61%" headers="mcps1.1.5.1.4 "><p id="p1190mcpsimp"><a name="p1190mcpsimp"></a><a name="p1190mcpsimp"></a>Whether a vertical divider is used. The value <strong id="b1119922554315"><a name="b1119922554315"></a><a name="b1119922554315"></a>true</strong> means that a vertical divider is used, and <strong id="b179503434318"><a name="b179503434318"></a><a name="b179503434318"></a>false</strong> means that a horizontal divider is used.</p>
</td>
</tr>
<tr id="row1191mcpsimp"><td class="cellrowborder" valign="top" width="14.540000000000001%" headers="mcps1.1.5.1.1 "><p id="p1193mcpsimp"><a name="p1193mcpsimp"></a><a name="p1193mcpsimp"></a>color</p>
</td>
<td class="cellrowborder" valign="top" width="14.82%" headers="mcps1.1.5.1.2 "><p id="p1195mcpsimp"><a name="p1195mcpsimp"></a><a name="p1195mcpsimp"></a>Color</p>
</td>
<td class="cellrowborder" valign="top" width="9.64%" headers="mcps1.1.5.1.3 "><p id="p1197mcpsimp"><a name="p1197mcpsimp"></a><a name="p1197mcpsimp"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="61%" headers="mcps1.1.5.1.4 "><p id="p1199mcpsimp"><a name="p1199mcpsimp"></a><a name="p1199mcpsimp"></a>Color of the divider.</p>
</td>
</tr>
<tr id="row1200mcpsimp"><td class="cellrowborder" valign="top" width="14.540000000000001%" headers="mcps1.1.5.1.1 "><p id="p1202mcpsimp"><a name="p1202mcpsimp"></a><a name="p1202mcpsimp"></a>strokeWidth</p>
</td>
<td class="cellrowborder" valign="top" width="14.82%" headers="mcps1.1.5.1.2 "><p id="p1204mcpsimp"><a name="p1204mcpsimp"></a><a name="p1204mcpsimp"></a>Length</p>
</td>
<td class="cellrowborder" valign="top" width="9.64%" headers="mcps1.1.5.1.3 "><p id="p1206mcpsimp"><a name="p1206mcpsimp"></a><a name="p1206mcpsimp"></a>1</p>
</td>
<td class="cellrowborder" valign="top" width="61%" headers="mcps1.1.5.1.4 "><p id="p1208mcpsimp"><a name="p1208mcpsimp"></a><a name="p1208mcpsimp"></a>Width of the divider.</p>
</td>
</tr>
<tr id="row1209mcpsimp"><td class="cellrowborder" valign="top" width="14.540000000000001%" headers="mcps1.1.5.1.1 "><p id="p1211mcpsimp"><a name="p1211mcpsimp"></a><a name="p1211mcpsimp"></a>lineCap</p>
</td>
<td class="cellrowborder" valign="top" width="14.82%" headers="mcps1.1.5.1.2 "><p id="p1213mcpsimp"><a name="p1213mcpsimp"></a><a name="p1213mcpsimp"></a><a href="ts-appendix-enums.md#section549694781614">LineCapStyle</a></p>
</td>
<td class="cellrowborder" valign="top" width="9.64%" headers="mcps1.1.5.1.3 "><p id="p1215mcpsimp"><a name="p1215mcpsimp"></a><a name="p1215mcpsimp"></a>Butt</p>
</td>
<td class="cellrowborder" valign="top" width="61%" headers="mcps1.1.5.1.4 "><p id="p1217mcpsimp"><a name="p1217mcpsimp"></a><a name="p1217mcpsimp"></a>Cap style of the divider. The default value is <strong id="b2497816144410"><a name="b2497816144410"></a><a name="b2497816144410"></a>Butt</strong>.</p>
</td>
</tr>
</tbody>
</table>

## Events<a name="section8567175225417"></a>

Universal events are not supported.

## Example<a name="section18551123820541"></a>

```
@Entry
@Component
struct DividerExample {
  build() {
    Flex({ direction: FlexDirection.Column, alignItems: ItemAlign.Start, justifyContent: FlexAlign.SpaceBetween }) {
      Text('Horizontal divider').fontSize(9).fontColor(0xCCCCCC)
      Row().width('100%').height(40).backgroundColor(0xF1F3F5)
      Divider()
      Row().width('100%').height(40).backgroundColor(0xF1F3F5)

      Text('Vertical divider').fontSize(9).fontColor(0xCCCCCC)
      Flex({ alignItems: ItemAlign.Center, wrap: FlexWrap.Wrap }) {
        Text('bravery')
        Divider().vertical(true).margin(20).height(15)
        Text('effort')
        Divider().vertical(true).margin(20).height(15)
        Text('upward')
      }.width(250)

      Text('Custom Styles').fontSize(9).fontColor(0xCCCCCC)
      Row().width('100%').height(40).backgroundColor(0xF1F3F5)
      Divider().vertical(false).strokeWidth(5).color(0x2788D9).lineCap(LineCapStyle.Round)
      Row().width('100%').height(40).backgroundColor(0xF1F3F5)
    }.width('100%').height(350).padding({ left: 35, right: 35, top: 35 })
  }
}
```

![](figures/divider.png)

