# TypeScript-based Declarative Development Paradigm

-   [Framework Overview](ts-framework-framework.md)
    -   [File Organization](ts-framework-file.md)
        -   [Directory Structure](ts-framework-directory.md)
        -   [Rules for Accessing Application Code Files](ts-framework-file-access-rules.md)

    -   ["js" Tag](ts-framework-js-tag.md)
    -   [Resource Access](ts-resource-access.md)
        -   [Media Resource Types](ts-media-resource-type.md)

    -   [Pixel Units](ts-pixel-units.md)
    -   [Types](ts-types.md)

-   [Declarative Syntax](ts-declarative-syntax.md)
    -   [Overview](ts-syntax-intro.md)
    -   [General UI Description Specifications](ts-general-ui-description-specifications.md)
        -   [Basic Concepts](ts-general-ui-concepts.md)
        -   [Declarative UI Description Specifications](ts-declarative-ui-description-specifications.md)
            -   [Parameterless Configuration](ts-parameterless-configuration.md)
            -   [Configuration with Mandatory Parameters](ts-configuration-with-mandatory-parameters.md)
            -   [Attribution Configuration](ts-attribution-configuration.md)
            -   [Event Configuration](ts-event-configuration.md)
            -   [Child Component Configuration](ts-child-component-configuration.md)

        -   [Component-based](ts-component-based.md)
            -   [@Component](ts-component-based-component.md)
            -   [@Entry](ts-component-based-entry.md)
            -   [@Preview](ts-component-based-preview.md)
            -   [@Builder](ts-component-based-builder.md)
            -   [@Extend](ts-component-based-extend.md)
            -   [@CustomDialog](ts-component-based-customdialog.md)

    -   [UI State Management](ts-ui-state-management.md)
        -   [Basic Concepts](ts-ui-state-mgmt-concepts.md)
        -   [Managing Component States](ts-managing-component-states.md)
            -   [@State](ts-component-states-state.md)
            -   [@Prop](ts-component-states-prop.md)
            -   [@Link](ts-component-states-link.md)

        -   [Managing Application States](ts-managing-application-states.md)
            -   [APIs](ts-managing-application-states-apis.md)
                -   [AppStorage](ts-application-states-appstorage.md)
                -   [PersistentStorage](ts-application-states-apis-persistentstorage.md)
                -   [Environment](ts-application-states-apis-environment.md)

            -   [Synchronization Between AppStorage and Components](ts-application-states-storagelink-storageprop.md)

        -   [Managing Other States](ts-managing-other-states.md)
            -   [@observed and @objectLink](ts-other-states-observed-objectlink.md)
            -   [@Consume and @Provide](ts-other-states-consume-provide.md)
            -   [@Watch](ts-other-states-watch.md)

    -   [Rendering Control Syntax](ts-rending-control-syntax.md)
        -   [if/else](ts-rending-control-syntax-if-else.md)
        -   [ForEach](ts-rending-control-syntax-foreach.md)
        -   [LazyForEach](ts-rending-control-syntax-lazyforeach.md)

    -   [A Deep Dive into @Component](ts-a-deep-dive-into-component.md)
        -   [build Function](ts-function-build.md)
        -   [Custom Component Initialization](ts-custom-component-initialization.md)
        -   [Custom Component Lifecycle Callbacks](ts-custom-component-lifecycle-callbacks.md)
        -   [Example: Component Creation and Re-Initialization](ts-component-creation-re-initialization.md)

    -   [Syntactic Sugar](ts-syntactic-sugar.md)
        -   [@Decorator](ts-syntactic-sugar-decorator.md)
        -   [Chaining](ts-syntactic-sugar-chaining.md)
        -   [struct](ts-syntactic-sugar-struct.md)
        -   [Instantiating a struct Without the new Keyword](ts-instantiating-a-struct-without-new-keyword.md)
        -   [Using a Separate Line for New Component](ts-using-a-separate-line-for-new-component.md)
        -   [Restrictions on Using the TS Language for Generators](ts-restrictions-for-generators.md)

-   [Components](ts-components.md)
    -   [Universal Components](ts-universal-components.md)
        -   [Universal Events](ts-universal-events.md)
            -   [Click Event](ts-universal-events-click.md)
            -   [Touch Event](ts-universal-events-touch.md)
            -   [Show/Hide Event](ts-universal-events-show-hide.md)
            -   [Key Event](ts-universal-events-key.md)

        -   [Universal Attributes](ts-universal-attributes.md)
            -   [Size](ts-universal-attributes-size.md)
            -   [Location](ts-universal-attributes-location.md)
            -   [Layout Constraints](ts-universal-attributes-layout-constraints.md)
            -   [Flex Layout](ts-universal-attributes-flex-layout.md)
            -   [Border Configuration](ts-universal-attributes-border.md)
            -   [Background](ts-universal-attributes-background.md)
            -   [Opacity](ts-universal-attributes-opacity.md)
            -   [Visibility](ts-universal-attributes-visibility.md)
            -   [Enable/Disable](ts-universal-attributes-enable.md)
            -   [Overlay](ts-universal-attributes-overlay.md)
            -   [Z-order Control](ts-universal-attributes-z-order.md)
            -   [Transformation](ts-universal-attributes-transformation.md)
            -   [Image Effect Configuration](ts-universal-attributes-image-effect.md)
            -   [Shape Clipping](ts-universal-attributes-sharp-clipping.md)
            -   [Text Style](ts-universal-attributes-text-style.md)
            -   [Grid](ts-universal-attributes-grid.md)
            -   [Gradient Color](ts-universal-attributes-gradient-color.md)
            -   [Popup Control](ts-universal-attributes-popup.md)
            -   [Menu Control](ts-universal-attributes-menu.md)

        -   [Gesture Processing](ts-gesture-processing.md)
            -   [Gesture Binding Methods](ts-gesture-settings.md)
            -   [Basic Gestures](ts-basic-gestures.md)
                -   [TapGesture](ts-basic-gestures-tapgesture.md)
                -   [LongPressGesture](ts-basic-gestures-longpressgesture.md)
                -   [PanGesture](ts-basic-gestures-pangesture.md)
                -   [PinchGesture](ts-basic-gestures-pinchgesture.md)
                -   [RotationGesture](ts-basic-gestures-rotationgesture.md)

            -   [Combined Gestures](ts-combined-gestures.md)

    -   [Basic Components](ts-basic-components.md)
        -   [Blank](ts-basic-components-blank.md)
        -   [Button](ts-basic-components-button.md)
        -   [DataPanel](ts-basic-components-datapanel.md)
        -   [Divider](ts-basic-components-divider.md)
        -   [Image](ts-basic-components-image.md)
        -   [ImageAnimator](ts-basic-components-imageanimator.md)
        -   [Progress](ts-basic-components-progress.md)
        -   [QRCode](ts-basic-components-qrcode.md)
        -   [Rating](ts-basic-components-rating.md)
        -   [Span](ts-basic-components-span.md)
        -   [Slider](ts-basic-components-slider.md)
        -   [Text](ts-basic-components-text.md)

    -   [Container Components](ts-components-container.md)
        -   [AlphabetIndexer](ts-container-alphabet-indexer.md)
        -   [Badge](ts-container-badge.md)
        -   [Column](ts-container-column.md)
        -   [ColumnSplit](ts-container-columnsplit.md)
        -   [Counter](ts-container-counter.md)
        -   [Flex](ts-container-flex.md)
        -   [GridContainer](ts-container-gridcontainer.md)
        -   [Grid](ts-container-grid.md)
        -   [GridItem](ts-container-griditem.md)
        -   [List](ts-container-list.md)
        -   [ListItem](ts-container-listitem.md)
        -   [Navigator](ts-container-navigator.md)
        -   [Panel](ts-container-panel.md)
        -   [Row](ts-container-row.md)
        -   [RowSplit](ts-container-rowsplit.md)
        -   [Scroll](ts-container-scroll.md)
        -   [Stack](ts-container-stack.md)
        -   [Swiper](ts-container-swiper.md)
        -   [Tabs](ts-container-tabs.md)
        -   [TabContent](ts-container-tabcontent.md)

    -   [Drawing Components](ts-drawing-components.md)
        -   [Circle](ts-drawing-components-circle.md)
        -   [Ellipse](ts-drawing-components-ellipse.md)
        -   [Line](ts-drawing-components-line.md)
        -   [Polyline](ts-drawing-components-polyline.md)
        -   [Polygon](ts-drawing-components-polygon.md)
        -   [Path](ts-drawing-components-path.md)
        -   [Rect](ts-drawing-components-rect.md)
        -   [Shape](ts-drawing-components-shape.md)

-   [Animation](ts-animation.md)
    -   [AnimatorProperty](ts-animatorproperty.md)
    -   [Explicit Animation](ts-explicit-animation.md)
    -   [Transition Animation](ts-transition-animation.md)
        -   [Page Transition](ts-page-transition-animation.md)
        -   [Component Transition](ts-transition-animation-component.md)
        -   [Transition of Shared Elements](ts-transition-animation-shared-elements.md)

    -   [Motion Path Animation](ts-motion-path-animation.md)
    -   [Matrix Transformation](ts-matrix-transformation.md)
    -   [Interpolation Calculation](ts-interpolation-calculation.md)

-   [Global UI Methods](ts-global-ui-methods.md)
    -   [Alert Dialog Box](ts-methods-alert-dialog-box.md)
    -   [Custom Dialog box](ts-methods-custom-dialog-box.md)
    -   [Image Cache](ts-methods-image-cache.md)
    -   [Media Query](ts-methods-media-query.md)

-   [Appendix](ts-appendix.md)
    -   [Built-in Enums](ts-appendix-enums.md)

