# "js" Tag<a name="EN-US_TOPIC_0000001173324643"></a>

The "js" tag contains the instance name, window style, and page route information.

<a name="t092f7d78cacb46d583b3499e7cf3e7f2"></a>
<table><thead align="left"><tr id="r8ff2bb3ff6c84115be187bad81bb8dce"><th class="cellrowborder" valign="top" width="25%" id="mcps1.1.6.1.1"><p id="a16a1bbba39d7414b8e77ae9bcf230b7b"><a name="a16a1bbba39d7414b8e77ae9bcf230b7b"></a><a name="a16a1bbba39d7414b8e77ae9bcf230b7b"></a>Tag</p>
</th>
<th class="cellrowborder" valign="top" width="12%" id="mcps1.1.6.1.2"><p id="a1fdbf4e9a38840029b6eb94a7f89b29a"><a name="a1fdbf4e9a38840029b6eb94a7f89b29a"></a><a name="a1fdbf4e9a38840029b6eb94a7f89b29a"></a>Data Type</p>
</th>
<th class="cellrowborder" valign="top" width="12%" id="mcps1.1.6.1.3"><p id="a07bcb8a8bbea4e8d9c60b8a4b1031970"><a name="a07bcb8a8bbea4e8d9c60b8a4b1031970"></a><a name="a07bcb8a8bbea4e8d9c60b8a4b1031970"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="9%" id="mcps1.1.6.1.4"><p id="a39b2ea2535e04e37a418e8374f3271e4"><a name="a39b2ea2535e04e37a418e8374f3271e4"></a><a name="a39b2ea2535e04e37a418e8374f3271e4"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="42%" id="mcps1.1.6.1.5"><p id="ae9e9127cfa374d18a3741f4247791acf"><a name="ae9e9127cfa374d18a3741f4247791acf"></a><a name="ae9e9127cfa374d18a3741f4247791acf"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row19493102613510"><td class="cellrowborder" valign="top" width="25%" headers="mcps1.1.6.1.1 "><p id="p6494172618357"><a name="p6494172618357"></a><a name="p6494172618357"></a>name</p>
</td>
<td class="cellrowborder" valign="top" width="12%" headers="mcps1.1.6.1.2 "><p id="p1449472643513"><a name="p1449472643513"></a><a name="p1449472643513"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="12%" headers="mcps1.1.6.1.3 "><p id="p1749412619355"><a name="p1749412619355"></a><a name="p1749412619355"></a>default</p>
</td>
<td class="cellrowborder" valign="top" width="9%" headers="mcps1.1.6.1.4 "><p id="p64947262359"><a name="p64947262359"></a><a name="p64947262359"></a>Yes</p>
</td>
<td class="cellrowborder" valign="top" width="42%" headers="mcps1.1.6.1.5 "><p id="p8494122612352"><a name="p8494122612352"></a><a name="p8494122612352"></a>Name of the JavaScript instance.</p>
</td>
</tr>
<tr id="r3d05cd5e24f14308a71d21d2d01adb81"><td class="cellrowborder" valign="top" width="25%" headers="mcps1.1.6.1.1 "><p id="a5a33cd31feb7416ab1ee44a6b863e57d"><a name="a5a33cd31feb7416ab1ee44a6b863e57d"></a><a name="a5a33cd31feb7416ab1ee44a6b863e57d"></a>pages</p>
</td>
<td class="cellrowborder" valign="top" width="12%" headers="mcps1.1.6.1.2 "><p id="a90233739ef8a4977ba0a9a48282d324d"><a name="a90233739ef8a4977ba0a9a48282d324d"></a><a name="a90233739ef8a4977ba0a9a48282d324d"></a>Array</p>
</td>
<td class="cellrowborder" valign="top" width="12%" headers="mcps1.1.6.1.3 "><p id="aaa1317b02aef4aee98e42227902ac7e5"><a name="aaa1317b02aef4aee98e42227902ac7e5"></a><a name="aaa1317b02aef4aee98e42227902ac7e5"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="9%" headers="mcps1.1.6.1.4 "><p id="a225959a4c42f44f4ad25fac5f48f34f5"><a name="a225959a4c42f44f4ad25fac5f48f34f5"></a><a name="a225959a4c42f44f4ad25fac5f48f34f5"></a>Yes</p>
</td>
<td class="cellrowborder" valign="top" width="42%" headers="mcps1.1.6.1.5 "><p id="a5f03a4f4a1fd461b9e4bc025569fcb2d"><a name="a5f03a4f4a1fd461b9e4bc025569fcb2d"></a><a name="a5f03a4f4a1fd461b9e4bc025569fcb2d"></a>Route information. For details, see <a href="#section3239252133513">"pages"</a>.</p>
</td>
</tr>
<tr id="row12517192619239"><td class="cellrowborder" valign="top" width="25%" headers="mcps1.1.6.1.1 "><p id="p18517172622317"><a name="p18517172622317"></a><a name="p18517172622317"></a>window</p>
</td>
<td class="cellrowborder" valign="top" width="12%" headers="mcps1.1.6.1.2 "><p id="p15517626112313"><a name="p15517626112313"></a><a name="p15517626112313"></a>Object</p>
</td>
<td class="cellrowborder" valign="top" width="12%" headers="mcps1.1.6.1.3 "><p id="p3517112615234"><a name="p3517112615234"></a><a name="p3517112615234"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="9%" headers="mcps1.1.6.1.4 "><p id="p1451782692314"><a name="p1451782692314"></a><a name="p1451782692314"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="42%" headers="mcps1.1.6.1.5 "><p id="p1517326152317"><a name="p1517326152317"></a><a name="p1517326152317"></a>Window information. For details, see <a href="#section728811177376">"window"</a>.</p>
</td>
</tr>
</tbody>
</table>

>![](../../public_sys-resources/icon-note.gif) **NOTE:** 
>The  **"name"**, "window", and  **"pages"**  tags are configured in the  **"js"**  tag of the  config.json  file.

## "pages"<a name="section3239252133513"></a>

The  **"pages"**  defines the route information of each page. Each page consists of the page path and page name. The following is an example:

```
{
    ...
    "pages": [
        "pages/index/index",
        "pages/detail/detail"
    ]
    ...
}
```

>![](../../public_sys-resources/icon-note.gif) **NOTE:** 
>-   The first page in the  **pages**  list is the home page, also referred to as the entry, of the application.
>-   The page name should not be a component name, for example,  **text.hml**  or  **button.hml**.

## window<a name="section728811177376"></a>

The  **"window"**  defines window-related configurations. To solve the screen adaptation problem, you can use either of the following methods:

-   Specify  **designWidth**, which is the logical screen width. All size styles, such as  **width**  and  **font-size**, are scaled at the ratio of  **designWidth**  to the physical screen width. For example, when  **designWidth**  is 720 px and if you set  **width**  to 100 px, the actual display width is scaled to 200 physical px on the screen whose physical width is 1440 px.
-   Set  **autoDesignWidth**  to  **true**, the  **designWidth**  field will be ignored, and the component and layout will be scaled automatically based on the screen density. The logical screen width is automatically calculated based on the physical screen width and screen density. The logical screen width may vary depending on the device. Use the relative layout to adapt to different devices. For example, on a device with a resolution of 466x466 and 320 DPI \(a screen density of 2x, with 160 DPI as the base\), 1 px is equivalent to 2 physical px.

    >![](../../public_sys-resources/icon-note.gif) **NOTE:** 
    >1. The default  **<length\>**  value in the current style is calculated based on the screen density. For example, if the screen density is x2 \(with 160 DPI as the baseline\) and the default  **<length\>**  value is 1 px, the actual length rendered on the device is 2 physical px.
    >2. Values of  **autoDesignWidth**  and  **designWidth**  do not affect how the default  **<length\>**  value is calculated and the final effect.


<a name="table4231104116370"></a>
<table><thead align="left"><tr id="row17231541183714"><th class="cellrowborder" valign="top" width="16.28837116288371%" id="mcps1.1.6.1.1"><p id="p1723112411376"><a name="p1723112411376"></a><a name="p1723112411376"></a>Attribute</p>
</th>
<th class="cellrowborder" valign="top" width="11.678832116788321%" id="mcps1.1.6.1.2"><p id="p12313414371"><a name="p12313414371"></a><a name="p12313414371"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="10.63893610638936%" id="mcps1.1.6.1.3"><p id="p1323118413374"><a name="p1323118413374"></a><a name="p1323118413374"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="6.969303069693031%" id="mcps1.1.6.1.4"><p id="p2423537113218"><a name="p2423537113218"></a><a name="p2423537113218"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="54.42455754424558%" id="mcps1.1.6.1.5"><p id="p17231124163710"><a name="p17231124163710"></a><a name="p17231124163710"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1423174133715"><td class="cellrowborder" valign="top" width="16.28837116288371%" headers="mcps1.1.6.1.1 "><p id="p1923284111373"><a name="p1923284111373"></a><a name="p1923284111373"></a>designWidth</p>
</td>
<td class="cellrowborder" valign="top" width="11.678832116788321%" headers="mcps1.1.6.1.2 "><p id="p1023219418372"><a name="p1023219418372"></a><a name="p1023219418372"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="10.63893610638936%" headers="mcps1.1.6.1.3 "><p id="p023217410379"><a name="p023217410379"></a><a name="p023217410379"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="6.969303069693031%" headers="mcps1.1.6.1.4 "><p id="p15424137103212"><a name="p15424137103212"></a><a name="p15424137103212"></a>720</p>
</td>
<td class="cellrowborder" valign="top" width="54.42455754424558%" headers="mcps1.1.6.1.5 "><p id="p1232174173717"><a name="p1232174173717"></a><a name="p1232174173717"></a>Logical screen width, which is a reference value for page design. The actual display width is scaled at the ratio of the value to the device width.</p>
</td>
</tr>
<tr id="row78924466220"><td class="cellrowborder" valign="top" width="16.28837116288371%" headers="mcps1.1.6.1.1 "><p id="p1289216461925"><a name="p1289216461925"></a><a name="p1289216461925"></a>autoDesignWidth</p>
</td>
<td class="cellrowborder" valign="top" width="11.678832116788321%" headers="mcps1.1.6.1.2 "><p id="p1489220466214"><a name="p1489220466214"></a><a name="p1489220466214"></a>boolean</p>
</td>
<td class="cellrowborder" valign="top" width="10.63893610638936%" headers="mcps1.1.6.1.3 "><p id="p10892184612218"><a name="p10892184612218"></a><a name="p10892184612218"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="6.969303069693031%" headers="mcps1.1.6.1.4 "><p id="p10424237183218"><a name="p10424237183218"></a><a name="p10424237183218"></a>false</p>
</td>
<td class="cellrowborder" valign="top" width="54.42455754424558%" headers="mcps1.1.6.1.5 "><p id="p198921746524"><a name="p198921746524"></a><a name="p198921746524"></a>Whether to automatically calculate the baseline width. If <strong id="b14176155215510"><a name="b14176155215510"></a><a name="b14176155215510"></a>autoDesignWidth</strong> is set to <strong id="b68529554517"><a name="b68529554517"></a><a name="b68529554517"></a>true</strong>, <strong id="b1690031366"><a name="b1690031366"></a><a name="b1690031366"></a>designWidth</strong> is ignored. The baseline width is calculated based on the physical screen width and screen density.</p>
</td>
</tr>
</tbody>
</table>

The following is a sample code snippet:

```
{
    ...
    "window": {
        "designWidth": 720,
        "autoDesignWidth": false
    }
    ...
}
```

## Example<a name="section19421142983812"></a>

```
{
  "app": {
    "bundleName": "com.huawei.player",
    "version": {
        "code": 1,
        "name": "1.0"
    },
    "vendor": "example"
  }
  "module": {
      ...
      "js": [
      {
          "name": "default",
          "pages": [
              "pages/index/index",
              "pages/detail/detail"
          ],
          "window": {
              "designWidth": 720,
              "autoDesignWidth": false
          }
      }
      ],
      "abilities": [
      {
          ...
      }
    ]
  }
}
```

