# animate<a name="EN-US_TOPIC_0000001127125042"></a>

The  **<animate\>**  component is used to apply animation to an  **<svg\>**  component.

>![](../../public_sys-resources/icon-note.gif) **NOTE:** 
>The APIs of this module are supported since API version 7.

## Permission List<a name="section11257113618419"></a>

None

## Child Components<a name="section9288143101012"></a>

Not supported

## Attributes<a name="section2907183951110"></a>

<a name="table20633101642315"></a>
<table><thead align="left"><tr id="row663331618238"><th class="cellrowborder" valign="top" width="23.119999999999997%" id="mcps1.1.6.1.1"><p id="aaf1247770b244944bbcc9f28d9a6f00b"><a name="aaf1247770b244944bbcc9f28d9a6f00b"></a><a name="aaf1247770b244944bbcc9f28d9a6f00b"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="23.119999999999997%" id="mcps1.1.6.1.2"><p id="a6efc3502761f4faf9630e484280f75b6"><a name="a6efc3502761f4faf9630e484280f75b6"></a><a name="a6efc3502761f4faf9630e484280f75b6"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="10.48%" id="mcps1.1.6.1.3"><p id="a27a37273d9ad47569ddbcb8db985d302"><a name="a27a37273d9ad47569ddbcb8db985d302"></a><a name="a27a37273d9ad47569ddbcb8db985d302"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="7.5200000000000005%" id="mcps1.1.6.1.4"><p id="p824610360217"><a name="p824610360217"></a><a name="p824610360217"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="35.76%" id="mcps1.1.6.1.5"><p id="a2ff3361bfd3b420ba4967452d2ddd098"><a name="a2ff3361bfd3b420ba4967452d2ddd098"></a><a name="a2ff3361bfd3b420ba4967452d2ddd098"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row36332165231"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="a83b6dd280109466fb015e64de1ef4df3"><a name="a83b6dd280109466fb015e64de1ef4df3"></a><a name="a83b6dd280109466fb015e64de1ef4df3"></a>id</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="abc38fa2b85854bc687af75eb17a00a4d"><a name="abc38fa2b85854bc687af75eb17a00a4d"></a><a name="abc38fa2b85854bc687af75eb17a00a4d"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="a8d12e4af905d4743a5ec9cd6018d2972"><a name="a8d12e4af905d4743a5ec9cd6018d2972"></a><a name="a8d12e4af905d4743a5ec9cd6018d2972"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p42461736102118"><a name="p42461736102118"></a><a name="p42461736102118"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="a1a1731af05554f119fa365748f276bb2"><a name="a1a1731af05554f119fa365748f276bb2"></a><a name="a1a1731af05554f119fa365748f276bb2"></a>Unique ID of the component.</p>
</td>
</tr>
<tr id="row13633131616239"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p135984362214"><a name="p135984362214"></a><a name="p135984362214"></a>attributeName</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p1759753619211"><a name="p1759753619211"></a><a name="p1759753619211"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p7596736122112"><a name="p7596736122112"></a><a name="p7596736122112"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p17246836142119"><a name="p17246836142119"></a><a name="p17246836142119"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="adbe7ecbee96b4f938b04a4b8d62791bf"><a name="adbe7ecbee96b4f938b04a4b8d62791bf"></a><a name="adbe7ecbee96b4f938b04a4b8d62791bf"></a>Name of the component to which the animation is applied.</p>
</td>
</tr>
<tr id="row10634131610230"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p1159543642120"><a name="p1159543642120"></a><a name="p1159543642120"></a>begin</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p6593336132115"><a name="p6593336132115"></a><a name="p6593336132115"></a>&lt;time&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p11592936142117"><a name="p11592936142117"></a><a name="p11592936142117"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p1646316754213"><a name="p1646316754213"></a><a name="p1646316754213"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p10941922464"><a name="p10941922464"></a><a name="p10941922464"></a>Delay time of the animation.</p>
<p id="p1094114216469"><a name="p1094114216469"></a><a name="p1094114216469"></a>The value can be ms (ms), s (second), or m (minute). The default value is s (second). Other formats are not supported.</p>
</td>
</tr>
<tr id="row1634171618236"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p19590123611210"><a name="p19590123611210"></a><a name="p19590123611210"></a>dur</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p17686152762312"><a name="p17686152762312"></a><a name="p17686152762312"></a>&lt;time&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p6589163611217"><a name="p6589163611217"></a><a name="p6589163611217"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p1624612362219"><a name="p1624612362219"></a><a name="p1624612362219"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p1676818505465"><a name="p1676818505465"></a><a name="p1676818505465"></a>Animation duration. If <strong id="b1544660203114"><a name="b1544660203114"></a><a name="b1544660203114"></a>dur</strong> is not set, the value of <strong id="b136951589311"><a name="b136951589311"></a><a name="b136951589311"></a>end</strong>-<strong id="b1444821113311"><a name="b1444821113311"></a><a name="b1444821113311"></a>begin</strong> is used as the duration. If the value is less than or equal to 0, the animation is not triggered.</p>
<p id="p18768125018462"><a name="p18768125018462"></a><a name="p18768125018462"></a>The value can be ms (ms), s (second), or m (minute). The default value is s (second). Other formats are not supported.</p>
</td>
</tr>
<tr id="row1259531661611"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p1758863619218"><a name="p1758863619218"></a><a name="p1758863619218"></a>end</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p3587173632114"><a name="p3587173632114"></a><a name="p3587173632114"></a>&lt;time&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p115867360215"><a name="p115867360215"></a><a name="p115867360215"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p1059610169169"><a name="p1059610169169"></a><a name="p1059610169169"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p759484922319"><a name="p759484922319"></a><a name="p759484922319"></a>Duration after which the animation ends. The value can be ms (ms), s (second), or m (minute). The default value is s (second). Other formats are not supported.</p>
</td>
</tr>
<tr id="row11404114510176"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p145859363216"><a name="p145859363216"></a><a name="p145859363216"></a>repeatCount</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p1758493620212"><a name="p1758493620212"></a><a name="p1758493620212"></a>&lt;number | indefinite&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p1758315366214"><a name="p1758315366214"></a><a name="p1758315366214"></a>1</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p7893010540"><a name="p7893010540"></a><a name="p7893010540"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p759344911237"><a name="p759344911237"></a><a name="p759344911237"></a>Number of times the animation is played. The default value is indefinite. You can set the value to <strong id="b14918201573219"><a name="b14918201573219"></a><a name="b14918201573219"></a>1</strong> to play the animation only once.</p>
</td>
</tr>
<tr id="row75241175410"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p6582123618212"><a name="p6582123618212"></a><a name="p6582123618212"></a>fill</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p65811136102115"><a name="p65811136102115"></a><a name="p65811136102115"></a>&lt;freeze | remove&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p1155610362211"><a name="p1155610362211"></a><a name="p1155610362211"></a>remove</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p4724145065420"><a name="p4724145065420"></a><a name="p4724145065420"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p557624915236"><a name="p557624915236"></a><a name="p557624915236"></a>State when the animation ends.</p>
</td>
</tr>
<tr id="row158325589294"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p1083214589293"><a name="p1083214589293"></a><a name="p1083214589293"></a>calcMode</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p7832258142920"><a name="p7832258142920"></a><a name="p7832258142920"></a>&lt;discrete | linear | paced | spline&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p12833175812295"><a name="p12833175812295"></a><a name="p12833175812295"></a>linear</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p138331058192911"><a name="p138331058192911"></a><a name="p138331058192911"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p2083395862919"><a name="p2083395862919"></a><a name="p2083395862919"></a>Interpolation mode of the animation.</p>
<p id="p191847533337"><a name="p191847533337"></a><a name="p191847533337"></a><strong id="b8323142113216"><a name="b8323142113216"></a><a name="b8323142113216"></a>discrete</strong>: The value of <strong id="b752455013214"><a name="b752455013214"></a><a name="b752455013214"></a>from</strong> directly jumps to the value of <strong id="b411775643213"><a name="b411775643213"></a><a name="b411775643213"></a>to</strong>.</p>
<p id="p196601957163315"><a name="p196601957163315"></a><a name="p196601957163315"></a><strong id="b97511633317"><a name="b97511633317"></a><a name="b97511633317"></a>linear</strong>: linear.</p>
<p id="p599115247353"><a name="p599115247353"></a><a name="p599115247353"></a><strong id="b125981513183319"><a name="b125981513183319"></a><a name="b125981513183319"></a>paced</strong>: linear. After this value is set, the values of <strong id="b19223130123317"><a name="b19223130123317"></a><a name="b19223130123317"></a>keyTimes</strong> and <strong id="b1386173520336"><a name="b1386173520336"></a><a name="b1386173520336"></a>keyPoints</strong> are invalid.</p>
<p id="p1734674418335"><a name="p1734674418335"></a><a name="p1734674418335"></a><strong id="b136563407338"><a name="b136563407338"></a><a name="b136563407338"></a>spline</strong>: user-defined Bessel curve. The spline point is defined in the <strong id="b3738847163315"><a name="b3738847163315"></a><a name="b3738847163315"></a>keyTimes</strong> attribute, and the control point of each interval is defined by <strong id="b6133175153320"><a name="b6133175153320"></a><a name="b6133175153320"></a>keySplines</strong>.</p>
</td>
</tr>
<tr id="row1021415563011"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p1921455183019"><a name="p1921455183019"></a><a name="p1921455183019"></a>keyTimes</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p102145515309"><a name="p102145515309"></a><a name="p102145515309"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p162141751306"><a name="p162141751306"></a><a name="p162141751306"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p1621485203020"><a name="p1621485203020"></a><a name="p1621485203020"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p621412519306"><a name="p621412519306"></a><a name="p621412519306"></a>Start time of the key frame animation. The value ranges from 0 to 1, separated by semicolons (;), for example, <strong id="b1375915100341"><a name="b1375915100341"></a><a name="b1375915100341"></a>0;0.3;0.8;1</strong>. <strong id="b196691614123412"><a name="b196691614123412"></a><a name="b196691614123412"></a>keyTimes</strong>, <strong id="b388521518349"><a name="b388521518349"></a><a name="b388521518349"></a>keySplines</strong>, and <strong id="b105861120173419"><a name="b105861120173419"></a><a name="b105861120173419"></a>values</strong> are combined to set the key frame animation. The number of <strong id="b11841122810348"><a name="b11841122810348"></a><a name="b11841122810348"></a>keyTimes</strong> is the same as that of <strong id="b8880193063411"><a name="b8880193063411"></a><a name="b8880193063411"></a>values</strong>. The number of <strong id="b114117381341"><a name="b114117381341"></a><a name="b114117381341"></a>keySplines</strong> is the number of <strong id="b695174110345"><a name="b695174110345"></a><a name="b695174110345"></a>keyTimes</strong> minus 1.</p>
</td>
</tr>
<tr id="row18385173510392"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p738623513914"><a name="p738623513914"></a><a name="p738623513914"></a>keySplines</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p143861535123917"><a name="p143861535123917"></a><a name="p143861535123917"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p20386103533910"><a name="p20386103533910"></a><a name="p20386103533910"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p193861235183917"><a name="p193861235183917"></a><a name="p193861235183917"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p5386113518391"><a name="p5386113518391"></a><a name="p5386113518391"></a>A set of Bessel control points associated with <strong id="b37611449153418"><a name="b37611449153418"></a><a name="b37611449153418"></a>keyTimes</strong>. You can define the Bessel curves for each key frame. The curves are separated by semicolons (;). The format of the two controls in the curve is x1 y1 x2 y2. For example, <strong id="b42741357193520"><a name="b42741357193520"></a><a name="b42741357193520"></a>0.5 0 0.5 1; 0.5 0 0.5 1;0.5 0 0.5 1</strong>.</p>
</td>
</tr>
<tr id="row136799388349"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p1472514210595"><a name="p1472514210595"></a><a name="p1472514210595"></a>by</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p272614211599"><a name="p272614211599"></a><a name="p272614211599"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p9726202114595"><a name="p9726202114595"></a><a name="p9726202114595"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p2072682110592"><a name="p2072682110592"></a><a name="p2072682110592"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p772662145916"><a name="p772662145916"></a><a name="p772662145916"></a>Relative offset value to add to a specified attribute in the animation. The default value of <strong id="b1538419278369"><a name="b1538419278369"></a><a name="b1538419278369"></a>from</strong> is the original attribute value.</p>
</td>
</tr>
<tr id="row17371104994019"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p93721649164018"><a name="p93721649164018"></a><a name="p93721649164018"></a>from</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p1437294914015"><a name="p1437294914015"></a><a name="p1437294914015"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p05167580429"><a name="p05167580429"></a><a name="p05167580429"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p205161158184210"><a name="p205161158184210"></a><a name="p205161158184210"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p17372184944016"><a name="p17372184944016"></a><a name="p17372184944016"></a>Start value of the attribute to which the animation is applied.</p>
<p id="p18674115684120"><a name="p18674115684120"></a><a name="p18674115684120"></a>If the <strong id="b14993865376"><a name="b14993865376"></a><a name="b14993865376"></a>values</strong> attribute has been set, the <strong id="b663481314372"><a name="b663481314372"></a><a name="b663481314372"></a>from</strong> attribute is invalid.</p>
</td>
</tr>
<tr id="row31035566404"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p1910315684017"><a name="p1910315684017"></a><a name="p1910315684017"></a>to</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p71035562408"><a name="p71035562408"></a><a name="p71035562408"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p1215689435"><a name="p1215689435"></a><a name="p1215689435"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p2156814315"><a name="p2156814315"></a><a name="p2156814315"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p131031856134010"><a name="p131031856134010"></a><a name="p131031856134010"></a>End value of the attribute to which the animation is applied.</p>
<p id="p3660170134220"><a name="p3660170134220"></a><a name="p3660170134220"></a>If the <strong id="b5960321193718"><a name="b5960321193718"></a><a name="b5960321193718"></a>values</strong> attribute has been set, the <strong id="b159601321193715"><a name="b159601321193715"></a><a name="b159601321193715"></a>to</strong> attribute is invalid.</p>
</td>
</tr>
<tr id="row8777175111408"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p1777735117405"><a name="p1777735117405"></a><a name="p1777735117405"></a>values</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p1377785119406"><a name="p1377785119406"></a><a name="p1377785119406"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p135001510174320"><a name="p135001510174320"></a><a name="p135001510174320"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p8500151044311"><a name="p8500151044311"></a><a name="p8500151044311"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p1277755115407"><a name="p1277755115407"></a><a name="p1277755115407"></a>Change value of a group of animations. The format is value1;value2;value3.</p>
</td>
</tr>
</tbody>
</table>

## Example<a name="section360556124815"></a>

```
<!-- xxx.hml -->
<div class="container">
  <svg width="400" height="400">
    <rect x="20" y="20" width="100" height="100" fill="red" rx="0" ry="20">
      <animate attributeName="rx" values="0;10;30;0" keyTimes="0;0.25;0.75;1" keySplines="0.5 0 0.5 1; 0.5 0 0.5 1; 0.5 0 0.5 1" dur="1000" repeatCount="indefinite">
      </animate>
    </rect>
  </svg>
</div>
```

![](figures/animate-1.gif)

```
<!-- xxx.hml -->
<div class="container">
  <svg width="400" height="400">
    <rect x="20" y="20" width="100" height="100" fill="red" rx="0" ry="20">
      <animate attributeName="fill" from="red" to="blue" dur="1000" repeatCount="indefinite"></animate>
      <animate attributeName="height" from="50" to="150" begin="500" end="1000" repeatCount="indefinite">  </animate>
    </rect>
  </svg>
</div>
```

![](figures/1-45.gif)

```
<!-- xxx.hml -->
<div class="container">
  <svg width="400" height="400">
    <rect x="20" y="20" width="100" height="100" fill="red" rx="0" ry="20">
      <animate attributeName="rx" values="0;30" dur="1000" repeatCount="10" fill="freeze" calcMode="linear"></animate>
    </rect>
  </svg>
</div>
```

![](figures/animate-3.gif)

```
<!-- xxx.hml -->
<div class="container">
  <svg fill="white" width="600" height="600">
    <circle cx="60" cy="70" r="50" stroke-width="4" fill="white" stroke="blue">
      <animate attributeName="r" from="0" to="50" dur="2000" repeatCount="indefinite"></animate>
      <animate attributeName="cx" from="60" to="200" dur="2000" repeatCount="indefinite"></animate>
    </circle>
    <circle cx="60" cy="200" r="50" stroke-width="4" fill="white" stroke="blue">
      <animate attributeName="stroke-width" from="4" to="10" calcMode="discrete" dur="2000" repeatCount="indefinite"></animate>
      <animate attributeName="stroke" values="red;blue" dur="2000" repeatCount="indefinite"></animate>
    </circle>
    <circle cx="180" cy="200" r="50" stroke-width="10" stroke="red" stroke-dasharray="60 10" stroke-dashoffset="3">
      <animate attributeName="stroke-opacity" from="1.0" to="0.5" dur="2000" repeatCount="indefinite"></animate>
      <animate attributeName="stroke-dashoffset" values="30;0;30" dur="500" repeatCount="indefinite"></animate>
     <animate attributeName="cx" from="180" to="400" dur="2000" repeatCount="indefinite"></animate>
    </circle>
    <circle cx="180" cy="200" r="5" fill="blue">
      <animate attributeName="cx" from="180" to="400" dur="2000" repeatCount="indefinite"></animate>
    </circle>
    <circle cx="60" cy="380" r="50"  fill="blue">
      <animate attributeName="fill" values="red;blue" dur="2000" repeatCount="indefinite"></animate>
    </circle>
    <circle cx="180" cy="380" r="50"  fill="blue">
      <animate attributeName="fill-opacity" from="1.0" to="0.5" dur="2000" repeatCount="indefinite"></animate>
    </circle>
    </svg>
</div>
```

![](figures/animate-4.gif)

