# refresh<a name="EN-US_TOPIC_0000001173164669"></a>

The  **<refresh\>**  component is used to pull down to refresh the page.

## Permission List<a name="section11257113618419"></a>

None

## Child Component<a name="section9288143101012"></a>

Supported

## Attribute<a name="section2907183951110"></a>

In addition to the attributes in  [Universal Attributes](js-components-common-attributes.md), the following attributes are supported.

<a name="table20633101642315"></a>
<table><thead align="left"><tr id="row663331618238"><th class="cellrowborder" valign="top" width="23.119999999999997%" id="mcps1.1.6.1.1"><p id="aa872998ac2d84843a3c5161889afffef"><a name="aa872998ac2d84843a3c5161889afffef"></a><a name="aa872998ac2d84843a3c5161889afffef"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="23.119999999999997%" id="mcps1.1.6.1.2"><p id="ab2111648ee0e4f6d881be8954e7acaab"><a name="ab2111648ee0e4f6d881be8954e7acaab"></a><a name="ab2111648ee0e4f6d881be8954e7acaab"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="10.48%" id="mcps1.1.6.1.3"><p id="ab377d1c90900478ea4ecab51e9a058af"><a name="ab377d1c90900478ea4ecab51e9a058af"></a><a name="ab377d1c90900478ea4ecab51e9a058af"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="7.5200000000000005%" id="mcps1.1.6.1.4"><p id="p824610360217"><a name="p824610360217"></a><a name="p824610360217"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="35.76%" id="mcps1.1.6.1.5"><p id="a1d574a0044ed42ec8a2603bc82734232"><a name="a1d574a0044ed42ec8a2603bc82734232"></a><a name="a1d574a0044ed42ec8a2603bc82734232"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row9157554193514"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p178012583610"><a name="p178012583610"></a><a name="p178012583610"></a>offset</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p1880112512360"><a name="p1880112512360"></a><a name="p1880112512360"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p4801551360"><a name="p4801551360"></a><a name="p4801551360"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p880112519366"><a name="p880112519366"></a><a name="p880112519366"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p380114563617"><a name="p380114563617"></a><a name="p380114563617"></a>Distance to the top of the parent component from the <strong id="b179761137151712"><a name="b179761137151712"></a><a name="b179761137151712"></a>&lt;refresh&gt;</strong> component that comes to rest after a successful swipe gesture.</p>
</td>
</tr>
<tr id="row125231450153511"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p1380145163611"><a name="p1380145163611"></a><a name="p1380145163611"></a>refreshing</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p108011457365"><a name="p108011457365"></a><a name="p108011457365"></a>boolean</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p128011554364"><a name="p128011554364"></a><a name="p128011554364"></a>false</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p480119563613"><a name="p480119563613"></a><a name="p480119563613"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p28011856362"><a name="p28011856362"></a><a name="p28011856362"></a>Whether the <strong id="b1342720507196"><a name="b1342720507196"></a><a name="b1342720507196"></a>&lt;refresh&gt;</strong> component is being used for refreshing.</p>
</td>
</tr>
<tr id="row1752375015356"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p1480116513611"><a name="p1480116513611"></a><a name="p1480116513611"></a>type</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p11801105143616"><a name="p11801105143616"></a><a name="p11801105143616"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p198028518361"><a name="p198028518361"></a><a name="p198028518361"></a>auto</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p680275173619"><a name="p680275173619"></a><a name="p680275173619"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p9802205183619"><a name="p9802205183619"></a><a name="p9802205183619"></a>Dynamic effect when the component is refreshed. Two options are available and cannot be modified dynamically.</p>
<a name="ul0802951367"></a><a name="ul0802951367"></a><ul id="ul0802951367"><li><strong id="b0351155943013"><a name="b0351155943013"></a><a name="b0351155943013"></a>auto</strong>: default effect. When the list is pulled to the top, the list does not move. When the list is pulled to the bottom, a circle is displayed.</li><li><strong id="b12317132114318"><a name="b12317132114318"></a><a name="b12317132114318"></a>pulldown</strong>: When the list is pulled to the top, users can continue to pull down to trigger a refresh. The rebound effect will appear after the refresh. If the child component contains a list, set <strong id="b1218171023213"><a name="b1218171023213"></a><a name="b1218171023213"></a>scrolleffect</strong> of the list to <strong id="b1152941417327"><a name="b1152941417327"></a><a name="b1152941417327"></a>no</strong> to prevent drop-down effect conflicts.</li></ul>
</td>
</tr>
<tr id="row2303174523514"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p17802951363"><a name="p17802951363"></a><a name="p17802951363"></a>lasttime</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p580235153616"><a name="p580235153616"></a><a name="p580235153616"></a>boolean</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p198026510362"><a name="p198026510362"></a><a name="p198026510362"></a>false</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p118029511366"><a name="p118029511366"></a><a name="p118029511366"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p1880211583612"><a name="p1880211583612"></a><a name="p1880211583612"></a>Whether to display the last update time. The character string format is <strong id="b46471930153316"><a name="b46471930153316"></a><a name="b46471930153316"></a>last update time: XXXX</strong>, where <strong id="b142341139133312"><a name="b142341139133312"></a><a name="b142341139133312"></a>XXXX</strong> is displayed based on the time and date display specifications and cannot be dynamically modified. (It is recommended that this attribute be used when <strong id="b22347013416"><a name="b22347013416"></a><a name="b22347013416"></a>type</strong> is set to <strong id="b20303548342"><a name="b20303548342"></a><a name="b20303548342"></a>pulldown</strong>. The fixed distance is at the bottom of the content drop-down area. Pay attention to the <strong id="b18265168348"><a name="b18265168348"></a><a name="b18265168348"></a>offset</strong> attribute setting to prevent overlapping.)</p>
</td>
</tr>
<tr id="row119861446131017"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p1098734616104"><a name="p1098734616104"></a><a name="p1098734616104"></a>timeoffset<sup id="sup2158132916489"><a name="sup2158132916489"></a><a name="sup2158132916489"></a>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p59872046111017"><a name="p59872046111017"></a><a name="p59872046111017"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p1198724661014"><a name="p1198724661014"></a><a name="p1198724661014"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p298764616106"><a name="p298764616106"></a><a name="p298764616106"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p12987154619106"><a name="p12987154619106"></a><a name="p12987154619106"></a>Sets the distance between the update time and the top of the parent component.</p>
</td>
</tr>
<tr id="row08492042113518"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p11802105143616"><a name="p11802105143616"></a><a name="p11802105143616"></a>friction</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p1180265153613"><a name="p1180265153613"></a><a name="p1180265153613"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p128026563620"><a name="p128026563620"></a><a name="p128026563620"></a>42</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p11802185153615"><a name="p11802185153615"></a><a name="p11802185153615"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p118021351362"><a name="p118021351362"></a><a name="p118021351362"></a>Pull-down friction coefficient. The value ranges from <strong id="b7887020335"><a name="b7887020335"></a><a name="b7887020335"></a>0</strong> to <strong id="b81365257313"><a name="b81365257313"></a><a name="b81365257313"></a>100</strong>. A larger value indicates a more responsive component. For example, if a user pulls the component down 100 px, it will actually move 100 * <strong id="b2130757132018"><a name="b2130757132018"></a><a name="b2130757132018"></a>friction</strong>% px.</p>
<div class="note" id="note204304260349"><a name="note204304260349"></a><a name="note204304260349"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p1343012264345"><a name="p1343012264345"></a><a name="p1343012264345"></a>This attribute is only supported on phones, tablets, and wearables.</p>
</div></div>
</td>
</tr>
</tbody>
</table>

## Style<a name="section1893981522413"></a>

In addition to the styles in  [Universal Styles](js-components-common-styles.md), the following styles are supported.

<a name="table1493916152248"></a>
<table><thead align="left"><tr id="row16940141532414"><th class="cellrowborder" valign="top" width="25.03%" id="mcps1.1.6.1.1"><p id="p994031519247"><a name="p994031519247"></a><a name="p994031519247"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="18.86%" id="mcps1.1.6.1.2"><p id="p179406154245"><a name="p179406154245"></a><a name="p179406154245"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="10.76%" id="mcps1.1.6.1.3"><p id="p15940161517242"><a name="p15940161517242"></a><a name="p15940161517242"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="7.449999999999999%" id="mcps1.1.6.1.4"><p id="p1694061552419"><a name="p1694061552419"></a><a name="p1694061552419"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="37.9%" id="mcps1.1.6.1.5"><p id="p29401815132419"><a name="p29401815132419"></a><a name="p29401815132419"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row109404152249"><td class="cellrowborder" valign="top" width="25.03%" headers="mcps1.1.6.1.1 "><p id="p994017159246"><a name="p994017159246"></a><a name="p994017159246"></a>background-color</p>
</td>
<td class="cellrowborder" valign="top" width="18.86%" headers="mcps1.1.6.1.2 "><p id="p12940201582418"><a name="p12940201582418"></a><a name="p12940201582418"></a>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="10.76%" headers="mcps1.1.6.1.3 "><p id="p16940215132418"><a name="p16940215132418"></a><a name="p16940215132418"></a>white</p>
</td>
<td class="cellrowborder" valign="top" width="7.449999999999999%" headers="mcps1.1.6.1.4 "><p id="p14940151592415"><a name="p14940151592415"></a><a name="p14940151592415"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="37.9%" headers="mcps1.1.6.1.5 "><p id="p12940181519248"><a name="p12940181519248"></a><a name="p12940181519248"></a>Background color of the <strong id="b6261744123520"><a name="b6261744123520"></a><a name="b6261744123520"></a>&lt;refresh&gt;</strong> component.</p>
</td>
</tr>
<tr id="row169401315182419"><td class="cellrowborder" valign="top" width="25.03%" headers="mcps1.1.6.1.1 "><p id="p69401415152410"><a name="p69401415152410"></a><a name="p69401415152410"></a>progress-color</p>
</td>
<td class="cellrowborder" valign="top" width="18.86%" headers="mcps1.1.6.1.2 "><p id="p16940161522412"><a name="p16940161522412"></a><a name="p16940161522412"></a>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="10.76%" headers="mcps1.1.6.1.3 "><p id="p2940171518246"><a name="p2940171518246"></a><a name="p2940171518246"></a>black</p>
</td>
<td class="cellrowborder" valign="top" width="7.449999999999999%" headers="mcps1.1.6.1.4 "><p id="p594041514245"><a name="p594041514245"></a><a name="p594041514245"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="37.9%" headers="mcps1.1.6.1.5 "><p id="p169402151243"><a name="p169402151243"></a><a name="p169402151243"></a>Loading color of the <strong id="b10245113211611"><a name="b10245113211611"></a><a name="b10245113211611"></a>&lt;refresh&gt;</strong> component.</p>
</td>
</tr>
</tbody>
</table>

## Event<a name="section3892191911214"></a>

The following events are supported.

<a name="table71957715020"></a>
<table><thead align="left"><tr id="row4224147104"><th class="cellrowborder" valign="top" width="18.459999999999997%" id="mcps1.1.4.1.1"><p id="p11224575017"><a name="p11224575017"></a><a name="p11224575017"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="30.79%" id="mcps1.1.4.1.2"><p id="p13225377018"><a name="p13225377018"></a><a name="p13225377018"></a>Parameter</p>
</th>
<th class="cellrowborder" valign="top" width="50.74999999999999%" id="mcps1.1.4.1.3"><p id="p19225197001"><a name="p19225197001"></a><a name="p19225197001"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row9225278016"><td class="cellrowborder" valign="top" width="18.459999999999997%" headers="mcps1.1.4.1.1 "><p id="p6225187706"><a name="p6225187706"></a><a name="p6225187706"></a>refresh</p>
</td>
<td class="cellrowborder" valign="top" width="30.79%" headers="mcps1.1.4.1.2 "><p id="p1422514714013"><a name="p1422514714013"></a><a name="p1422514714013"></a>{ refreshing: refreshingValue }</p>
</td>
<td class="cellrowborder" valign="top" width="50.74999999999999%" headers="mcps1.1.4.1.3 "><p id="p15225575017"><a name="p15225575017"></a><a name="p15225575017"></a>Triggered when the <strong id="b152251728113018"><a name="b152251728113018"></a><a name="b152251728113018"></a>&lt;refresh&gt;</strong> component is pulled down and the refresh status changes. Available values are as follows:</p>
<a name="ul96951626943"></a><a name="ul96951626943"></a><ul id="ul96951626943"><li><strong id="b18264193215"><a name="b18264193215"></a><a name="b18264193215"></a>false</strong>: The <strong id="b01351252103212"><a name="b01351252103212"></a><a name="b01351252103212"></a>&lt;refresh&gt;</strong> component is being pulled down.</li><li><strong id="b610561314337"><a name="b610561314337"></a><a name="b610561314337"></a>true</strong>: The <strong id="b2742219336"><a name="b2742219336"></a><a name="b2742219336"></a>&lt;refresh&gt;</strong> component is not being pulled down.</li></ul>
</td>
</tr>
<tr id="row13275847193920"><td class="cellrowborder" valign="top" width="18.459999999999997%" headers="mcps1.1.4.1.1 "><p id="p42761147173920"><a name="p42761147173920"></a><a name="p42761147173920"></a>pulldown</p>
</td>
<td class="cellrowborder" valign="top" width="30.79%" headers="mcps1.1.4.1.2 "><p id="p227664711392"><a name="p227664711392"></a><a name="p227664711392"></a>{ state: string }</p>
</td>
<td class="cellrowborder" valign="top" width="50.74999999999999%" headers="mcps1.1.4.1.3 "><p id="p527644753917"><a name="p527644753917"></a><a name="p527644753917"></a>Triggered when a user starts or stops pulling down the <strong id="b101091622103416"><a name="b101091622103416"></a><a name="b101091622103416"></a>&lt;refresh&gt;</strong> component. Available values are as follows:</p>
<a name="ul225113709"></a><a name="ul225113709"></a><ul id="ul225113709"><li><strong id="b18546112103519"><a name="b18546112103519"></a><a name="b18546112103519"></a>start</strong>: The pull-down starts.</li><li><strong id="b1978717723516"><a name="b1978717723516"></a><a name="b1978717723516"></a>end</strong>: The pull-down ends.</li></ul>
</td>
</tr>
</tbody>
</table>

## Method<a name="section2279124532420"></a>

Methods in  [Universal Methods](js-components-common-methods.md)  are not supported.

## Example<a name="section1050103282219"></a>

```
<!-- xxx.hml -->
<div class="container">
  <refresh refreshing="{{fresh}}" onrefresh="refresh">
    <list class="list" scrolleffect="no">
      <list-item class="listitem" for="list">
        <div class="content">
          <text class="text">{{$item}}</text>
        </div>
      </list-item>
    </list>
  </refresh>
</div>
```

```
/* xxx.css */
.container {
  flex-direction: column;
  align-items: center;
  width: 100%;
  height: 100%;
}

.list {
  width: 100%;
  height: 100%;
}

.listitem {
  width: 100%;
  height: 150px;
}

.content {
  width: 100%;
  height: 100%;
  flex-direction: column;
  align-items: center;
  justify-content: center;
}

.text {
  font-size: 35px;
  font-weight: bold;
}
```

```
// xxx.js
import prompt from '@system.prompt';
export default {
  data: {
    list:[],
    fresh:false
  },
  onInit() {
    this.list = [];
    for (var i = 0; i <= 3; i++) {
      var item ='List element' + i;
      this.list.push(item);
    }
  },
  refresh: function (e) {
    prompt.showToast({
      message: 'Refreshing...'
    })
    var that = this;
    that.fresh = e.refreshing;
    setTimeout(function () {
      that.fresh = false;
      var addItem ='Refresh element';
      that.list.unshift(addItem);
      prompt.showToast({
        message: 'Refreshed.'
      })
    }, 2000)
  }
}
```

![](figures/en-us_image_0000001150719520.gif)

