# Universal Styles<a name="EN-US_TOPIC_0000001173324679"></a>

You can set component appearance in the  **style**  attribute or  **.css**  files.

<a name="td0e7eac6a0284816a5c047f153c07d82"></a>
<table><thead align="left"><tr id="rccf63bae170347ec85cc93fb5c6c2dbb"><th class="cellrowborder" valign="top" width="27.04270427042704%" id="mcps1.1.5.1.1"><p id="a14a0c012a26248cfbec6b13dcc4f2cbe"><a name="a14a0c012a26248cfbec6b13dcc4f2cbe"></a><a name="a14a0c012a26248cfbec6b13dcc4f2cbe"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="20.402040204020402%" id="mcps1.1.5.1.2"><p id="a8dc328a555a74157a00de86181fc3a7b"><a name="a8dc328a555a74157a00de86181fc3a7b"></a><a name="a8dc328a555a74157a00de86181fc3a7b"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="11.601160116011602%" id="mcps1.1.5.1.3"><p id="a41a31e48d0c74ad4982add2655515c82"><a name="a41a31e48d0c74ad4982add2655515c82"></a><a name="a41a31e48d0c74ad4982add2655515c82"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="40.954095409540955%" id="mcps1.1.5.1.4"><p id="af7a726e456f7485c87bd4e0527bc6584"><a name="af7a726e456f7485c87bd4e0527bc6584"></a><a name="af7a726e456f7485c87bd4e0527bc6584"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="r86e8f72ab5d34004853cb4c0d2f72c9d"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="a8bc81ecef4934adf91deb1d6167045d7"><a name="a8bc81ecef4934adf91deb1d6167045d7"></a><a name="a8bc81ecef4934adf91deb1d6167045d7"></a>width</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="a59692217b9c94353a020a2f0a20f01a7"><a name="a59692217b9c94353a020a2f0a20f01a7"></a><a name="a59692217b9c94353a020a2f0a20f01a7"></a>&lt;length&gt; | &lt;percentage&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="p3948114217528"><a name="p3948114217528"></a><a name="p3948114217528"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p624653010258"><a name="p624653010258"></a><a name="p624653010258"></a>Component width.</p>
<p id="p84811050134010"><a name="p84811050134010"></a><a name="p84811050134010"></a>If this attribute is not set, the width required for the element content is used. </p>
</td>
</tr>
<tr id="r4f331adcbe404a8081155e9582e2e1ba"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="a738cc687552c4b8cb1aa9f9e7d9ea8c2"><a name="a738cc687552c4b8cb1aa9f9e7d9ea8c2"></a><a name="a738cc687552c4b8cb1aa9f9e7d9ea8c2"></a>height</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="a82c5d9c65b3646ec92afe5f0f47a2149"><a name="a82c5d9c65b3646ec92afe5f0f47a2149"></a><a name="a82c5d9c65b3646ec92afe5f0f47a2149"></a>&lt;length&gt;<span id="ph11748352163918"><a name="ph11748352163918"></a><a name="ph11748352163918"></a></span> | &lt;percentage&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="a7e6c7daafecf475888d0420835662eb4"><a name="a7e6c7daafecf475888d0420835662eb4"></a><a name="a7e6c7daafecf475888d0420835662eb4"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p1477601264"><a name="p1477601264"></a><a name="p1477601264"></a>Component height.</p>
<p id="p208761554184020"><a name="p208761554184020"></a><a name="p208761554184020"></a>If this length attribute is not set, the length required for the element content is used. </p>
</td>
</tr>
<tr id="row13660102510327"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="p6377163523212"><a name="p6377163523212"></a><a name="p6377163523212"></a>min-width<sup id="sup537763519325"><a name="sup537763519325"></a><a name="sup537763519325"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="p1637715359321"><a name="p1637715359321"></a><a name="p1637715359321"></a>&lt;length&gt; | &lt;percentage&gt;<sup id="sup21401217019"><a name="sup21401217019"></a><a name="sup21401217019"></a>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="p7377133512326"><a name="p7377133512326"></a><a name="p7377133512326"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p183771735113211"><a name="p183771735113211"></a><a name="p183771735113211"></a>Minimum component width</p>
</td>
</tr>
<tr id="row1165519287327"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="p73779355328"><a name="p73779355328"></a><a name="p73779355328"></a>min-height<sup id="sup11377735113211"><a name="sup11377735113211"></a><a name="sup11377735113211"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="p3377335143216"><a name="p3377335143216"></a><a name="p3377335143216"></a>&lt;length&gt; | &lt;percentage&gt;<sup id="sup18164144009"><a name="sup18164144009"></a><a name="sup18164144009"></a>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="p1737743533212"><a name="p1737743533212"></a><a name="p1737743533212"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p337818353329"><a name="p337818353329"></a><a name="p337818353329"></a>Minimum component height</p>
</td>
</tr>
<tr id="row1202531163210"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="p10378183533219"><a name="p10378183533219"></a><a name="p10378183533219"></a>max-width<sup id="sup537813511327"><a name="sup537813511327"></a><a name="sup537813511327"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="p8251271007"><a name="p8251271007"></a><a name="p8251271007"></a>&lt;length&gt; | &lt;percentage&gt;<sup id="sup8251271603"><a name="sup8251271603"></a><a name="sup8251271603"></a>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="p737817355325"><a name="p737817355325"></a><a name="p737817355325"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p19378203513216"><a name="p19378203513216"></a><a name="p19378203513216"></a>Maximum component width, which has no restriction by default</p>
</td>
</tr>
<tr id="row3921633163215"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="p8378135193215"><a name="p8378135193215"></a><a name="p8378135193215"></a>max-height<sup id="sup63781535163210"><a name="sup63781535163210"></a><a name="sup63781535163210"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="p173788353327"><a name="p173788353327"></a><a name="p173788353327"></a>&lt;length&gt; | &lt;percentage&gt;<sup id="sup370891800"><a name="sup370891800"></a><a name="sup370891800"></a>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="p11378193523214"><a name="p11378193523214"></a><a name="p11378193523214"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p23781235203214"><a name="p23781235203214"></a><a name="p23781235203214"></a>Maximum component height, which has no restriction by default</p>
</td>
</tr>
<tr id="rbc132bca84214d4295bfeb9530425f5c"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="a8ff18465b8f0453c836067e5902b7eb6"><a name="a8ff18465b8f0453c836067e5902b7eb6"></a><a name="a8ff18465b8f0453c836067e5902b7eb6"></a>padding</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="a53628f36a25a4823a901d5b66860f44e"><a name="a53628f36a25a4823a901d5b66860f44e"></a><a name="a53628f36a25a4823a901d5b66860f44e"></a>&lt;length&gt; | &lt;percentage&gt;<sup id="sup1886516813013"><a name="sup1886516813013"></a><a name="sup1886516813013"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="adc824deaee924821a47a798b589f22c8"><a name="adc824deaee924821a47a798b589f22c8"></a><a name="adc824deaee924821a47a798b589f22c8"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p157435053316"><a name="p157435053316"></a><a name="p157435053316"></a>Shorthand attribute to set all padding attributes.</p>
<div class="p" id="a68a6d5ddc59c49f0aaddd82e75932524"><a name="a68a6d5ddc59c49f0aaddd82e75932524"></a><a name="a68a6d5ddc59c49f0aaddd82e75932524"></a>The attribute can have one to four values:<a name="ul15202134923211"></a><a name="ul15202134923211"></a><ul id="ul15202134923211"><li><p id="p10614155353215"><a name="p10614155353215"></a><a name="p10614155353215"></a>If you set only one value, it specifies the padding for four sides.</p>
</li><li><p id="p10614175393216"><a name="p10614175393216"></a><a name="p10614175393216"></a>If you set two values, the first value specifies the top and bottom padding, and the second value specifies the left and right padding.</p>
</li><li><p id="p8614205393214"><a name="p8614205393214"></a><a name="p8614205393214"></a>If you set three values, the first value specifies the top padding, the second value specifies the left and right padding, and the third value specifies the bottom padding.</p>
</li><li><p id="p106141853193215"><a name="p106141853193215"></a><a name="p106141853193215"></a>If you set four values, they respectively specify the padding for top, right, bottom, and left sides (in clockwise order).</p>
</li></ul>
</div>
</td>
</tr>
<tr id="r5b9c603c3e9b4695b8908eb599f7146b"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="ab0185a7b5a4944f3b38f8c71c8ca794d"><a name="ab0185a7b5a4944f3b38f8c71c8ca794d"></a><a name="ab0185a7b5a4944f3b38f8c71c8ca794d"></a>padding-[left|top|right|bottom]</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="a49dd523e2f1b4253a19231e776dc1951"><a name="a49dd523e2f1b4253a19231e776dc1951"></a><a name="a49dd523e2f1b4253a19231e776dc1951"></a>&lt;length&gt; | &lt;percentage&gt;<sup id="sup19949912807"><a name="sup19949912807"></a><a name="sup19949912807"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="af52ecd93919b4fa08ae4d376e3d544a2"><a name="af52ecd93919b4fa08ae4d376e3d544a2"></a><a name="af52ecd93919b4fa08ae4d376e3d544a2"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="a3575ab240d384ab1a21119ea3428ab7d"><a name="a3575ab240d384ab1a21119ea3428ab7d"></a><a name="a3575ab240d384ab1a21119ea3428ab7d"></a>Left, top, right, and bottom padding (in px).</p>
</td>
</tr>
<tr id="row116908472362"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="p769124717365"><a name="p769124717365"></a><a name="p769124717365"></a>padding-[start|end]</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="p157617124374"><a name="p157617124374"></a><a name="p157617124374"></a>&lt;length&gt; | &lt;percentage&gt;<sup id="sup8490161513019"><a name="sup8490161513019"></a><a name="sup8490161513019"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="p1069144703616"><a name="p1069144703616"></a><a name="p1069144703616"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p1269184753610"><a name="p1269184753610"></a><a name="p1269184753610"></a>Start and end padding.</p>
</td>
</tr>
<tr id="ra1f0ab04099e40da96fcea74a214d6dc"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="afa508e5429d948b2b561943d6b2f0f31"><a name="afa508e5429d948b2b561943d6b2f0f31"></a><a name="afa508e5429d948b2b561943d6b2f0f31"></a>margin</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="a4dab4f9d97a74a27a45b7ef1d2ab08e6"><a name="a4dab4f9d97a74a27a45b7ef1d2ab08e6"></a><a name="a4dab4f9d97a74a27a45b7ef1d2ab08e6"></a>&lt;length&gt; | &lt;percentage&gt;<sup id="sup1433352175220"><a name="sup1433352175220"></a><a name="sup1433352175220"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="a5e3c234d78214e8180b51d237adda154"><a name="a5e3c234d78214e8180b51d237adda154"></a><a name="a5e3c234d78214e8180b51d237adda154"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="a1d350e36a773420baf5ebb930cd5ad66"><a name="a1d350e36a773420baf5ebb930cd5ad66"></a><a name="a1d350e36a773420baf5ebb930cd5ad66"></a>Shorthand attribute to set margins for all sides in a declaration. The attribute can have one to four values:</p>
<a name="ul5333133311105"></a><a name="ul5333133311105"></a><ul id="ul5333133311105"><li><p id="p03345339103"><a name="p03345339103"></a><a name="p03345339103"></a>If you set only one value, it specifies the margin for all the four sides.</p>
</li><li><p id="p1133420334108"><a name="p1133420334108"></a><a name="p1133420334108"></a>If you set two values, the first value is for the top and bottom sides and the second value for the left and right sides.</p>
</li><li><p id="p193341533191015"><a name="p193341533191015"></a><a name="p193341533191015"></a>If you set three values, the first value is for the top, the second value for the left and right, and the third value for the bottom.</p>
</li><li><p id="p733412334102"><a name="p733412334102"></a><a name="p733412334102"></a>If you set four values, they are margins for top, right, bottom, and left sides, respectively.</p>
</li></ul>
</td>
</tr>
<tr id="rbcdeb5f7b53646bcbeb0d9ce45842f34"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="a70939a36b2b04dd8bec21f5bddc8637e"><a name="a70939a36b2b04dd8bec21f5bddc8637e"></a><a name="a70939a36b2b04dd8bec21f5bddc8637e"></a>margin-[left|top|right|bottom]</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="ae53ac9ac370d483990e04ea9789c1e49"><a name="ae53ac9ac370d483990e04ea9789c1e49"></a><a name="ae53ac9ac370d483990e04ea9789c1e49"></a>&lt;length&gt; | &lt;percentage&gt;<sup id="sup378331720532"><a name="sup378331720532"></a><a name="sup378331720532"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="a180cd037e6174e5c82f35a3a66b6f2ec"><a name="a180cd037e6174e5c82f35a3a66b6f2ec"></a><a name="a180cd037e6174e5c82f35a3a66b6f2ec"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="a487d09add6e54c5c89fa4f22e9318271"><a name="a487d09add6e54c5c89fa4f22e9318271"></a><a name="a487d09add6e54c5c89fa4f22e9318271"></a>Left, top, right, and bottom margins.</p>
</td>
</tr>
<tr id="row2347125383714"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="p9492107123816"><a name="p9492107123816"></a><a name="p9492107123816"></a>margin-[start|end]</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="p164928753815"><a name="p164928753815"></a><a name="p164928753815"></a>&lt;length&gt; | &lt;percentage&gt;<sup id="sup164498399219"><a name="sup164498399219"></a><a name="sup164498399219"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="p1549213793811"><a name="p1549213793811"></a><a name="p1549213793811"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p1049212715388"><a name="p1049212715388"></a><a name="p1049212715388"></a>Start and end margins.</p>
</td>
</tr>
<tr id="r60ccba1f3cc54a4399490c92f2fd350d"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="a222bb48f24014f2eb2b16a1a840bbebb"><a name="a222bb48f24014f2eb2b16a1a840bbebb"></a><a name="a222bb48f24014f2eb2b16a1a840bbebb"></a>border</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="a79b4eaf9983c44d0aad39ff04d0997a8"><a name="a79b4eaf9983c44d0aad39ff04d0997a8"></a><a name="a79b4eaf9983c44d0aad39ff04d0997a8"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="aac320f4f0a42401aa7fa778d9829d77c"><a name="aac320f4f0a42401aa7fa778d9829d77c"></a><a name="aac320f4f0a42401aa7fa778d9829d77c"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="a9cd962871a4c467a8e1ef452621d5cd7"><a name="a9cd962871a4c467a8e1ef452621d5cd7"></a><a name="a9cd962871a4c467a8e1ef452621d5cd7"></a>Shorthand attribute to set all borders. You can set <strong id="b79128342503"><a name="b79128342503"></a><a name="b79128342503"></a>border-width</strong>, <strong id="b9366173919505"><a name="b9366173919505"></a><a name="b9366173919505"></a>border-style</strong>, and <strong id="b184351248205019"><a name="b184351248205019"></a><a name="b184351248205019"></a>border-color</strong> in sequence. Default values are used for attributes that are not set.</p>
</td>
</tr>
<tr id="rf47e6860036e4ababdf04b51974c019c"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="a987708c0864a4128af094334f1b024b3"><a name="a987708c0864a4128af094334f1b024b3"></a><a name="a987708c0864a4128af094334f1b024b3"></a>border-style</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="p513631613319"><a name="p513631613319"></a><a name="p513631613319"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="a2567083af59c40e58e3e4d9b0ddf1485"><a name="a2567083af59c40e58e3e4d9b0ddf1485"></a><a name="a2567083af59c40e58e3e4d9b0ddf1485"></a>solid</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p342285712314"><a name="p342285712314"></a><a name="p342285712314"></a>Shorthand attribute to set the style for all borders. Available values are as follows:</p>
<a name="ul1470834505612"></a><a name="ul1470834505612"></a><ul id="ul1470834505612"><li><strong id="b143453286360"><a name="b143453286360"></a><a name="b143453286360"></a>dotted</strong>: Dotted border. The radius of a dot is half of border-width.</li><li><strong id="b792117280367"><a name="b792117280367"></a><a name="b792117280367"></a>dashed</strong>: Dashed border</li></ul>
<a name="ul15621125545612"></a><a name="ul15621125545612"></a><ul id="ul15621125545612"><li><strong id="b1335862963610"><a name="b1335862963610"></a><a name="b1335862963610"></a>solid</strong>: Solid border</li></ul>
</td>
</tr>
<tr id="row4953937976"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="p119531437370"><a name="p119531437370"></a><a name="p119531437370"></a>border-[left|top|right|bottom]-style</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="p129532037175"><a name="p129532037175"></a><a name="p129532037175"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="p495312372717"><a name="p495312372717"></a><a name="p495312372717"></a>solid</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p595353718719"><a name="p595353718719"></a><a name="p595353718719"></a>Styles of the left, top, right, and bottom borders. The available values are <strong id="b17769171311540"><a name="b17769171311540"></a><a name="b17769171311540"></a>dotted</strong>, <strong id="b237141519547"><a name="b237141519547"></a><a name="b237141519547"></a>dashed</strong>, and <strong id="b8949161613540"><a name="b8949161613540"></a><a name="b8949161613540"></a>solid</strong>.</p>
</td>
</tr>
<tr id="r6d2787d3df7c4c88ab88ab99a87459d3"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="a8afd82b1aba547d3b0188b749518b2de"><a name="a8afd82b1aba547d3b0188b749518b2de"></a><a name="a8afd82b1aba547d3b0188b749518b2de"></a>border-[left|top|right|bottom]</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="ac4b8a3b39e5446b5868f1f2989dc9590"><a name="ac4b8a3b39e5446b5868f1f2989dc9590"></a><a name="ac4b8a3b39e5446b5868f1f2989dc9590"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="a3420bc82bd17458ab82fa996ade7064c"><a name="a3420bc82bd17458ab82fa996ade7064c"></a><a name="a3420bc82bd17458ab82fa996ade7064c"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="af4178a066c344412afbd38f4b0c44818"><a name="af4178a066c344412afbd38f4b0c44818"></a><a name="af4178a066c344412afbd38f4b0c44818"></a>Shorthand attribute to set the borders for every side respectively. You can set <strong id="b122415514554"><a name="b122415514554"></a><a name="b122415514554"></a>border-width</strong>, <strong id="b12296178135513"><a name="b12296178135513"></a><a name="b12296178135513"></a>border-style</strong>, and <strong id="b1129701210553"><a name="b1129701210553"></a><a name="b1129701210553"></a>border-color</strong> in sequence. Default values are used for attributes that are not set.</p>
</td>
</tr>
<tr id="ra8d2cc3cfa024bb3a5c167e3a84d974e"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="adf0e0afedc774afca9cda0e509391029"><a name="adf0e0afedc774afca9cda0e509391029"></a><a name="adf0e0afedc774afca9cda0e509391029"></a>border-width</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="a0782ea2c45eb4864a8df82f30dd2cd5f"><a name="a0782ea2c45eb4864a8df82f30dd2cd5f"></a><a name="a0782ea2c45eb4864a8df82f30dd2cd5f"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="a395cbedd521145bd820b9171ee2dd7ac"><a name="a395cbedd521145bd820b9171ee2dd7ac"></a><a name="a395cbedd521145bd820b9171ee2dd7ac"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="a7ae60621ea3341818a03bfdffa641894"><a name="a7ae60621ea3341818a03bfdffa641894"></a><a name="a7ae60621ea3341818a03bfdffa641894"></a>Shorthand attribute to set the width of all borders<span id="ph07997369365"><a name="ph07997369365"></a><a name="ph07997369365"></a>, or separately set the width of each border</span>.</p>
</td>
</tr>
<tr id="r97f2117589624b018d91ca8a099f3264"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="a7371edc07c664266a2e1866f31ad0d0c"><a name="a7371edc07c664266a2e1866f31ad0d0c"></a><a name="a7371edc07c664266a2e1866f31ad0d0c"></a>border-[left|top|right|bottom]-width</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="a2faa532b841948a7b6598542b4eccc7b"><a name="a2faa532b841948a7b6598542b4eccc7b"></a><a name="a2faa532b841948a7b6598542b4eccc7b"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="a87f38cfa47f54bc18c32f9671c0f9ca6"><a name="a87f38cfa47f54bc18c32f9671c0f9ca6"></a><a name="a87f38cfa47f54bc18c32f9671c0f9ca6"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="a20386e66c3834d5f96cf9435c4715c5b"><a name="a20386e66c3834d5f96cf9435c4715c5b"></a><a name="a20386e66c3834d5f96cf9435c4715c5b"></a>Attribute to set widths of left, top, right, and bottom borders.</p>
</td>
</tr>
<tr id="rebb331f7734b46b98d7d630beb4bfc40"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="a40a816cf0a03489d81f209a8aa7d81a6"><a name="a40a816cf0a03489d81f209a8aa7d81a6"></a><a name="a40a816cf0a03489d81f209a8aa7d81a6"></a>border-color</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="afcc7c948ae0947b2a78002d31f2f9748"><a name="afcc7c948ae0947b2a78002d31f2f9748"></a><a name="afcc7c948ae0947b2a78002d31f2f9748"></a>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="ae0909d2b896342f9b2196fe0dce72920"><a name="ae0909d2b896342f9b2196fe0dce72920"></a><a name="ae0909d2b896342f9b2196fe0dce72920"></a>black</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="a76fd98995e1d4217aa703fecd69325c7"><a name="a76fd98995e1d4217aa703fecd69325c7"></a><a name="a76fd98995e1d4217aa703fecd69325c7"></a>Shorthand attribute to set the color of all borders<span id="ph9587639113619"><a name="ph9587639113619"></a><a name="ph9587639113619"></a>, or separately set the color of each border</span>.</p>
</td>
</tr>
<tr id="r92bbe455dcbe40c9aeeb71145a46dee7"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="a2afc646d6a2549548bcd5c4b9bed1fb5"><a name="a2afc646d6a2549548bcd5c4b9bed1fb5"></a><a name="a2afc646d6a2549548bcd5c4b9bed1fb5"></a>border-[left|top|right|bottom]-color</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="a34556866a4f54f5da88f148fc698867b"><a name="a34556866a4f54f5da88f148fc698867b"></a><a name="a34556866a4f54f5da88f148fc698867b"></a>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="a8ff58e18553846a38e82c69149e2aa30"><a name="a8ff58e18553846a38e82c69149e2aa30"></a><a name="a8ff58e18553846a38e82c69149e2aa30"></a>black</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="a5c85947d388c4c7fbf0de07b022bb44e"><a name="a5c85947d388c4c7fbf0de07b022bb44e"></a><a name="a5c85947d388c4c7fbf0de07b022bb44e"></a>Attribute to set colors of left, top, right, and bottom borders.</p>
</td>
</tr>
<tr id="r466497bc9bfd48f9a3e718beb413ac0c"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="a65974e3078c447a383fb9237cc4ffa32"><a name="a65974e3078c447a383fb9237cc4ffa32"></a><a name="a65974e3078c447a383fb9237cc4ffa32"></a>border-radius</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="a413fd0aea8b243349a19f825e96ee8b6"><a name="a413fd0aea8b243349a19f825e96ee8b6"></a><a name="a413fd0aea8b243349a19f825e96ee8b6"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="af786857698c74e259f52589a6670a0a1"><a name="af786857698c74e259f52589a6670a0a1"></a><a name="af786857698c74e259f52589a6670a0a1"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="a52ca834f42124d3b8b12bbf54914fc96"><a name="a52ca834f42124d3b8b12bbf54914fc96"></a><a name="a52ca834f42124d3b8b12bbf54914fc96"></a>Attribute to set the radius of round borders of an element. <span id="ph1249443123611"><a name="ph1249443123611"></a><a name="ph1249443123611"></a>This attribute cannot be used to set the width, color, or style of a specific border. To set the width or color, you need to set <strong id="b124211434362"><a name="b124211434362"></a><a name="b124211434362"></a>border-width</strong>, <strong id="b124894383615"><a name="b124894383615"></a><a name="b124894383615"></a>border-color</strong>, or <strong id="b7166134516465"><a name="b7166134516465"></a><a name="b7166134516465"></a>border-style</strong> for all the borders at the same time.</span></p>
</td>
</tr>
<tr id="rd4fc211b573447a1a1b7841a144eccae"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="a466f1f8bc2fb404e82e8417c5133eacb"><a name="a466f1f8bc2fb404e82e8417c5133eacb"></a><a name="a466f1f8bc2fb404e82e8417c5133eacb"></a>border-[top|bottom]-[left|right]-radius</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="a499fe910d0284647abc48b1bd0eb4868"><a name="a499fe910d0284647abc48b1bd0eb4868"></a><a name="a499fe910d0284647abc48b1bd0eb4868"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="ac142d1054eee499f948069f46129c492"><a name="ac142d1054eee499f948069f46129c492"></a><a name="ac142d1054eee499f948069f46129c492"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="a63757091a86c4ced97f0c39d37a2117c"><a name="a63757091a86c4ced97f0c39d37a2117c"></a><a name="a63757091a86c4ced97f0c39d37a2117c"></a>Attribute to receptively set the radii of upper-left, upper-right, lower-right, and lower-left rounded corners</p>
</td>
</tr>
<tr id="re84d5481999b4984ac1242cc5cdf20ca"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="ae335be2c6150440fb31b40b1ca117858"><a name="ae335be2c6150440fb31b40b1ca117858"></a><a name="ae335be2c6150440fb31b40b1ca117858"></a>background</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="a394a81171c5c4d1aa81b94fc5d2f0f07"><a name="a394a81171c5c4d1aa81b94fc5d2f0f07"></a><a name="a394a81171c5c4d1aa81b94fc5d2f0f07"></a>&lt;linear-gradient&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="a0734de04e90e470cb608e8d5f42c6874"><a name="a0734de04e90e470cb608e8d5f42c6874"></a><a name="a0734de04e90e470cb608e8d5f42c6874"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="a1d2985ee819d4cfd87861080354def51"><a name="a1d2985ee819d4cfd87861080354def51"></a><a name="a1d2985ee819d4cfd87861080354def51"></a>This attribute supports <a href="js-components-common-gradient.md">Gradient Styles</a> only but is not compatible with <strong id="b389373419292"><a name="b389373419292"></a><a name="b389373419292"></a>background-color</strong> or <strong id="b0399637142918"><a name="b0399637142918"></a><a name="b0399637142918"></a>background-image</strong>.</p>
</td>
</tr>
<tr id="r81e36151ade9499aa21d3c0b72da1111"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="a2977672444224b738a566c61225961c2"><a name="a2977672444224b738a566c61225961c2"></a><a name="a2977672444224b738a566c61225961c2"></a>background-color</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="a87186748ed7c4694aef0095d8a7f8e43"><a name="a87186748ed7c4694aef0095d8a7f8e43"></a><a name="a87186748ed7c4694aef0095d8a7f8e43"></a>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="a2775a3cca8994bec9b754af0d2455eb5"><a name="a2775a3cca8994bec9b754af0d2455eb5"></a><a name="a2775a3cca8994bec9b754af0d2455eb5"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="a372b6089bf9746f091c91fa49b571f1d"><a name="a372b6089bf9746f091c91fa49b571f1d"></a><a name="a372b6089bf9746f091c91fa49b571f1d"></a>Background color.</p>
</td>
</tr>
<tr id="r80de1dc3e37848b38f65fd4ef7711bfa"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="ab2dff80cd59c4db1bf4293172f89735e"><a name="ab2dff80cd59c4db1bf4293172f89735e"></a><a name="ab2dff80cd59c4db1bf4293172f89735e"></a>background-image</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="ad9a7e9f2469b45238a6a0ac6da232286"><a name="ad9a7e9f2469b45238a6a0ac6da232286"></a><a name="ad9a7e9f2469b45238a6a0ac6da232286"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="a73fb72c96edd488ba74c364568e345c6"><a name="a73fb72c96edd488ba74c364568e345c6"></a><a name="a73fb72c96edd488ba74c364568e345c6"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="a24de29e3cb4d476fabe55d48d69350a8"><a name="a24de29e3cb4d476fabe55d48d69350a8"></a><a name="a24de29e3cb4d476fabe55d48d69350a8"></a>Background image. Currently, this attribute is not compatible with <strong id="b17699154763620"><a name="b17699154763620"></a><a name="b17699154763620"></a>background-color</strong> or <strong id="b87001647163613"><a name="b87001647163613"></a><a name="b87001647163613"></a>background</strong>. Local and online image resources are supported.</p>
<p id="p45914251572"><a name="p45914251572"></a><a name="p45914251572"></a>Example:</p>
<p id="p16184973578"><a name="p16184973578"></a><a name="p16184973578"></a>background-image: url("/common/background.png")</p>
</td>
</tr>
<tr id="re1870d7c91f148e8ad7264a95eb2c580"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="af81424fd1fbf4f5da65ea5d136390494"><a name="af81424fd1fbf4f5da65ea5d136390494"></a><a name="af81424fd1fbf4f5da65ea5d136390494"></a>background-size</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><a name="ul1065173641310"></a><a name="ul1065173641310"></a><ul id="ul1065173641310"><li>string</li><li>&lt;length&gt; &lt;length&gt;</li><li>&lt;percentage&gt; &lt;percentage&gt;</li></ul>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="a222f4e09239a4ab08880d1d9544d337c"><a name="a222f4e09239a4ab08880d1d9544d337c"></a><a name="a222f4e09239a4ab08880d1d9544d337c"></a>auto</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p91971112114318"><a name="p91971112114318"></a><a name="p91971112114318"></a>Background image size.</p>
<a name="ul41331853154111"></a><a name="ul41331853154111"></a><ul id="ul41331853154111"><li>The <strong id="b1229715499365"><a name="b1229715499365"></a><a name="b1229715499365"></a>string</strong> values are as follows:<a name="ul13611494111"></a><a name="ul13611494111"></a><ul id="ul13611494111"><li><strong id="b4759749163610"><a name="b4759749163610"></a><a name="b4759749163610"></a>contain</strong>: Expands the image to the maximum size so that the height and width of the image are applicable to the content area.</li><li><strong id="b437619381712"><a name="b437619381712"></a><a name="b437619381712"></a>cover</strong>: Extends the background image to a large enough size so that the background image completely covers the background area. Some parts of the image may not be displayed in the background area.</li><li><strong id="b1425512535366"><a name="b1425512535366"></a><a name="b1425512535366"></a>auto</strong>: The original image width-height ratio is retained.</li></ul>
</li><li>The two <strong id="b13309145193614"><a name="b13309145193614"></a><a name="b13309145193614"></a>&lt;length&gt;</strong> values are as follows:<p id="p1840244924418"><a name="p1840244924418"></a><a name="p1840244924418"></a>Width and height of the background image. The first value indicates the width, and the second value indicates the height. If you only set one value, the other value is set to <strong id="b146661156143617"><a name="b146661156143617"></a><a name="b146661156143617"></a>auto</strong> by default.</p>
</li><li>The two <strong id="b1667415763613"><a name="b1667415763613"></a><a name="b1667415763613"></a>&lt;percentage&gt;</strong> values are as follows:<p id="p17936154410457"><a name="p17936154410457"></a><a name="p17936154410457"></a>Width and height of the background image in percentage of the parent element. The first value indicates the width, and the second value indicates the height. If you only set one value, the other value is set to <strong id="b1478151430"><a name="b1478151430"></a><a name="b1478151430"></a>auto</strong> by default.</p>
</li></ul>
</td>
</tr>
<tr id="r2f8ec5072a754e038c89308dd8997259"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="a9957170386754fb5b648ba2114bd52d4"><a name="a9957170386754fb5b648ba2114bd52d4"></a><a name="a9957170386754fb5b648ba2114bd52d4"></a>background-repeat</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="a155b4cc325e747279694d36c2fa69bcc"><a name="a155b4cc325e747279694d36c2fa69bcc"></a><a name="a155b4cc325e747279694d36c2fa69bcc"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="a82029c0dc1d540cf994f690b451c48f4"><a name="a82029c0dc1d540cf994f690b451c48f4"></a><a name="a82029c0dc1d540cf994f690b451c48f4"></a>repeat</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="afb8e41c117884b368a0f1df348be8e54"><a name="afb8e41c117884b368a0f1df348be8e54"></a><a name="afb8e41c117884b368a0f1df348be8e54"></a>How a background image is repeatedly drawn. By default, a background image is repeated both horizontally and vertically.</p>
<a name="ul8236153103612"></a><a name="ul8236153103612"></a><ul id="ul8236153103612"><li><strong id="b1363463710"><a name="b1363463710"></a><a name="b1363463710"></a>repeat</strong>: Repeatedly draws images along the x-axis and y-axis at the same time.</li><li><strong id="b267416916377"><a name="b267416916377"></a><a name="b267416916377"></a>repeat-x</strong>: Repeatedly draws images along the x-axis.</li><li><strong id="b625561011379"><a name="b625561011379"></a><a name="b625561011379"></a>repeat-y</strong>: Repeatedly draws images along the y-axis.</li><li><strong id="b1122181133715"><a name="b1122181133715"></a><a name="b1122181133715"></a>no-repeat</strong>: The image is not drawn repeatedly.</li></ul>
</td>
</tr>
<tr id="r74d37bef16544cddbabf94a6c0d8f0f6"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="a709eb4a9fa87428897bebb4a98693df2"><a name="a709eb4a9fa87428897bebb4a98693df2"></a><a name="a709eb4a9fa87428897bebb4a98693df2"></a>background-position</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><a name="ul8874155216502"></a><a name="ul8874155216502"></a><ul id="ul8874155216502"><li>string string</li><li>&lt;length&gt; &lt;length&gt;</li><li>&lt;percentage&gt; &lt;percentage&gt;</li></ul>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="a6f8f5d1c92f447bd868a841ad1a33cb1"><a name="a6f8f5d1c92f447bd868a841ad1a33cb1"></a><a name="a6f8f5d1c92f447bd868a841ad1a33cb1"></a>0px 0px</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><a name="ul1590812103363"></a><a name="ul1590812103363"></a><ul id="ul1590812103363"><li>Using keywords: If only one keyword is specified, the other value is <strong id="b5234102011540"><a name="b5234102011540"></a><a name="b5234102011540"></a>center</strong> by default. The two values define the horizontal position and vertical position, respectively.<a name="ul1453531734716"></a><a name="ul1453531734716"></a><ul id="ul1453531734716"><li><strong id="b0982111273712"><a name="b0982111273712"></a><a name="b0982111273712"></a>left</strong>: leftmost in the horizontal direction</li><li><strong id="b866713583912"><a name="b866713583912"></a><a name="b866713583912"></a>right</strong>: rightmost in the horizontal direction</li><li><strong id="b5886013193716"><a name="b5886013193716"></a><a name="b5886013193716"></a>top</strong>: top in the vertical direction</li><li><strong id="b84197142376"><a name="b84197142376"></a><a name="b84197142376"></a>bottom</strong>: bottom in the vertical direction</li><li><strong id="b14894114103710"><a name="b14894114103710"></a><a name="b14894114103710"></a>center</strong>: center position</li></ul>
</li></ul>
<a name="ul10908121023615"></a><a name="ul10908121023615"></a><ul id="ul10908121023615"><li>Using <strong id="b11401615193715"><a name="b11401615193715"></a><a name="b11401615193715"></a>&lt;length&gt;</strong>: The first value indicates the horizontal position, and the second value indicates the vertical position. <strong id="b1341381819379"><a name="b1341381819379"></a><a name="b1341381819379"></a>0 0</strong> indicates the upper left corner. The unit is pixel. If only one value is specified, the other one is <strong id="b48671516183714"><a name="b48671516183714"></a><a name="b48671516183714"></a>50%</strong>.</li><li>Using <strong id="b5492717163712"><a name="b5492717163712"></a><a name="b5492717163712"></a>&lt;percentage&gt;</strong>: The first value indicates the horizontal position, and the second value indicates the vertical position. <strong id="b164741723183712"><a name="b164741723183712"></a><a name="b164741723183712"></a>0% 0%</strong> indicates the upper left corner. <strong id="b64022245377"><a name="b64022245377"></a><a name="b64022245377"></a>100% 100%</strong> indicates the lower right corner. If only one value is specified, the other one is <strong id="b7893424163718"><a name="b7893424163718"></a><a name="b7893424163718"></a>50%</strong>.</li><li>Using both <strong id="b154811725193718"><a name="b154811725193718"></a><a name="b154811725193718"></a>&lt;percentage&gt;</strong> and <strong id="b34834254377"><a name="b34834254377"></a><a name="b34834254377"></a>&lt;length&gt;</strong>.</li></ul>
</td>
</tr>
<tr id="row1994075164514"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="p17940151124510"><a name="p17940151124510"></a><a name="p17940151124510"></a>box-shadow<sup id="sup787912854114"><a name="sup787912854114"></a><a name="sup787912854114"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="p194095154515"><a name="p194095154515"></a><a name="p194095154515"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="p169401351174518"><a name="p169401351174518"></a><a name="p169401351174518"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p15549650195115"><a name="p15549650195115"></a><a name="p15549650195115"></a>Shadow style of the current component. The value consists of the horizontal position (mandatory), vertical position (mandatory), fuzzy radius (optional, default value: <strong id="b1191123116548"><a name="b1191123116548"></a><a name="b1191123116548"></a>0</strong>), extension distance (optional, default value: <strong id="b17911331135415"><a name="b17911331135415"></a><a name="b17911331135415"></a>0</strong>), and color (optional, default value: <strong id="b2091173111540"><a name="b2091173111540"></a><a name="b2091173111540"></a>black</strong>) of the shadow.</p>
<p id="p1159519921410"><a name="p1159519921410"></a><a name="p1159519921410"></a>Syntax: <strong id="b8462151851412"><a name="b8462151851412"></a><a name="b8462151851412"></a>box-shadow:</strong><em id="i14921019151415"><a name="i14921019151415"></a><a name="i14921019151415"></a> h-shadow v-shadow blur spread color</em></p>
<p id="p1431193714518"><a name="p1431193714518"></a><a name="p1431193714518"></a>Example:</p>
<a name="ul131475255546"></a><a name="ul131475255546"></a><ul id="ul131475255546"><li>box-shadow :10px 20px 5px 10px #888888</li><li>box-shadow :100px 100px 30px red</li><li>box-shadow :-100px -100px 0px 40px</li></ul>
</td>
</tr>
<tr id="row82361948145612"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="p1823644815567"><a name="p1823644815567"></a><a name="p1823644815567"></a>filter<sup id="sup1229754054112"><a name="sup1229754054112"></a><a name="sup1229754054112"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="p92361748195619"><a name="p92361748195619"></a><a name="p92361748195619"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="p92369486566"><a name="p92369486566"></a><a name="p92369486566"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p18913655131410"><a name="p18913655131410"></a><a name="p18913655131410"></a>Radius of the blur area within the component layout. If the radius is not set, the default value <strong id="b13575134219519"><a name="b13575134219519"></a><a name="b13575134219519"></a>0</strong> (no blur area) is used. Percentage values are not supported.</p>
<p id="p52361548125619"><a name="p52361548125619"></a><a name="p52361548125619"></a>Syntax: <strong id="b15182122117599"><a name="b15182122117599"></a><a name="b15182122117599"></a>filter: blur(px)</strong></p>
<p id="p15591725115713"><a name="p15591725115713"></a><a name="p15591725115713"></a>Example:</p>
<p id="p192108318564"><a name="p192108318564"></a><a name="p192108318564"></a>filter: blur(10px)</p>
</td>
</tr>
<tr id="row673615525313"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="p1973618528317"><a name="p1973618528317"></a><a name="p1973618528317"></a>backdrop-filter<sup id="sup1384544716411"><a name="sup1384544716411"></a><a name="sup1384544716411"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="p1473620522315"><a name="p1473620522315"></a><a name="p1473620522315"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="p873645220314"><a name="p873645220314"></a><a name="p873645220314"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p31725155158"><a name="p31725155158"></a><a name="p31725155158"></a>Radius of the background blur area within the component layout. If the radius is not set, the default value <strong id="b1321710397598"><a name="b1321710397598"></a><a name="b1321710397598"></a>0</strong> (no background blur) is used. Percentage values are not supported.</p>
<p id="p208828572419"><a name="p208828572419"></a><a name="p208828572419"></a>Syntax: <strong id="b1399414367598"><a name="b1399414367598"></a><a name="b1399414367598"></a>backdrop-filter: blur(px)</strong></p>
<p id="p17592112545711"><a name="p17592112545711"></a><a name="p17592112545711"></a>Example:</p>
<p id="p13989132119565"><a name="p13989132119565"></a><a name="p13989132119565"></a>backdrop-filter: blur(10px)</p>
</td>
</tr>
<tr id="row48481153952"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="p1884855317520"><a name="p1884855317520"></a><a name="p1884855317520"></a>window-filter<sup id="sup8563115516412"><a name="sup8563115516412"></a><a name="sup8563115516412"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="p8848353958"><a name="p8848353958"></a><a name="p8848353958"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="p13848125320516"><a name="p13848125320516"></a><a name="p13848125320516"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p1322197103319"><a name="p1322197103319"></a><a name="p1322197103319"></a>Blur degree and style for windows within the component layout. If this style is not set, the default value <strong id="b142210712331"><a name="b142210712331"></a><a name="b142210712331"></a>0%</strong> (no blur) is used.</p>
<p id="p102252567314"><a name="p102252567314"></a><a name="p102252567314"></a>Different blur degrees and styles for multiple blur areas are not supported.</p>
<p id="p53767145333"><a name="p53767145333"></a><a name="p53767145333"></a>Available blur styles are as follows: <strong id="b8702545265"><a name="b8702545265"></a><a name="b8702545265"></a>small_light</strong> (default value), <strong id="b570294142615"><a name="b570294142615"></a><a name="b570294142615"></a>medium_light</strong>, <strong id="b177023413262"><a name="b177023413262"></a><a name="b177023413262"></a>large_light</strong>, <strong id="b18702184202618"><a name="b18702184202618"></a><a name="b18702184202618"></a>xlarge_light</strong>, <strong id="b770394102619"><a name="b770394102619"></a><a name="b770394102619"></a>small_dark</strong>, <strong id="b77034472620"><a name="b77034472620"></a><a name="b77034472620"></a>medium_dark</strong>, <strong id="b15703174162615"><a name="b15703174162615"></a><a name="b15703174162615"></a>large_dark</strong>, and <strong id="b37035419268"><a name="b37035419268"></a><a name="b37035419268"></a>xlarge_dark</strong>.</p>
<p id="p1151943883117"><a name="p1151943883117"></a><a name="p1151943883117"></a>Syn tax: <strong id="b17705123211318"><a name="b17705123211318"></a><a name="b17705123211318"></a>window-filter: blur(percent, style</strong><sup id="sup770553212318"><a name="sup770553212318"></a><a name="sup770553212318"></a>5+</sup><strong id="b127051432193111"><a name="b127051432193111"></a><a name="b127051432193111"></a>)</strong></p>
<p id="p5376111410332"><a name="p5376111410332"></a><a name="p5376111410332"></a>Example:</p>
<a name="ul1891201693"></a><a name="ul1891201693"></a><ul id="ul1891201693"><li>window-filter: blur(50%)</li><li>window-filter: blur(10%), large_light</li></ul>
<div class="note" id="note53141845133118"><a name="note53141845133118"></a><a name="note53141845133118"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p11314945143112"><a name="p11314945143112"></a><a name="p11314945143112"></a>This style is only supported on phones and tablets.</p>
</div></div>
</td>
</tr>
<tr id="rebe2f395a6c34b04be864a46ba6b10ae"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="p134581712103910"><a name="p134581712103910"></a><a name="p134581712103910"></a>opacity</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="a45185999ae584676af4c36467c2ade8b"><a name="a45185999ae584676af4c36467c2ade8b"></a><a name="a45185999ae584676af4c36467c2ade8b"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="a09ff20dda8e44794bca18c84f413d972"><a name="a09ff20dda8e44794bca18c84f413d972"></a><a name="a09ff20dda8e44794bca18c84f413d972"></a>1</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p122515161139"><a name="p122515161139"></a><a name="p122515161139"></a>Transparency of an element. The value ranges from <strong id="b1871715526385"><a name="b1871715526385"></a><a name="b1871715526385"></a>0</strong> to <strong id="b177181452103815"><a name="b177181452103815"></a><a name="b177181452103815"></a>1</strong>. The value <strong id="b13718155210380"><a name="b13718155210380"></a><a name="b13718155210380"></a>1</strong> means opaque, and <strong id="b6718152103818"><a name="b6718152103818"></a><a name="b6718152103818"></a>0</strong> means completely transparent.</p>
</td>
</tr>
<tr id="r0dd61199ee2f4b64bd93b7448bbde433"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="aeda9e2f8d8344958bf4f43d429dcb55e"><a name="aeda9e2f8d8344958bf4f43d429dcb55e"></a><a name="aeda9e2f8d8344958bf4f43d429dcb55e"></a>display</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="p1544115441446"><a name="p1544115441446"></a><a name="p1544115441446"></a>string</p>
<p id="aaaa164aa970b490fb048e5f260f1c661"><a name="aaaa164aa970b490fb048e5f260f1c661"></a><a name="aaaa164aa970b490fb048e5f260f1c661"></a></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="aa5ce61466c9847dbb7f44852338d9006"><a name="aa5ce61466c9847dbb7f44852338d9006"></a><a name="aa5ce61466c9847dbb7f44852338d9006"></a>flex</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p23704018414"><a name="p23704018414"></a><a name="p23704018414"></a>How and whether to display the box containing an element. Available values are as follows:</p>
<a name="ul12227103394916"></a><a name="ul12227103394916"></a><ul id="ul12227103394916"><li><strong id="b57468289377"><a name="b57468289377"></a><a name="b57468289377"></a>flex</strong>: flexible layout</li><li><strong id="b18887133293920"><a name="b18887133293920"></a><a name="b18887133293920"></a>none</strong>: The element is hidden.</li></ul>
</td>
</tr>
<tr id="r2260108545704aeb885aa4e3fd8cdbcb"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="aa2ed1da39c8e4ad78829712734226ab9"><a name="aa2ed1da39c8e4ad78829712734226ab9"></a><a name="aa2ed1da39c8e4ad78829712734226ab9"></a>visibility</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="p15475737486"><a name="p15475737486"></a><a name="p15475737486"></a>string</p>
<p id="aabfb0eb044194745af56c313f40e7781"><a name="aabfb0eb044194745af56c313f40e7781"></a><a name="aabfb0eb044194745af56c313f40e7781"></a></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="acaca80d4ef9a4f0d87adf92cb2d1ff9a"><a name="acaca80d4ef9a4f0d87adf92cb2d1ff9a"></a><a name="acaca80d4ef9a4f0d87adf92cb2d1ff9a"></a>visible</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p1568839154517"><a name="p1568839154517"></a><a name="p1568839154517"></a>Whether to display an element. Invisible borders occupy layout space. (To remove the borders, set the <strong id="b15844103015378"><a name="b15844103015378"></a><a name="b15844103015378"></a>display</strong> attribute to <strong id="b4845153013712"><a name="b4845153013712"></a><a name="b4845153013712"></a>none</strong>.) Available values are as follows:</p>
<a name="ul751984164920"></a><a name="ul751984164920"></a><ul id="ul751984164920"><li><strong id="b17429331133711"><a name="b17429331133711"></a><a name="b17429331133711"></a>visible</strong>: The element is visible.</li><li><strong id="b109191231193710"><a name="b109191231193710"></a><a name="b109191231193710"></a>hidden</strong>: The element is hidden but still takes up space.</li></ul>
<div class="note" id="note4549524649"><a name="note4549524649"></a><a name="note4549524649"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p25499241642"><a name="p25499241642"></a><a name="p25499241642"></a>If both <strong id="b719810016405"><a name="b719810016405"></a><a name="b719810016405"></a>visibility</strong> and <strong id="b187052264018"><a name="b187052264018"></a><a name="b187052264018"></a>display</strong> are set, only <strong id="b107788924011"><a name="b107788924011"></a><a name="b107788924011"></a>display</strong> takes effect.</p>
</div></div>
</td>
</tr>
<tr id="r92a9fc54538249b5828980638c60071b"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="ad74a6a48aca7439e9344c18c26b4177e"><a name="ad74a6a48aca7439e9344c18c26b4177e"></a><a name="ad74a6a48aca7439e9344c18c26b4177e"></a>flex</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="a2e6e5192a1534872be5fcfd9f83e3fdc"><a name="a2e6e5192a1534872be5fcfd9f83e3fdc"></a><a name="a2e6e5192a1534872be5fcfd9f83e3fdc"></a>number | string</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="a8512eda38e25410685be8a8992890257"><a name="a8512eda38e25410685be8a8992890257"></a><a name="a8512eda38e25410685be8a8992890257"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="a11c317cdfa7d4066878d86c6b3bcbd82"><a name="a11c317cdfa7d4066878d86c6b3bcbd82"></a><a name="a11c317cdfa7d4066878d86c6b3bcbd82"></a>How to divide available space of the parent component for a child component.</p>
<p id="p6968144051814"><a name="p6968144051814"></a><a name="p6968144051814"></a>You can set one, two<sup id="sup894453017315"><a name="sup894453017315"></a><a name="sup894453017315"></a>5+</sup>, or three<sup id="sup1255142393114"><a name="sup1255142393114"></a><a name="sup1255142393114"></a>5+</sup> values for this style.</p>
<p id="p16733313171911"><a name="p16733313171911"></a><a name="p16733313171911"></a>Set one value in either of the following ways:</p>
<a name="ul93371539192211"></a><a name="ul93371539192211"></a><ul id="ul93371539192211"><li>A unitless number to set <strong id="b152581117781"><a name="b152581117781"></a><a name="b152581117781"></a>flex-grow</strong>.</li><li>A valid width value<sup id="sup133014373318"><a name="sup133014373318"></a><a name="sup133014373318"></a>5+</sup> to set <strong id="b182101331199"><a name="b182101331199"></a><a name="b182101331199"></a>flex-basis</strong>.</li></ul>
<p id="p6786171632018"><a name="p6786171632018"></a><a name="p6786171632018"></a>Set two values<sup id="sup39514502313"><a name="sup39514502313"></a><a name="sup39514502313"></a>5+</sup> in the following ways:</p>
<p id="p6400429122011"><a name="p6400429122011"></a><a name="p6400429122011"></a>The first value must be a unitless number used to set <strong id="b171516283129"><a name="b171516283129"></a><a name="b171516283129"></a>flex-grow</strong>. The second value must be either of the following:</p>
<a name="ul767043502219"></a><a name="ul767043502219"></a><ul id="ul767043502219"><li>A unitless number to set <strong id="b1428375141313"><a name="b1428375141313"></a><a name="b1428375141313"></a>flex-shrink</strong>.</li><li>A valid width value to set <strong id="b1632495651416"><a name="b1632495651416"></a><a name="b1632495651416"></a>flex-basis</strong>.</li></ul>
<p id="p748416351217"><a name="p748416351217"></a><a name="p748416351217"></a>Set three values<sup id="sup168671312151514"><a name="sup168671312151514"></a><a name="sup168671312151514"></a>5+</sup> in the following ways:</p>
<p id="p7373204832111"><a name="p7373204832111"></a><a name="p7373204832111"></a>The first value must be a unitless number used to set <strong id="b19419131221612"><a name="b19419131221612"></a><a name="b19419131221612"></a>flex-grow</strong>. The second value must be a unitless number used to set <strong id="b19378733181612"><a name="b19378733181612"></a><a name="b19378733181612"></a>flex-shrink</strong>. The third value must be a valid width value used to set <strong id="b47717118176"><a name="b47717118176"></a><a name="b47717118176"></a>flex-basis</strong>.</p>
<div class="note" id="note34891253201520"><a name="note34891253201520"></a><a name="note34891253201520"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p1248915538152"><a name="p1248915538152"></a><a name="p1248915538152"></a>This style takes effect only when the container is any of the following components: <strong id="b17156153131"><a name="b17156153131"></a><a name="b17156153131"></a>&lt;div&gt;</strong>, <strong id="b1201415151311"><a name="b1201415151311"></a><a name="b1201415151311"></a>&lt;list-item&gt;</strong>, <strong id="b72031515132"><a name="b72031515132"></a><a name="b72031515132"></a>&lt;refresh&gt;</strong>, <strong id="b1920131551310"><a name="b1920131551310"></a><a name="b1920131551310"></a>&lt;stepper-item&gt;</strong><sup id="sup17201815121317"><a name="sup17201815121317"></a><a name="sup17201815121317"></a>5+</sup>, and <strong id="b2211915121313"><a name="b2211915121313"></a><a name="b2211915121313"></a>&lt;tabs&gt;</strong>.</p>
</div></div>
</td>
</tr>
<tr id="r5f813e3521f94c6e995388e103618445"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="a5d88cacaaf5c4f6a87390ab916b695c6"><a name="a5d88cacaaf5c4f6a87390ab916b695c6"></a><a name="a5d88cacaaf5c4f6a87390ab916b695c6"></a>flex-grow</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="a2c379e3af283446da446f1631e572efd"><a name="a2c379e3af283446da446f1631e572efd"></a><a name="a2c379e3af283446da446f1631e572efd"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="aa374f6c7415a4ee48a06930d76c55be7"><a name="aa374f6c7415a4ee48a06930d76c55be7"></a><a name="aa374f6c7415a4ee48a06930d76c55be7"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p4437122419557"><a name="p4437122419557"></a><a name="p4437122419557"></a>How much a child component will grow. The value specifies allocation of the remaining space on the main axis of the parent component. Size of available space = Container size - Total size of all child components. Value <strong id="b1682343583716"><a name="b1682343583716"></a><a name="b1682343583716"></a>0</strong> indicates that the child component does not grow.</p>
<div class="note" id="note201231734212"><a name="note201231734212"></a><a name="note201231734212"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p184555314553"><a name="p184555314553"></a><a name="p184555314553"></a>This style takes effect only when the container is any of the following components: <strong id="b18575165615499"><a name="b18575165615499"></a><a name="b18575165615499"></a>&lt;div&gt;</strong>, <strong id="b8575165618495"><a name="b8575165618495"></a><a name="b8575165618495"></a>&lt;list-item&gt;</strong>, <strong id="b125751756164917"><a name="b125751756164917"></a><a name="b125751756164917"></a>&lt;refresh&gt;</strong>, <strong id="b15751456104920"><a name="b15751456104920"></a><a name="b15751456104920"></a>&lt;stepper-item&gt;</strong><sup id="sup257595611492"><a name="sup257595611492"></a><a name="sup257595611492"></a>5+</sup>, and <strong id="b55761856114912"><a name="b55761856114912"></a><a name="b55761856114912"></a>&lt;tabs&gt;</strong>.</p>
</div></div>
</td>
</tr>
<tr id="r61282e986a5f4475a63704a514097c62"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="ac65ef7e2b1f24a13b09c495f643168c9"><a name="ac65ef7e2b1f24a13b09c495f643168c9"></a><a name="ac65ef7e2b1f24a13b09c495f643168c9"></a>flex-shrink</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="a98e7d367f0e649699892ae5bad6ade37"><a name="a98e7d367f0e649699892ae5bad6ade37"></a><a name="a98e7d367f0e649699892ae5bad6ade37"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="a422d978368814d12a33201cb839060ee"><a name="a422d978368814d12a33201cb839060ee"></a><a name="a422d978368814d12a33201cb839060ee"></a>1</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="ab032342dfe56460ca742800de482ca0f"><a name="ab032342dfe56460ca742800de482ca0f"></a><a name="ab032342dfe56460ca742800de482ca0f"></a>How much a child component will shrink. The shrink occurs only when the sum of default child component widths is greater than that of the parent component. Value <strong id="b783242395"><a name="b783242395"></a><a name="b783242395"></a>0</strong> indicates that the child component does not shrink.</p>
<div class="note" id="note147160917217"><a name="note147160917217"></a><a name="note147160917217"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p844914328577"><a name="p844914328577"></a><a name="p844914328577"></a>This style takes effect only when the container is any of the following components: <strong id="b1168212543127"><a name="b1168212543127"></a><a name="b1168212543127"></a>&lt;div&gt;</strong>, <strong id="b76821454121211"><a name="b76821454121211"></a><a name="b76821454121211"></a>&lt;list-item&gt;</strong>, <strong id="b1168255411126"><a name="b1168255411126"></a><a name="b1168255411126"></a>&lt;refresh&gt;</strong>, <strong id="b10682155415120"><a name="b10682155415120"></a><a name="b10682155415120"></a>&lt;stepper-item&gt;</strong><sup id="sup10683145491215"><a name="sup10683145491215"></a><a name="sup10683145491215"></a>5+</sup>, and <strong id="b1868385461211"><a name="b1868385461211"></a><a name="b1868385461211"></a>&lt;tabs&gt;</strong>.</p>
</div></div>
</td>
</tr>
<tr id="r7758e3a4a5934e188ff90936ec9de163"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="a82c323a994634032963169eeee1a55e4"><a name="a82c323a994634032963169eeee1a55e4"></a><a name="a82c323a994634032963169eeee1a55e4"></a>flex-basis</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="p1148910787"><a name="p1148910787"></a><a name="p1148910787"></a>&lt;length&gt;</p>
<p id="a43613cf0c2184c0d8b44e8d292f6edb7"><a name="a43613cf0c2184c0d8b44e8d292f6edb7"></a><a name="a43613cf0c2184c0d8b44e8d292f6edb7"></a></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="ab9e1c7dc25f840e58993af05c1d32109"><a name="ab9e1c7dc25f840e58993af05c1d32109"></a><a name="ab9e1c7dc25f840e58993af05c1d32109"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="a0993ef9b0ef64785a76e6310dd834f09"><a name="a0993ef9b0ef64785a76e6310dd834f09"></a><a name="a0993ef9b0ef64785a76e6310dd834f09"></a>Initial length of the flex item on the main axis.</p>
<div class="note" id="note62848141222"><a name="note62848141222"></a><a name="note62848141222"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p16711745115718"><a name="p16711745115718"></a><a name="p16711745115718"></a>This style takes effect only when the container is any of the following components: <strong id="b18795155631219"><a name="b18795155631219"></a><a name="b18795155631219"></a>&lt;div&gt;</strong>, <strong id="b107951056121217"><a name="b107951056121217"></a><a name="b107951056121217"></a>&lt;list-item&gt;</strong>, <strong id="b2795105619128"><a name="b2795105619128"></a><a name="b2795105619128"></a>&lt;refresh&gt;</strong>, <strong id="b1579510564126"><a name="b1579510564126"></a><a name="b1579510564126"></a>&lt;stepper-item&gt;</strong><sup id="sup187953565122"><a name="sup187953565122"></a><a name="sup187953565122"></a>5+</sup>, and <strong id="b11796456201211"><a name="b11796456201211"></a><a name="b11796456201211"></a>&lt;tabs&gt;</strong>.</p>
</div></div>
</td>
</tr>
<tr id="row68521132124719"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="p1852163211475"><a name="p1852163211475"></a><a name="p1852163211475"></a>align-self<sup id="sup188874714717"><a name="sup188874714717"></a><a name="sup188874714717"></a>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="p1853113211479"><a name="p1853113211479"></a><a name="p1853113211479"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="p15208521144814"><a name="p15208521144814"></a><a name="p15208521144814"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p18535328478"><a name="p18535328478"></a><a name="p18535328478"></a>Alignment mode on the cross axis of the parent element. This style overwrites the align-items style of the parent element. The align-items style is used only in the div and list styles of the parent container. Text alignment mode. Available values include:</p>
<a name="ul16801138134811"></a><a name="ul16801138134811"></a><ul id="ul16801138134811"><li><strong id="b83231255613"><a name="b83231255613"></a><a name="b83231255613"></a>stretch</strong>: Items are stretched to the same height or width as the container in the cross axis direction.</li><li><strong id="b63541297143"><a name="b63541297143"></a><a name="b63541297143"></a>flex-start</strong>: Items are aligned to the start of the cross axis.</li><li><strong id="b08443191414"><a name="b08443191414"></a><a name="b08443191414"></a>flex-end</strong>: Items are aligned to the end of the cross axis.</li><li><strong id="b164481932161412"><a name="b164481932161412"></a><a name="b164481932161412"></a>center</strong>: Items are aligned in the middle of the cross axis.</li><li><strong id="b1294619482035"><a name="b1294619482035"></a><a name="b1294619482035"></a>baseline</strong>: Items are aligned on the peracross axis.</li></ul>
</td>
</tr>
<tr id="r873309c7368d4074bbd6048bf6f7d8b6"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="a50180d720a374549ae72c848e53320cb"><a name="a50180d720a374549ae72c848e53320cb"></a><a name="a50180d720a374549ae72c848e53320cb"></a>position</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="a63672ed9a4c040f7a6ec9c8089b79bb6"><a name="a63672ed9a4c040f7a6ec9c8089b79bb6"></a><a name="a63672ed9a4c040f7a6ec9c8089b79bb6"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="a2666820c71eb420485e4d20e55b4eabe"><a name="a2666820c71eb420485e4d20e55b4eabe"></a><a name="a2666820c71eb420485e4d20e55b4eabe"></a>relative</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="ae28abf4e47a740efbd45a8f280577912"><a name="ae28abf4e47a740efbd45a8f280577912"></a><a name="ae28abf4e47a740efbd45a8f280577912"></a>Positioning type of an element. Dynamic changes are not supported.</p>
<a name="ul17185232185014"></a><a name="ul17185232185014"></a><ul id="ul17185232185014"><li><strong id="b1894911155394"><a name="b1894911155394"></a><a name="b1894911155394"></a>fixed</strong>: The element is positioned related to the browser window.</li><li><strong id="b823115152390"><a name="b823115152390"></a><a name="b823115152390"></a>absolute</strong>: The element is positioned absolutely to its parent element.</li><li><strong id="b736151417395"><a name="b736151417395"></a><a name="b736151417395"></a>relative</strong>: The element is positioned relative to its normal position.</li></ul>
<div class="note" id="note167617191219"><a name="note167617191219"></a><a name="note167617191219"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p1839092815101"><a name="p1839092815101"></a><a name="p1839092815101"></a>The <strong id="b13941713133910"><a name="b13941713133910"></a><a name="b13941713133910"></a>absolute</strong> attribute takes effect only when the parent component is <strong id="b1099913173916"><a name="b1099913173916"></a><a name="b1099913173916"></a>&lt;div&gt;</strong> or <strong id="b181001413123919"><a name="b181001413123919"></a><a name="b181001413123919"></a>&lt;stack&gt;</strong>.</p>
</div></div>
</td>
</tr>
<tr id="r134d69553376475c9aada631cc431396"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="a70405cb9696b4329ac7625af93310018"><a name="a70405cb9696b4329ac7625af93310018"></a><a name="a70405cb9696b4329ac7625af93310018"></a>[left|top<span id="ph14927143614712"><a name="ph14927143614712"></a><a name="ph14927143614712"></a>|right|bottom</span>]</p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="p1849062221214"><a name="p1849062221214"></a><a name="p1849062221214"></a>&lt;length&gt; | &lt;percentage&gt;<sup id="sup780503811531"><a name="sup780503811531"></a><a name="sup780503811531"></a>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="a579ac7c03d1d46758ebaacd565d86ed3"><a name="a579ac7c03d1d46758ebaacd565d86ed3"></a><a name="a579ac7c03d1d46758ebaacd565d86ed3"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="a9a662a62cd9b40eaa0cb9ca082b6d1c2"><a name="a9a662a62cd9b40eaa0cb9ca082b6d1c2"></a><a name="a9a662a62cd9b40eaa0cb9ca082b6d1c2"></a><strong id="b481348173914"><a name="b481348173914"></a><a name="b481348173914"></a>left|top</strong><span id="ph4818118173914"><a name="ph4818118173914"></a><a name="ph4818118173914"></a><strong id="b68143833912"><a name="b68143833912"></a><a name="b68143833912"></a>|right|bottom</strong></span> must be used together with <strong id="b881916818394"><a name="b881916818394"></a><a name="b881916818394"></a>position</strong> to determine the offset position of an element.</p>
<a name="ul12671003525"></a><a name="ul12671003525"></a><ul id="ul12671003525"><li>The <strong id="b885117712398"><a name="b885117712398"></a><a name="b885117712398"></a>left</strong> attribute specifies the left edge position of the element. This attribute defines the offset between the left edge of a positioned element and that of a block included in the element.</li><li>The <strong id="b65591759395"><a name="b65591759395"></a><a name="b65591759395"></a>top</strong> attribute specifies the top edge position of the element. This attribute defines the offset between the top edge of a positioned element and that of a block included in the element.</li><li>The <strong id="b179013323910"><a name="b179013323910"></a><a name="b179013323910"></a>right</strong> attribute specifies the right edge position of the element. This attribute defines the offset between the right edge of a positioned element and that of a block included in the element. </li><li>The <strong id="b77091602397"><a name="b77091602397"></a><a name="b77091602397"></a>bottom</strong> attribute specifies the bottom edge position of the element. This attribute defines the offset between the bottom edge of a positioned element and that of a block included in the element. </li></ul>
</td>
</tr>
<tr id="row3707155785514"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="p582085817554"><a name="p582085817554"></a><a name="p582085817554"></a>[start | end]<sup id="sup072040165910"><a name="sup072040165910"></a><a name="sup072040165910"></a>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="p1182055810551"><a name="p1182055810551"></a><a name="p1182055810551"></a>&lt;length&gt; | &lt;percentage&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="p18820145810555"><a name="p18820145810555"></a><a name="p18820145810555"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p3748160105710"><a name="p3748160105710"></a><a name="p3748160105710"></a><strong id="b466773714588"><a name="b466773714588"></a><a name="b466773714588"></a>start | end</strong> must be used together with <strong id="b18674173720587"><a name="b18674173720587"></a><a name="b18674173720587"></a>position</strong> to determine the offset of an element.</p>
<a name="ul177495065715"></a><a name="ul177495065715"></a><ul id="ul177495065715"><li>The <strong id="b118319333592"><a name="b118319333592"></a><a name="b118319333592"></a>start</strong> attribute specifies the start edge position of the element. This attribute defines the offset between the start edge of a positioned element and that of a block included in the element.</li><li>The <strong id="b20190832110"><a name="b20190832110"></a><a name="b20190832110"></a>end</strong> attribute specifies the end edge position of the element. This attribute defines the offset between the end edge of a positioned element and that of a block included in the element.</li></ul>
</td>
</tr>
<tr id="row18741629184812"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="p183768265013"><a name="p183768265013"></a><a name="p183768265013"></a>z-index<sup id="sup47906591838"><a name="sup47906591838"></a><a name="sup47906591838"></a>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="p33757225014"><a name="p33757225014"></a><a name="p33757225014"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="p2037472185010"><a name="p2037472185010"></a><a name="p2037472185010"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p235472205018"><a name="p235472205018"></a><a name="p235472205018"></a>Rendering sequence of child nodes under the same parent node. The larger the value is, the later the rendering data is.</p>
<div class="note" id="note2062416595525"><a name="note2062416595525"></a><a name="note2062416595525"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p1862510596524"><a name="p1862510596524"></a><a name="p1862510596524"></a>z-index does not support auto, and other styles such as opacity do not affect the rendering sequence of z-index.</p>
</div></div>
</td>
</tr>
<tr id="row81981557165511"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="p201997571556"><a name="p201997571556"></a><a name="p201997571556"></a>image-fill<sup id="sup173048147917"><a name="sup173048147917"></a><a name="sup173048147917"></a>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="p12199165718558"><a name="p12199165718558"></a><a name="p12199165718558"></a>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="p15199105785518"><a name="p15199105785518"></a><a name="p15199105785518"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p819913575558"><a name="p819913575558"></a><a name="p819913575558"></a>Indicates the fill color for SVG images. The following components (and attributes) are supported: <strong id="b1762209242"><a name="b1762209242"></a><a name="b1762209242"></a>button</strong> (icon attribute), <strong id="b54348111246"><a name="b54348111246"></a><a name="b54348111246"></a>piece</strong> (icon attribute), <strong id="b1012610147412"><a name="b1012610147412"></a><a name="b1012610147412"></a>search</strong> (icon attribute), <strong id="b1820351718410"><a name="b1820351718410"></a><a name="b1820351718410"></a>input</strong> (headericon attribute), <strong id="b7501920640"><a name="b7501920640"></a><a name="b7501920640"></a>textarea</strong> (headericon attribute), and <strong id="b713010283412"><a name="b713010283412"></a><a name="b713010283412"></a>image</strong> (src attribute), and <strong id="b136173555"><a name="b136173555"></a><a name="b136173555"></a>toolbar-item</strong> (icon attribute).</p>
<p id="p10159166173611"><a name="p10159166173611"></a><a name="p10159166173611"></a>The <strong id="b75579543717"><a name="b75579543717"></a><a name="b75579543717"></a>fill</strong> color value in the SVG image file is replaced with the value of <strong id="b1929418161085"><a name="b1929418161085"></a><a name="b1929418161085"></a>image-fill</strong> during rendering, and is valid only for the fill attribute that is declared in the SVG image.</p>
</td>
</tr>
<tr id="row1123215188489"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="p82332182487"><a name="p82332182487"></a><a name="p82332182487"></a>clip-path<sup id="sup72421215138"><a name="sup72421215138"></a><a name="sup72421215138"></a>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="p823311817485"><a name="p823311817485"></a><a name="p823311817485"></a>[ &lt;geometry-box&gt; || &lt;basic-shape&gt; ] | none</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="p12330183481"><a name="p12330183481"></a><a name="p12330183481"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p3233818114810"><a name="p3233818114810"></a><a name="p3233818114810"></a>Clip area of a component. Only the content within this area is displayed.</p>
<p id="p154319832714"><a name="p154319832714"></a><a name="p154319832714"></a><strong id="b4127241205410"><a name="b4127241205410"></a><a name="b4127241205410"></a>&lt;geometry-box&gt;</strong>: applicable scope of the clip area's width and height. The default value is <strong id="b1385554719580"><a name="b1385554719580"></a><a name="b1385554719580"></a>border-box</strong>. Available values include:</p>
<a name="ul17350142316276"></a><a name="ul17350142316276"></a><ul id="ul17350142316276"><li><strong id="b1768919150919"><a name="b1768919150919"></a><a name="b1768919150919"></a>margin-box</strong>: The width and height includes the margin.</li><li><strong id="b69741730917"><a name="b69741730917"></a><a name="b69741730917"></a>border-box</strong>: The width and height includes the border.</li><li><strong id="b5798204310116"><a name="b5798204310116"></a><a name="b5798204310116"></a>padding-box</strong>: The width and height includes the padding.</li><li><strong id="b35961231724"><a name="b35961231724"></a><a name="b35961231724"></a>content-box</strong>: The width and height does not include any margin, border, or padding.</li></ul>
<p id="p27639253501"><a name="p27639253501"></a><a name="p27639253501"></a><strong id="b183113521102"><a name="b183113521102"></a><a name="b183113521102"></a>&lt;basic-shape&gt;</strong>: shape of the clip area. Available values include:</p>
<a name="ul1217191102613"></a><a name="ul1217191102613"></a><ul id="ul1217191102613"><li><strong id="b77761644121114"><a name="b77761644121114"></a><a name="b77761644121114"></a>inset</strong>, in the format of inset( &lt;percentage&gt;{1,4} [ round &lt;'border-radius'&gt; ]? ).</li><li><strong id="b1777113712123"><a name="b1777113712123"></a><a name="b1777113712123"></a>circle</strong>, in the format of circle( [&amp;lt;percentage&amp;gt;]? [ at &lt;percentage&gt; &lt;percentage&gt; ]? ).</li><li><strong id="b9872444171217"><a name="b9872444171217"></a><a name="b9872444171217"></a>ellipse</strong>, in the format of ellipse([&amp;lt;percentage&amp;gt;{2}]? [ at &lt;percentage&gt; &lt;percentage&gt; ]? ).</li><li><strong id="b20483410139"><a name="b20483410139"></a><a name="b20483410139"></a>polygon</strong>, in the format of polygon( [ &lt;percentage&gt;&lt;percentage&gt;]# )</li><li><strong id="b1395604611137"><a name="b1395604611137"></a><a name="b1395604611137"></a>path</strong>, in the format of path( &lt;string&gt; ).</li></ul>
</td>
</tr>
<tr id="row1142541162310"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="p1442631102316"><a name="p1442631102316"></a><a name="p1442631102316"></a>mask-image<sup id="sup39819127293"><a name="sup39819127293"></a><a name="sup39819127293"></a>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><a name="ul1679352103015"></a><a name="ul1679352103015"></a><ul id="ul1679352103015"><li>&lt;linear-gradient&gt;</li><li>string</li></ul>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="p144260132315"><a name="p144260132315"></a><a name="p144260132315"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p142619115239"><a name="p142619115239"></a><a name="p142619115239"></a>Image used for the mask of a component:</p>
<p id="p19331162103919"><a name="p19331162103919"></a><a name="p19331162103919"></a>Gradient color mask, for example:</p>
<p id="p73311427390"><a name="p73311427390"></a><a name="p73311427390"></a><strong id="b09779722617"><a name="b09779722617"></a><a name="b09779722617"></a>linear-gradient(to left, black, white)</strong></p>
<p id="p183310263912"><a name="p183310263912"></a><a name="p183310263912"></a>Solid color mask, for example:</p>
<p id="p143319223910"><a name="p143319223910"></a><a name="p143319223910"></a><strong id="b154221931264"><a name="b154221931264"></a><a name="b154221931264"></a>linear-gradient(to right, grey , grey)</strong></p>
<p id="p1933119218398"><a name="p1933119218398"></a><a name="p1933119218398"></a>Mask filled by a local SVG image, for example, <strong id="b18353259122517"><a name="b18353259122517"></a><a name="b18353259122517"></a>url(common/mask.svg)</strong></p>
</td>
</tr>
<tr id="row1620144617234"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="p19620146162316"><a name="p19620146162316"></a><a name="p19620146162316"></a>mask-size<sup id="sup19969212192918"><a name="sup19969212192918"></a><a name="sup19969212192918"></a>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><a name="ul16293555102918"></a><a name="ul16293555102918"></a><ul id="ul16293555102918"><li>string</li><li>&lt;length&gt;&lt;length&gt;</li><li>&lt;percentage&gt; &lt;percentage&gt;</li></ul>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="p2620154652312"><a name="p2620154652312"></a><a name="p2620154652312"></a>auto</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p265717128307"><a name="p265717128307"></a><a name="p265717128307"></a>Display size of the mask image. The setting is valid only when <strong id="b1032933892617"><a name="b1032933892617"></a><a name="b1032933892617"></a>mask-image</strong> is set to an image source.</p>
<p id="p7530122117243"><a name="p7530122117243"></a><a name="p7530122117243"></a>The <strong id="b2085671213"><a name="b2085671213"></a><a name="b2085671213"></a>string</strong> values are as follows:</p>
<a name="ul484762411309"></a><a name="ul484762411309"></a><ul id="ul484762411309"><li><strong id="b391273188"><a name="b391273188"></a><a name="b391273188"></a>contain</strong>: Expands the image to the maximum size so that the height and width of the image are applicable to the content area.</li><li><strong id="b7163163515273"><a name="b7163163515273"></a><a name="b7163163515273"></a>cover</strong>: Extends the image to a large enough size so that it completely covers the background area. Some parts of the image may not be displayed in the background area.</li><li><strong id="b1729290050"><a name="b1729290050"></a><a name="b1729290050"></a>auto</strong>: The original image width-height ratio is retained.</li></ul>
<p id="p753017210249"><a name="p753017210249"></a><a name="p753017210249"></a><strong id="b19788050192816"><a name="b19788050192816"></a><a name="b19788050192816"></a>length</strong> indicates the width and height of the image. The first value indicates the width, and the second value indicates the height. If you only set one value, the other value is set to <strong id="b185086440"><a name="b185086440"></a><a name="b185086440"></a>auto</strong> by default.</p>
<p id="p13530162192416"><a name="p13530162192416"></a><a name="p13530162192416"></a>When you set the width and height with percentage values, the image size is set in relative to the original size. The first value indicates the width, and the second value indicates the height. If you only set one value, the other value is set to <strong id="b1055529362"><a name="b1055529362"></a><a name="b1055529362"></a>auto</strong> by default.</p>
</td>
</tr>
<tr id="row208901544153013"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="p128908448305"><a name="p128908448305"></a><a name="p128908448305"></a>mask-position<sup id="sup1836916162918"><a name="sup1836916162918"></a><a name="sup1836916162918"></a>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><a name="ul234618590304"></a><a name="ul234618590304"></a><ul id="ul234618590304"><li>string string</li><li>&lt;length&gt; &lt;length&gt;</li><li>&lt;percentage&gt; &lt;percentage&gt;</li></ul>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="p1389084413010"><a name="p1389084413010"></a><a name="p1389084413010"></a>0px 0px</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p563114246318"><a name="p563114246318"></a><a name="p563114246318"></a>Display position of the mask image. The setting is valid only when <strong id="b13358144513357"><a name="b13358144513357"></a><a name="b13358144513357"></a>mask-image</strong> is set to an image source. Using keywords: If only one keyword is specified, the other value is <strong id="b105241458193513"><a name="b105241458193513"></a><a name="b105241458193513"></a>center</strong> by default. The two values define the horizontal position and vertical position, respectively.</p>
<p id="p158151314323"><a name="p158151314323"></a><a name="p158151314323"></a>The <strong id="b861584379"><a name="b861584379"></a><a name="b861584379"></a>string</strong> values are as follows:</p>
<a name="ul1565191933217"></a><a name="ul1565191933217"></a><ul id="ul1565191933217"><li><strong id="b591765073"><a name="b591765073"></a><a name="b591765073"></a>left</strong>: leftmost in the horizontal direction</li><li><strong id="b897142379"><a name="b897142379"></a><a name="b897142379"></a>right</strong>: rightmost in the horizontal direction</li><li><strong id="b1124433502"><a name="b1124433502"></a><a name="b1124433502"></a>top</strong>: top in the vertical direction</li><li><strong id="b122147172"><a name="b122147172"></a><a name="b122147172"></a>bottom</strong>: bottom in the vertical direction</li><li><strong id="b914922060"><a name="b914922060"></a><a name="b914922060"></a>center</strong>: center position</li></ul>
<p id="p8631192415319"><a name="p8631192415319"></a><a name="p8631192415319"></a>Using <strong id="b1876850390"><a name="b1876850390"></a><a name="b1876850390"></a>&lt;length&gt;</strong>: The first value indicates the horizontal position, and the second value indicates the vertical position. <strong id="b1831195789"><a name="b1831195789"></a><a name="b1831195789"></a>0 0</strong> indicates the upper left corner. The unit is pixel. If only one value is specified, the other one is <strong id="b291016666"><a name="b291016666"></a><a name="b291016666"></a>50%</strong>.</p>
<p id="p4632424173116"><a name="p4632424173116"></a><a name="p4632424173116"></a>Using <strong id="b185878292"><a name="b185878292"></a><a name="b185878292"></a>&lt;percentage&gt;</strong>: The first value indicates the horizontal position, and the second value indicates the vertical position. <strong id="b287473450"><a name="b287473450"></a><a name="b287473450"></a>0% 0%</strong> indicates the upper left corner. <strong id="b915504617"><a name="b915504617"></a><a name="b915504617"></a>100% 100%</strong> indicates the lower right corner. If only one value is specified, the other one is <strong id="b2068933501"><a name="b2068933501"></a><a name="b2068933501"></a>50%</strong>.</p>
<p id="p6632122443117"><a name="p6632122443117"></a><a name="p6632122443117"></a>Using both <strong id="b1519987723"><a name="b1519987723"></a><a name="b1519987723"></a>&lt;percentage&gt;</strong> and <strong id="b1528837690"><a name="b1528837690"></a><a name="b1528837690"></a>&lt;length&gt;</strong>.</p>
</td>
</tr>
<tr id="row118287509458"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="p128281150144513"><a name="p128281150144513"></a><a name="p128281150144513"></a>border-image-source<sup id="sup19243191410013"><a name="sup19243191410013"></a><a name="sup19243191410013"></a>7+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="p1082816504459"><a name="p1082816504459"></a><a name="p1082816504459"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="p982805004510"><a name="p982805004510"></a><a name="p982805004510"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p1828135012459"><a name="p1828135012459"></a><a name="p1828135012459"></a>Border image of the specified element.</p>
<p id="p186361230114613"><a name="p186361230114613"></a><a name="p186361230114613"></a>Example:</p>
<p id="p16361430134618"><a name="p16361430134618"></a><a name="p16361430134618"></a>border-image-source: url("/common/images/border.png")</p>
</td>
</tr>
<tr id="row15772115124718"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="p1177295194716"><a name="p1177295194716"></a><a name="p1177295194716"></a>border-image-slice<sup id="sup1452910163014"><a name="sup1452910163014"></a><a name="sup1452910163014"></a>7+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="p107724516472"><a name="p107724516472"></a><a name="p107724516472"></a>&lt;length&gt; | &lt;percentage&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="p6772145184717"><a name="p6772145184717"></a><a name="p6772145184717"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p1077219518478"><a name="p1077219518478"></a><a name="p1077219518478"></a>Padding of the image.</p>
<p id="p10458230144817"><a name="p10458230144817"></a><a name="p10458230144817"></a>The attribute can have one to four values:</p>
<p id="p17458143094817"><a name="p17458143094817"></a><a name="p17458143094817"></a>If you set only one value, it specifies the padding for four sides.</p>
<p id="p74581930134818"><a name="p74581930134818"></a><a name="p74581930134818"></a>If you set two values, the first value specifies the top and bottom padding, and the second value specifies the left and right padding.</p>
<p id="p144581530114818"><a name="p144581530114818"></a><a name="p144581530114818"></a>If you set three values, the first value specifies the top padding, the second value specifies the left and right padding, and the third value specifies the bottom padding.</p>
<p id="p54581730104812"><a name="p54581730104812"></a><a name="p54581730104812"></a>If you set four values, they respectively specify the padding for top, right, bottom, and left sides (in clockwise order).</p>
</td>
</tr>
<tr id="row16936853134810"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="p69367530487"><a name="p69367530487"></a><a name="p69367530487"></a>border-image-width<sup id="sup10426101817011"><a name="sup10426101817011"></a><a name="sup10426101817011"></a>7+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="p189361653134813"><a name="p189361653134813"></a><a name="p189361653134813"></a>&lt;length&gt; | &lt;percentage&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="p1293610533481"><a name="p1293610533481"></a><a name="p1293610533481"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p19936125310481"><a name="p19936125310481"></a><a name="p19936125310481"></a>Width of the image boundary.</p>
<p id="p1975945114498"><a name="p1975945114498"></a><a name="p1975945114498"></a>If you set only one value, it specifies the width for four sides.</p>
<p id="p875917519493"><a name="p875917519493"></a><a name="p875917519493"></a>If you set two values, the first value specifies the top and bottom width, and the second value specifies the left and right width.</p>
<p id="p375975111493"><a name="p375975111493"></a><a name="p375975111493"></a>If you set three values, the first value specifies the top width, the second value specifies the left and right width, and the third value specifies the bottom width.</p>
<p id="p1767175114494"><a name="p1767175114494"></a><a name="p1767175114494"></a>If you set four values, they respectively specify the width for top, right, bottom, and left sides (in clockwise order).</p>
</td>
</tr>
<tr id="row14666115155018"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="p266619519509"><a name="p266619519509"></a><a name="p266619519509"></a>border-image-outset<sup id="sup1098614191002"><a name="sup1098614191002"></a><a name="sup1098614191002"></a>7+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="p1866635155016"><a name="p1866635155016"></a><a name="p1866635155016"></a>&lt;length&gt; | &lt;percentage&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="p1566620520503"><a name="p1566620520503"></a><a name="p1566620520503"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p766695175016"><a name="p766695175016"></a><a name="p766695175016"></a>Size of the border image that can exceed the border.</p>
<p id="p620321917512"><a name="p620321917512"></a><a name="p620321917512"></a>If you set only one value, it specifies the distance of the boarder image beyond the border on four sides.</p>
<p id="p16203119165118"><a name="p16203119165118"></a><a name="p16203119165118"></a>If you set two values, the first value specifies the distance of the boarder image's top and bottom sides beyond the boarder, and the second value specifies the distance of the boarder image's left and right sides beyond the boarder.</p>
<p id="p15203201935120"><a name="p15203201935120"></a><a name="p15203201935120"></a>If you set three values, the first value specifies the distance of the boarder image's top side beyond the boarder, the second value specifies the distance of the boarder image's left and right sides beyond the boarder, and the third value specifies the distance of the boarder image's bottom side beyond the boarder.</p>
<p id="p19203191995117"><a name="p19203191995117"></a><a name="p19203191995117"></a>If you set four values, they respectively specify the distance of the boarder image's top, right, bottom, and left sides beyond the boarder (in clockwise order).</p>
</td>
</tr>
<tr id="row1450318395541"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="p14503113925419"><a name="p14503113925419"></a><a name="p14503113925419"></a>border-image-repeat<sup id="sup205575211502"><a name="sup205575211502"></a><a name="sup205575211502"></a>7+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="p125031039135411"><a name="p125031039135411"></a><a name="p125031039135411"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="p115039397544"><a name="p115039397544"></a><a name="p115039397544"></a>stretch</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p25034393547"><a name="p25034393547"></a><a name="p25034393547"></a>How the image fills the border.</p>
<p id="p1565619515552"><a name="p1565619515552"></a><a name="p1565619515552"></a><strong id="b17135141519202"><a name="b17135141519202"></a><a name="b17135141519202"></a>stretch</strong>: stretches the image to fill the border.</p>
<p id="p1065685145518"><a name="p1065685145518"></a><a name="p1065685145518"></a><strong id="b8590723152011"><a name="b8590723152011"></a><a name="b8590723152011"></a>repeat</strong>: tiles the image to fill the border.</p>
<p id="p15656195116551"><a name="p15656195116551"></a><a name="p15656195116551"></a><strong id="b125122912014"><a name="b125122912014"></a><a name="b125122912014"></a>round</strong>: tiles the image. When the image cannot be tiled for an integer number of times, it can be scaled based on the site requirements.</p>
</td>
</tr>
<tr id="row836255814556"><td class="cellrowborder" valign="top" width="27.04270427042704%" headers="mcps1.1.5.1.1 "><p id="p536220584558"><a name="p536220584558"></a><a name="p536220584558"></a>border-image<sup id="sup13625822203"><a name="sup13625822203"></a><a name="sup13625822203"></a>7+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.402040204020402%" headers="mcps1.1.5.1.2 "><p id="p17362135835517"><a name="p17362135835517"></a><a name="p17362135835517"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="11.601160116011602%" headers="mcps1.1.5.1.3 "><p id="p736317581553"><a name="p736317581553"></a><a name="p736317581553"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="40.954095409540955%" headers="mcps1.1.5.1.4 "><p id="p636314586558"><a name="p636314586558"></a><a name="p636314586558"></a>Shorthand attribute. The options are as follows:</p>
<a name="ul192711844297"></a><a name="ul192711844297"></a><ul id="ul192711844297"><li>Attributes of the image border. The parameters include <strong id="b87661029122310"><a name="b87661029122310"></a><a name="b87661029122310"></a>border-image-source</strong>, <strong id="b5609433182310"><a name="b5609433182310"></a><a name="b5609433182310"></a>border-image-slice</strong>, <strong id="b21858391236"><a name="b21858391236"></a><a name="b21858391236"></a>border-image-width</strong>, <strong id="b124371434238"><a name="b124371434238"></a><a name="b124371434238"></a>border-image-outset</strong>, and <strong id="b1463045010235"><a name="b1463045010235"></a><a name="b1463045010235"></a>border-image-repeat</strong>, respectively meaning the padding, width of the image border, size of the border image that can exceed the border, and how the image fills the border. The default values are used if the parameters are not set.<p id="p2288416171016"><a name="p2288416171016"></a><a name="p2288416171016"></a>Syntax reference: <a href="https://developer.mozilla.org/zh-CN/docs/Web/CSS/border-image-source" target="_blank" rel="noopener noreferrer">&lt;'border-image-source'&gt;</a> <a href="https://developer.mozilla.org/zh-CN/docs/Web/CSS/Value_definition_syntax#double_bar" target="_blank" rel="noopener noreferrer">||</a> <a href="https://developer.mozilla.org/zh-CN/docs/Web/CSS/border-image-slice" target="_blank" rel="noopener noreferrer">&lt;'border-image-slice'&gt;</a> <a href="https://developer.mozilla.org/zh-CN/docs/Web/CSS/Value_definition_syntax#brackets" target="_blank" rel="noopener noreferrer">[</a> / <a href="https://developer.mozilla.org/zh-CN/docs/Web/CSS/border-image-width" target="_blank" rel="noopener noreferrer">&lt;'border-image-width'&gt;</a> <a href="https://developer.mozilla.org/zh-CN/docs/Web/CSS/Value_definition_syntax#single_bar" target="_blank" rel="noopener noreferrer">|</a> / <a href="https://developer.mozilla.org/zh-CN/docs/Web/CSS/border-image-width" target="_blank" rel="noopener noreferrer">&lt;'border-image-width'&gt;</a><a href="https://developer.mozilla.org/zh-CN/docs/Web/CSS/Value_definition_syntax#question_mark" target="_blank" rel="noopener noreferrer">?</a> / <a href="https://developer.mozilla.org/zh-CN/docs/Web/CSS/border-image-outset" target="_blank" rel="noopener noreferrer">&lt;'border-image-outset'&gt;</a> <a href="https://developer.mozilla.org/zh-CN/docs/Web/CSS/Value_definition_syntax#brackets" target="_blank" rel="noopener noreferrer">]</a><a href="https://developer.mozilla.org/zh-CN/docs/Web/CSS/Value_definition_syntax#question_mark" target="_blank" rel="noopener noreferrer">?</a> <a href="https://developer.mozilla.org/zh-CN/docs/Web/CSS/Value_definition_syntax#double_bar" target="_blank" rel="noopener noreferrer">||</a> <a href="https://developer.mozilla.org/zh-CN/docs/Web/CSS/border-image-repeat" target="_blank" rel="noopener noreferrer">&lt;'border-image-repeat'&gt;</a></p>
</li></ul>
<a name="ul13090488916"></a><a name="ul13090488916"></a><ul id="ul13090488916"><li>Gradient color border.<p id="p4219102819109"><a name="p4219102819109"></a><a name="p4219102819109"></a>Example</p>
<p id="p42198283101"><a name="p42198283101"></a><a name="p42198283101"></a>border-image: linear-gradient(red, yellow) 10px</p>
</li></ul>
</td>
</tr>
</tbody>
</table>

>![](../../public_sys-resources/icon-note.gif) **NOTE:** 
>The above-mentioned common styles are not mandatory.

