# Universal Methods<a name="EN-US_TOPIC_0000001127284884"></a>

After a component is assigned the  **id**  attribute, you can use the ID to obtain the component objects and call functions.

<a name="t16791c2761d34150a3a89954b52d1453"></a>
<table><thead align="left"><tr id="r0148773c052c4f38bef9962bc22a16bf"><th class="cellrowborder" valign="top" width="15.310000000000002%" id="mcps1.1.6.1.1"><p id="ab430207c41eb4593a9fff4377fd60b27"><a name="ab430207c41eb4593a9fff4377fd60b27"></a><a name="ab430207c41eb4593a9fff4377fd60b27"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="28.610000000000003%" id="mcps1.1.6.1.2"><p id="adadb9fe3ee9d45ab8e55fad0a56ec311"><a name="adadb9fe3ee9d45ab8e55fad0a56ec311"></a><a name="adadb9fe3ee9d45ab8e55fad0a56ec311"></a>Parameter</p>
</th>
<th class="cellrowborder" valign="top" width="8.19%" id="mcps1.1.6.1.3"><p id="p5451162571712"><a name="p5451162571712"></a><a name="p5451162571712"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="8.290000000000001%" id="mcps1.1.6.1.4"><p id="p17256161265111"><a name="p17256161265111"></a><a name="p17256161265111"></a>Return Value</p>
</th>
<th class="cellrowborder" valign="top" width="39.6%" id="mcps1.1.6.1.5"><p id="a7a0dfce144d445e19289835b2e4c8697"><a name="a7a0dfce144d445e19289835b2e4c8697"></a><a name="a7a0dfce144d445e19289835b2e4c8697"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row48146221457"><td class="cellrowborder" valign="top" width="15.310000000000002%" headers="mcps1.1.6.1.1 "><p id="p168151422164511"><a name="p168151422164511"></a><a name="p168151422164511"></a>animate</p>
<p id="p564915003620"><a name="p564915003620"></a><a name="p564915003620"></a></p>
</td>
<td class="cellrowborder" valign="top" width="28.610000000000003%" headers="mcps1.1.6.1.2 "><p id="p228224092010"><a name="p228224092010"></a><a name="p228224092010"></a>keyframes: <a href="#table1491078445">Keyframes</a>, options: <a href="#table587915341817">Options</a></p>
</td>
<td class="cellrowborder" valign="top" width="8.19%" headers="mcps1.1.6.1.3 "><p id="p108159229458"><a name="p108159229458"></a><a name="p108159229458"></a>Yes</p>
</td>
<td class="cellrowborder" valign="top" width="8.290000000000001%" headers="mcps1.1.6.1.4 "><p id="p6256112155112"><a name="p6256112155112"></a><a name="p6256112155112"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="39.6%" headers="mcps1.1.6.1.5 "><p id="p15815102244511"><a name="p15815102244511"></a><a name="p15815102244511"></a>Creates and runs an animation shortcut on the component. Specify the <strong id="b635643723719"><a name="b635643723719"></a><a name="b635643723719"></a>keyframes</strong> and <strong id="b1335713377375"><a name="b1335713377375"></a><a name="b1335713377375"></a>options</strong> required for the animation. This method returns the animation object.</p>
</td>
</tr>
<tr id="row143796917504"><td class="cellrowborder" valign="top" width="15.310000000000002%" headers="mcps1.1.6.1.1 "><p id="p10117420125016"><a name="p10117420125016"></a><a name="p10117420125016"></a>getBoundingClientRect<sup id="sup14424201005214"><a name="sup14424201005214"></a><a name="sup14424201005214"></a>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="28.610000000000003%" headers="mcps1.1.6.1.2 "><p id="p13871830115012"><a name="p13871830115012"></a><a name="p13871830115012"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="8.19%" headers="mcps1.1.6.1.3 "><p id="p163801097506"><a name="p163801097506"></a><a name="p163801097506"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="8.290000000000001%" headers="mcps1.1.6.1.4 "><p id="p82562126516"><a name="p82562126516"></a><a name="p82562126516"></a><a href="#table115553448519">Rect</a></p>
</td>
<td class="cellrowborder" valign="top" width="39.6%" headers="mcps1.1.6.1.5 "><p id="p738010925019"><a name="p738010925019"></a><a name="p738010925019"></a>Obtains the size of the element and its position relative to the window.</p>
</td>
</tr>
<tr id="row1843119299139"><td class="cellrowborder" valign="top" width="15.310000000000002%" headers="mcps1.1.6.1.1 "><p id="p64327294132"><a name="p64327294132"></a><a name="p64327294132"></a>createIntersectionObserver<sup id="sup156638422811"><a name="sup156638422811"></a><a name="sup156638422811"></a>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="28.610000000000003%" headers="mcps1.1.6.1.2 "><p id="p18432429171313"><a name="p18432429171313"></a><a name="p18432429171313"></a><a href="#table143341035121917">ObserverParam</a></p>
</td>
<td class="cellrowborder" valign="top" width="8.19%" headers="mcps1.1.6.1.3 ">&nbsp;&nbsp;</td>
<td class="cellrowborder" valign="top" width="8.290000000000001%" headers="mcps1.1.6.1.4 "><p id="p3432152915131"><a name="p3432152915131"></a><a name="p3432152915131"></a><a href="#table4259113611414">Observer</a></p>
</td>
<td class="cellrowborder" valign="top" width="39.6%" headers="mcps1.1.6.1.5 "><p id="p343212921312"><a name="p343212921312"></a><a name="p343212921312"></a>Adds an <strong id="b117332328582"><a name="b117332328582"></a><a name="b117332328582"></a>Observer</strong>, which will be notified of the changes of a component on the current page.</p>
</td>
</tr>
</tbody>
</table>

**Table  1**  Rect object description  <sup>6+</sup>

<a name="table115553448519"></a>
<table><thead align="left"><tr id="row955534419511"><th class="cellrowborder" valign="top" width="33.33333333333333%" id="mcps1.2.4.1.1"><p id="p6555544165116"><a name="p6555544165116"></a><a name="p6555544165116"></a>Attribute</p>
</th>
<th class="cellrowborder" valign="top" width="33.33333333333333%" id="mcps1.2.4.1.2"><p id="p16555194419519"><a name="p16555194419519"></a><a name="p16555194419519"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="33.33333333333333%" id="mcps1.2.4.1.3"><p id="p10555164415516"><a name="p10555164415516"></a><a name="p10555164415516"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1355564435118"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.1 "><p id="p1955544465113"><a name="p1955544465113"></a><a name="p1955544465113"></a>width</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.2 "><p id="p15555194485119"><a name="p15555194485119"></a><a name="p15555194485119"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p9555184419514"><a name="p9555184419514"></a><a name="p9555184419514"></a>Width of an element.</p>
</td>
</tr>
<tr id="row205556442517"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.1 "><p id="p655544414513"><a name="p655544414513"></a><a name="p655544414513"></a>height</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.2 "><p id="p7555134485117"><a name="p7555134485117"></a><a name="p7555134485117"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p10555044105118"><a name="p10555044105118"></a><a name="p10555044105118"></a>Height of an element.</p>
</td>
</tr>
<tr id="row1255534465119"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.1 "><p id="p95558448517"><a name="p95558448517"></a><a name="p95558448517"></a>left</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.2 "><p id="p9555944185117"><a name="p9555944185117"></a><a name="p9555944185117"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p1555144165118"><a name="p1555144165118"></a><a name="p1555144165118"></a>Offset between the left boundary of the element and the window.</p>
</td>
</tr>
<tr id="row135552447511"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.1 "><p id="p20555174465112"><a name="p20555174465112"></a><a name="p20555174465112"></a>top</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.2 "><p id="p10555544175114"><a name="p10555544175114"></a><a name="p10555544175114"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p155618445517"><a name="p155618445517"></a><a name="p155618445517"></a>Offset between the upper boundary of the element and the window.</p>
</td>
</tr>
</tbody>
</table>

**Table  2**  ObserverParam attributes<sup>6+</sup>

<a name="table143341035121917"></a>
<table><thead align="left"><tr id="row11334163521916"><th class="cellrowborder" valign="top" width="33.33333333333333%" id="mcps1.2.4.1.1"><p id="p833411354195"><a name="p833411354195"></a><a name="p833411354195"></a>Attribute</p>
</th>
<th class="cellrowborder" valign="top" width="33.33333333333333%" id="mcps1.2.4.1.2"><p id="p1233453551912"><a name="p1233453551912"></a><a name="p1233453551912"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="33.33333333333333%" id="mcps1.2.4.1.3"><p id="p173341835171912"><a name="p173341835171912"></a><a name="p173341835171912"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1633503511196"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.1 "><p id="p933518359198"><a name="p933518359198"></a><a name="p933518359198"></a>ratios</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.2 "><p id="p17335103510196"><a name="p17335103510196"></a><a name="p17335103510196"></a>Array&lt;number&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p20335113514191"><a name="p20335113514191"></a><a name="p20335113514191"></a>When the component is out of the range or is less than the range, the observer callback is triggered.</p>
</td>
</tr>
</tbody>
</table>

**Table  3**  Methods supported by the Observer object<sup>6+</sup>

<a name="table4259113611414"></a>
<table><thead align="left"><tr id="row925913612148"><th class="cellrowborder" valign="top" width="33.33333333333333%" id="mcps1.2.4.1.1"><p id="p3259336191410"><a name="p3259336191410"></a><a name="p3259336191410"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="33.33333333333333%" id="mcps1.2.4.1.2"><p id="p525920364144"><a name="p525920364144"></a><a name="p525920364144"></a>Parameter</p>
</th>
<th class="cellrowborder" valign="top" width="33.33333333333333%" id="mcps1.2.4.1.3"><p id="p1225913612148"><a name="p1225913612148"></a><a name="p1225913612148"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row32591036161415"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.1 "><p id="p1025920369145"><a name="p1025920369145"></a><a name="p1025920369145"></a>observe</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.2 "><p id="p92591636131412"><a name="p92591636131412"></a><a name="p92591636131412"></a>callback: function</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p10259236191419"><a name="p10259236191419"></a><a name="p10259236191419"></a>Subscribes to events of the observed object. The callback method is called when the value is greater than or less than the threshold.</p>
</td>
</tr>
<tr id="row725903614146"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.1 "><p id="p20259103631417"><a name="p20259103631417"></a><a name="p20259103631417"></a>unobserve</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.2 ">&nbsp;&nbsp;</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p1625953618140"><a name="p1625953618140"></a><a name="p1625953618140"></a>Unsubscribes from events of the observed object.</p>
</td>
</tr>
</tbody>
</table>

## this.$element\('_id_'\).animate\(Object, Object\)<a name="section844805134319"></a>

You can use the  **animate\(keyframes: Keyframes, options: Options\)**  method to obtain an animation object. This object supports properties, methods, and events of the animation component. If  **animate**  is called for multiple times and the replace policy is used, parameters passed to the last call will take effect.

**Table  4**  Keyframes

<a name="table1491078445"></a>
<table><thead align="left"><tr id="row159311381240"><th class="cellrowborder" valign="top" width="23.56%" id="mcps1.2.4.1.1"><p id="p79311181544"><a name="p79311181544"></a><a name="p79311181544"></a>Parameter</p>
</th>
<th class="cellrowborder" valign="top" width="23.95%" id="mcps1.2.4.1.2"><p id="p19311818417"><a name="p19311818417"></a><a name="p19311818417"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="52.49%" id="mcps1.2.4.1.3"><p id="p17931185415"><a name="p17931185415"></a><a name="p17931185415"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row993198749"><td class="cellrowborder" valign="top" width="23.56%" headers="mcps1.2.4.1.1 "><p id="p10931080410"><a name="p10931080410"></a><a name="p10931080410"></a>frames</p>
</td>
<td class="cellrowborder" valign="top" width="23.95%" headers="mcps1.2.4.1.2 "><p id="p1493113816413"><a name="p1493113816413"></a><a name="p1493113816413"></a>Array&lt;Style&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="52.49%" headers="mcps1.2.4.1.3 "><p id="p15171240102918"><a name="p15171240102918"></a><a name="p15171240102918"></a>Array of objects used to set animation style attributes. For details about style attributes, see <a href="#table29075541349">Style attributes</a>.</p>
</td>
</tr>
</tbody>
</table>

**Table  5**  Style attributes

<a name="table29075541349"></a>
<table><thead align="left"><tr id="row1961954543"><th class="cellrowborder" valign="top" width="22.91%" id="mcps1.2.5.1.1"><p id="p119614542419"><a name="p119614542419"></a><a name="p119614542419"></a>Parameter</p>
</th>
<th class="cellrowborder" valign="top" width="10.61%" id="mcps1.2.5.1.2"><p id="p2961954840"><a name="p2961954840"></a><a name="p2961954840"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="24.58%" id="mcps1.2.5.1.3"><p id="p15961145416415"><a name="p15961145416415"></a><a name="p15961145416415"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="41.9%" id="mcps1.2.5.1.4"><p id="p1196118542410"><a name="p1196118542410"></a><a name="p1196118542410"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1796113541041"><td class="cellrowborder" valign="top" width="22.91%" headers="mcps1.2.5.1.1 "><p id="p129615545417"><a name="p129615545417"></a><a name="p129615545417"></a>width</p>
</td>
<td class="cellrowborder" valign="top" width="10.61%" headers="mcps1.2.5.1.2 "><p id="p1296111541345"><a name="p1296111541345"></a><a name="p1296111541345"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="24.58%" headers="mcps1.2.5.1.3 "><p id="p296117541140"><a name="p296117541140"></a><a name="p296117541140"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="41.9%" headers="mcps1.2.5.1.4 "><p id="p1296112541247"><a name="p1296112541247"></a><a name="p1296112541247"></a>Width set for the component during playback of the animation.</p>
</td>
</tr>
<tr id="row149616548418"><td class="cellrowborder" valign="top" width="22.91%" headers="mcps1.2.5.1.1 "><p id="p14961654846"><a name="p14961654846"></a><a name="p14961654846"></a>height</p>
</td>
<td class="cellrowborder" valign="top" width="10.61%" headers="mcps1.2.5.1.2 "><p id="p1296113545416"><a name="p1296113545416"></a><a name="p1296113545416"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="24.58%" headers="mcps1.2.5.1.3 "><p id="p11462818125515"><a name="p11462818125515"></a><a name="p11462818125515"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="41.9%" headers="mcps1.2.5.1.4 "><p id="p1696216541448"><a name="p1696216541448"></a><a name="p1696216541448"></a>Height set for the component during playback of the animation.</p>
</td>
</tr>
<tr id="row1962754242"><td class="cellrowborder" valign="top" width="22.91%" headers="mcps1.2.5.1.1 "><p id="p14962145418411"><a name="p14962145418411"></a><a name="p14962145418411"></a>backgroundColor</p>
</td>
<td class="cellrowborder" valign="top" width="10.61%" headers="mcps1.2.5.1.2 "><p id="p09628541446"><a name="p09628541446"></a><a name="p09628541446"></a>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="24.58%" headers="mcps1.2.5.1.3 "><p id="p39621754042"><a name="p39621754042"></a><a name="p39621754042"></a>none</p>
</td>
<td class="cellrowborder" valign="top" width="41.9%" headers="mcps1.2.5.1.4 "><p id="p11962125420412"><a name="p11962125420412"></a><a name="p11962125420412"></a>Background color set for the component during playback of the animation.</p>
</td>
</tr>
<tr id="row99623548410"><td class="cellrowborder" valign="top" width="22.91%" headers="mcps1.2.5.1.1 "><p id="p1896216541345"><a name="p1896216541345"></a><a name="p1896216541345"></a>opacity</p>
</td>
<td class="cellrowborder" valign="top" width="10.61%" headers="mcps1.2.5.1.2 "><p id="p12409238152914"><a name="p12409238152914"></a><a name="p12409238152914"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="24.58%" headers="mcps1.2.5.1.3 "><p id="p6962354649"><a name="p6962354649"></a><a name="p6962354649"></a>1</p>
</td>
<td class="cellrowborder" valign="top" width="41.9%" headers="mcps1.2.5.1.4 "><p id="p1696275417410"><a name="p1696275417410"></a><a name="p1696275417410"></a>Opacity set for the component. The value ranges from <strong id="b76363459372"><a name="b76363459372"></a><a name="b76363459372"></a>0</strong> to <strong id="b1964116457373"><a name="b1964116457373"></a><a name="b1964116457373"></a>1</strong>.</p>
</td>
</tr>
<tr id="row6141915145917"><td class="cellrowborder" valign="top" width="22.91%" headers="mcps1.2.5.1.1 "><p id="p14778012599"><a name="p14778012599"></a><a name="p14778012599"></a>backgroundPosition</p>
</td>
<td class="cellrowborder" valign="top" width="10.61%" headers="mcps1.2.5.1.2 "><p id="p151419151591"><a name="p151419151591"></a><a name="p151419151591"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="24.58%" headers="mcps1.2.5.1.3 "><p id="p11551505916"><a name="p11551505916"></a><a name="p11551505916"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="41.9%" headers="mcps1.2.5.1.4 "><p id="p615181514596"><a name="p615181514596"></a><a name="p615181514596"></a>The value format is <strong id="b49364643719"><a name="b49364643719"></a><a name="b49364643719"></a>x y</strong>, in percentage or pixels.</p>
<p id="p74641623022"><a name="p74641623022"></a><a name="p74641623022"></a>The first value indicates the horizontal position, and the second value indicates the vertical position.</p>
<p id="p5609351927"><a name="p5609351927"></a><a name="p5609351927"></a>If only one value is specified, the other value is <strong id="b2860446193717"><a name="b2860446193717"></a><a name="b2860446193717"></a>50%</strong> by default.</p>
</td>
</tr>
<tr id="row8962754643"><td class="cellrowborder" valign="top" width="22.91%" headers="mcps1.2.5.1.1 "><p id="p7962145414417"><a name="p7962145414417"></a><a name="p7962145414417"></a>transformOrigin</p>
</td>
<td class="cellrowborder" valign="top" width="10.61%" headers="mcps1.2.5.1.2 "><p id="p896213541048"><a name="p896213541048"></a><a name="p896213541048"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="24.58%" headers="mcps1.2.5.1.3 "><p id="p169621454340"><a name="p169621454340"></a><a name="p169621454340"></a>'center center'</p>
</td>
<td class="cellrowborder" valign="top" width="41.9%" headers="mcps1.2.5.1.4 "><p id="p12962115415412"><a name="p12962115415412"></a><a name="p12962115415412"></a>Origin position of the transformed element.</p>
<p id="p193331521134020"><a name="p193331521134020"></a><a name="p193331521134020"></a>The first value indicates the x-axis position. The value can be <strong id="b20914191218395"><a name="b20914191218395"></a><a name="b20914191218395"></a>left</strong>, <strong id="b16915141233913"><a name="b16915141233913"></a><a name="b16915141233913"></a>center</strong>, <strong id="b1591571233911"><a name="b1591571233911"></a><a name="b1591571233911"></a>right</strong>, a length, or a percentage.</p>
<p id="p6457202144018"><a name="p6457202144018"></a><a name="p6457202144018"></a>The second value indicates the y-axis position. The value can be <strong id="b15935411173916"><a name="b15935411173916"></a><a name="b15935411173916"></a>top</strong>, <strong id="b994031111394"><a name="b994031111394"></a><a name="b994031111394"></a>center</strong>, <strong id="b19411111163910"><a name="b19411111163910"></a><a name="b19411111163910"></a>bottom</strong>, a length, or a percentage.</p>
</td>
</tr>
<tr id="row496214548419"><td class="cellrowborder" valign="top" width="22.91%" headers="mcps1.2.5.1.1 "><p id="p139621354144"><a name="p139621354144"></a><a name="p139621354144"></a>transform</p>
</td>
<td class="cellrowborder" valign="top" width="10.61%" headers="mcps1.2.5.1.2 "><p id="p189624543418"><a name="p189624543418"></a><a name="p189624543418"></a><a href="js-components-common-animation.md#table28802443315">Transform</a></p>
</td>
<td class="cellrowborder" valign="top" width="24.58%" headers="mcps1.2.5.1.3 "><p id="p1896218541242"><a name="p1896218541242"></a><a name="p1896218541242"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="41.9%" headers="mcps1.2.5.1.4 "><p id="p19962454547"><a name="p19962454547"></a><a name="p19962454547"></a>Transformation type set for a transformed element.</p>
</td>
</tr>
<tr id="row18717853325"><td class="cellrowborder" valign="top" width="22.91%" headers="mcps1.2.5.1.1 "><p id="p197170513218"><a name="p197170513218"></a><a name="p197170513218"></a>offset</p>
</td>
<td class="cellrowborder" valign="top" width="10.61%" headers="mcps1.2.5.1.2 "><p id="p207175553213"><a name="p207175553213"></a><a name="p207175553213"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="24.58%" headers="mcps1.2.5.1.3 "><p id="p1171719518322"><a name="p1171719518322"></a><a name="p1171719518322"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="41.9%" headers="mcps1.2.5.1.4 "><a name="ul768313101318"></a><a name="ul768313101318"></a><ul id="ul768313101318"><li>The value of <strong id="b0754154863713"><a name="b0754154863713"></a><a name="b0754154863713"></a>offset</strong> must be within (0.0,1.0] and sorted in ascending order if it is provided.</li><li>If there are only two frames, <strong id="b10139164983712"><a name="b10139164983712"></a><a name="b10139164983712"></a>offset</strong> can be left empty.</li><li>If there are more than two frames, <strong id="b1271014953717"><a name="b1271014953717"></a><a name="b1271014953717"></a>offset</strong> is mandatory.</li></ul>
</td>
</tr>
</tbody>
</table>

**Table  6**  Options

<a name="table587915341817"></a>
<table><thead align="left"><tr id="row98794371819"><th class="cellrowborder" valign="top" width="18.91%" id="mcps1.2.5.1.1"><p id="p15879539188"><a name="p15879539188"></a><a name="p15879539188"></a>Parameter</p>
</th>
<th class="cellrowborder" valign="top" width="27.54%" id="mcps1.2.5.1.2"><p id="p1487943181810"><a name="p1487943181810"></a><a name="p1487943181810"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="18.22%" id="mcps1.2.5.1.3"><p id="p178799381812"><a name="p178799381812"></a><a name="p178799381812"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="35.33%" id="mcps1.2.5.1.4"><p id="p187983181814"><a name="p187983181814"></a><a name="p187983181814"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row178790311818"><td class="cellrowborder" valign="top" width="18.91%" headers="mcps1.2.5.1.1 "><p id="p128791938181"><a name="p128791938181"></a><a name="p128791938181"></a>duration</p>
</td>
<td class="cellrowborder" valign="top" width="27.54%" headers="mcps1.2.5.1.2 "><p id="p1587911311818"><a name="p1587911311818"></a><a name="p1587911311818"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="18.22%" headers="mcps1.2.5.1.3 "><p id="p19879133161815"><a name="p19879133161815"></a><a name="p19879133161815"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="35.33%" headers="mcps1.2.5.1.4 "><p id="p108808301819"><a name="p108808301819"></a><a name="p108808301819"></a>Duration for playing the animation, in milliseconds.</p>
</td>
</tr>
<tr id="row3880839187"><td class="cellrowborder" valign="top" width="18.91%" headers="mcps1.2.5.1.1 "><p id="p1088053111812"><a name="p1088053111812"></a><a name="p1088053111812"></a>easing</p>
</td>
<td class="cellrowborder" valign="top" width="27.54%" headers="mcps1.2.5.1.2 "><p id="p588019351814"><a name="p588019351814"></a><a name="p588019351814"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="18.22%" headers="mcps1.2.5.1.3 "><p id="p188801731184"><a name="p188801731184"></a><a name="p188801731184"></a>linear</p>
</td>
<td class="cellrowborder" valign="top" width="35.33%" headers="mcps1.2.5.1.4 "><p id="p888019319181"><a name="p888019319181"></a><a name="p888019319181"></a>Time curve of the animation. For details about the supported types, see <a href="#table3690154751817">Available values of the easing attribute</a>.</p>
</td>
</tr>
<tr id="row2880833186"><td class="cellrowborder" valign="top" width="18.91%" headers="mcps1.2.5.1.1 "><p id="p1688018319186"><a name="p1688018319186"></a><a name="p1688018319186"></a>delay</p>
</td>
<td class="cellrowborder" valign="top" width="27.54%" headers="mcps1.2.5.1.2 "><p id="p1388017361816"><a name="p1388017361816"></a><a name="p1388017361816"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="18.22%" headers="mcps1.2.5.1.3 "><p id="p6880930185"><a name="p6880930185"></a><a name="p6880930185"></a>0</p>
</td>
<td class="cellrowborder" valign="top" width="35.33%" headers="mcps1.2.5.1.4 "><p id="p16880193111811"><a name="p16880193111811"></a><a name="p16880193111811"></a>Delay for the animation start. The default value indicates no delay.</p>
</td>
</tr>
<tr id="row188801316184"><td class="cellrowborder" valign="top" width="18.91%" headers="mcps1.2.5.1.1 "><p id="p158801234188"><a name="p158801234188"></a><a name="p158801234188"></a>iterations</p>
</td>
<td class="cellrowborder" valign="top" width="27.54%" headers="mcps1.2.5.1.2 "><p id="p178801430188"><a name="p178801430188"></a><a name="p178801430188"></a>number | string</p>
</td>
<td class="cellrowborder" valign="top" width="18.22%" headers="mcps1.2.5.1.3 "><p id="p138801237184"><a name="p138801237184"></a><a name="p138801237184"></a>1</p>
</td>
<td class="cellrowborder" valign="top" width="35.33%" headers="mcps1.2.5.1.4 "><p id="p1688020301816"><a name="p1688020301816"></a><a name="p1688020301816"></a>Number of times the animation will be played. <strong id="b1119019523812"><a name="b1119019523812"></a><a name="b1119019523812"></a>number</strong> indicates a fixed number of playback operations, and <strong id="b319110563816"><a name="b319110563816"></a><a name="b319110563816"></a>Infinity</strong> indicates an unlimited number of playback operations.</p>
</td>
</tr>
<tr id="row148806341814"><td class="cellrowborder" valign="top" width="18.91%" headers="mcps1.2.5.1.1 "><p id="p488083201819"><a name="p488083201819"></a><a name="p488083201819"></a>direction<sup id="sup58815331816"><a name="sup58815331816"></a><a name="sup58815331816"></a>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="27.54%" headers="mcps1.2.5.1.2 "><p id="p58811336188"><a name="p58811336188"></a><a name="p58811336188"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="18.22%" headers="mcps1.2.5.1.3 "><p id="p19881153131811"><a name="p19881153131811"></a><a name="p19881153131811"></a>normal</p>
</td>
<td class="cellrowborder" valign="top" width="35.33%" headers="mcps1.2.5.1.4 "><p id="p3881193101815"><a name="p3881193101815"></a><a name="p3881193101815"></a>Mode of playing the animation.</p>
<p id="p1588153131811"><a name="p1588153131811"></a><a name="p1588153131811"></a><strong id="b661265611817"><a name="b661265611817"></a><a name="b661265611817"></a>normal</strong>: Plays the animation in forward loop mode.</p>
<p id="p13881123111810"><a name="p13881123111810"></a><a name="p13881123111810"></a><strong id="b315117564199"><a name="b315117564199"></a><a name="b315117564199"></a>reverse</strong>: Plays the animation in reverse loop mode.</p>
<p id="p138810381815"><a name="p138810381815"></a><a name="p138810381815"></a><strong id="b01883517209"><a name="b01883517209"></a><a name="b01883517209"></a>alternate</strong>: Plays the animation in alternating loop mode. When the animation is played for an odd number of times, the playback is in forward direction. When the animation is played for an even number of times, the playback is in backward direction. </p>
<p id="p4881113131815"><a name="p4881113131815"></a><a name="p4881113131815"></a><strong id="b1122444132810"><a name="b1122444132810"></a><a name="b1122444132810"></a>alternate-reverse</strong>: Plays the animation in reverse-alternating loop mode. When the animation is played for an odd number of times, the playback is in backward direction. When the animation is played for an even number of times, the playback is in forward direction. </p>
</td>
</tr>
<tr id="row6881735184"><td class="cellrowborder" valign="top" width="18.91%" headers="mcps1.2.5.1.1 "><p id="p198818313188"><a name="p198818313188"></a><a name="p198818313188"></a>fill</p>
</td>
<td class="cellrowborder" valign="top" width="27.54%" headers="mcps1.2.5.1.2 "><p id="p6881932180"><a name="p6881932180"></a><a name="p6881932180"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="18.22%" headers="mcps1.2.5.1.3 "><p id="p1488115331818"><a name="p1488115331818"></a><a name="p1488115331818"></a>none</p>
</td>
<td class="cellrowborder" valign="top" width="35.33%" headers="mcps1.2.5.1.4 "><p id="p1688115317182"><a name="p1688115317182"></a><a name="p1688115317182"></a>Start and end styles of the animation.</p>
<p id="p8881153181813"><a name="p8881153181813"></a><a name="p8881153181813"></a><strong id="b95102196241659"><a name="b95102196241659"></a><a name="b95102196241659"></a>none</strong>: No style is applied to the target before or after the animation is executed.</p>
<p id="p1188143131812"><a name="p1188143131812"></a><a name="p1188143131812"></a><strong id="b60720248341659"><a name="b60720248341659"></a><a name="b60720248341659"></a>forwards</strong>: The target keeps the state at the end of the animation (defined in the last key frame) after the animation is executed.</p>
<p id="p5881938182"><a name="p5881938182"></a><a name="p5881938182"></a><strong id="b46810291047"><a name="b46810291047"></a><a name="b46810291047"></a>backwards</strong><sup id="sup138811738182"><a name="sup138811738182"></a><a name="sup138811738182"></a>6+</sup>: The animation uses the value defined in the first key frame during the <strong id="b835517106516"><a name="b835517106516"></a><a name="b835517106516"></a>animation-delay</strong>. When <strong id="b133698551511"><a name="b133698551511"></a><a name="b133698551511"></a>animation-direction</strong> is set to <strong id="b2327558755"><a name="b2327558755"></a><a name="b2327558755"></a>normal</strong> or <strong id="b1599365910513"><a name="b1599365910513"></a><a name="b1599365910513"></a>alternate</strong>, the value in the <strong id="b451431119612"><a name="b451431119612"></a><a name="b451431119612"></a>from</strong> key frame is used. When <strong id="b167462211565"><a name="b167462211565"></a><a name="b167462211565"></a>animation-direction</strong> is set to <strong id="b122791361617"><a name="b122791361617"></a><a name="b122791361617"></a>reverse</strong> or <strong id="b63560395611"><a name="b63560395611"></a><a name="b63560395611"></a>alternate-reverse</strong>, the value in the <strong id="b19219491061"><a name="b19219491061"></a><a name="b19219491061"></a>to</strong> key frame is used..</p>
<p id="p1788173201814"><a name="p1788173201814"></a><a name="p1788173201814"></a><strong id="b13700558762"><a name="b13700558762"></a><a name="b13700558762"></a>both</strong><sup id="sup1588111341817"><a name="sup1588111341817"></a><a name="sup1588111341817"></a>6+</sup>: The animation follows the <strong id="b693012181778"><a name="b693012181778"></a><a name="b693012181778"></a>forwards</strong> and <strong id="b991216202075"><a name="b991216202075"></a><a name="b991216202075"></a>backwards</strong> rules.</p>
</td>
</tr>
</tbody>
</table>

**Table  7**  Available values of the easing attribute

<a name="table3690154751817"></a>
<table><thead align="left"><tr id="row13690647151813"><th class="cellrowborder" valign="top" width="37.940000000000005%" id="mcps1.2.3.1.1"><p id="p3690247111819"><a name="p3690247111819"></a><a name="p3690247111819"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="62.06%" id="mcps1.2.3.1.2"><p id="p176901647121812"><a name="p176901647121812"></a><a name="p176901647121812"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row0690134712189"><td class="cellrowborder" valign="top" width="37.940000000000005%" headers="mcps1.2.3.1.1 "><p id="p269084719187"><a name="p269084719187"></a><a name="p269084719187"></a>linear</p>
</td>
<td class="cellrowborder" valign="top" width="62.06%" headers="mcps1.2.3.1.2 "><p id="p269004718188"><a name="p269004718188"></a><a name="p269004718188"></a>The animation speed keeps unchanged.</p>
</td>
</tr>
<tr id="row206901947121815"><td class="cellrowborder" valign="top" width="37.940000000000005%" headers="mcps1.2.3.1.1 "><p id="p969016479185"><a name="p969016479185"></a><a name="p969016479185"></a>ease-in</p>
</td>
<td class="cellrowborder" valign="top" width="62.06%" headers="mcps1.2.3.1.2 "><p id="p1169094710187"><a name="p1169094710187"></a><a name="p1169094710187"></a>The animation starts at a low speed. <strong id="b378417512383"><a name="b378417512383"></a><a name="b378417512383"></a>cubic-bezier(0.42, 0.0, 1.0, 1.0)</strong>.</p>
</td>
</tr>
<tr id="row11690174717183"><td class="cellrowborder" valign="top" width="37.940000000000005%" headers="mcps1.2.3.1.1 "><p id="p176901047111811"><a name="p176901047111811"></a><a name="p176901047111811"></a>ease-out</p>
</td>
<td class="cellrowborder" valign="top" width="62.06%" headers="mcps1.2.3.1.2 "><p id="p969119478180"><a name="p969119478180"></a><a name="p969119478180"></a>The animation ends at a low speed. <strong id="b715465119387"><a name="b715465119387"></a><a name="b715465119387"></a>cubic-bezier(0.0, 0.0, 0.58, 1.0)</strong>.</p>
</td>
</tr>
<tr id="row6691204712187"><td class="cellrowborder" valign="top" width="37.940000000000005%" headers="mcps1.2.3.1.1 "><p id="p1769111472182"><a name="p1769111472182"></a><a name="p1769111472182"></a>ease-in-out</p>
</td>
<td class="cellrowborder" valign="top" width="62.06%" headers="mcps1.2.3.1.2 "><p id="p6691104721812"><a name="p6691104721812"></a><a name="p6691104721812"></a>The animation starts and ends at a low speed. <strong id="b1526650183812"><a name="b1526650183812"></a><a name="b1526650183812"></a>cubic-bezier(0.42, 0.0, 0.58, 1.0)</strong>.</p>
</td>
</tr>
<tr id="row1269154713187"><td class="cellrowborder" valign="top" width="37.940000000000005%" headers="mcps1.2.3.1.1 "><p id="p116910479183"><a name="p116910479183"></a><a name="p116910479183"></a>friction</p>
</td>
<td class="cellrowborder" valign="top" width="62.06%" headers="mcps1.2.3.1.2 "><p id="p176915478186"><a name="p176915478186"></a><a name="p176915478186"></a>Damping curve, <strong id="b2065404720381"><a name="b2065404720381"></a><a name="b2065404720381"></a>cubic-bezier(0.2, 0.0, 0.2, 1.0)</strong>.</p>
</td>
</tr>
<tr id="row469134713183"><td class="cellrowborder" valign="top" width="37.940000000000005%" headers="mcps1.2.3.1.1 "><p id="p1969124717186"><a name="p1969124717186"></a><a name="p1969124717186"></a>extreme-deceleration</p>
</td>
<td class="cellrowborder" valign="top" width="62.06%" headers="mcps1.2.3.1.2 "><p id="p6691547171811"><a name="p6691547171811"></a><a name="p6691547171811"></a>Extreme deceleration curve, <strong id="b84625466389"><a name="b84625466389"></a><a name="b84625466389"></a>cubic-bezier(0.0, 0.0, 0.0, 1.0)</strong>.</p>
</td>
</tr>
<tr id="row1169113473183"><td class="cellrowborder" valign="top" width="37.940000000000005%" headers="mcps1.2.3.1.1 "><p id="p469194713185"><a name="p469194713185"></a><a name="p469194713185"></a>sharp</p>
</td>
<td class="cellrowborder" valign="top" width="62.06%" headers="mcps1.2.3.1.2 "><p id="p126915471189"><a name="p126915471189"></a><a name="p126915471189"></a>Sharp curve, <strong id="b13866045193817"><a name="b13866045193817"></a><a name="b13866045193817"></a>cubic-bezier(0.33, 0.0, 0.67, 1.0)</strong>.</p>
</td>
</tr>
<tr id="row1269174710185"><td class="cellrowborder" valign="top" width="37.940000000000005%" headers="mcps1.2.3.1.1 "><p id="p15691347171817"><a name="p15691347171817"></a><a name="p15691347171817"></a>rhythm</p>
</td>
<td class="cellrowborder" valign="top" width="62.06%" headers="mcps1.2.3.1.2 "><p id="p176921647121818"><a name="p176921647121818"></a><a name="p176921647121818"></a>Rhythm curve, <strong id="b1230104513388"><a name="b1230104513388"></a><a name="b1230104513388"></a>cubic-bezier(0.7, 0.0, 0.2, 1.0)</strong>.</p>
</td>
</tr>
<tr id="row8692847191813"><td class="cellrowborder" valign="top" width="37.940000000000005%" headers="mcps1.2.3.1.1 "><p id="p10692124741817"><a name="p10692124741817"></a><a name="p10692124741817"></a>smooth</p>
</td>
<td class="cellrowborder" valign="top" width="62.06%" headers="mcps1.2.3.1.2 "><p id="p15692347111817"><a name="p15692347111817"></a><a name="p15692347111817"></a>Smooth curve, <strong id="b8396144416387"><a name="b8396144416387"></a><a name="b8396144416387"></a>cubic-bezier(0.4, 0.0, 0.4, 1.0)</strong>.</p>
</td>
</tr>
<tr id="row569218476183"><td class="cellrowborder" valign="top" width="37.940000000000005%" headers="mcps1.2.3.1.1 "><p id="p969214710189"><a name="p969214710189"></a><a name="p969214710189"></a>cubic-bezier(x1, y1, x2, y2)</p>
</td>
<td class="cellrowborder" valign="top" width="62.06%" headers="mcps1.2.3.1.2 "><p id="p1069234714187"><a name="p1069234714187"></a><a name="p1069234714187"></a>You can customize an animation speed curve in the <strong id="b55061643143812"><a name="b55061643143812"></a><a name="b55061643143812"></a>cubic-bezier()</strong> function. The x and y values of each input parameter must be between 0 and 1.</p>
</td>
</tr>
<tr id="row1269204715181"><td class="cellrowborder" valign="top" width="37.940000000000005%" headers="mcps1.2.3.1.1 "><p id="p569284741812"><a name="p569284741812"></a><a name="p569284741812"></a>steps(number, step-position)<sup id="sup1169219475185"><a name="sup1169219475185"></a><a name="sup1169219475185"></a>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="62.06%" headers="mcps1.2.3.1.2 "><p id="p569218472189"><a name="p569218472189"></a><a name="p569218472189"></a>Step curve.</p>
<p id="p1269244713185"><a name="p1269244713185"></a><a name="p1269244713185"></a>The <strong id="b1284724173817"><a name="b1284724173817"></a><a name="b1284724173817"></a>number</strong> must be set and only an integer is supported.</p>
<p id="p8692164761815"><a name="p8692164761815"></a><a name="p8692164761815"></a><strong id="b14691366316"><a name="b14691366316"></a><a name="b14691366316"></a>step-position</strong> is optional. It can be set to <strong id="b10477736730"><a name="b10477736730"></a><a name="b10477736730"></a>start</strong> or <strong id="b147819361338"><a name="b147819361338"></a><a name="b147819361338"></a>end</strong>. The default value is <strong id="b104799365317"><a name="b104799365317"></a><a name="b104799365317"></a>end</strong>.</p>
</td>
</tr>
</tbody>
</table>

-   Return values

    Attributes supported by the animation object

    <a name="table11261733574"></a>
    <table><thead align="left"><tr id="row2029411331076"><th class="cellrowborder" valign="top" width="16.48%" id="mcps1.1.4.1.1"><p id="p629463316716"><a name="p629463316716"></a><a name="p629463316716"></a>Attribute</p>
    </th>
    <th class="cellrowborder" valign="top" width="20.46%" id="mcps1.1.4.1.2"><p id="p129411331718"><a name="p129411331718"></a><a name="p129411331718"></a>Type</p>
    </th>
    <th class="cellrowborder" valign="top" width="63.06%" id="mcps1.1.4.1.3"><p id="p11294123317716"><a name="p11294123317716"></a><a name="p11294123317716"></a>Description</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="row1429417331711"><td class="cellrowborder" valign="top" width="16.48%" headers="mcps1.1.4.1.1 "><p id="p1429416331375"><a name="p1429416331375"></a><a name="p1429416331375"></a>finished</p>
    </td>
    <td class="cellrowborder" valign="top" width="20.46%" headers="mcps1.1.4.1.2 "><p id="p52943334720"><a name="p52943334720"></a><a name="p52943334720"></a>boolean</p>
    </td>
    <td class="cellrowborder" valign="top" width="63.06%" headers="mcps1.1.4.1.3 "><p id="p7294233876"><a name="p7294233876"></a><a name="p7294233876"></a>Read-only attribute, which indicates whether the animation playback is complete.</p>
    </td>
    </tr>
    <tr id="row493817253419"><td class="cellrowborder" valign="top" width="16.48%" headers="mcps1.1.4.1.1 "><p id="p593913251444"><a name="p593913251444"></a><a name="p593913251444"></a>pending</p>
    </td>
    <td class="cellrowborder" valign="top" width="20.46%" headers="mcps1.1.4.1.2 "><p id="p2939925349"><a name="p2939925349"></a><a name="p2939925349"></a>boolean</p>
    </td>
    <td class="cellrowborder" valign="top" width="63.06%" headers="mcps1.1.4.1.3 "><p id="p293911251414"><a name="p293911251414"></a><a name="p293911251414"></a>Read-only attribute, which indicates whether the animation is waiting for the completion of other asynchronous operations (for example, start an animation with a delay).</p>
    </td>
    </tr>
    <tr id="row11294123313714"><td class="cellrowborder" valign="top" width="16.48%" headers="mcps1.1.4.1.1 "><p id="p22943339718"><a name="p22943339718"></a><a name="p22943339718"></a>playState</p>
    </td>
    <td class="cellrowborder" valign="top" width="20.46%" headers="mcps1.1.4.1.2 "><p id="p1129403315713"><a name="p1129403315713"></a><a name="p1129403315713"></a>string</p>
    </td>
    <td class="cellrowborder" valign="top" width="63.06%" headers="mcps1.1.4.1.3 "><p id="p1529417331719"><a name="p1529417331719"></a><a name="p1529417331719"></a>Read-write attribute, which indicates the playback status of the animation:</p>
    <a name="ul854516488179"></a><a name="ul854516488179"></a><ul id="ul854516488179"><li><strong id="b111155323383"><a name="b111155323383"></a><a name="b111155323383"></a>idle</strong>: The animation is not running (playback ended or not started).</li><li><strong id="b16562194011527"><a name="b16562194011527"></a><a name="b16562194011527"></a>running</strong>: The animation is running.</li><li><strong id="b1262634712524"><a name="b1262634712524"></a><a name="b1262634712524"></a>paused</strong>: The animation is paused.</li><li><strong id="b9892827103810"><a name="b9892827103810"></a><a name="b9892827103810"></a>finished</strong>: Animation playback ends.</li></ul>
    </td>
    </tr>
    <tr id="row1581113368516"><td class="cellrowborder" valign="top" width="16.48%" headers="mcps1.1.4.1.1 "><p id="p128116361853"><a name="p128116361853"></a><a name="p128116361853"></a>startTime</p>
    </td>
    <td class="cellrowborder" valign="top" width="20.46%" headers="mcps1.1.4.1.2 "><p id="p1281118361053"><a name="p1281118361053"></a><a name="p1281118361053"></a>number</p>
    </td>
    <td class="cellrowborder" valign="top" width="63.06%" headers="mcps1.1.4.1.3 "><p id="p1581133616512"><a name="p1581133616512"></a><a name="p1581133616512"></a>Read-write attribute, which indicates the animation start time. This attribute is similar to <strong id="b1099302618382"><a name="b1099302618382"></a><a name="b1099302618382"></a>delay</strong> in the <strong id="b149981261389"><a name="b149981261389"></a><a name="b149981261389"></a>options</strong> attribute.</p>
    </td>
    </tr>
    </tbody>
    </table>

    Methods supported by the animation object

    <a name="table17991117817"></a>
    <table><thead align="left"><tr id="row18321722815"><th class="cellrowborder" valign="top" width="30.86%" id="mcps1.1.4.1.1"><p id="p9322211811"><a name="p9322211811"></a><a name="p9322211811"></a>Method</p>
    </th>
    <th class="cellrowborder" valign="top" width="10.58%" id="mcps1.1.4.1.2"><p id="p53272783"><a name="p53272783"></a><a name="p53272783"></a>Parameter</p>
    </th>
    <th class="cellrowborder" valign="top" width="58.56%" id="mcps1.1.4.1.3"><p id="p7321921788"><a name="p7321921788"></a><a name="p7321921788"></a>Description</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="row632623816"><td class="cellrowborder" valign="top" width="30.86%" headers="mcps1.1.4.1.1 "><p id="p0321827812"><a name="p0321827812"></a><a name="p0321827812"></a>play</p>
    </td>
    <td class="cellrowborder" valign="top" width="10.58%" headers="mcps1.1.4.1.2 "><p id="p20321121812"><a name="p20321121812"></a><a name="p20321121812"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="58.56%" headers="mcps1.1.4.1.3 "><p id="p103222388"><a name="p103222388"></a><a name="p103222388"></a>Plays the animation.</p>
    </td>
    </tr>
    <tr id="row12321721285"><td class="cellrowborder" valign="top" width="30.86%" headers="mcps1.1.4.1.1 "><p id="p1632321988"><a name="p1632321988"></a><a name="p1632321988"></a>finish</p>
    </td>
    <td class="cellrowborder" valign="top" width="10.58%" headers="mcps1.1.4.1.2 "><p id="p832162782"><a name="p832162782"></a><a name="p832162782"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="58.56%" headers="mcps1.1.4.1.3 "><p id="p1329219819"><a name="p1329219819"></a><a name="p1329219819"></a>Ends the animation.</p>
    </td>
    </tr>
    <tr id="row12321421087"><td class="cellrowborder" valign="top" width="30.86%" headers="mcps1.1.4.1.1 "><p id="p18331421383"><a name="p18331421383"></a><a name="p18331421383"></a>pause</p>
    </td>
    <td class="cellrowborder" valign="top" width="10.58%" headers="mcps1.1.4.1.2 "><p id="p7332218813"><a name="p7332218813"></a><a name="p7332218813"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="58.56%" headers="mcps1.1.4.1.3 "><p id="p63317211815"><a name="p63317211815"></a><a name="p63317211815"></a>Pauses the animation.</p>
    </td>
    </tr>
    <tr id="row153318215815"><td class="cellrowborder" valign="top" width="30.86%" headers="mcps1.1.4.1.1 "><p id="p2331021080"><a name="p2331021080"></a><a name="p2331021080"></a>cancel</p>
    </td>
    <td class="cellrowborder" valign="top" width="10.58%" headers="mcps1.1.4.1.2 "><p id="p1133422818"><a name="p1133422818"></a><a name="p1133422818"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="58.56%" headers="mcps1.1.4.1.3 "><p id="p533162482"><a name="p533162482"></a><a name="p533162482"></a>Cancels the animation.</p>
    </td>
    </tr>
    <tr id="row833142687"><td class="cellrowborder" valign="top" width="30.86%" headers="mcps1.1.4.1.1 "><p id="p113313216816"><a name="p113313216816"></a><a name="p113313216816"></a>reverse</p>
    </td>
    <td class="cellrowborder" valign="top" width="10.58%" headers="mcps1.1.4.1.2 "><p id="p17331321689"><a name="p17331321689"></a><a name="p17331321689"></a>-</p>
    </td>
    <td class="cellrowborder" valign="top" width="58.56%" headers="mcps1.1.4.1.3 "><p id="p1733521285"><a name="p1733521285"></a><a name="p1733521285"></a>Plays the animation in reverse direction.</p>
    </td>
    </tr>
    </tbody>
    </table>

    Events supported by the animation object

    <a name="table42538381785"></a>
    <table><thead align="left"><tr id="row16274163811819"><th class="cellrowborder" valign="top" width="20.810000000000002%" id="mcps1.1.3.1.1"><p id="p13274123816814"><a name="p13274123816814"></a><a name="p13274123816814"></a>Event</p>
    </th>
    <th class="cellrowborder" valign="top" width="79.19%" id="mcps1.1.3.1.2"><p id="p7274163812815"><a name="p7274163812815"></a><a name="p7274163812815"></a>Description</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="row117422274135"><td class="cellrowborder" valign="top" width="20.810000000000002%" headers="mcps1.1.3.1.1 "><p id="p47421127121318"><a name="p47421127121318"></a><a name="p47421127121318"></a>start<sup id="sup1414915482315"><a name="sup1414915482315"></a><a name="sup1414915482315"></a>6+</sup></p>
    </td>
    <td class="cellrowborder" valign="top" width="79.19%" headers="mcps1.1.3.1.2 "><p id="p167421827181315"><a name="p167421827181315"></a><a name="p167421827181315"></a>The animation starts.</p>
    </td>
    </tr>
    <tr id="row12749389813"><td class="cellrowborder" valign="top" width="20.810000000000002%" headers="mcps1.1.3.1.1 "><p id="p1927412381487"><a name="p1927412381487"></a><a name="p1927412381487"></a>cancel</p>
    </td>
    <td class="cellrowborder" valign="top" width="79.19%" headers="mcps1.1.3.1.2 "><p id="p17274203812816"><a name="p17274203812816"></a><a name="p17274203812816"></a>The animation is forcibly canceled.</p>
    </td>
    </tr>
    <tr id="row13274938488"><td class="cellrowborder" valign="top" width="20.810000000000002%" headers="mcps1.1.3.1.1 "><p id="p1727412383815"><a name="p1727412383815"></a><a name="p1727412383815"></a>finish</p>
    </td>
    <td class="cellrowborder" valign="top" width="79.19%" headers="mcps1.1.3.1.2 "><p id="p1327416383814"><a name="p1327416383814"></a><a name="p1327416383814"></a>The animation playback is complete.</p>
    </td>
    </tr>
    <tr id="row7836145011411"><td class="cellrowborder" valign="top" width="20.810000000000002%" headers="mcps1.1.3.1.1 "><p id="p208371050154117"><a name="p208371050154117"></a><a name="p208371050154117"></a>repeat</p>
    </td>
    <td class="cellrowborder" valign="top" width="79.19%" headers="mcps1.1.3.1.2 "><p id="p583735020415"><a name="p583735020415"></a><a name="p583735020415"></a>The animation repeats.</p>
    </td>
    </tr>
    </tbody>
    </table>


-   Example code:

    ```
    <!-- xxx.hml -->
    <div class="container">
      <div id="idName" class="box"></div>
      <div class="buttonBox">
        <button @click="start">
          start
        </button>
        <button @click="cancel">
          cancels
        </button>
      </div>
    </div>
    ```

    ```
    /* xxx.css */
    .container {
      flex-direction: column;
      justify-content: center;
      align-items: center;
      width: 100%;
    }
    .box{
      width: 200px;
      height: 200px;
      background-color: #ff0000;
      margin-top: 30px;
    }
    .buttonBox{
      margin-top: 30px;
      width: 250px;
      justify-content: space-between;
    }
    button{
      background-color: #8e8b89;
      color: white;
      width: 100px;
      height: 40px;
      font-size: 24px;
    }
    ```

    ```
    // xxx.js
    import prompt from '@system.prompt';
    export default{
      data:{
        animation:'',
      },
      onInit(){
      },
      onShow(){
        var options = {
          duration: 1500,
          easing: 'friction',
          delay: 500,
          fill: 'forwards',
          iterations: 2,
          direction: 'normal',
        };
        var frames = [
          {transform: {translate: '-120px -0px'}, opacity: 0.1, offset: 0.0},
          {transform: {translate: '120px 0px'}, opacity: 1.0, offset: 1.0}
        ];
        this.animation = this.$element('idName').animate(frames, options);
        // handle finish event
        this.animation.onfinish = function(){
          prompt.showToast({
            message: "The animation is finished."
          });
        };
        // handle cancel event
        this.animation.oncancel = function(){
          prompt.showToast({
            message: "The animation is canceled."
          });
        };
        // handle repeat event
        this.animation.onrepeat = function(){
           prompt.showToast({
              message: "The animation is repeated."
           });
        };
      },
      start(){
        this.animation.play();
      },
      cancel(){
        this.animation.cancel();
      }
    }
    ```

    ![](figures/en-us_image_0000001173324753.gif)


## this.$element\('_id_'\).getBoundingClientRect\(\)<sup>6+</sup><a name="section8611320155314"></a>

Obtains the size of the element and its position relative to the window.

-   Example

    ```
    // xxx.js
    var rect = this.$element('id').getBoundingClientRect();
    console.info(`current element position is ${rect.left}, ${rect.top}`);
    ```


## this.$element\('_id_'\).createIntersectionObserver\(\)<sup>6+</sup><a name="section137899052719"></a>

Gets notified of the visibility of an element on the current page.

-   Example

    ```
    // xxx.js
    let observer = this.$element('broad').createIntersectionObserver({
      ratios: [0.2, 0.5], // number
    });
    
    observer.observe((isVisible, ratio)=> {
        console.info('this element is ' + isVisible + 'ratio is ' + ratio)
    })
    
    observer.unobserve()
    ```


