# textarea<a name="EN-US_TOPIC_0000001173324595"></a>

The  **<textarea\>**  component provides a text box to receive multi-line text input.

## Required Permissions<a name="section11257113618419"></a>

None

## Child Component<a name="section9288143101012"></a>

Not supported

## Attribute<a name="section2907183951110"></a>

In addition to the attributes in  [Universal Attributes](js-components-common-attributes.md), the following attributes are supported.

<a name="table20633101642315"></a>
<table><thead align="left"><tr id="row663331618238"><th class="cellrowborder" valign="top" width="23.119999999999997%" id="mcps1.1.6.1.1"><p id="aa872998ac2d84843a3c5161889afffef"><a name="aa872998ac2d84843a3c5161889afffef"></a><a name="aa872998ac2d84843a3c5161889afffef"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="23.119999999999997%" id="mcps1.1.6.1.2"><p id="ab2111648ee0e4f6d881be8954e7acaab"><a name="ab2111648ee0e4f6d881be8954e7acaab"></a><a name="ab2111648ee0e4f6d881be8954e7acaab"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="10.48%" id="mcps1.1.6.1.3"><p id="ab377d1c90900478ea4ecab51e9a058af"><a name="ab377d1c90900478ea4ecab51e9a058af"></a><a name="ab377d1c90900478ea4ecab51e9a058af"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="7.5200000000000005%" id="mcps1.1.6.1.4"><p id="p824610360217"><a name="p824610360217"></a><a name="p824610360217"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="35.76%" id="mcps1.1.6.1.5"><p id="a1d574a0044ed42ec8a2603bc82734232"><a name="a1d574a0044ed42ec8a2603bc82734232"></a><a name="a1d574a0044ed42ec8a2603bc82734232"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row207976211241"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p1172110226415"><a name="p1172110226415"></a><a name="p1172110226415"></a>placeholder</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p1572111221649"><a name="p1572111221649"></a><a name="p1572111221649"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p1072112229411"><a name="p1072112229411"></a><a name="p1072112229411"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p197218228415"><a name="p197218228415"></a><a name="p197218228415"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p1372114227414"><a name="p1372114227414"></a><a name="p1372114227414"></a>Content of the hint text.</p>
</td>
</tr>
<tr id="row57972211740"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p18721522047"><a name="p18721522047"></a><a name="p18721522047"></a>maxlength</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p127225224413"><a name="p127225224413"></a><a name="p127225224413"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p19722172217410"><a name="p19722172217410"></a><a name="p19722172217410"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p27223221745"><a name="p27223221745"></a><a name="p27223221745"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p1872218223415"><a name="p1872218223415"></a><a name="p1872218223415"></a>Maximum number of characters that can be entered in the multi-line text box.</p>
</td>
</tr>
<tr id="row41157171546"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p1972216221247"><a name="p1972216221247"></a><a name="p1972216221247"></a>headericon</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p177229221041"><a name="p177229221041"></a><a name="p177229221041"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p15722132218415"><a name="p15722132218415"></a><a name="p15722132218415"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p27221122445"><a name="p27221122445"></a><a name="p27221122445"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p172213223414"><a name="p172213223414"></a><a name="p172213223414"></a>Icon displayed before text input. This icon does not support click events. The supported icon formats are JPG, PNG, and SVG.</p>
</td>
</tr>
<tr id="row1416414649"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p5722162213413"><a name="p5722162213413"></a><a name="p5722162213413"></a>extend</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p47221221447"><a name="p47221221447"></a><a name="p47221221447"></a>boolean</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p15722172212412"><a name="p15722172212412"></a><a name="p15722172212412"></a>false</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p1172212221745"><a name="p1172212221745"></a><a name="p1172212221745"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p1872232213411"><a name="p1872232213411"></a><a name="p1872232213411"></a>Whether a text box can be extended. If the value of this attribute is set to <strong id="b073910572418"><a name="b073910572418"></a><a name="b073910572418"></a>true</strong>, the height of the text box can adapt to the text.</p>
</td>
</tr>
<tr id="row1273032304111"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p1073002304114"><a name="p1073002304114"></a><a name="p1073002304114"></a>value<sup id="sup5397930164210"><a name="sup5397930164210"></a><a name="sup5397930164210"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p37316238419"><a name="p37316238419"></a><a name="p37316238419"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p773116239412"><a name="p773116239412"></a><a name="p773116239412"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p1473162314411"><a name="p1473162314411"></a><a name="p1473162314411"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p20731162310415"><a name="p20731162310415"></a><a name="p20731162310415"></a>Content in a multi-line text box.</p>
</td>
</tr>
<tr id="row8191717132813"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p7201317102812"><a name="p7201317102812"></a><a name="p7201317102812"></a>showcounter<sup id="sup10332204922918"><a name="sup10332204922918"></a><a name="sup10332204922918"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p920141732817"><a name="p920141732817"></a><a name="p920141732817"></a>boolean</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p15201317132812"><a name="p15201317132812"></a><a name="p15201317132812"></a>false</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p11201317192811"><a name="p11201317192811"></a><a name="p11201317192811"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p72081718281"><a name="p72081718281"></a><a name="p72081718281"></a>Whether to display the character counter for the text box. This attribute takes effect only when <strong id="b764616114321"><a name="b764616114321"></a><a name="b764616114321"></a>maxlength</strong> is set.</p>
</td>
</tr>
<tr id="row1765514319572"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p177221571244"><a name="p177221571244"></a><a name="p177221571244"></a>menuoptions<sup id="sup154944401542"><a name="sup154944401542"></a><a name="sup154944401542"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p8722157248"><a name="p8722157248"></a><a name="p8722157248"></a>Array&lt;<a href="#table83621954963">MenuOption</a>&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p167221878414"><a name="p167221878414"></a><a name="p167221878414"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p197227713411"><a name="p197227713411"></a><a name="p197227713411"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p207221573417"><a name="p207221573417"></a><a name="p207221573417"></a>Menu options displayed after users click the <strong id="b21781315182119"><a name="b21781315182119"></a><a name="b21781315182119"></a>More</strong> button in the pop menu.</p>
</td>
</tr>
<tr id="row198351301534"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p95550281483"><a name="p95550281483"></a><a name="p95550281483"></a>autofocus<sup id="sup1775142235010"><a name="sup1775142235010"></a><a name="sup1775142235010"></a>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p1955511286485"><a name="p1955511286485"></a><a name="p1955511286485"></a>boolean</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p6555192874812"><a name="p6555192874812"></a><a name="p6555192874812"></a>false</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p3555142844817"><a name="p3555142844817"></a><a name="p3555142844817"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p135551628184820"><a name="p135551628184820"></a><a name="p135551628184820"></a>Whether to automatically obtain the focus.</p>
</td>
</tr>
<tr id="row1066516375317"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p16196311485"><a name="p16196311485"></a><a name="p16196311485"></a>selectedstart<sup id="sup151911922125019"><a name="sup151911922125019"></a><a name="sup151911922125019"></a>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p126191631104819"><a name="p126191631104819"></a><a name="p126191631104819"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p7619163110489"><a name="p7619163110489"></a><a name="p7619163110489"></a>-1</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p1619123120488"><a name="p1619123120488"></a><a name="p1619123120488"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p9619113118488"><a name="p9619113118488"></a><a name="p9619113118488"></a>Start position for text selection.</p>
</td>
</tr>
<tr id="row81412785317"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p42301334184813"><a name="p42301334184813"></a><a name="p42301334184813"></a>selectedend<sup id="sup759182155017"><a name="sup759182155017"></a><a name="sup759182155017"></a>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p1523013444810"><a name="p1523013444810"></a><a name="p1523013444810"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p1823053404815"><a name="p1823053404815"></a><a name="p1823053404815"></a>-1</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p162301434104819"><a name="p162301434104819"></a><a name="p162301434104819"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p2023014344489"><a name="p2023014344489"></a><a name="p2023014344489"></a>End position for text selection.</p>
</td>
</tr>
<tr id="row15650913537"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p11428837134811"><a name="p11428837134811"></a><a name="p11428837134811"></a>softkeyboardenabled<sup id="sup135541120205017"><a name="sup135541120205017"></a><a name="sup135541120205017"></a>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p18428837114816"><a name="p18428837114816"></a><a name="p18428837114816"></a>boolean</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p124281037144812"><a name="p124281037144812"></a><a name="p124281037144812"></a>true</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p842823714486"><a name="p842823714486"></a><a name="p842823714486"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p1642873734813"><a name="p1642873734813"></a><a name="p1642873734813"></a>Whether to display the soft keyboard during editing.</p>
</td>
</tr>
</tbody>
</table>

**Table  1**  MenuOption<sup>5+</sup>

<a name="table83621954963"></a>
<table><thead align="left"><tr id="row536212545619"><th class="cellrowborder" valign="top" width="33.33333333333333%" id="mcps1.2.4.1.1"><p id="p143621541967"><a name="p143621541967"></a><a name="p143621541967"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="33.33333333333333%" id="mcps1.2.4.1.2"><p id="p936215541620"><a name="p936215541620"></a><a name="p936215541620"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="33.33333333333333%" id="mcps1.2.4.1.3"><p id="p23626541665"><a name="p23626541665"></a><a name="p23626541665"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row5362254461"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.1 "><p id="p33631541265"><a name="p33631541265"></a><a name="p33631541265"></a>icon</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.2 "><p id="p536311543619"><a name="p536311543619"></a><a name="p536311543619"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p73631954762"><a name="p73631954762"></a><a name="p73631954762"></a>Path of the icon for a menu option.</p>
</td>
</tr>
<tr id="row136319547613"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.1 "><p id="p12363654367"><a name="p12363654367"></a><a name="p12363654367"></a>content</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.2 "><p id="p1936312549617"><a name="p1936312549617"></a><a name="p1936312549617"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p1036311548616"><a name="p1036311548616"></a><a name="p1036311548616"></a>Text content in a menu option.</p>
</td>
</tr>
</tbody>
</table>

## Style<a name="section182794053"></a>

In addition to the styles in  [Universal Styles](js-components-common-styles.md), the following styles are supported.

<a name="table14588121079"></a>
<table><thead align="left"><tr id="row3588182975"><th class="cellrowborder" valign="top" width="23.11768823117688%" id="mcps1.1.6.1.1"><p id="p2588112873"><a name="p2588112873"></a><a name="p2588112873"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="14.1985801419858%" id="mcps1.1.6.1.2"><p id="p18588321876"><a name="p18588321876"></a><a name="p18588321876"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="20.247975202479754%" id="mcps1.1.6.1.3"><p id="p1588132673"><a name="p1588132673"></a><a name="p1588132673"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="5.23947605239476%" id="mcps1.1.6.1.4"><p id="p3588192276"><a name="p3588192276"></a><a name="p3588192276"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="37.1962803719628%" id="mcps1.1.6.1.5"><p id="p55881121575"><a name="p55881121575"></a><a name="p55881121575"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row45881726713"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p1588182874"><a name="p1588182874"></a><a name="p1588182874"></a>color</p>
</td>
<td class="cellrowborder" valign="top" width="14.1985801419858%" headers="mcps1.1.6.1.2 "><p id="p8588725714"><a name="p8588725714"></a><a name="p8588725714"></a>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="20.247975202479754%" headers="mcps1.1.6.1.3 "><p id="p13588521677"><a name="p13588521677"></a><a name="p13588521677"></a>#e6000000</p>
</td>
<td class="cellrowborder" valign="top" width="5.23947605239476%" headers="mcps1.1.6.1.4 "><p id="p11588112272"><a name="p11588112272"></a><a name="p11588112272"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="37.1962803719628%" headers="mcps1.1.6.1.5 "><p id="p17588923718"><a name="p17588923718"></a><a name="p17588923718"></a>Text color of the multi-line text box.</p>
</td>
</tr>
<tr id="row858822573"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p25881521973"><a name="p25881521973"></a><a name="p25881521973"></a>font-size</p>
</td>
<td class="cellrowborder" valign="top" width="14.1985801419858%" headers="mcps1.1.6.1.2 "><p id="p13588629717"><a name="p13588629717"></a><a name="p13588629717"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="20.247975202479754%" headers="mcps1.1.6.1.3 "><p id="p15588321719"><a name="p15588321719"></a><a name="p15588321719"></a>16px</p>
</td>
<td class="cellrowborder" valign="top" width="5.23947605239476%" headers="mcps1.1.6.1.4 "><p id="p05899216712"><a name="p05899216712"></a><a name="p05899216712"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="37.1962803719628%" headers="mcps1.1.6.1.5 "><p id="p175891621973"><a name="p175891621973"></a><a name="p175891621973"></a>Font size of the multi-line text box. </p>
</td>
</tr>
<tr id="row14589724712"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p155891921078"><a name="p155891921078"></a><a name="p155891921078"></a>allow-scale</p>
</td>
<td class="cellrowborder" valign="top" width="14.1985801419858%" headers="mcps1.1.6.1.2 "><p id="p658922277"><a name="p658922277"></a><a name="p658922277"></a>boolean</p>
</td>
<td class="cellrowborder" valign="top" width="20.247975202479754%" headers="mcps1.1.6.1.3 "><p id="p12589521713"><a name="p12589521713"></a><a name="p12589521713"></a>true</p>
</td>
<td class="cellrowborder" valign="top" width="5.23947605239476%" headers="mcps1.1.6.1.4 "><p id="p155891121872"><a name="p155891121872"></a><a name="p155891121872"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="37.1962803719628%" headers="mcps1.1.6.1.5 "><p id="p55894219719"><a name="p55894219719"></a><a name="p55894219719"></a>Whether the font size changes with the system's font size settings.</p>
<div class="note" id="note13589162372"><a name="note13589162372"></a><a name="note13589162372"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p12589021175"><a name="p12589021175"></a><a name="p12589021175"></a>If the <strong id="b114871535165219"><a name="b114871535165219"></a><a name="b114871535165219"></a>config-changes</strong> tag of <strong id="b749317356521"><a name="b749317356521"></a><a name="b749317356521"></a>fontSize</strong> is configured for abilities in the <strong id="b3494193515215"><a name="b3494193515215"></a><a name="b3494193515215"></a>config.json</strong> file, the setting takes effect without application restart.</p>
</div></div>
</td>
</tr>
<tr id="row3589121375"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p95891321170"><a name="p95891321170"></a><a name="p95891321170"></a>placeholder-color</p>
</td>
<td class="cellrowborder" valign="top" width="14.1985801419858%" headers="mcps1.1.6.1.2 "><p id="p1058982376"><a name="p1058982376"></a><a name="p1058982376"></a>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="20.247975202479754%" headers="mcps1.1.6.1.3 "><p id="p9589726718"><a name="p9589726718"></a><a name="p9589726718"></a>#99000000</p>
</td>
<td class="cellrowborder" valign="top" width="5.23947605239476%" headers="mcps1.1.6.1.4 "><p id="p558914219710"><a name="p558914219710"></a><a name="p558914219710"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="37.1962803719628%" headers="mcps1.1.6.1.5 "><p id="p25896215710"><a name="p25896215710"></a><a name="p25896215710"></a>Color of the hint text in the multi-line text box. This attribute is available when the component type is set to <strong id="b1880264510313"><a name="b1880264510313"></a><a name="b1880264510313"></a>text</strong>, <strong id="b1980916451312"><a name="b1980916451312"></a><a name="b1980916451312"></a>email</strong>, <strong id="b7809144513311"><a name="b7809144513311"></a><a name="b7809144513311"></a>date</strong>, <strong id="b158107452319"><a name="b158107452319"></a><a name="b158107452319"></a>time</strong>, <strong id="b10811104511318"><a name="b10811104511318"></a><a name="b10811104511318"></a>number</strong>, or <strong id="b15811545130"><a name="b15811545130"></a><a name="b15811545130"></a>password</strong>.</p>
</td>
</tr>
<tr id="row1658911216712"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p4589182976"><a name="p4589182976"></a><a name="p4589182976"></a>font-weight</p>
</td>
<td class="cellrowborder" valign="top" width="14.1985801419858%" headers="mcps1.1.6.1.2 "><p id="p18589122578"><a name="p18589122578"></a><a name="p18589122578"></a>number | string</p>
</td>
<td class="cellrowborder" valign="top" width="20.247975202479754%" headers="mcps1.1.6.1.3 "><p id="p1058982179"><a name="p1058982179"></a><a name="p1058982179"></a>normal</p>
</td>
<td class="cellrowborder" valign="top" width="5.23947605239476%" headers="mcps1.1.6.1.4 "><p id="p1058917212710"><a name="p1058917212710"></a><a name="p1058917212710"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="37.1962803719628%" headers="mcps1.1.6.1.5 "><p id="p2058912778"><a name="p2058912778"></a><a name="p2058912778"></a>Font weight. For details, see <a href="js-components-basic-text.md#section5775351116">font-weight</a> of the <strong id="b780883514536"><a name="b780883514536"></a><a name="b780883514536"></a>text</strong> component.</p>
</td>
</tr>
<tr id="row45906217712"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p115907212715"><a name="p115907212715"></a><a name="p115907212715"></a>font-family</p>
</td>
<td class="cellrowborder" valign="top" width="14.1985801419858%" headers="mcps1.1.6.1.2 "><p id="p459015215711"><a name="p459015215711"></a><a name="p459015215711"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="20.247975202479754%" headers="mcps1.1.6.1.3 "><p id="p4590172674"><a name="p4590172674"></a><a name="p4590172674"></a>sans-serif</p>
</td>
<td class="cellrowborder" valign="top" width="5.23947605239476%" headers="mcps1.1.6.1.4 "><p id="p12590828720"><a name="p12590828720"></a><a name="p12590828720"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="37.1962803719628%" headers="mcps1.1.6.1.5 "><p id="p17590721579"><a name="p17590721579"></a><a name="p17590721579"></a>Font family, in which fonts are separated by commas (,). Each font is set using a font name or font family name. The first font that exists in the system or the font specified by <a href="js-components-common-customizing-font.md">Custom Font Styles</a> in the family is selected as the font for the text. </p>
</td>
</tr>
<tr id="row583415126314"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p18674104193019"><a name="p18674104193019"></a><a name="p18674104193019"></a>caret-color<sup id="sup628114393018"><a name="sup628114393018"></a><a name="sup628114393018"></a>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="14.1985801419858%" headers="mcps1.1.6.1.2 "><p id="p13674194173010"><a name="p13674194173010"></a><a name="p13674194173010"></a>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="20.247975202479754%" headers="mcps1.1.6.1.3 "><p id="p12674164113010"><a name="p12674164113010"></a><a name="p12674164113010"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="5.23947605239476%" headers="mcps1.1.6.1.4 "><p id="p5674114183020"><a name="p5674114183020"></a><a name="p5674114183020"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="37.1962803719628%" headers="mcps1.1.6.1.5 "><p id="p18674134153015"><a name="p18674134153015"></a><a name="p18674134153015"></a>Color of the input cursor.</p>
</td>
</tr>
</tbody>
</table>

## Event<a name="section3892191911214"></a>

In addition to the events in  [Universal Events](js-components-common-events.md), the following events are supported.

<a name="table836435619510"></a>
<table><thead align="left"><tr id="row153658563517"><th class="cellrowborder" valign="top" width="24.852485248524854%" id="mcps1.1.4.1.1"><p id="a426b8903842d48fa8012a24ff3c997eb"><a name="a426b8903842d48fa8012a24ff3c997eb"></a><a name="a426b8903842d48fa8012a24ff3c997eb"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="29.552955295529554%" id="mcps1.1.4.1.2"><p id="a53448ba47e5e4ae9bf7774c90820e970"><a name="a53448ba47e5e4ae9bf7774c90820e970"></a><a name="a53448ba47e5e4ae9bf7774c90820e970"></a>Parameter</p>
</th>
<th class="cellrowborder" valign="top" width="45.5945594559456%" id="mcps1.1.4.1.3"><p id="add489ff50c444f24b759162c7f4bad9a"><a name="add489ff50c444f24b759162c7f4bad9a"></a><a name="add489ff50c444f24b759162c7f4bad9a"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row18605132815610"><td class="cellrowborder" valign="top" width="24.852485248524854%" headers="mcps1.1.4.1.1 "><p id="p768720297617"><a name="p768720297617"></a><a name="p768720297617"></a>change</p>
</td>
<td class="cellrowborder" valign="top" width="29.552955295529554%" headers="mcps1.1.4.1.2 "><p id="p126881629369"><a name="p126881629369"></a><a name="p126881629369"></a>{ text: newText, lines: textLines, height: textHeight }</p>
</td>
<td class="cellrowborder" valign="top" width="45.5945594559456%" headers="mcps1.1.4.1.3 "><p id="p56883296617"><a name="p56883296617"></a><a name="p56883296617"></a>Triggered when the input content changes. The input content, number of rows, and row height are obtained through the parameters.</p>
<div class="note" id="note42491433440"><a name="note42491433440"></a><a name="note42491433440"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p1524933204418"><a name="p1524933204418"></a><a name="p1524933204418"></a>If you change the <strong id="b1292019401570"><a name="b1292019401570"></a><a name="b1292019401570"></a>value</strong> attribute directly, this event will not be triggered. <sup id="sup1674874183511"><a name="sup1674874183511"></a><a name="sup1674874183511"></a>5+</sup></p>
</div></div>
</td>
</tr>
<tr id="row122281128165410"><td class="cellrowborder" valign="top" width="24.852485248524854%" headers="mcps1.1.4.1.1 "><p id="p3284165512920"><a name="p3284165512920"></a><a name="p3284165512920"></a>translate<sup id="sup1220715214307"><a name="sup1220715214307"></a><a name="sup1220715214307"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="29.552955295529554%" headers="mcps1.1.4.1.2 "><p id="p112841555916"><a name="p112841555916"></a><a name="p112841555916"></a>{ value: selectedText }</p>
</td>
<td class="cellrowborder" valign="top" width="45.5945594559456%" headers="mcps1.1.4.1.3 "><p id="p132842551198"><a name="p132842551198"></a><a name="p132842551198"></a>Triggered when users click the translate button in the pop menu displayed after they select a text segment. The selected text content is returned.</p>
</td>
</tr>
<tr id="row286017313541"><td class="cellrowborder" valign="top" width="24.852485248524854%" headers="mcps1.1.4.1.1 "><p id="p9677163420503"><a name="p9677163420503"></a><a name="p9677163420503"></a>share<sup id="sup107382026312"><a name="sup107382026312"></a><a name="sup107382026312"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="29.552955295529554%" headers="mcps1.1.4.1.2 "><p id="p86771934155012"><a name="p86771934155012"></a><a name="p86771934155012"></a>{ value: selectedText }</p>
</td>
<td class="cellrowborder" valign="top" width="45.5945594559456%" headers="mcps1.1.4.1.3 "><p id="p1967743413507"><a name="p1967743413507"></a><a name="p1967743413507"></a>Triggered when users click the share button in the pop menu displayed after they select a text segment. The selected text content is returned.</p>
</td>
</tr>
<tr id="row1143814381541"><td class="cellrowborder" valign="top" width="24.852485248524854%" headers="mcps1.1.4.1.1 "><p id="p12601236205015"><a name="p12601236205015"></a><a name="p12601236205015"></a>search<sup id="sup7157178113113"><a name="sup7157178113113"></a><a name="sup7157178113113"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="29.552955295529554%" headers="mcps1.1.4.1.2 "><p id="p1626016369501"><a name="p1626016369501"></a><a name="p1626016369501"></a>{ value: selectedText }</p>
</td>
<td class="cellrowborder" valign="top" width="45.5945594559456%" headers="mcps1.1.4.1.3 "><p id="p1026053614504"><a name="p1026053614504"></a><a name="p1026053614504"></a>Triggered when users click the search button in the pop menu displayed after they select a text segment. The selected text content is returned.</p>
</td>
</tr>
<tr id="row144191735105415"><td class="cellrowborder" valign="top" width="24.852485248524854%" headers="mcps1.1.4.1.1 "><p id="p1712579511"><a name="p1712579511"></a><a name="p1712579511"></a>optionselect<sup id="sup053512117315"><a name="sup053512117315"></a><a name="sup053512117315"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="29.552955295529554%" headers="mcps1.1.4.1.2 "><p id="p07155775115"><a name="p07155775115"></a><a name="p07155775115"></a>{ index:optionIndex, value: selectedText }</p>
</td>
<td class="cellrowborder" valign="top" width="45.5945594559456%" headers="mcps1.1.4.1.3 "><p id="p1671157105114"><a name="p1671157105114"></a><a name="p1671157105114"></a>Triggered when users click a menu option in the pop menu displayed after they select a text segment. This event is valid only when the <strong id="b9972192992713"><a name="b9972192992713"></a><a name="b9972192992713"></a>menuoptions</strong> attribute is set. The option index and selected text content are returned.</p>
</td>
</tr>
<tr id="row11141826125316"><td class="cellrowborder" valign="top" width="24.852485248524854%" headers="mcps1.1.4.1.1 "><p id="p17803157175014"><a name="p17803157175014"></a><a name="p17803157175014"></a>selectchange<sup id="sup774434715119"><a name="sup774434715119"></a><a name="sup774434715119"></a>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="29.552955295529554%" headers="mcps1.1.4.1.2 "><p id="p13803157185013"><a name="p13803157185013"></a><a name="p13803157185013"></a>{ start: number, end: number }</p>
</td>
<td class="cellrowborder" valign="top" width="45.5945594559456%" headers="mcps1.1.4.1.3 "><p id="p4803155719505"><a name="p4803155719505"></a><a name="p4803155719505"></a>Triggered when the text selection changes.</p>
</td>
</tr>
</tbody>
</table>

## Method<a name="section47669296127"></a>

Methods in  [Universal Methods](js-components-common-methods.md)  are supported.

## Example Code<a name="section1224516501541"></a>

```
<!-- xxx.hml -->
<textarea id="textarea" class="textarea" extend="true" maxlength="20"
  headericon="/common/navigation_menu1_icon.svg" placeholder="Please input text"
  onchange="change">
</textarea>
```

```
/* xxx.css */
.textarea {
  placeholder-color: gray;
}
```

```
// xxx.js
change(e){
  prompt.showToast({
    message: 'value: ' + e.text + ', lines: ' + e.lines + ', height: ' + e.height,
    duration: 3000,
  });
}
```

![](figures/000000.png)

