# switch<a name="EN-US_TOPIC_0000001127125072"></a>

The  **<switch\>**  component is used to enable or disable a function.

## Permission List<a name="section11257113618419"></a>

None

## Child Component<a name="section9288143101012"></a>

None

## Attribute<a name="section2907183951110"></a>

In addition to the attributes in  [Universal Attributes](js-components-common-attributes.md), the following attributes are supported.

<a name="table20633101642315"></a>
<table><thead align="left"><tr id="row663331618238"><th class="cellrowborder" valign="top" width="23.119999999999997%" id="mcps1.1.6.1.1"><p id="aa872998ac2d84843a3c5161889afffef"><a name="aa872998ac2d84843a3c5161889afffef"></a><a name="aa872998ac2d84843a3c5161889afffef"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="23.119999999999997%" id="mcps1.1.6.1.2"><p id="ab2111648ee0e4f6d881be8954e7acaab"><a name="ab2111648ee0e4f6d881be8954e7acaab"></a><a name="ab2111648ee0e4f6d881be8954e7acaab"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="10.48%" id="mcps1.1.6.1.3"><p id="ab377d1c90900478ea4ecab51e9a058af"><a name="ab377d1c90900478ea4ecab51e9a058af"></a><a name="ab377d1c90900478ea4ecab51e9a058af"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="7.5200000000000005%" id="mcps1.1.6.1.4"><p id="p824610360217"><a name="p824610360217"></a><a name="p824610360217"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="35.76%" id="mcps1.1.6.1.5"><p id="a1d574a0044ed42ec8a2603bc82734232"><a name="a1d574a0044ed42ec8a2603bc82734232"></a><a name="a1d574a0044ed42ec8a2603bc82734232"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row187510515582"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p1126255375818"><a name="p1126255375818"></a><a name="p1126255375818"></a>checked</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p826225395810"><a name="p826225395810"></a><a name="p826225395810"></a>boolean</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p1126210533587"><a name="p1126210533587"></a><a name="p1126210533587"></a>false</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p10262185375814"><a name="p10262185375814"></a><a name="p10262185375814"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p526295335811"><a name="p526295335811"></a><a name="p526295335811"></a>Whether the component is checked or not.</p>
</td>
</tr>
<tr id="row18459154995812"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p17262853175817"><a name="p17262853175817"></a><a name="p17262853175817"></a>showtext</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p122621153175814"><a name="p122621153175814"></a><a name="p122621153175814"></a>boolean</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p1126365310589"><a name="p1126365310589"></a><a name="p1126365310589"></a>false</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p11263195345814"><a name="p11263195345814"></a><a name="p11263195345814"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p172631453135816"><a name="p172631453135816"></a><a name="p172631453135816"></a>Whether the component displays text.</p>
</td>
</tr>
<tr id="row55711479587"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p626355311584"><a name="p626355311584"></a><a name="p626355311584"></a>texton</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p72637533582"><a name="p72637533582"></a><a name="p72637533582"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p182634538587"><a name="p182634538587"></a><a name="p182634538587"></a>"On"</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p112631153185813"><a name="p112631153185813"></a><a name="p112631153185813"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p3263753175817"><a name="p3263753175817"></a><a name="p3263753175817"></a>Text displayed when the component is checked.</p>
</td>
</tr>
<tr id="row116161444115812"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p32631553145810"><a name="p32631553145810"></a><a name="p32631553145810"></a>textoff</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p11263253105816"><a name="p11263253105816"></a><a name="p11263253105816"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p182632539586"><a name="p182632539586"></a><a name="p182632539586"></a>"Off"</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p3263195375819"><a name="p3263195375819"></a><a name="p3263195375819"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p19263185312583"><a name="p19263185312583"></a><a name="p19263185312583"></a>Text displayed when the component is not checked.</p>
</td>
</tr>
</tbody>
</table>

## Style<a name="section5775351116"></a>

In addition to the styles in  [Universal Styles](js-components-common-styles.md), the following styles are supported.

<a name="table18141141019"></a>
<table><thead align="left"><tr id="row17141841318"><th class="cellrowborder" valign="top" width="23.11768823117688%" id="mcps1.1.6.1.1"><p id="p814213411616"><a name="p814213411616"></a><a name="p814213411616"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="20.477952204779523%" id="mcps1.1.6.1.2"><p id="p101428411816"><a name="p101428411816"></a><a name="p101428411816"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="8.869113088691131%" id="mcps1.1.6.1.3"><p id="p1214219411518"><a name="p1214219411518"></a><a name="p1214219411518"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="7.519248075192481%" id="mcps1.1.6.1.4"><p id="p1814213417115"><a name="p1814213417115"></a><a name="p1814213417115"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="40.01599840015999%" id="mcps1.1.6.1.5"><p id="p5142174112118"><a name="p5142174112118"></a><a name="p5142174112118"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row15142941912"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p141422413117"><a name="p141422413117"></a><a name="p141422413117"></a>texton-color(Rich)</p>
</td>
<td class="cellrowborder" valign="top" width="20.477952204779523%" headers="mcps1.1.6.1.2 "><p id="p21426411815"><a name="p21426411815"></a><a name="p21426411815"></a>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="8.869113088691131%" headers="mcps1.1.6.1.3 "><p id="p1614210411718"><a name="p1614210411718"></a><a name="p1614210411718"></a>#000000</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p414264111119"><a name="p414264111119"></a><a name="p414264111119"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p17142194118113"><a name="p17142194118113"></a><a name="p17142194118113"></a>Text color displayed when the component is checked.</p>
</td>
</tr>
<tr id="row01425413117"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p31426419115"><a name="p31426419115"></a><a name="p31426419115"></a>textoff-color(Rich)</p>
</td>
<td class="cellrowborder" valign="top" width="20.477952204779523%" headers="mcps1.1.6.1.2 "><p id="p714211411914"><a name="p714211411914"></a><a name="p714211411914"></a>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="8.869113088691131%" headers="mcps1.1.6.1.3 "><p id="p1614244112117"><a name="p1614244112117"></a><a name="p1614244112117"></a>#000000</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p1914294116111"><a name="p1914294116111"></a><a name="p1914294116111"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p7142041512"><a name="p7142041512"></a><a name="p7142041512"></a>Text color displayed when the component is not checked.</p>
</td>
</tr>
<tr id="row21421741914"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p15143441811"><a name="p15143441811"></a><a name="p15143441811"></a>text-padding(Rich)</p>
</td>
<td class="cellrowborder" valign="top" width="20.477952204779523%" headers="mcps1.1.6.1.2 "><p id="p12143741518"><a name="p12143741518"></a><a name="p12143741518"></a>number</p>
</td>
<td class="cellrowborder" valign="top" width="8.869113088691131%" headers="mcps1.1.6.1.3 "><p id="p9143241114"><a name="p9143241114"></a><a name="p9143241114"></a>0px</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p101439419117"><a name="p101439419117"></a><a name="p101439419117"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p714374115110"><a name="p714374115110"></a><a name="p714374115110"></a>Distance between the two sides of the longest text in <strong id="b143766341196"><a name="b143766341196"></a><a name="b143766341196"></a>texton</strong> and <strong id="b1838317345192"><a name="b1838317345192"></a><a name="b1838317345192"></a>textoff</strong> and the border of the slider.</p>
</td>
</tr>
<tr id="row19143194112115"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p1614364119110"><a name="p1614364119110"></a><a name="p1614364119110"></a>font-size(Rich)</p>
</td>
<td class="cellrowborder" valign="top" width="20.477952204779523%" headers="mcps1.1.6.1.2 "><p id="p11436419111"><a name="p11436419111"></a><a name="p11436419111"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="8.869113088691131%" headers="mcps1.1.6.1.3 "><p id="p21431416117"><a name="p21431416117"></a><a name="p21431416117"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p014313412014"><a name="p014313412014"></a><a name="p014313412014"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p19143184110114"><a name="p19143184110114"></a><a name="p19143184110114"></a>Font size. This attribute is available only when <strong id="b2605184019198"><a name="b2605184019198"></a><a name="b2605184019198"></a>texton</strong> and <strong id="b18612114016193"><a name="b18612114016193"></a><a name="b18612114016193"></a>textoff</strong> are set.</p>
</td>
</tr>
<tr id="row514317411319"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p1143241119"><a name="p1143241119"></a><a name="p1143241119"></a>allow-scale(Rich)</p>
</td>
<td class="cellrowborder" valign="top" width="20.477952204779523%" headers="mcps1.1.6.1.2 "><p id="p1914314117112"><a name="p1914314117112"></a><a name="p1914314117112"></a>boolean</p>
</td>
<td class="cellrowborder" valign="top" width="8.869113088691131%" headers="mcps1.1.6.1.3 "><p id="p514319415118"><a name="p514319415118"></a><a name="p514319415118"></a>true</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p71431411417"><a name="p71431411417"></a><a name="p71431411417"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p71435417112"><a name="p71435417112"></a><a name="p71435417112"></a>Whether the font size changes following the system's font size settings.</p>
<div class="note" id="note214334112118"><a name="note214334112118"></a><a name="note214334112118"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p3143174118114"><a name="p3143174118114"></a><a name="p3143174118114"></a>If the <strong id="b524714361237"><a name="b524714361237"></a><a name="b524714361237"></a>config-changes</strong> tag of <strong id="b19256136236"><a name="b19256136236"></a><a name="b19256136236"></a>fontSize</strong> is configured for abilities in the <strong id="b32576360318"><a name="b32576360318"></a><a name="b32576360318"></a>config.json</strong> file, the setting takes effect without application restart.</p>
</div></div>
</td>
</tr>
<tr id="row114334114116"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p81431141814"><a name="p81431141814"></a><a name="p81431141814"></a>font-style(Rich)</p>
</td>
<td class="cellrowborder" valign="top" width="20.477952204779523%" headers="mcps1.1.6.1.2 "><p id="p20144941015"><a name="p20144941015"></a><a name="p20144941015"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="8.869113088691131%" headers="mcps1.1.6.1.3 "><p id="p1514464111120"><a name="p1514464111120"></a><a name="p1514464111120"></a>normal</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p1914484118112"><a name="p1914484118112"></a><a name="p1914484118112"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p61446412015"><a name="p61446412015"></a><a name="p61446412015"></a>Font style. This attribute is available only when <strong id="b19186714194419"><a name="b19186714194419"></a><a name="b19186714194419"></a>texton</strong> and <strong id="b480316171449"><a name="b480316171449"></a><a name="b480316171449"></a>textoff</strong> are set. For details, see <a href="js-components-basic-text.md#section5775351116">font-style</a> of the <strong id="b12931164418193"><a name="b12931164418193"></a><a name="b12931164418193"></a>text</strong> component.</p>
</td>
</tr>
<tr id="row1414434118113"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p91441641917"><a name="p91441641917"></a><a name="p91441641917"></a>font-weight(Rich)</p>
</td>
<td class="cellrowborder" valign="top" width="20.477952204779523%" headers="mcps1.1.6.1.2 "><p id="p17144241417"><a name="p17144241417"></a><a name="p17144241417"></a>number | string</p>
</td>
<td class="cellrowborder" valign="top" width="8.869113088691131%" headers="mcps1.1.6.1.3 "><p id="p17144184118118"><a name="p17144184118118"></a><a name="p17144184118118"></a>normal</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p2144144115118"><a name="p2144144115118"></a><a name="p2144144115118"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p1714484118114"><a name="p1714484118114"></a><a name="p1714484118114"></a>Font weight. This attribute is available only when <strong id="b419312514441"><a name="b419312514441"></a><a name="b419312514441"></a>texton</strong> and <strong id="b8521102704413"><a name="b8521102704413"></a><a name="b8521102704413"></a>textoff</strong> are set. For details, see <a href="js-components-basic-text.md#section5775351116">font-weight</a> of the <strong id="b15764157161917"><a name="b15764157161917"></a><a name="b15764157161917"></a>text</strong> component.</p>
</td>
</tr>
<tr id="row16144154118117"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p1914419411613"><a name="p1914419411613"></a><a name="p1914419411613"></a>font-family(Rich)</p>
</td>
<td class="cellrowborder" valign="top" width="20.477952204779523%" headers="mcps1.1.6.1.2 "><p id="p61447411415"><a name="p61447411415"></a><a name="p61447411415"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="8.869113088691131%" headers="mcps1.1.6.1.3 "><p id="p191448411817"><a name="p191448411817"></a><a name="p191448411817"></a>sans-serif</p>
</td>
<td class="cellrowborder" valign="top" width="7.519248075192481%" headers="mcps1.1.6.1.4 "><p id="p314415411118"><a name="p314415411118"></a><a name="p314415411118"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="40.01599840015999%" headers="mcps1.1.6.1.5 "><p id="p614414411115"><a name="p614414411115"></a><a name="p614414411115"></a>Font family, in which fonts are separated by commas (,). Each font is set using a font name or font family name. The first font in the family or the font specified by <a href="js-components-common-customizing-font.md">Custom Font Styles</a> is used for the text. This attribute is available only when <strong id="b77641525192017"><a name="b77641525192017"></a><a name="b77641525192017"></a>texton</strong> and <strong id="b1477292511201"><a name="b1477292511201"></a><a name="b1477292511201"></a>textoff</strong> are set.</p>
</td>
</tr>
</tbody>
</table>

## Event<a name="section1042893411015"></a>

In addition to the events in  [Universal Events](js-components-common-events.md), the following events are supported.

<a name="table4429183420016"></a>
<table><thead align="left"><tr id="row14295345017"><th class="cellrowborder" valign="top" width="24.852485248524854%" id="mcps1.1.4.1.1"><p id="p342910341105"><a name="p342910341105"></a><a name="p342910341105"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="29.552955295529554%" id="mcps1.1.4.1.2"><p id="p142913343017"><a name="p142913343017"></a><a name="p142913343017"></a>Parameter</p>
</th>
<th class="cellrowborder" valign="top" width="45.5945594559456%" id="mcps1.1.4.1.3"><p id="p6429034005"><a name="p6429034005"></a><a name="p6429034005"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row94293341601"><td class="cellrowborder" valign="top" width="24.852485248524854%" headers="mcps1.1.4.1.1 "><p id="p842910342010"><a name="p842910342010"></a><a name="p842910342010"></a>change</p>
</td>
<td class="cellrowborder" valign="top" width="29.552955295529554%" headers="mcps1.1.4.1.2 "><p id="p342917344013"><a name="p342917344013"></a><a name="p342917344013"></a>{ checked: checkedValue }</p>
</td>
<td class="cellrowborder" valign="top" width="45.5945594559456%" headers="mcps1.1.4.1.3 "><p id="p24295341304"><a name="p24295341304"></a><a name="p24295341304"></a>Triggered when the <strong id="b611663315206"><a name="b611663315206"></a><a name="b611663315206"></a>checked</strong> state changes.</p>
</td>
</tr>
</tbody>
</table>

## Method<a name="section2279124532420"></a>

Methods in  [Universal Methods](js-components-common-methods.md)  are supported.

## Example Code<a name="section1149419101412"></a>

```
<!-- xxx.hml -->
<div class="container">
  <switch showtext="true" texton="On" textoff="Off" checked="true" @change="switchChange">
  </switch>
</div>
```

```
/* xxx.css */
.container {
  display: flex;
  justify-content: center;
  align-items: center;
}
switch{
  texton-color:#002aff;
  textoff-color:silver;
  text-padding:20px;
}
```

```
// xxx.js
import prompt from '@system.prompt';
export default {
  data: {
    title: 'World'
  },
  switchChange(e){
    console.log(e.checked);
    if(e.checked){
      prompt.showToast({
        message: "Switch on."
      });
    }else{
      prompt.showToast({
        message: "Switch off."
      });
    }
  }
}
```

![](figures/en-us_image_0000001152862510.gif)

