# search<a name="EN-US_TOPIC_0000001173164773"></a>

The  **<search\>**  component provides an input area for users to search.

## Child Component<a name="section9288143101012"></a>

Not supported

## Attribute<a name="section2907183951110"></a>

In addition to the attributes in  [Universal Attributes](js-components-common-attributes.md), the following attributes are supported.

<a name="table20633101642315"></a>
<table><thead align="left"><tr id="row663331618238"><th class="cellrowborder" valign="top" width="23.119999999999997%" id="mcps1.1.6.1.1"><p id="aa872998ac2d84843a3c5161889afffef"><a name="aa872998ac2d84843a3c5161889afffef"></a><a name="aa872998ac2d84843a3c5161889afffef"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="23.119999999999997%" id="mcps1.1.6.1.2"><p id="ab2111648ee0e4f6d881be8954e7acaab"><a name="ab2111648ee0e4f6d881be8954e7acaab"></a><a name="ab2111648ee0e4f6d881be8954e7acaab"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="10.48%" id="mcps1.1.6.1.3"><p id="ab377d1c90900478ea4ecab51e9a058af"><a name="ab377d1c90900478ea4ecab51e9a058af"></a><a name="ab377d1c90900478ea4ecab51e9a058af"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="7.5200000000000005%" id="mcps1.1.6.1.4"><p id="p824610360217"><a name="p824610360217"></a><a name="p824610360217"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="35.76%" id="mcps1.1.6.1.5"><p id="a1d574a0044ed42ec8a2603bc82734232"><a name="a1d574a0044ed42ec8a2603bc82734232"></a><a name="a1d574a0044ed42ec8a2603bc82734232"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row16500184513188"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p19823174614180"><a name="p19823174614180"></a><a name="p19823174614180"></a>icon</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p3823184617189"><a name="p3823184617189"></a><a name="p3823184617189"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p9823946181811"><a name="p9823946181811"></a><a name="p9823946181811"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p1782334621813"><a name="p1782334621813"></a><a name="p1782334621813"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p082364616188"><a name="p082364616188"></a><a name="p082364616188"></a>Search icon. By default, the system search icon is used. The supported icon format is SVG, JPG, and PNG.</p>
</td>
</tr>
<tr id="row517994310189"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p1782314611185"><a name="p1782314611185"></a><a name="p1782314611185"></a>hint</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p6823164617184"><a name="p6823164617184"></a><a name="p6823164617184"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p282314617188"><a name="p282314617188"></a><a name="p282314617188"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p198231046181817"><a name="p198231046181817"></a><a name="p198231046181817"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p1823846131819"><a name="p1823846131819"></a><a name="p1823846131819"></a>Hint text.</p>
</td>
</tr>
<tr id="row19730640181819"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p482374611185"><a name="p482374611185"></a><a name="p482374611185"></a>value</p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p1082315461186"><a name="p1082315461186"></a><a name="p1082315461186"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p1282384613182"><a name="p1282384613182"></a><a name="p1282384613182"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p18823154617189"><a name="p18823154617189"></a><a name="p18823154617189"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p208241446121810"><a name="p208241446121810"></a><a name="p208241446121810"></a>Text in the search box.</p>
</td>
</tr>
<tr id="row83561013112217"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p735651316223"><a name="p735651316223"></a><a name="p735651316223"></a>searchbutton<sup id="sup46781354122715"><a name="sup46781354122715"></a><a name="sup46781354122715"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p1356213172219"><a name="p1356213172219"></a><a name="p1356213172219"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p6356713182219"><a name="p6356713182219"></a><a name="p6356713182219"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p13564131227"><a name="p13564131227"></a><a name="p13564131227"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p4356131312222"><a name="p4356131312222"></a><a name="p4356131312222"></a>Text on the search button at the end of the search box.</p>
</td>
</tr>
<tr id="row31984911281"><td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.1 "><p id="p177221571244"><a name="p177221571244"></a><a name="p177221571244"></a>menuoptions<sup id="sup154944401542"><a name="sup154944401542"></a><a name="sup154944401542"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="23.119999999999997%" headers="mcps1.1.6.1.2 "><p id="p8722157248"><a name="p8722157248"></a><a name="p8722157248"></a>Array&lt;<a href="#table83621954963">MenuOption</a>&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="10.48%" headers="mcps1.1.6.1.3 "><p id="p167221878414"><a name="p167221878414"></a><a name="p167221878414"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="7.5200000000000005%" headers="mcps1.1.6.1.4 "><p id="p197227713411"><a name="p197227713411"></a><a name="p197227713411"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="35.76%" headers="mcps1.1.6.1.5 "><p id="p207221573417"><a name="p207221573417"></a><a name="p207221573417"></a>Menu options displayed after users click the <strong id="b21781315182119"><a name="b21781315182119"></a><a name="b21781315182119"></a>More</strong> button in the pop menu.</p>
</td>
</tr>
</tbody>
</table>

**Table  1**  MenuOption<sup>5+</sup>

<a name="table83621954963"></a>
<table><thead align="left"><tr id="row536212545619"><th class="cellrowborder" valign="top" width="33.33333333333333%" id="mcps1.2.4.1.1"><p id="p143621541967"><a name="p143621541967"></a><a name="p143621541967"></a>Method</p>
</th>
<th class="cellrowborder" valign="top" width="33.33333333333333%" id="mcps1.2.4.1.2"><p id="p936215541620"><a name="p936215541620"></a><a name="p936215541620"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="33.33333333333333%" id="mcps1.2.4.1.3"><p id="p23626541665"><a name="p23626541665"></a><a name="p23626541665"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row5362254461"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.1 "><p id="p33631541265"><a name="p33631541265"></a><a name="p33631541265"></a>icon</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.2 "><p id="p536311543619"><a name="p536311543619"></a><a name="p536311543619"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p73631954762"><a name="p73631954762"></a><a name="p73631954762"></a>Path of the icon for a menu option.</p>
</td>
</tr>
<tr id="row136319547613"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.1 "><p id="p12363654367"><a name="p12363654367"></a><a name="p12363654367"></a>content</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.2 "><p id="p1936312549617"><a name="p1936312549617"></a><a name="p1936312549617"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p1036311548616"><a name="p1036311548616"></a><a name="p1036311548616"></a>Text content in a menu option.</p>
</td>
</tr>
</tbody>
</table>

## Style<a name="section5775351116"></a>

In addition to the styles in  [Universal Styles](js-components-common-styles.md), the following styles are supported.

<a name="table14588121079"></a>
<table><thead align="left"><tr id="row3588182975"><th class="cellrowborder" valign="top" width="23.11768823117688%" id="mcps1.1.6.1.1"><p id="p2588112873"><a name="p2588112873"></a><a name="p2588112873"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="14.1985801419858%" id="mcps1.1.6.1.2"><p id="p18588321876"><a name="p18588321876"></a><a name="p18588321876"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="20.247975202479754%" id="mcps1.1.6.1.3"><p id="p1588132673"><a name="p1588132673"></a><a name="p1588132673"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="5.23947605239476%" id="mcps1.1.6.1.4"><p id="p3588192276"><a name="p3588192276"></a><a name="p3588192276"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="37.1962803719628%" id="mcps1.1.6.1.5"><p id="p55881121575"><a name="p55881121575"></a><a name="p55881121575"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row45881726713"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p1588182874"><a name="p1588182874"></a><a name="p1588182874"></a>color</p>
</td>
<td class="cellrowborder" valign="top" width="14.1985801419858%" headers="mcps1.1.6.1.2 "><p id="p8588725714"><a name="p8588725714"></a><a name="p8588725714"></a>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="20.247975202479754%" headers="mcps1.1.6.1.3 "><p id="p13588521677"><a name="p13588521677"></a><a name="p13588521677"></a>#e6000000</p>
</td>
<td class="cellrowborder" valign="top" width="5.23947605239476%" headers="mcps1.1.6.1.4 "><p id="p11588112272"><a name="p11588112272"></a><a name="p11588112272"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="37.1962803719628%" headers="mcps1.1.6.1.5 "><p id="p17588923718"><a name="p17588923718"></a><a name="p17588923718"></a>Font color of the search box.</p>
</td>
</tr>
<tr id="row858822573"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p25881521973"><a name="p25881521973"></a><a name="p25881521973"></a>font-size</p>
</td>
<td class="cellrowborder" valign="top" width="14.1985801419858%" headers="mcps1.1.6.1.2 "><p id="p13588629717"><a name="p13588629717"></a><a name="p13588629717"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="20.247975202479754%" headers="mcps1.1.6.1.3 "><p id="p15588321719"><a name="p15588321719"></a><a name="p15588321719"></a>16px</p>
</td>
<td class="cellrowborder" valign="top" width="5.23947605239476%" headers="mcps1.1.6.1.4 "><p id="p05899216712"><a name="p05899216712"></a><a name="p05899216712"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="37.1962803719628%" headers="mcps1.1.6.1.5 "><p id="p175891621973"><a name="p175891621973"></a><a name="p175891621973"></a>Font size of the search box.</p>
</td>
</tr>
<tr id="row14589724712"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p155891921078"><a name="p155891921078"></a><a name="p155891921078"></a>allow-scale</p>
</td>
<td class="cellrowborder" valign="top" width="14.1985801419858%" headers="mcps1.1.6.1.2 "><p id="p658922277"><a name="p658922277"></a><a name="p658922277"></a>boolean</p>
</td>
<td class="cellrowborder" valign="top" width="20.247975202479754%" headers="mcps1.1.6.1.3 "><p id="p12589521713"><a name="p12589521713"></a><a name="p12589521713"></a>true</p>
</td>
<td class="cellrowborder" valign="top" width="5.23947605239476%" headers="mcps1.1.6.1.4 "><p id="p155891121872"><a name="p155891121872"></a><a name="p155891121872"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="37.1962803719628%" headers="mcps1.1.6.1.5 "><p id="p55894219719"><a name="p55894219719"></a><a name="p55894219719"></a>Whether the font size changes with the system's font size settings.</p>
<div class="note" id="note13589162372"><a name="note13589162372"></a><a name="note13589162372"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p12589021175"><a name="p12589021175"></a><a name="p12589021175"></a>If the <strong id="b740874017101"><a name="b740874017101"></a><a name="b740874017101"></a>config-changes</strong> tag of <strong id="b12415940161018"><a name="b12415940161018"></a><a name="b12415940161018"></a>fontSize</strong> is configured for abilities in the <strong id="b1415740131016"><a name="b1415740131016"></a><a name="b1415740131016"></a>config.json</strong> file, the setting takes effect without application restart.</p>
</div></div>
</td>
</tr>
<tr id="row3589121375"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p95891321170"><a name="p95891321170"></a><a name="p95891321170"></a>placeholder-color</p>
</td>
<td class="cellrowborder" valign="top" width="14.1985801419858%" headers="mcps1.1.6.1.2 "><p id="p1058982376"><a name="p1058982376"></a><a name="p1058982376"></a>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="20.247975202479754%" headers="mcps1.1.6.1.3 "><p id="p9589726718"><a name="p9589726718"></a><a name="p9589726718"></a>#99000000</p>
</td>
<td class="cellrowborder" valign="top" width="5.23947605239476%" headers="mcps1.1.6.1.4 "><p id="p558914219710"><a name="p558914219710"></a><a name="p558914219710"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="37.1962803719628%" headers="mcps1.1.6.1.5 "><p id="p25896215710"><a name="p25896215710"></a><a name="p25896215710"></a>Color of the hint text.</p>
</td>
</tr>
<tr id="row1658911216712"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p4589182976"><a name="p4589182976"></a><a name="p4589182976"></a>font-weight</p>
</td>
<td class="cellrowborder" valign="top" width="14.1985801419858%" headers="mcps1.1.6.1.2 "><p id="p18589122578"><a name="p18589122578"></a><a name="p18589122578"></a>number | string</p>
</td>
<td class="cellrowborder" valign="top" width="20.247975202479754%" headers="mcps1.1.6.1.3 "><p id="p1058982179"><a name="p1058982179"></a><a name="p1058982179"></a>normal</p>
</td>
<td class="cellrowborder" valign="top" width="5.23947605239476%" headers="mcps1.1.6.1.4 "><p id="p1058917212710"><a name="p1058917212710"></a><a name="p1058917212710"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="37.1962803719628%" headers="mcps1.1.6.1.5 "><p id="p2058912778"><a name="p2058912778"></a><a name="p2058912778"></a>Font weight. For details, see <a href="js-components-basic-text.md#section5775351116">font-weight</a> of the <strong id="b126119204152"><a name="b126119204152"></a><a name="b126119204152"></a>text</strong> component.</p>
</td>
</tr>
<tr id="row45906217712"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p115907212715"><a name="p115907212715"></a><a name="p115907212715"></a>font-family</p>
</td>
<td class="cellrowborder" valign="top" width="14.1985801419858%" headers="mcps1.1.6.1.2 "><p id="p459015215711"><a name="p459015215711"></a><a name="p459015215711"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="20.247975202479754%" headers="mcps1.1.6.1.3 "><p id="p4590172674"><a name="p4590172674"></a><a name="p4590172674"></a>sans-serif</p>
</td>
<td class="cellrowborder" valign="top" width="5.23947605239476%" headers="mcps1.1.6.1.4 "><p id="p12590828720"><a name="p12590828720"></a><a name="p12590828720"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="37.1962803719628%" headers="mcps1.1.6.1.5 "><p id="p17590721579"><a name="p17590721579"></a><a name="p17590721579"></a>Font family, in which fonts are separated by commas (,). Each font is set using a font name or font family name. The first font that exists in the system or the font specified by <a href="js-components-common-customizing-font.md">Custom Font Styles</a> in the family is selected as the font for the text. </p>
</td>
</tr>
<tr id="row583415126314"><td class="cellrowborder" valign="top" width="23.11768823117688%" headers="mcps1.1.6.1.1 "><p id="p153521247133716"><a name="p153521247133716"></a><a name="p153521247133716"></a>caret-color<sup id="sup535294718377"><a name="sup535294718377"></a><a name="sup535294718377"></a>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="14.1985801419858%" headers="mcps1.1.6.1.2 "><p id="p53529471377"><a name="p53529471377"></a><a name="p53529471377"></a>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="20.247975202479754%" headers="mcps1.1.6.1.3 "><p id="p235244716372"><a name="p235244716372"></a><a name="p235244716372"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="5.23947605239476%" headers="mcps1.1.6.1.4 "><p id="p4352174712375"><a name="p4352174712375"></a><a name="p4352174712375"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="37.1962803719628%" headers="mcps1.1.6.1.5 "><p id="p1935320474379"><a name="p1935320474379"></a><a name="p1935320474379"></a>Color of the input cursor.</p>
</td>
</tr>
</tbody>
</table>

## Event<a name="section17878123517511"></a>

In addition to the events in  [Universal Events](js-components-common-events.md), the following events are supported.

<a name="table13878203565113"></a>
<table><thead align="left"><tr id="row18789355519"><th class="cellrowborder" valign="top" width="24.852485248524854%" id="mcps1.1.4.1.1"><p id="p08781335165113"><a name="p08781335165113"></a><a name="p08781335165113"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="29.552955295529554%" id="mcps1.1.4.1.2"><p id="p6878123595117"><a name="p6878123595117"></a><a name="p6878123595117"></a>Parameter</p>
</th>
<th class="cellrowborder" valign="top" width="45.5945594559456%" id="mcps1.1.4.1.3"><p id="p28783359518"><a name="p28783359518"></a><a name="p28783359518"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2087803565116"><td class="cellrowborder" valign="top" width="24.852485248524854%" headers="mcps1.1.4.1.1 "><p id="p3878113518516"><a name="p3878113518516"></a><a name="p3878113518516"></a>change</p>
</td>
<td class="cellrowborder" valign="top" width="29.552955295529554%" headers="mcps1.1.4.1.2 "><p id="p187813511516"><a name="p187813511516"></a><a name="p187813511516"></a>{ text:newText }</p>
</td>
<td class="cellrowborder" valign="top" width="45.5945594559456%" headers="mcps1.1.4.1.3 "><p id="p19878133518518"><a name="p19878133518518"></a><a name="p19878133518518"></a>Triggered when the content entered in the text box changes.</p>
<div class="note" id="note887893525112"><a name="note887893525112"></a><a name="note887893525112"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p19878435115119"><a name="p19878435115119"></a><a name="p19878435115119"></a>If you change the <strong id="b1292019401570"><a name="b1292019401570"></a><a name="b1292019401570"></a>value</strong> attribute directly, this event will not be triggered.</p>
</div></div>
</td>
</tr>
<tr id="row28781235145111"><td class="cellrowborder" valign="top" width="24.852485248524854%" headers="mcps1.1.4.1.1 "><p id="p48781535195110"><a name="p48781535195110"></a><a name="p48781535195110"></a>submit</p>
</td>
<td class="cellrowborder" valign="top" width="29.552955295529554%" headers="mcps1.1.4.1.2 "><p id="p19878535135111"><a name="p19878535135111"></a><a name="p19878535135111"></a>{ text:submitText }</p>
</td>
<td class="cellrowborder" valign="top" width="45.5945594559456%" headers="mcps1.1.4.1.3 "><p id="p13878335145119"><a name="p13878335145119"></a><a name="p13878335145119"></a>Triggered when users click the search icon or the search button<sup id="sup790816581014"><a name="sup790816581014"></a><a name="sup790816581014"></a>5+</sup>, or tap the search button on a soft keyboard.</p>
</td>
</tr>
<tr id="row108791535175110"><td class="cellrowborder" valign="top" width="24.852485248524854%" headers="mcps1.1.4.1.1 "><p id="p118790355519"><a name="p118790355519"></a><a name="p118790355519"></a>translate<sup id="sup18879203525118"><a name="sup18879203525118"></a><a name="sup18879203525118"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="29.552955295529554%" headers="mcps1.1.4.1.2 "><p id="p9879113511519"><a name="p9879113511519"></a><a name="p9879113511519"></a>{ value: selectedText }</p>
</td>
<td class="cellrowborder" valign="top" width="45.5945594559456%" headers="mcps1.1.4.1.3 "><p id="p08797356513"><a name="p08797356513"></a><a name="p08797356513"></a>Triggered when users click the translate button in the pop menu displayed after they select a text segment. The selected text content is returned.</p>
</td>
</tr>
<tr id="row68791835175117"><td class="cellrowborder" valign="top" width="24.852485248524854%" headers="mcps1.1.4.1.1 "><p id="p12879135135120"><a name="p12879135135120"></a><a name="p12879135135120"></a>share<sup id="sup3879173513515"><a name="sup3879173513515"></a><a name="sup3879173513515"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="29.552955295529554%" headers="mcps1.1.4.1.2 "><p id="p5879153595110"><a name="p5879153595110"></a><a name="p5879153595110"></a>{ value: selectedText }</p>
</td>
<td class="cellrowborder" valign="top" width="45.5945594559456%" headers="mcps1.1.4.1.3 "><p id="p15879183520514"><a name="p15879183520514"></a><a name="p15879183520514"></a>Triggered when users click the share button in the pop menu displayed after they select a text segment. The selected text content is returned.</p>
</td>
</tr>
<tr id="row1287912352517"><td class="cellrowborder" valign="top" width="24.852485248524854%" headers="mcps1.1.4.1.1 "><p id="p198791035125112"><a name="p198791035125112"></a><a name="p198791035125112"></a>search<sup id="sup1487914358515"><a name="sup1487914358515"></a><a name="sup1487914358515"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="29.552955295529554%" headers="mcps1.1.4.1.2 "><p id="p9879735125114"><a name="p9879735125114"></a><a name="p9879735125114"></a>{ value: selectedText }</p>
</td>
<td class="cellrowborder" valign="top" width="45.5945594559456%" headers="mcps1.1.4.1.3 "><p id="p38791935135119"><a name="p38791935135119"></a><a name="p38791935135119"></a>Triggered when users click the search button in the pop menu displayed after they select a text segment. The selected text content is returned.</p>
</td>
</tr>
<tr id="row14879335145120"><td class="cellrowborder" valign="top" width="24.852485248524854%" headers="mcps1.1.4.1.1 "><p id="p98790359512"><a name="p98790359512"></a><a name="p98790359512"></a>optionselect<sup id="sup28791635145111"><a name="sup28791635145111"></a><a name="sup28791635145111"></a>5+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="29.552955295529554%" headers="mcps1.1.4.1.2 "><p id="p158791235115114"><a name="p158791235115114"></a><a name="p158791235115114"></a>{ index:optionIndex, value: selectedText }</p>
</td>
<td class="cellrowborder" valign="top" width="45.5945594559456%" headers="mcps1.1.4.1.3 "><p id="p1087917353518"><a name="p1087917353518"></a><a name="p1087917353518"></a>Triggered when users click a menu option in the pop menu displayed after they select a text segment. This event is valid only when the <strong id="b192388148166"><a name="b192388148166"></a><a name="b192388148166"></a>menuoptions</strong> attribute is set. The option index and selected text content are returned.</p>
</td>
</tr>
</tbody>
</table>

## Method<a name="section2279124532420"></a>

Methods in  [Universal Methods](js-components-common-methods.md)  are supported.

## Example Code<a name="section586520905216"></a>

```
<!-- xxx.hml -->
<div class="container">
  <search hint="Enter keywords" searchbutton="Search" @search="search">
  </search>
</div>
```

```
/* xxx.css */
.container {
  display: flex;
  justify-content: center;
  align-items: center;
}
```

![](figures/en-us_image_0000001153427082.png)

