# piece<a name="EN-US_TOPIC_0000001173164767"></a>

An entrance piece that can contain images and text. It is usually used to display receivers, for example, email recipients or message recipients.

>![](../../public_sys-resources/icon-note.gif) **NOTE:** 
>This component is supported since API version 5.

## Child Component<a name="section9288143101012"></a>

None

## Attribute<a name="section2907183951110"></a>

In addition to the attributes in  [Universal Attributes](js-components-common-attributes.md), the following attributes are supported.

<a name="table20633101642315"></a>
<table><thead align="left"><tr id="row663331618238"><th class="cellrowborder" valign="top" width="14.5014501450145%" id="mcps1.1.6.1.1"><p id="a45273e2103004ff3bdd3375013e96a2a"><a name="a45273e2103004ff3bdd3375013e96a2a"></a><a name="a45273e2103004ff3bdd3375013e96a2a"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="12.62126212621262%" id="mcps1.1.6.1.2"><p id="ad5b10d4a60e44bb4a8bbb3b4416d7b27"><a name="ad5b10d4a60e44bb4a8bbb3b4416d7b27"></a><a name="ad5b10d4a60e44bb4a8bbb3b4416d7b27"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="8.03080308030803%" id="mcps1.1.6.1.3"><p id="ab2ae3d9f60d6475ab95ba095851a9d07"><a name="ab2ae3d9f60d6475ab95ba095851a9d07"></a><a name="ab2ae3d9f60d6475ab95ba095851a9d07"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="6.64066406640664%" id="mcps1.1.6.1.4"><p id="p154141646194"><a name="p154141646194"></a><a name="p154141646194"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="58.2058205820582%" id="mcps1.1.6.1.5"><p id="af5c3b773ed0a42e589819a6c8d257ca1"><a name="af5c3b773ed0a42e589819a6c8d257ca1"></a><a name="af5c3b773ed0a42e589819a6c8d257ca1"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1875918426407"><td class="cellrowborder" valign="top" width="14.5014501450145%" headers="mcps1.1.6.1.1 "><p id="p15759174219407"><a name="p15759174219407"></a><a name="p15759174219407"></a>content</p>
</td>
<td class="cellrowborder" valign="top" width="12.62126212621262%" headers="mcps1.1.6.1.2 "><p id="p14759184212400"><a name="p14759184212400"></a><a name="p14759184212400"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="8.03080308030803%" headers="mcps1.1.6.1.3 "><p id="p575913424403"><a name="p575913424403"></a><a name="p575913424403"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="6.64066406640664%" headers="mcps1.1.6.1.4 "><p id="p24156461792"><a name="p24156461792"></a><a name="p24156461792"></a>Yes</p>
</td>
<td class="cellrowborder" valign="top" width="58.2058205820582%" headers="mcps1.1.6.1.5 "><p id="p1975944244011"><a name="p1975944244011"></a><a name="p1975944244011"></a>Text content of the operational piece.</p>
</td>
</tr>
<tr id="row1401171483915"><td class="cellrowborder" valign="top" width="14.5014501450145%" headers="mcps1.1.6.1.1 "><p id="p637566151211"><a name="p637566151211"></a><a name="p637566151211"></a>closable</p>
</td>
<td class="cellrowborder" valign="top" width="12.62126212621262%" headers="mcps1.1.6.1.2 "><p id="p134021148395"><a name="p134021148395"></a><a name="p134021148395"></a>boolean</p>
</td>
<td class="cellrowborder" valign="top" width="8.03080308030803%" headers="mcps1.1.6.1.3 "><p id="p1840211418393"><a name="p1840211418393"></a><a name="p1840211418393"></a>false</p>
</td>
<td class="cellrowborder" valign="top" width="6.64066406640664%" headers="mcps1.1.6.1.4 "><p id="p1415746595"><a name="p1415746595"></a><a name="p1415746595"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="58.2058205820582%" headers="mcps1.1.6.1.5 "><p id="p19402201416398"><a name="p19402201416398"></a><a name="p19402201416398"></a>Whether to display the delete icon for the operational piece. When users click the delete icon, it triggers the close event.</p>
</td>
</tr>
<tr id="row78648123418"><td class="cellrowborder" valign="top" width="14.5014501450145%" headers="mcps1.1.6.1.1 "><p id="p173023953412"><a name="p173023953412"></a><a name="p173023953412"></a>icon</p>
</td>
<td class="cellrowborder" valign="top" width="12.62126212621262%" headers="mcps1.1.6.1.2 "><p id="p530216953412"><a name="p530216953412"></a><a name="p530216953412"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="8.03080308030803%" headers="mcps1.1.6.1.3 "><p id="p3302149133418"><a name="p3302149133418"></a><a name="p3302149133418"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="6.64066406640664%" headers="mcps1.1.6.1.4 "><p id="p103024953410"><a name="p103024953410"></a><a name="p103024953410"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="58.2058205820582%" headers="mcps1.1.6.1.5 "><p id="p230211914342"><a name="p230211914342"></a><a name="p230211914342"></a>URL of the delete icon for the operational piece. The value can be a local path.</p>
</td>
</tr>
</tbody>
</table>

## Style<a name="section17756476592"></a>

Styles in  [Universal Styles](js-components-common-styles.md)  are supported.

>![](../../public_sys-resources/icon-note.gif) **NOTE:** 
>By default, text and images are placed in the middle of the  **<piece\>**  component.

## Event<a name="section19137152119"></a>

In addition to the events in  [Universal Events](js-components-common-events.md), the following events are supported.

<a name="table3674139193020"></a>
<table><thead align="left"><tr id="row14674539123012"><th class="cellrowborder" valign="top" width="24.852485248524854%" id="mcps1.1.4.1.1"><p id="a426b8903842d48fa8012a24ff3c997eb"><a name="a426b8903842d48fa8012a24ff3c997eb"></a><a name="a426b8903842d48fa8012a24ff3c997eb"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="29.552955295529554%" id="mcps1.1.4.1.2"><p id="a53448ba47e5e4ae9bf7774c90820e970"><a name="a53448ba47e5e4ae9bf7774c90820e970"></a><a name="a53448ba47e5e4ae9bf7774c90820e970"></a>Parameter</p>
</th>
<th class="cellrowborder" valign="top" width="45.5945594559456%" id="mcps1.1.4.1.3"><p id="add489ff50c444f24b759162c7f4bad9a"><a name="add489ff50c444f24b759162c7f4bad9a"></a><a name="add489ff50c444f24b759162c7f4bad9a"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row418514431304"><td class="cellrowborder" valign="top" width="24.852485248524854%" headers="mcps1.1.4.1.1 "><p id="p11911549133016"><a name="p11911549133016"></a><a name="p11911549133016"></a>close</p>
</td>
<td class="cellrowborder" valign="top" width="29.552955295529554%" headers="mcps1.1.4.1.2 "><p id="p1691204993018"><a name="p1691204993018"></a><a name="p1691204993018"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="45.5945594559456%" headers="mcps1.1.4.1.3 "><p id="p1891114933015"><a name="p1891114933015"></a><a name="p1891114933015"></a>Triggered when users click the delete icon of the operational piece. You can delete this component by using the <strong id="b1276472010487"><a name="b1276472010487"></a><a name="b1276472010487"></a>if</strong> directive.</p>
</td>
</tr>
</tbody>
</table>

## Method<a name="section2279124532420"></a>

Methods in  [Universal Methods](js-components-common-methods.md)  are supported.

## Example<a name="section118886119320"></a>

```
<!-- xxx.hml-->
<div>
  <piece if="{{first}}" content="Huawei"></piece>
  <piece if="{{second}}" content="Huawei" closable="true" onclose="closeSecond"></piece>
</div>
```

```
// xxx.js
export default {
  data: {
    first: true,
    second: true
  },
  closeSecond(e) {
    this.second = false;
  }
}
```

![](figures/1-38.gif)

