# Form

Form是一个表单容器，支持容器内[Input](../reference/arkui-js/js-components-basic-input.md)组件内容的提交和重置。具体用法请参考[Form API](../reference/arkui-js/js-components-container-form.md)。


> ![icon-note.gif](public_sys-resources/icon-note.gif) **说明：**
> 从 API Version 6 开始支持。


## 创建Form组件

在pages/index目录下的hml文件中创建一个Form组件。
```
<!-- xxx.hml -->
<div class="container">
  <form>  <input type="text" style="width:80%"></input>
  </form>
</div>
```

```
/* xxx.css */
.container {
  flex-direction: column;
  justify-content: center;
  align-items: center;
  background-color: #F1F3F5;
}
```

![zh-cn_image_0000001211069339](figures/zh-cn_image_0000001211069339.png)


## 实现表单缩放

为Form组件添加click-effect属性，实现点击表单后的缩放效果，click-effect枚举值请参考[通用属性](../reference/arkui-js/js-components-common-attributes.md)。
```
<!-- xxx.hml -->
<div class="container">
  <form  id="formId" class="formClass" click-effect="spring-large">
    <input type="text"></input>  
  </form>
</div>
```


## 设置Form样式


通过为Form添加background-color和border属性，来设置表单的背景颜色和边框。


```
/* xxx.css */
.container {
  flex-direction: column;
  align-items: center;
  justify-content: center;
  background-color: #F1F3F5;
}
.formClass{
  width: 80%;
  padding: 10px;
  border: 1px solid #c3d3e7;
}
```


![zh-cn_image_0000001208771113](figures/zh-cn_image_0000001208771113.gif)


## 添加响应事件

为Form组件添加submit和reset事件，来提交表单内容或重置表单选项。
```
<!-- xxx.hml -->
<div class="container" style="background-color:#F1F3F5;">
  <form onsubmit='onSubmit' onreset='onReset' style="justify-content: center; align-items: center;text-align: center;">
    <div style="flex-direction: column;justify-content: center;align-self: center;">
      <div style="justify-content: center; align-items: center;">
        <label>Option 1</label>
        <input type='radio' name='radioGroup' value='radio1'></input>
        <label>Option 2</label>
        <input type='radio' name='radioGroup' value='radio2'></input>
      </div>
      <div style="margin-top: 30px;justify-content: center; align-items: center;">
        <input type="submit" value="Submit" style="width:100px; margin-right:20px;" ></input>
        <input type="reset" value="Reset" style="width:100px;"></input>
      </div>
    </div> 
  </form>
</div>
```

```
/* xxx.js */
import prompt from '@system.prompt';
export default{
  onSubmit(result) {
    prompt.showToast({
      message: result.value.radioGroup
    })
  },
  onReset() {
    prompt.showToast({
      message: 'Reset All'
    })
  }
}
```


![zh-cn_image_0000001234329539](figures/zh-cn_image_0000001234329539.gif)


## 场景示例

在本场景中，开发者可以选择相应选项并提交或重置数据。

创建[Input](../reference/arkui-js/js-components-basic-input.md)组件，分别设置type属性为checkbox（多选框）和radio（单选框），再使用Form组件的onsubmit和onreset事件实现表单数据的提交与重置。

```
<!-- xxx.hml -->
<div class="container">
   <form onsubmit="formSubmit" onreset="formReset">
 <text style="font-size: 30px; margin-bottom: 20px; margin-top: 100px;">
      <span > Form </span>
  </text>
    <div style="flex-direction: column;width: 90%;padding: 30px 0px;">
     <text class="txt">Select 1 or more options</text>
      <div style="width: 90%;height: 150px;align-items: center;justify-content: space-around;">
        <label target="checkbox1">Option 1</label>
        <input id="checkbox1" type="checkbox" name="checkbox1"></input>
        <label target="checkbox2">Option 2</label>
        <input id="checkbox2" type="checkbox" name="checkbox2"></input>
       </div>
       <divider style="margin: 20px 0px;color: pink;height: 5px;"></divider>
       <text class="txt">Select 1 option</text>
       <div style="width: 90%;height: 150px;align-items: center;justify-content: space-around;">
         <label target="radio1">Option 1</label>
         <input id="radio1" type="radio" name="myradio"></input>
         <label target="radio2">Option 2</label>
         <input id="radio2" type="radio" name="myradio"></input>
       </div>
       <divider style="margin: 20px 0px;color: pink;height: 5px;"></divider>
       <text class="txt">Text box</text>
       <input type="text" placeholder="Enter content." style="margin-top: 50px;"></input>
       <div style="width: 90%;align-items: center;justify-content: space-between;margin: 40px;">
         <input type="submit">Submit</input>
         <input type="reset">Reset</input>
       </div>
    </div>
  </form>
</div>
```

```
/* index.css */
.container {
  flex-direction:column;
  align-items:center;
  background-color:#F1F3F5;
}
.txt {
  font-size:33px;
  font-weight:bold;
  color:darkgray;
}
label{
  font-size: 20px;
}
```

```
/* xxx.js */
import prompt from '@system.prompt';
export default {
  formSubmit() {
    prompt.showToast({
      message: 'Submitted.'
    })
  },
  formReset() {
    prompt.showToast({
      message: 'Reset.'
    })
  }
}
```

![zh-cn_image_0000001234289465](figures/zh-cn_image_0000001234289465.gif)
