# 后台任务概述

后台应用频繁活动，会造成用户设备耗电快、卡顿等现象。因此，为了支撑性能、功耗诉求，系统仅允许应用在后台执行规范内的活动，规范外的活动默认会被挂起，当资源不足时会被回收。


## 后台任务类型

本文描述的后台任务特指应用或业务模块处于后台（无可见界面）时，有需要继续执行或者后续执行的业务。对这些应用不可见但要继续或者将要执行的业务动作，为避免后台任务管理对业务执行的影响，OpenHarmony将后台任务分为三种类型：

1. 无后台业务：退后台后，无任务需要处理。

2. 短时任务：退后台后，如果有紧急不可推迟且短时间能完成的任务，如应用退后台要进行数据压缩，不可中断，则使用短时任务申请延迟进入挂起（Suspend）状态。

3. 长时任务：如果是用户发起的可感知业务需要长时间后台运行的，如后台播放音乐、导航、设备连接、VoIP等，则使用长时任务避免进入挂起（Suspend）状态。


## 短时任务

退到后台的应用有不可中断且短时间能完成的任务时，可以使用短时任务机制，该机制允许应用在后台短时间内完成任务，保障应用业务运行不受后台生命周期管理的影响。

> ![icon-note.gif](public_sys-resources/icon-note.gif) **说明：**
> 短时任务仅针对应用的临时任务提供资源使用生命周期保障，限制单次最大使用时长为3分钟，全天使用配额默认为10分钟（具体时长系统根据应用场景和系统状态智能调整）。


### 短时任务使用约束

短时任务的使用需要遵从如下约束和规则：

- **申请时机**：允许应用在前台时，或退后台在被挂起之前（应用退到后台默认有6~12秒的运行时长，具体时长由系统根据具体场景决定）申请延迟挂起，否则可能被挂起（Suspend），导致申请失败。

- **超时**：延迟挂起超时（Timeout），系统通过回调知会应用，应用需要取消对应的延迟挂起，或再次申请延迟挂起。超期不取消或不处理，该应用会被强制取消延迟挂起。

- **取消时机**：任务完成后申请方应用主动取消延时申请，不要等到超时后被系统取消，否则会影响该应用的后台允许运行时长配额。

- **配额机制**：为了防止应用滥用保活，或者申请后不取消，每个应用每天都会有一定配额（会根据用户的使用习惯动态调整），配额消耗完就不再允许申请短时任务，所以应用完成短时任务后立刻取消延时申请，避免消耗配额。（注，这个配额指的是申请的时长，系统默认应用在后台运行的时间不计算在内）。

## 长时任务
长时任务给用户能够直观感受到的且需要一直在后台运行的业务提供后台运行生命周期的保障。比如：业务需要在后台播放声音、需要在后台持续导航定位等。此类用户可以直观感知到的后台业务行为，可以通过使用长时任务对应的后台模式保障业务在后台的运行，支撑应用完成在后台的业务。

### 后台模式分类
OpenHarmony提供了九种后台模式，供需要在后台做长时任务的业务使用，具体的后台模式类型如下：

**表1** 长时任务种类

| BackgroundMode | 说明 | 通知栏显示提示 | 备注 |
| -------- | -------- | -------- | -------- |
| dataTransfer | 通过网络/对端设备进行数据下载、备份、分享、传输等 | 正在运行数据传输任务 |  |
| audioPlayback | 音频输出 | 正在运行音频播放任务 |  |
| audioRecording | 音频输入 | 正在运行录音任务 |  |
| location | 定位、导航 | 正在运行定位任务 |  |
| bluetoothInteraction | 蓝牙传输 | 正在运行蓝牙相关任务 |  |
| multiDeviceConnection | 分布式互联任务 | 正在运行分布式任务 |  |
| wifiInteraction | WLAN传输 | 正在运行WLAN相关任务 | SystemApi，仅对System权限应用开放 |
| voip | 音视频电话、VOIP | 正在运行通话相关任务 | SystemApi，仅对System权限应用开放 |
| taskKeeping | 计算任务 | 正在运行计算任务 | PC特有，仅在PC申请生效 |

### 长时任务使用约束
- 如果用户选择可感知业务（如播音、导航等），触发对应后台模式，在任务启动时，系统会强制弹出通知提醒用户。
- 如果任务结束，应用应主动退出后台模式。若在后台运行期间，系统检测到应用并未使用对应后台模式的资源，则会被挂起（Suspend）。
- 避免不合理地申请后台长时任务，长时任务类型要与应用的业务类型匹配。如果执行的任务和申请的类型不匹配，也会被系统检测到并被挂起（Suspend）。
- 长时任务是为了真正在后台长时间执行某个任务，如果一个应用申请了长时任务，但在实际运行过程中，并未真正运行或执行此类任务时，也会被系统检测到并被挂起（Suspend）。
- 一个Ability同一时刻只能申请运行一个长时任务。