# text<a name="EN-US_TOPIC_0000001127125018"></a>

The  **<text\>**  component is used to display a piece of textual information.

>![](../../public_sys-resources/icon-note.gif) **NOTE:** 
>-   The text content must be written in the content area.

## Required Permissions<a name="section11257113618419"></a>

None

## Child Component<a name="section9288143101012"></a>

**<[span](js-components-basic-span.md)\>**  is supported. 

## Attributes<a name="section2907183951110"></a>

Attributes in  [Universal Attributes](js-components-common-attributes.md)  are supported.

## Styles<a name="section5775351116"></a>

In addition to the styles in  [Universal Styles](js-components-common-styles.md), the following styles are supported.

<a name="table11509320639"></a>
<table><thead align="left"><tr id="row1550982016312"><th class="cellrowborder" valign="top" width="16.58834116588341%" id="mcps1.1.6.1.1"><p id="p125091520234"><a name="p125091520234"></a><a name="p125091520234"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="12.37876212378762%" id="mcps1.1.6.1.2"><p id="p1509102011311"><a name="p1509102011311"></a><a name="p1509102011311"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="20.907909209079094%" id="mcps1.1.6.1.3"><p id="p6509320638"><a name="p6509320638"></a><a name="p6509320638"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="5.959404059594041%" id="mcps1.1.6.1.4"><p id="p6509220933"><a name="p6509220933"></a><a name="p6509220933"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="44.16558344165583%" id="mcps1.1.6.1.5"><p id="p950911201138"><a name="p950911201138"></a><a name="p950911201138"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row205092202034"><td class="cellrowborder" valign="top" width="16.58834116588341%" headers="mcps1.1.6.1.1 "><p id="p105090201332"><a name="p105090201332"></a><a name="p105090201332"></a>color</p>
</td>
<td class="cellrowborder" valign="top" width="12.37876212378762%" headers="mcps1.1.6.1.2 "><p id="p1050917201310"><a name="p1050917201310"></a><a name="p1050917201310"></a>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="20.907909209079094%" headers="mcps1.1.6.1.3 "><p id="p155090201833"><a name="p155090201833"></a><a name="p155090201833"></a>#e5000000</p>
</td>
<td class="cellrowborder" valign="top" width="5.959404059594041%" headers="mcps1.1.6.1.4 "><p id="p4509720836"><a name="p4509720836"></a><a name="p4509720836"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="44.16558344165583%" headers="mcps1.1.6.1.5 "><p id="p18509132017312"><a name="p18509132017312"></a><a name="p18509132017312"></a>Text color.</p>
</td>
</tr>
<tr id="row65091120339"><td class="cellrowborder" valign="top" width="16.58834116588341%" headers="mcps1.1.6.1.1 "><p id="p3509122017312"><a name="p3509122017312"></a><a name="p3509122017312"></a>font-size</p>
</td>
<td class="cellrowborder" valign="top" width="12.37876212378762%" headers="mcps1.1.6.1.2 "><p id="p1750912203310"><a name="p1750912203310"></a><a name="p1750912203310"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="20.907909209079094%" headers="mcps1.1.6.1.3 "><p id="p17510122018310"><a name="p17510122018310"></a><a name="p17510122018310"></a>30px</p>
</td>
<td class="cellrowborder" valign="top" width="5.959404059594041%" headers="mcps1.1.6.1.4 "><p id="p151014201234"><a name="p151014201234"></a><a name="p151014201234"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="44.16558344165583%" headers="mcps1.1.6.1.5 "><p id="p5510520039"><a name="p5510520039"></a><a name="p5510520039"></a>Font size (px).</p>
</td>
</tr>
<tr id="row1351011202036"><td class="cellrowborder" valign="top" width="16.58834116588341%" headers="mcps1.1.6.1.1 "><p id="p851019201937"><a name="p851019201937"></a><a name="p851019201937"></a>allow-scale </p>
</td>
<td class="cellrowborder" valign="top" width="12.37876212378762%" headers="mcps1.1.6.1.2 "><p id="p1751052012312"><a name="p1751052012312"></a><a name="p1751052012312"></a>boolean</p>
</td>
<td class="cellrowborder" valign="top" width="20.907909209079094%" headers="mcps1.1.6.1.3 "><p id="p65103201312"><a name="p65103201312"></a><a name="p65103201312"></a>true</p>
</td>
<td class="cellrowborder" valign="top" width="5.959404059594041%" headers="mcps1.1.6.1.4 "><p id="p651012207315"><a name="p651012207315"></a><a name="p651012207315"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="44.16558344165583%" headers="mcps1.1.6.1.5 "><p id="p1951012205310"><a name="p1951012205310"></a><a name="p1951012205310"></a>Whether the font size changes with the system's font size settings.</p>
<div class="note" id="note12510112010317"><a name="note12510112010317"></a><a name="note12510112010317"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p10510720332"><a name="p10510720332"></a><a name="p10510720332"></a>For details about how to make the configuration take effect dynamically, see the <strong id="b65592247511"><a name="b65592247511"></a><a name="b65592247511"></a>config-changes</strong> attribute in the <strong id="b1576712361551"><a name="b1576712361551"></a><a name="b1576712361551"></a>config.json</strong> file.</p>
</div></div>
</td>
</tr>
<tr id="row251042012318"><td class="cellrowborder" valign="top" width="16.58834116588341%" headers="mcps1.1.6.1.1 "><p id="p15510120730"><a name="p15510120730"></a><a name="p15510120730"></a>letter-spacing</p>
</td>
<td class="cellrowborder" valign="top" width="12.37876212378762%" headers="mcps1.1.6.1.2 "><p id="p651012011314"><a name="p651012011314"></a><a name="p651012011314"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="20.907909209079094%" headers="mcps1.1.6.1.3 "><p id="p195101320132"><a name="p195101320132"></a><a name="p195101320132"></a>0 px </p>
</td>
<td class="cellrowborder" valign="top" width="5.959404059594041%" headers="mcps1.1.6.1.4 "><p id="p951020207320"><a name="p951020207320"></a><a name="p951020207320"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="44.16558344165583%" headers="mcps1.1.6.1.5 "><p id="p75108209318"><a name="p75108209318"></a><a name="p75108209318"></a>Character spacing (px).</p>
</td>
</tr>
<tr id="row946783210188"><td class="cellrowborder" valign="top" width="16.58834116588341%" headers="mcps1.1.6.1.1 "><p id="p1246710327185"><a name="p1246710327185"></a><a name="p1246710327185"></a>word-spacing<sup id="sup1961211505"><a name="sup1961211505"></a><a name="sup1961211505"></a>7+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="12.37876212378762%" headers="mcps1.1.6.1.2 "><p id="p134671832131819"><a name="p134671832131819"></a><a name="p134671832131819"></a>&lt;length&gt; | &lt;percentage&gt; | string</p>
</td>
<td class="cellrowborder" valign="top" width="20.907909209079094%" headers="mcps1.1.6.1.3 "><p id="p146753217185"><a name="p146753217185"></a><a name="p146753217185"></a>normal</p>
</td>
<td class="cellrowborder" valign="top" width="5.959404059594041%" headers="mcps1.1.6.1.4 "><p id="p1946723291815"><a name="p1946723291815"></a><a name="p1946723291815"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="44.16558344165583%" headers="mcps1.1.6.1.5 "><p id="p3467173291810"><a name="p3467173291810"></a><a name="p3467173291810"></a>Spacing between texts. The options are as follows:</p>
<p id="p153692104121"><a name="p153692104121"></a><a name="p153692104121"></a><strong id="b146318161288"><a name="b146318161288"></a><a name="b146318161288"></a>normal</strong>: default spacing.</p>
</td>
</tr>
<tr id="row85101205320"><td class="cellrowborder" valign="top" width="16.58834116588341%" headers="mcps1.1.6.1.1 "><p id="p751020201136"><a name="p751020201136"></a><a name="p751020201136"></a>font-style </p>
</td>
<td class="cellrowborder" valign="top" width="12.37876212378762%" headers="mcps1.1.6.1.2 "><p id="p251020201132"><a name="p251020201132"></a><a name="p251020201132"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="20.907909209079094%" headers="mcps1.1.6.1.3 "><p id="p15510720734"><a name="p15510720734"></a><a name="p15510720734"></a>normal</p>
</td>
<td class="cellrowborder" valign="top" width="5.959404059594041%" headers="mcps1.1.6.1.4 "><p id="p25105201439"><a name="p25105201439"></a><a name="p25105201439"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="44.16558344165583%" headers="mcps1.1.6.1.5 "><p id="p95101120238"><a name="p95101120238"></a><a name="p95101120238"></a>Font style. Available values are as follows:</p>
<a name="ul85109201131"></a><a name="ul85109201131"></a><ul id="ul85109201131"><li><strong id="b111931527399"><a name="b111931527399"></a><a name="b111931527399"></a>normal</strong>: standard font style</li><li><strong id="b641135983918"><a name="b641135983918"></a><a name="b641135983918"></a>italic</strong>: italic font style</li></ul>
</td>
</tr>
<tr id="row14510182017316"><td class="cellrowborder" valign="top" width="16.58834116588341%" headers="mcps1.1.6.1.1 "><p id="p951112201931"><a name="p951112201931"></a><a name="p951112201931"></a>font-weight </p>
</td>
<td class="cellrowborder" valign="top" width="12.37876212378762%" headers="mcps1.1.6.1.2 "><p id="p1151112201333"><a name="p1151112201333"></a><a name="p1151112201333"></a>number | string</p>
</td>
<td class="cellrowborder" valign="top" width="20.907909209079094%" headers="mcps1.1.6.1.3 "><p id="p1251115201137"><a name="p1251115201137"></a><a name="p1251115201137"></a>normal</p>
</td>
<td class="cellrowborder" valign="top" width="5.959404059594041%" headers="mcps1.1.6.1.4 "><p id="p1551110206310"><a name="p1551110206310"></a><a name="p1551110206310"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="44.16558344165583%" headers="mcps1.1.6.1.5 "><p id="p135113209314"><a name="p135113209314"></a><a name="p135113209314"></a>Font width. For the number type, the value ranges from 100 to 900. The default value is 400. A larger value indicates a larger font width.</p>
<div class="note" id="note851111201435"><a name="note851111201435"></a><a name="note851111201435"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p15111020534"><a name="p15111020534"></a><a name="p15111020534"></a>The value must be an integer multiple of 100.</p>
</div></div>
<p id="p451182013310"><a name="p451182013310"></a><a name="p451182013310"></a>The value of the string type can be <strong id="b09316811414"><a name="b09316811414"></a><a name="b09316811414"></a>lighter</strong>, <strong id="b1952261211416"><a name="b1952261211416"></a><a name="b1952261211416"></a>normal</strong>, <strong id="b414611515413"><a name="b414611515413"></a><a name="b414611515413"></a>bold</strong>, or <strong id="b871421813416"><a name="b871421813416"></a><a name="b871421813416"></a>bolder</strong>.</p>
</td>
</tr>
<tr id="row125112201639"><td class="cellrowborder" valign="top" width="16.58834116588341%" headers="mcps1.1.6.1.1 "><p id="p19511182014314"><a name="p19511182014314"></a><a name="p19511182014314"></a>text-decoration </p>
</td>
<td class="cellrowborder" valign="top" width="12.37876212378762%" headers="mcps1.1.6.1.2 "><p id="p351111201339"><a name="p351111201339"></a><a name="p351111201339"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="20.907909209079094%" headers="mcps1.1.6.1.3 "><p id="p155111205314"><a name="p155111205314"></a><a name="p155111205314"></a>none</p>
</td>
<td class="cellrowborder" valign="top" width="5.959404059594041%" headers="mcps1.1.6.1.4 "><p id="p551152012314"><a name="p551152012314"></a><a name="p551152012314"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="44.16558344165583%" headers="mcps1.1.6.1.5 "><p id="p1751117201737"><a name="p1751117201737"></a><a name="p1751117201737"></a>Text decoration. Available values are as follows:</p>
<a name="ul9511720637"></a><a name="ul9511720637"></a><ul id="ul9511720637"><li><strong id="b164849427323"><a name="b164849427323"></a><a name="b164849427323"></a>underline</strong>: An underline is used.</li><li><strong id="b1562604511325"><a name="b1562604511325"></a><a name="b1562604511325"></a>line-through</strong>: A strikethrough is used.</li><li><strong id="b13748195193210"><a name="b13748195193210"></a><a name="b13748195193210"></a>none</strong>: The standard text is used.</li></ul>
</td>
</tr>
<tr id="row6436204121315"><td class="cellrowborder" valign="top" width="16.58834116588341%" headers="mcps1.1.6.1.1 "><p id="p1437194171313"><a name="p1437194171313"></a><a name="p1437194171313"></a>text-decoration-color<sup id="sup7239161572910"><a name="sup7239161572910"></a><a name="sup7239161572910"></a>7+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="12.37876212378762%" headers="mcps1.1.6.1.2 "><p id="p7437124121317"><a name="p7437124121317"></a><a name="p7437124121317"></a>&lt;color&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="20.907909209079094%" headers="mcps1.1.6.1.3 "><p id="p104371941161317"><a name="p104371941161317"></a><a name="p104371941161317"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="5.959404059594041%" headers="mcps1.1.6.1.4 "><p id="p1743764161320"><a name="p1743764161320"></a><a name="p1743764161320"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="44.16558344165583%" headers="mcps1.1.6.1.5 "><p id="p2437104151319"><a name="p2437104151319"></a><a name="p2437104151319"></a>Color of the text decoration.</p>
</td>
</tr>
<tr id="row95113208317"><td class="cellrowborder" valign="top" width="16.58834116588341%" headers="mcps1.1.6.1.1 "><p id="p651118201637"><a name="p651118201637"></a><a name="p651118201637"></a>text-align</p>
</td>
<td class="cellrowborder" valign="top" width="12.37876212378762%" headers="mcps1.1.6.1.2 "><p id="p205112201337"><a name="p205112201337"></a><a name="p205112201337"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="20.907909209079094%" headers="mcps1.1.6.1.3 "><p id="p951202013319"><a name="p951202013319"></a><a name="p951202013319"></a>start</p>
</td>
<td class="cellrowborder" valign="top" width="5.959404059594041%" headers="mcps1.1.6.1.4 "><p id="p18512192018319"><a name="p18512192018319"></a><a name="p18512192018319"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="44.16558344165583%" headers="mcps1.1.6.1.5 "><p id="p651214206312"><a name="p651214206312"></a><a name="p651214206312"></a>Text alignment mode. Available values are as follows:</p>
<a name="ul11512120336"></a><a name="ul11512120336"></a><ul id="ul11512120336"><li><strong id="b1068915261435"><a name="b1068915261435"></a><a name="b1068915261435"></a>left</strong>: The text is left-aligned.</li><li><strong id="b7194633134312"><a name="b7194633134312"></a><a name="b7194633134312"></a>center</strong>: The text is center-aligned.</li><li><strong id="b12787113444310"><a name="b12787113444310"></a><a name="b12787113444310"></a>right</strong>: The text is right-aligned.</li><li><strong id="b5698814174419"><a name="b5698814174419"></a><a name="b5698814174419"></a>start</strong>: The text is aligned with the direction in which the text is written.</li><li><strong id="b941011915456"><a name="b941011915456"></a><a name="b941011915456"></a>end</strong>: The text is aligned with the opposite direction in which the text is written. </li></ul>
<div class="note" id="note14512192013312"><a name="note14512192013312"></a><a name="note14512192013312"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p16513320938"><a name="p16513320938"></a><a name="p16513320938"></a>If the text width is not specified, the alignment effect may not be obvious when the text width is the same as the width of the parent container. </p>
</div></div>
</td>
</tr>
<tr id="row0513820638"><td class="cellrowborder" valign="top" width="16.58834116588341%" headers="mcps1.1.6.1.1 "><p id="p85131120136"><a name="p85131120136"></a><a name="p85131120136"></a>line-height</p>
</td>
<td class="cellrowborder" valign="top" width="12.37876212378762%" headers="mcps1.1.6.1.2 "><p id="p451352012310"><a name="p451352012310"></a><a name="p451352012310"></a>&lt;length&gt; | &lt;percentage&gt;<sup id="sup1397722015236"><a name="sup1397722015236"></a><a name="sup1397722015236"></a>7+</sup> | string<sup id="sup1826415224230"><a name="sup1826415224230"></a><a name="sup1826415224230"></a>7+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.907909209079094%" headers="mcps1.1.6.1.3 "><p id="p175883320223"><a name="p175883320223"></a><a name="p175883320223"></a>0px<sup id="sup11204125742215"><a name="sup11204125742215"></a><a name="sup11204125742215"></a>1-6</sup></p>
<p id="p1751342015311"><a name="p1751342015311"></a><a name="p1751342015311"></a>normal<sup id="sup6237425142212"><a name="sup6237425142212"></a><a name="sup6237425142212"></a>7+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="5.959404059594041%" headers="mcps1.1.6.1.4 "><p id="p451320202316"><a name="p451320202316"></a><a name="p451320202316"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="44.16558344165583%" headers="mcps1.1.6.1.5 "><p id="p1513520336"><a name="p1513520336"></a><a name="p1513520336"></a>Text line height. When this parameter is set to <strong id="b49513892117"><a name="b49513892117"></a><a name="b49513892117"></a>0px</strong>, the text line height is not limited and the font size is adaptive. The <strong id="b96908348288"><a name="b96908348288"></a><a name="b96908348288"></a>string</strong> values are as follows:</p>
<p id="p203731252121210"><a name="p203731252121210"></a><a name="p203731252121210"></a><strong id="b0710151102820"><a name="b0710151102820"></a><a name="b0710151102820"></a>normal</strong><sup id="sup1522861917228"><a name="sup1522861917228"></a><a name="sup1522861917228"></a>7+</sup>: default line height</p>
</td>
</tr>
<tr id="row851319205318"><td class="cellrowborder" valign="top" width="16.58834116588341%" headers="mcps1.1.6.1.1 "><p id="p16513162011317"><a name="p16513162011317"></a><a name="p16513162011317"></a>text-overflow</p>
</td>
<td class="cellrowborder" valign="top" width="12.37876212378762%" headers="mcps1.1.6.1.2 "><p id="p12513620931"><a name="p12513620931"></a><a name="p12513620931"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="20.907909209079094%" headers="mcps1.1.6.1.3 "><p id="p10513162010316"><a name="p10513162010316"></a><a name="p10513162010316"></a>clip</p>
</td>
<td class="cellrowborder" valign="top" width="5.959404059594041%" headers="mcps1.1.6.1.4 "><p id="p751362018310"><a name="p751362018310"></a><a name="p751362018310"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="44.16558344165583%" headers="mcps1.1.6.1.5 "><p id="p65130201310"><a name="p65130201310"></a><a name="p65130201310"></a><span id="ph13751113121520"><a name="ph13751113121520"></a><a name="ph13751113121520"></a>Takes effect when the maximum number of lines is specified. </span>Available values are as follows:</p>
<a name="ul2513142018312"></a><a name="ul2513142018312"></a><ul id="ul2513142018312"><li><strong id="b165145674710"><a name="b165145674710"></a><a name="b165145674710"></a>clip</strong>: The text is clipped and displayed based on the size of the parent container.</li><li><strong id="b1331610118486"><a name="b1331610118486"></a><a name="b1331610118486"></a>ellipsis</strong>: The text is displayed based on the size of the parent container. The text that cannot be displayed is replaced with ellipsis. This style must be used together with <strong id="b774215496487"><a name="b774215496487"></a><a name="b774215496487"></a>max-lines</strong>.</li></ul>
</td>
</tr>
<tr id="row95131920537"><td class="cellrowborder" valign="top" width="16.58834116588341%" headers="mcps1.1.6.1.1 "><p id="p115131320234"><a name="p115131320234"></a><a name="p115131320234"></a>font-family</p>
</td>
<td class="cellrowborder" valign="top" width="12.37876212378762%" headers="mcps1.1.6.1.2 "><p id="p20514102015311"><a name="p20514102015311"></a><a name="p20514102015311"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="20.907909209079094%" headers="mcps1.1.6.1.3 "><p id="p25141220839"><a name="p25141220839"></a><a name="p25141220839"></a>sans-serif</p>
</td>
<td class="cellrowborder" valign="top" width="5.959404059594041%" headers="mcps1.1.6.1.4 "><p id="p205145201735"><a name="p205145201735"></a><a name="p205145201735"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="44.16558344165583%" headers="mcps1.1.6.1.5 "><p id="p75148201333"><a name="p75148201333"></a><a name="p75148201333"></a>Font family, in which fonts are separated by commas (,). Each font is set using a font name or font family name. The first font that exists in the system or the font specified by <a href="js-components-common-customizing-font.md">Custom Font Styles</a> in the family is selected as the font for the text. </p>
</td>
</tr>
<tr id="row14514142013319"><td class="cellrowborder" valign="top" width="16.58834116588341%" headers="mcps1.1.6.1.1 "><p id="p1451411202319"><a name="p1451411202319"></a><a name="p1451411202319"></a>max-lines </p>
</td>
<td class="cellrowborder" valign="top" width="12.37876212378762%" headers="mcps1.1.6.1.2 "><p id="p6514420233"><a name="p6514420233"></a><a name="p6514420233"></a>number | string<sup id="sup1763505811384"><a name="sup1763505811384"></a><a name="sup1763505811384"></a>7+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="20.907909209079094%" headers="mcps1.1.6.1.3 "><p id="p15514102018311"><a name="p15514102018311"></a><a name="p15514102018311"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="5.959404059594041%" headers="mcps1.1.6.1.4 "><p id="p35148201135"><a name="p35148201135"></a><a name="p35148201135"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="44.16558344165583%" headers="mcps1.1.6.1.5 "><p id="p934052515223"><a name="p934052515223"></a><a name="p934052515223"></a>Maximum number of text lines. The <strong id="b10373134345315"><a name="b10373134345315"></a><a name="b10373134345315"></a>string</strong> values are as follows:</p>
<a name="ul6458027152218"></a><a name="ul6458027152218"></a><ul id="ul6458027152218"><li><strong id="b1132417423294"><a name="b1132417423294"></a><a name="b1132417423294"></a>auto</strong><sup id="sup15460165433814"><a name="sup15460165433814"></a><a name="sup15460165433814"></a>7+</sup>: The number of text lines adapts to the container height.</li></ul>
</td>
</tr>
<tr id="row7514122015312"><td class="cellrowborder" valign="top" width="16.58834116588341%" headers="mcps1.1.6.1.1 "><p id="p15514182016317"><a name="p15514182016317"></a><a name="p15514182016317"></a>min-font-size </p>
</td>
<td class="cellrowborder" valign="top" width="12.37876212378762%" headers="mcps1.1.6.1.2 "><p id="p55148206312"><a name="p55148206312"></a><a name="p55148206312"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="20.907909209079094%" headers="mcps1.1.6.1.3 "><p id="p165146200312"><a name="p165146200312"></a><a name="p165146200312"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="5.959404059594041%" headers="mcps1.1.6.1.4 "><p id="p16515420138"><a name="p16515420138"></a><a name="p16515420138"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="44.16558344165583%" headers="mcps1.1.6.1.5 "><p id="p125151201636"><a name="p125151201636"></a><a name="p125151201636"></a>Minimum font size in the text. This style must be used together with <strong id="b73481621155012"><a name="b73481621155012"></a><a name="b73481621155012"></a>max-font-size</strong>. The font size can be changed dynamically. After the maximum and minimum font sizes are set, <strong id="b483334111512"><a name="b483334111512"></a><a name="b483334111512"></a>font-size</strong> does not take effect.</p>
</td>
</tr>
<tr id="row20515720537"><td class="cellrowborder" valign="top" width="16.58834116588341%" headers="mcps1.1.6.1.1 "><p id="p25151620634"><a name="p25151620634"></a><a name="p25151620634"></a>max-font-size </p>
</td>
<td class="cellrowborder" valign="top" width="12.37876212378762%" headers="mcps1.1.6.1.2 "><p id="p135150201639"><a name="p135150201639"></a><a name="p135150201639"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="20.907909209079094%" headers="mcps1.1.6.1.3 "><p id="p19515132019318"><a name="p19515132019318"></a><a name="p19515132019318"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="5.959404059594041%" headers="mcps1.1.6.1.4 "><p id="p9515120231"><a name="p9515120231"></a><a name="p9515120231"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="44.16558344165583%" headers="mcps1.1.6.1.5 "><p id="p11515520038"><a name="p11515520038"></a><a name="p11515520038"></a>Maximum font size in the text. This style must be used together with <strong id="b22010161547"><a name="b22010161547"></a><a name="b22010161547"></a>min-font-size</strong>. The font size can be changed dynamically. After the maximum and minimum font sizes are set, <strong id="b302292867"><a name="b302292867"></a><a name="b302292867"></a>font-size</strong> does not take effect.</p>
</td>
</tr>
<tr id="row155154201838"><td class="cellrowborder" valign="top" width="16.58834116588341%" headers="mcps1.1.6.1.1 "><p id="p151592017316"><a name="p151592017316"></a><a name="p151592017316"></a>font-size-step </p>
</td>
<td class="cellrowborder" valign="top" width="12.37876212378762%" headers="mcps1.1.6.1.2 "><p id="p151515201233"><a name="p151515201233"></a><a name="p151515201233"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="20.907909209079094%" headers="mcps1.1.6.1.3 "><p id="p851562013310"><a name="p851562013310"></a><a name="p851562013310"></a>1px</p>
</td>
<td class="cellrowborder" valign="top" width="5.959404059594041%" headers="mcps1.1.6.1.4 "><p id="p85159201037"><a name="p85159201037"></a><a name="p85159201037"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="44.16558344165583%" headers="mcps1.1.6.1.5 "><p id="p1151519205317"><a name="p1151519205317"></a><a name="p1151519205317"></a>Step for dynamically adjusting the font size in the text. The minimum and maximum font sizes must be set.</p>
</td>
</tr>
<tr id="row155151120839"><td class="cellrowborder" valign="top" width="16.58834116588341%" headers="mcps1.1.6.1.1 "><p id="p851519201036"><a name="p851519201036"></a><a name="p851519201036"></a>prefer-font-sizes </p>
</td>
<td class="cellrowborder" valign="top" width="12.37876212378762%" headers="mcps1.1.6.1.2 "><p id="p1851511201630"><a name="p1851511201630"></a><a name="p1851511201630"></a>&lt;array&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="20.907909209079094%" headers="mcps1.1.6.1.3 "><p id="p15515152018315"><a name="p15515152018315"></a><a name="p15515152018315"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="5.959404059594041%" headers="mcps1.1.6.1.4 "><p id="p145154204313"><a name="p145154204313"></a><a name="p145154204313"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="44.16558344165583%" headers="mcps1.1.6.1.5 "><p id="p851513201317"><a name="p851513201317"></a><a name="p851513201317"></a>Preset preferred font sizes. For dynamic font size adjustment, the preset sizes are used to match the maximum number of lines in the text. If the preferred font sizes were not set, the font size will be adjusted based on the maximum and minimum font sizes and the step you have set. If the maximum number of lines in the text cannot be met, <strong id="b1420501110354"><a name="b1420501110354"></a><a name="b1420501110354"></a>text-overflow</strong> is used to truncate the text. If this parameter is set, <strong id="b153751052193511"><a name="b153751052193511"></a><a name="b153751052193511"></a>font-size</strong>, <strong id="b6195125503512"><a name="b6195125503512"></a><a name="b6195125503512"></a>max-font-size</strong>, <strong id="b561587352"><a name="b561587352"></a><a name="b561587352"></a>min-font-size</strong>, and <strong id="b41946114369"><a name="b41946114369"></a><a name="b41946114369"></a>font-size-step</strong> do not take effect.</p>
<p id="p18515202012316"><a name="p18515202012316"></a><a name="p18515202012316"></a>Example values: <strong id="b148981611383"><a name="b148981611383"></a><a name="b148981611383"></a>12px,14px,16px</strong></p>
</td>
</tr>
<tr id="row2298173115914"><td class="cellrowborder" valign="top" width="16.58834116588341%" headers="mcps1.1.6.1.1 "><p id="p1429820311498"><a name="p1429820311498"></a><a name="p1429820311498"></a>word-break<sup id="sup181941853171717"><a name="sup181941853171717"></a><a name="sup181941853171717"></a>6+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="12.37876212378762%" headers="mcps1.1.6.1.2 "><p id="p122981731691"><a name="p122981731691"></a><a name="p122981731691"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="20.907909209079094%" headers="mcps1.1.6.1.3 "><p id="p82985311094"><a name="p82985311094"></a><a name="p82985311094"></a>normal</p>
</td>
<td class="cellrowborder" valign="top" width="5.959404059594041%" headers="mcps1.1.6.1.4 "><p id="p102981231392"><a name="p102981231392"></a><a name="p102981231392"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="44.16558344165583%" headers="mcps1.1.6.1.5 "><p id="p329813311491"><a name="p329813311491"></a><a name="p329813311491"></a>Text line breaking mode. The options are as follows:</p>
<a name="ul3839682122"></a><a name="ul3839682122"></a><ul id="ul3839682122"><li><strong id="b329519515225"><a name="b329519515225"></a><a name="b329519515225"></a>normal</strong>: Allows text line breaks between words as appropriate to the relevant language writing systems. This is the default mode.</li><li><strong id="b118015913305"><a name="b118015913305"></a><a name="b118015913305"></a>break-all</strong>: Allows text line breaks between any characters for writing systems other than Chinese, Japanese, and Korean.</li><li><strong id="b1217910513399"><a name="b1217910513399"></a><a name="b1217910513399"></a>break-word</strong>: Has the same effect as <strong id="b187324215494"><a name="b187324215494"></a><a name="b187324215494"></a>break-all</strong>, except that it does not break unbreakable words.</li></ul>
</td>
</tr>
<tr id="row11732453136"><td class="cellrowborder" valign="top" width="16.58834116588341%" headers="mcps1.1.6.1.1 "><p id="p373219510132"><a name="p373219510132"></a><a name="p373219510132"></a>text-indent<sup id="sup85001052123316"><a name="sup85001052123316"></a><a name="sup85001052123316"></a>7+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="12.37876212378762%" headers="mcps1.1.6.1.2 "><p id="p47321857139"><a name="p47321857139"></a><a name="p47321857139"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="20.907909209079094%" headers="mcps1.1.6.1.3 "><p id="p1973212541319"><a name="p1973212541319"></a><a name="p1973212541319"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="5.959404059594041%" headers="mcps1.1.6.1.4 "><p id="p77336519137"><a name="p77336519137"></a><a name="p77336519137"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="44.16558344165583%" headers="mcps1.1.6.1.5 "><p id="p273314531310"><a name="p273314531310"></a><a name="p273314531310"></a>Indentation of the first line.</p>
</td>
</tr>
<tr id="row483811791617"><td class="cellrowborder" valign="top" width="16.58834116588341%" headers="mcps1.1.6.1.1 "><p id="p1083916179164"><a name="p1083916179164"></a><a name="p1083916179164"></a>white-space<sup id="sup1527825315332"><a name="sup1527825315332"></a><a name="sup1527825315332"></a>7+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="12.37876212378762%" headers="mcps1.1.6.1.2 "><p id="p2839117121616"><a name="p2839117121616"></a><a name="p2839117121616"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="20.907909209079094%" headers="mcps1.1.6.1.3 "><p id="p183981701620"><a name="p183981701620"></a><a name="p183981701620"></a>pre</p>
</td>
<td class="cellrowborder" valign="top" width="5.959404059594041%" headers="mcps1.1.6.1.4 "><p id="p083911713168"><a name="p083911713168"></a><a name="p083911713168"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="44.16558344165583%" headers="mcps1.1.6.1.5 "><p id="p9839417181617"><a name="p9839417181617"></a><a name="p9839417181617"></a>Mode for processing blanks in the component. The options are as follows:</p>
<a name="ul9139155131615"></a><a name="ul9139155131615"></a><ul id="ul9139155131615"><li><strong id="b491965183217"><a name="b491965183217"></a><a name="b491965183217"></a>normal</strong>: All spaces, carriage returns, and tabs are combined into one space, and the text is automatically wrapped.</li><li><strong id="b6272101473212"><a name="b6272101473212"></a><a name="b6272101473212"></a>nowrap</strong>: All spaces, carriage returns, and tabs are combined into one space, and the text is not wrapped.</li><li><strong id="b1853091145817"><a name="b1853091145817"></a><a name="b1853091145817"></a>pre</strong>: All contents are output as-is.</li><li><strong id="b16557113373214"><a name="b16557113373214"></a><a name="b16557113373214"></a>pre-wrap</strong>: All contents are output as-is with line breaks.</li><li><strong id="b16445113143320"><a name="b16445113143320"></a><a name="b16445113143320"></a>pre-line</strong>: All spaces and tabs are combined into one space, the carriage return remains unchanged, and the text is wrapped.</li></ul>
</td>
</tr>
<tr id="row10859173188"><td class="cellrowborder" valign="top" width="16.58834116588341%" headers="mcps1.1.6.1.1 "><p id="p168595741814"><a name="p168595741814"></a><a name="p168595741814"></a>adapt-height<sup id="sup10570154133314"><a name="sup10570154133314"></a><a name="sup10570154133314"></a>7+</sup></p>
</td>
<td class="cellrowborder" valign="top" width="12.37876212378762%" headers="mcps1.1.6.1.2 "><p id="p1085919791816"><a name="p1085919791816"></a><a name="p1085919791816"></a>boolean</p>
</td>
<td class="cellrowborder" valign="top" width="20.907909209079094%" headers="mcps1.1.6.1.3 "><p id="p208591779182"><a name="p208591779182"></a><a name="p208591779182"></a>false</p>
</td>
<td class="cellrowborder" valign="top" width="5.959404059594041%" headers="mcps1.1.6.1.4 "><p id="p38591675189"><a name="p38591675189"></a><a name="p38591675189"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="44.16558344165583%" headers="mcps1.1.6.1.5 "><p id="p2099116133418"><a name="p2099116133418"></a><a name="p2099116133418"></a>Whether the text size adapts to the container height.</p>
<div class="note" id="note1725773504115"><a name="note1725773504115"></a><a name="note1725773504115"></a><span class="notetitle"> NOTE: </span><div class="notebody"><p id="p02571035164111"><a name="p02571035164111"></a><a name="p02571035164111"></a>The settings take effect after font size auto-adaptation is configured.</p>
</div></div>
</td>
</tr>
</tbody>
</table>

>![](../../public_sys-resources/icon-note.gif) **NOTE:** 
>-   In dynamic font adjustment, both the preset size set and the minimum/maximum font sizes are used to adjust the font size to display the text within the maximum number of lines. The preset size set is checked from left to right, and the minimum/maximum font sizes are checked from large to small, to find a size meeting the requirement. 
>-   Use the escape character  **\\r\\n**  for newline.
>-   The following escape characters are supported:  **\\a**,  **\\b**,  **\\f**,  **\\n**,  **\\r**,  **\\t**,  **\\v**,  **\\'**,  **\\"**, and  **\\0**.
>-   When you use  **<span\>**  as a child component to form a text paragraph, note that if a  **<span\>**  style is abnormal, the text paragraph cannot be displayed.
>-   The  **letter-spacing**,  **text-align**,  **line-height**,  **text-overflow**, and  **max-lines**  styles take effect on text content held by the  **<text\>**  component and its child components \(**<span\>**\).
>-   The  **<text\>**  component does not support the coexistence of the text content and  **<span\>**  subcomponents. \(If both of them exist, only the content in  **<span\>**  is displayed.\)

## Events<a name="section1948820711216"></a>

Events in  [Universal Events](js-components-common-events.md)  are supported.

## Method<a name="section2279124532420"></a>

Methods in  [Universal Methods](js-components-common-methods.md)  are supported.

## Example Code<a name="section13294026042"></a>

```
<!-- xxx.hml -->
<div class="container">
  <div class="content">
    <text class="title">
      Hello {{ title }}
    </text>
  </div>
</div>
```

```
/* xxx.css */
.container {
  display: flex;
  justify-content: center;
  align-items: center;
}
.content{
  width: 400px;
  height: 400px;
  border: 20px;
  border-image-source: url("/common/images/landscape.jpg");
  border-image-slice: 20px;
  border-image-width: 30px;
  border-image-outset: 10px;
  border-image-repeat: round;
}
.title {
  font-size: 80px;
  text-align: center;
  width: 400px;
  height: 400px;
}
```

```
// xxx.js
export default {
  data: {
    title: 'World'
  }
}
```

![](figures/3.png)

```
<!-- xxx.hml -->
<div class="container">
  <text class="text1">
    This is a passage
  </text>
  <text class="text2">
    This is a passage
  </text>
</div>
```

```
/* xxx.css */
.container {
  flex-direction: column;
  align-items: center;
  background-color: #F1F3F5;
  justify-content: center;
}
.text1{
  word-spacing: 10px;
  adapt-height: true;
}
.text2{
  width: 200px;
  max-lines: 1;
  text-overflow: ellipsis;
  text-valign: middle;
  line-height: 40px;
  text-decoration: underline;
  text-decoration-color: red;
  text-indent: 20px;
  white-space: pre;
}
```

![](figures/2.png)

