# 概述<a name="ZH-CN_TOPIC_0000001058831526"></a>

-   [基本概念](#section175012297491)
-   [约束与限制](#section2029921310472)

OpenHarmony安全子系统目前提供给开发者的安全能力主要包含应用可信、权限管理、设备可信。涉及以下几个模块：

-   应用验签

    为了确保应用内容的完整性，系统通过应用签名和Profile对应用的来源进行管控，同时对于调试应用，还可通过验签接口验证应用和设备的UDID是否匹配，确保应用安装在了正确的设备上。

-   应用权限管理

    应用权限是管理应用访问系统资源和使用系统能力的一种通用方式，应用在开发阶段需要在profile.json中指明此应用在运行过程中可能会调用哪些权限，其中静态权限表示只需要在安装阶段注册就可以，而动态权限一般表示涉及到敏感信息，所以需要用户进行动态授权。

-   IPC通信鉴权

    系统服务通过IPC暴露接口给其他进程访问，这些接口需要配置相应的访问策略，当其他进程访问这些接口时，将会触发IPC通信鉴权机制校验访问进程是否拥有权限访问该接口，若无权限，则拒绝访问该接口。

-   可信设备群组管理

    提供基于群组概念的同华为账号群组、点对点群组（如二维码、碰一碰等）的设备安全可信关系的创建和查询，分布式应用可基于该能力进行设备间的可信认证，然后向分布式软总线请求设备间安全会话。


## 基本概念<a name="section175012297491"></a>

在进行依赖验签组件的应用开发前，开发者应了解以下基本概念：

-   Samgr

    Samgr\(System Ability M2anager\)系统能力管理，在OpenHarmony上作为一个管理系统能力的模块，详见系统服务框架子系统。


-   BMS

    BMS\(Bundle Manager Service\)包管理管理，在OpenHarmony上主要负责应用的安装、卸载和数据管理。


-   描述文件

    本文中的描述文件，指HarmonyAppProvision，简称profile。HarmonyAppProvision采用json文件格式进行描述。


-   叶子证书

    最终用于为整包或profile签名的证书称为叶子证书，位于数字证书链的最末端。


-   调试应用

    指开发者从应用市场申请调试证书与调试描述文件，并以此签名的hap包。


-   待上架应用

    指开发者从应用市场申请发布证书与发布描述文件，以此签名，未通过应用市场正式发布的hap包。


-   发布应用

    指开发者从应用市场申请发布证书与发布描述文件，以此签名的hap包，上传至应用市场，并由应用市场正式发布的hap包。


-   OpenHarmony自签名应用

    当开发者自行编译OpenHarmony系统应用后，采用原应用描述文件，以及公开的OpenHarmony公私钥对和证书进行自签名产生的hap包。


## 约束与限制<a name="section2029921310472"></a>

-   仅支持以下三类应用的验签：应用市场调试应用、应用市场发布应用、OpenHarmony自签名应用的验签。
-   若对应用市场调试应用验签，则本机UDID需要在描述文件包含的UDID列表中。
-   待上架应用无法验签通过。
-   验签组件提供的接口都位于security\_interfaces\_innerkits\_app\_verify仓[app\_verify\_pub.h](https://gitee.com/fork_ohos_wj/security_interfaces_innerkits_app_verify/blob/master/app_verify_pub.h)中，仅支持系统应用开发者调用。
-   可信设备群组管理接口，目前只对系统签名权限才可以使用。

