# 概述

* **【开发指南总体** **写作要求】***


* 适用于鸿蒙南北向子系统开发、应用侧的设备开发、南向开发指南。*


* 章节调整：本模板知识点内容结构可以根据产品内容多少微调，具体操作方式见下。*


| 章节 | 可选/必选说明 | 备注 |
| -------- | -------- | -------- |
| 概述 | 必选，标题名称不变 | - |
| 搭建环境 | 可选，如果快速入门已有，可不用提供，否则需提供。 | - |
| 开发指导 | 必选，可根据多场景任务增加章节。 | 拍照开发指导<br/>预览开发指导<br/>录像开发指导 |
| 开发实例 | 必选。<br/>-&nbsp;标题名称可自定义。如果“开发指导”是多场景，标题名称可以调整为拍照开发实例、预览开发实例等。<br/>-&nbsp;标题可合并。如果产品链接到示例代码或内容少于1屏，可合并到“开发指导”，整本统一。 | - |
| 常见问题 | 可选，标题不变。<br/>-&nbsp;如果无常见问题，删除此章节。<br/>-&nbsp;如果有常见问题，建议单独章节，后续具备扩展性。<br/>-&nbsp;如果有常见问题，问题少于1屏，未来扩充可能行不大，可放在“开发指导”。 | - |
| 参考 | 可选，根据实际需要补充。 | - |


 * 整体写作要求见下，完成写作后，请逐项自检。*
| 要求项 | 内容要求 | 是否满足 |
| -------- | -------- | -------- |
| **A.1** | **用语要求** |  |
| A.1.1 | 行文风格：文档在官方网站发布，用语正式，避免口语化。 |  |
| A.1.2 | 合规要求：不能使用Android特有概念等存在合规和法务风险的词汇。敏感词汇包含但不限于：Android、Google、EMUI、Activity、AOSP、provider、binder、APK、Dalvik、AVD、ADT、DDMS、adb、AAPT、AndroidManifest、NDK、ART、dex、ANR、Cursor、Blacklist、Whitelist、Master、Slave、L0、L1、轻鸿蒙、富鸿蒙等。 |  |
| A.1.3 | 内容简洁：内容采用信息必备、最小化原则，旨在指导开发者在尽量短的时间完成操作。 |  |
| A.1.4 | 内容正确：文档的代码、需要设置的参数等需要跟产品实际情况实时保持一致。 |  |
| A.1.5 | 用语准确：应当确切，不能出现多义性的描述。 |  |
| A.1.6 | 用语一致：同一叫法，全文保持一致，术语与术语库保持一致，正文中缩略语首次出现要给出全称。 |  |
| A.1.7 | 用语具体：如表示数量或程度时，避免用笼统的“多”“少”“大”，建议用具体数字表示。 |  |
| **A.2** | **格式要求** |  |
| A.2.1 | 标点符号正确、句尾有符号结尾。 |  |
| A.2.2 | 内容尽量用项目列表或分类的方式清晰呈现。不要有单个项目列表；不要有多余空行。 |  |
| A.2.3 | 英文字母和中文字之间不要有空格。 |  |
| A.2.4 | 链接必须有效，具体，可直接跳转或下载。 |  |
| A.2.5 | 如果是内容的辅助说明，请使用“说明”式样；如果提前申明事项，，请使用“须知”式样。To&nbsp;D的资料不用“注意”格式。 |  |
| **A.3** | **表格** |  |
| A.3.1 | 表格有表注，表头风格一致，采用名词或名词词组形式。 |  |
| A.3.2 | 表格有表头，至少为2行2列，避免出现单行或单列表。 |  |
| A.3.3 | 表格无内容用“_”，不出现空白的单元格。 |  |
| **A.4** | **图形** |  |
| A.4.2 | 符合华为调性，避免互联网化，避免涉及宗教信仰类截图。 |  |
| A.4.3 | 图文并茂，行文应力求简明，如有可能，配以适当的图，表。 |  |
| A.4.4 | 图形有图注（不可直接粘贴图形），图注风格一致，采用名词或名词词组形式。 |  |
| A.4.5 | 图形应清晰可辩识，信息表达完整，易于阅读。如流程图不可缺少“开始”和“结束”。 |  |
| A.4.6 | 图形逻辑清晰，图文配合使用，切忌图文分离。 |  |
| A.4.7 | 图片的高度建议在640px左右，宽度不超过820px，一般为.png格式，图片的大小建议不超过150k。 |  |
| A.4.8 | 图形建议尽量不要用文字，中文图用中文，英文图用英文。 |  |


## 基本概念

*【 **写作要求】***

*必选，描述本开发任务相关的基本概念，帮助开发者更好的理解开发任务。* *写作要求见下，完成写作后，请逐项自检。*

| 要求项 | 内容要求 | 是否满足 |
| -------- | -------- | -------- |
| B.1.1 | 业界通用的概念不用再此赘述。 |  |
| B.1.2 | 注意使用业界通用术语来表达，不用华为研发内部语言。 |  |
| B.1.3 | 基本概念要黑盒描述，不用体现具体细节。 |  |


【写作样例】


鸿蒙系统音频模块支持音频业务的开发，提供音频相关的功能，主要包括音频播放、音频采集、音量管理和短音播放等。


在进行应用的开发前，开发者应了解以下基本概念：


- 采样
  采样就是把模拟信号数字化的过程，所有的模拟信号都需要通过采样转换为可以用0101来表示的数字信号。

- 采样率
  采样率为每秒从连续信号中提取并组成离散信号的采样次数，单位用赫兹（Hz）来表示。通常人耳能听到频率范围大约在20Hz～20kHz之间的声音。常用的音频采样频率有：8kHz、11.025kHz、22.05kHz、16kHz、37.8kHz、44.1kHz、48kHz、96kHz、192kHz等。

- 声道
  声道是指声音在录制或播放时在不同空间位置采集或回放的相互独立的音频信号，所以声道数也就是声音录制时的音源数量或回放时相应的扬声器数量。

- 音频帧
  音频数据是流式的，本身没有明确的一帧帧的概念，在实际的应用中，为了音频算法处理/传输的方便，一般约定俗成取2.5ms~60ms为单位的数据量为一帧音频。这个时间被称之为“采样时间”，其长度没有特别的标准，它是根据编解码器和具体应用的需求来决定的。


## 运作机制

*【 **写作要求】***

*可选。如果机制比较简单，通过前面基本概念就可以说清楚，此章节可以不用提供，删除标题即可。*

*描述实现原理介绍机制，如关键步骤相关接口调用时机和触发时机，帮助开发者了解该功能的基本运作原理，以便更好的理解开发任务和定位问题。*

* 写作要求见下，完成写作后，请逐项自检。*

| 要求项 | 内容要求 | 是否满足 |
| -------- | -------- | -------- |
| C.1.1 | 仅描述开发任务相关的原理。 |  |
| C.1.2 | 尽量图文配合，一般使用时序图、流程图等形式。文字描述与图形描述匹配。 |  |
| C.1.3 | 原理要黑盒描述，注意不要泄密。 |  |

【写作样例-1】

- 信号量初始化，为配置的N个信号量申请内存（N值可以由用户自行配置，受内存限制），并把所有的信号量初始化成未使用，并加入到未使用链表中供系统使用。

- 信号量创建，从未使用的信号量链表中获取一个信号量资源，并设定初值。

- 信号量申请，若其计数器值大于0，则直接减1返回成功。否则任务阻塞，等待其它任务释放该信号量，等待的超时时间可设定。当任务被一个信号量阻塞时，将该任务挂到信号量等待任务队列的队尾。

- 信号量释放，若没有任务等待该信号量，则直接将计数器加1返回。否则唤醒该信号量等待任务队列上的第一个任务。

- 信号量删除，将正在使用的信号量置为未使用信号量，并挂回到未使用链表。

- 信号量允许多个任务在同一时刻访问同一资源，但会限制同一时刻访问此资源的最大任务数目。访问同一资源的任务数达到该资源的最大数量时，会阻塞其他试图获取该资源的任务，直到有任务释放该信号量。
  ![1624266502700](C:\Users\LWX104~1\AppData\Local\Temp\1624266502700.png)

  【写作样例-2】

  **互斥锁运作原理**

  多任务环境下会存在多个任务访问同一公共资源的场景，而有些公共资源是非共享的，需要任务进行独占式处理。互斥锁怎样来避免这种冲突呢？

  用互斥锁处理非共享资源的同步访问时，如果有任务访问该资源，则互斥锁为加锁状态。此时其他任务如果想访问这个公共资源则会被阻塞，直到互斥锁被持有该锁的任务释放后，其他任务才能重新访问该公共资源，此时互斥锁再次上锁，如此确保同一时刻只有一个任务正在访问这个公共资源，保证了公共资源操作的完整性。

  **图2** 互斥锁运作示意图
  ![1624266485662](C:\Users\LWX104~1\AppData\Local\Temp\1624266485662.png)


## 约束与限制

* **【写作要求】***

*必选。* *描述本开发任务过程中* *的约束条件，以及此操作约束带来相应的负面影响，包括但不限于如下几方面：*

* **功能限制：***

- * 功能使用范围（明确不支持的场景）。*

- *规格限制。*

* **操作限制** **：***

- * 已知问题的操作。*

- * 潜在风险的操作（如引起性能降低）。*

- * 引起性能降低的操作*。

* 写作要求见下，完成写作后，请逐项自检。*

| 要求项 | 内容要求 | 是否满足 |
| -------- | -------- | -------- |
| D.1.1 | 明确功能限制或操作限制。 |  |
| D.1.2 | 约束对指导任务开发有影响或体验有感知，否则不用体现。 |  |
| D.1.3 | 容易出错的操作在步骤里描述，不在此体现。 |  |

**【写作样例】**

**互斥锁的约束与限制：**

- 两个任务不能对同一把互斥锁加锁。如果某任务对已被持有的互斥锁加锁，则该任务会被挂起，直到持有该锁的任务对互斥锁解锁，才能执行对这把互斥锁的加锁操作。

- 互斥锁不能在中断服务程序中使用。

- Huawei LiteOS作为实时操作系统需要保证任务调度的实时性，尽量避免任务的长时间阻塞，因此在获得互斥锁之后，应该尽快释放互斥锁。

- 持有互斥锁的过程中，不得再调用LOS_TaskPriSet等接口更改持有互斥锁任务的优先级。
