# 开发实例

** *【写作要求】***


*必选。描述开发完成后，基于一个任务整体做代码段的描述。*


- * 标题名称不变。如果“开发指导”是多场景，标题名称可以调整为拍照开发实例、预览开发指导等。*

- * 标题可合并。如果产品链接到示例代码或内容少于1屏，可合并到“开发指导”，整本统一。*


*具体写作要求见下，完成写作后，请逐项自检下。*


| 要求项 | 内容要求 | 是否满足 | 
| -------- | -------- | -------- |
| M1.1 | 有任务的场景介绍，且和代码端内容呼应。 |  | 
| M1.2 | 代码段顺利指导完成操作，无缺失。 |  | 
| M1.3 | 代码涉及开发者拷贝的命令，必须用可编辑的报文呈现，避免截图（DOCS插入Screen）。 |  | 
| M1.4 | 代码中关键段用蓝色（RGB：0.0.255）突出显示，关键步骤要有注释说明。 |  | 
| M1.5 | 代码显示符合代码缩进要求。 |  | 


**【写作样例---节选】**


SDIO设备完整的使用示例如下所示，首先打开总线号为1的SDIO控制器，然后独占HOST、使能设备、注册中断，接着进行SDIO通信（读写等），通信完成之后，释放中断、去使能设备、释放HOST，最后关闭SDIO控制器。
```
#include "hdf_log.h"
#include "sdio_if.h"

#define TEST_FUNC_NUM 1              /* 本测试用例中，使用编号为1的I/O function */
#define TEST_FBR_BASE_ADDR 0x100     /* 编号为1的I/O function的FBR基地址 */
#define TEST_ADDR_OFFSET 9           /* 本测试用例中，需要读写的寄存器的地址偏移 */
#define TEST_DATA_LEN 3              /* 本测试用例中，读写数据的长度 */
#define TEST_BLOCKSIZE 2             /* 本测试用例中，数据块的大小，单位字节 */

/* 中断服务函数，需要根据各自平台的情况去实现 */
static void SdioIrqFunc(void *data)
{
    if (data == NULL) {
        HDF_LOGE("SdioIrqFunc: data is NULL.\n");
        return;
    }
    /* 需要开发者自行添加具体的实现 */
}
```
