# 准备工作<a name="ZH-CN_TOPIC_0000001051770836"></a>

-   [硬件要求](#section98535485518)
-   [安装Node.js和hpm命令行工具](#section106591616205311)
-   [更改hpm的配置（可选）](#section71821165412)
-   [下载OpenHarmony代码](#section102338221707)
-   [安装开发依赖的组件](#section19233183315020)

## 硬件要求<a name="section98535485518"></a>

-   准备设备开发的开发板（如Hi3861、Hi3516DV300、Hi3518EV300）
-   主机电脑（Windows工作台）
-   Linux服务器

**图 1**  硬件环境连接关系<a name="fig113816181847"></a>  
![](figures/硬件环境连接关系.png "硬件环境连接关系")

## 安装Node.js和hpm命令行工具<a name="section106591616205311"></a>

1.  安装Node.js。

    从官网下载并在本地安装Node.js.

    推荐安装  [Node.js](https://nodejs.org/)  12.x \(包含 npm 6.14.4\)或更高版本 \(推荐 12.13.0+\)。

2.  通过Node.js自带的npm安装hpm-cli命令行工具。执行以下命令：

    ```
    npm install -g @ohos/hpm-cli
    ```

3.  安装完成后执行如下命令，显示hpm版本，即安装成功。

    ```
    hpm -V  或 hpm --version
    ```

4.  （可选）如果需要升级hpm版本，请执行如下命令：

    ```
    npm update -g @ohos/hpm-cli
    ```


## 更改hpm的配置（可选）<a name="section71821165412"></a>

安装完hpm-cli命令行工具后，执行以下命令可以查看hpm配置：

```
hpm config
```

上述命令执行后将会显示hpm的默认配置，您可以根据自己的喜好对默认配置进行修改，以下是hpm的常用配置：

```
registry = https://hpm.harmonyos.com/hpm/registry/api              # hpm注册中心地址，下载组件必须
login = https://hpm.harmonyos.com/hpm/auth/pk                      # hpm处理登录地址，发布组件必须
loginUser = {your-account}                                         # 配置hpm登录账号，发布组件必须
shellPath = C:\WINDOWS\System32\cmd.exe                            # hpm命令执行使用的shell
globalRepo = C:\Users\yourname\.global                             # 配置全局安装的组件存放路径
http_proxy = http://your-proxy-server:port                         # 配置HTTP代理
https_proxy = http://your-proxy-server:port                        # 配置HTTPS代理
```

hpm-cli的命令介绍可以参考：[hpm操作命令](组件管理.md)

## 下载OpenHarmony代码<a name="section102338221707"></a>

参考[《源码获取》](../get-code/源码获取.md)

## 安装开发依赖的组件<a name="section19233183315020"></a>

hpm包管理器将常用开发开发工具（如烧录，编译，压缩等）也发布成了组件。可以通过如下命令方式进行安装，执行完该命令后，系统会自动将开发依赖的工具下载安装，且这些组件只需全局安装一次。

```
hpm i -g @ohos/llvm
hpm i -g @ohos/ninja
hpm i -g @ohos/gn
hpm i -g @ohos/hc_gen
hpm i -g @ohos/sysroot
```

这是一组开发工具的组件包（如包含gn，ninja等工具），有了这些开发态的组件，就可以进行常规的源码组件的开发了。

