# Image<a name="EN-US_TOPIC_0000001115974752"></a>

-   [Attribute](#en-us_topic_0000001058948927_section1968021961113)
-   [Example](#en-us_topic_0000001058948927_section13457717134912)

**Image**  allows you to add an image.

## Attribute<a name="en-us_topic_0000001058948927_section1968021961113"></a>

<a name="en-us_topic_0000001058948927_table1025010619328"></a>
<table><thead align="left"><tr id="en-us_topic_0000001058948927_row163667603219"><th class="cellrowborder" valign="top" width="21.73%" id="mcps1.1.6.1.1"><p id="en-us_topic_0000001058948927_p536646193210"><a name="en-us_topic_0000001058948927_p536646193210"></a><a name="en-us_topic_0000001058948927_p536646193210"></a>Attribute</p>
</th>
<th class="cellrowborder" valign="top" width="22.41%" id="mcps1.1.6.1.2"><p id="en-us_topic_0000001058948927_p7366166163213"><a name="en-us_topic_0000001058948927_p7366166163213"></a><a name="en-us_topic_0000001058948927_p7366166163213"></a>Type</p>
</th>
<th class="cellrowborder" valign="top" width="7.9799999999999995%" id="mcps1.1.6.1.3"><p id="en-us_topic_0000001058948927_p143661564327"><a name="en-us_topic_0000001058948927_p143661564327"></a><a name="en-us_topic_0000001058948927_p143661564327"></a>Default Value</p>
</th>
<th class="cellrowborder" valign="top" width="11.73%" id="mcps1.1.6.1.4"><p id="en-us_topic_0000001058948927_p11366264324"><a name="en-us_topic_0000001058948927_p11366264324"></a><a name="en-us_topic_0000001058948927_p11366264324"></a>Mandatory</p>
</th>
<th class="cellrowborder" valign="top" width="36.15%" id="mcps1.1.6.1.5"><p id="en-us_topic_0000001058948927_p636619618325"><a name="en-us_topic_0000001058948927_p636619618325"></a><a name="en-us_topic_0000001058948927_p636619618325"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="en-us_topic_0000001058948927_row936656193210"><td class="cellrowborder" valign="top" width="21.73%" headers="mcps1.1.6.1.1 "><p id="en-us_topic_0000001058948927_p1436610643211"><a name="en-us_topic_0000001058948927_p1436610643211"></a><a name="en-us_topic_0000001058948927_p1436610643211"></a>src</p>
</td>
<td class="cellrowborder" valign="top" width="22.41%" headers="mcps1.1.6.1.2 "><p id="en-us_topic_0000001058948927_p4366156183210"><a name="en-us_topic_0000001058948927_p4366156183210"></a><a name="en-us_topic_0000001058948927_p4366156183210"></a>string</p>
</td>
<td class="cellrowborder" valign="top" width="7.9799999999999995%" headers="mcps1.1.6.1.3 "><p id="en-us_topic_0000001058948927_p193667616322"><a name="en-us_topic_0000001058948927_p193667616322"></a><a name="en-us_topic_0000001058948927_p193667616322"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="11.73%" headers="mcps1.1.6.1.4 "><p id="en-us_topic_0000001058948927_p636611610320"><a name="en-us_topic_0000001058948927_p636611610320"></a><a name="en-us_topic_0000001058948927_p636611610320"></a>Yes</p>
</td>
<td class="cellrowborder" valign="top" width="36.15%" headers="mcps1.1.6.1.5 "><p id="en-us_topic_0000001058948927_p13366106173215"><a name="en-us_topic_0000001058948927_p13366106173215"></a><a name="en-us_topic_0000001058948927_p13366106173215"></a>Image resource path</p>
</td>
</tr>
<tr id="en-us_topic_0000001058948927_row13366969325"><td class="cellrowborder" valign="top" width="21.73%" headers="mcps1.1.6.1.1 "><p id="en-us_topic_0000001058948927_p13366136183210"><a name="en-us_topic_0000001058948927_p13366136183210"></a><a name="en-us_topic_0000001058948927_p13366136183210"></a>width</p>
</td>
<td class="cellrowborder" valign="top" width="22.41%" headers="mcps1.1.6.1.2 "><p id="en-us_topic_0000001058948927_p73668623216"><a name="en-us_topic_0000001058948927_p73668623216"></a><a name="en-us_topic_0000001058948927_p73668623216"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="7.9799999999999995%" headers="mcps1.1.6.1.3 "><p id="en-us_topic_0000001058948927_p8366206123215"><a name="en-us_topic_0000001058948927_p8366206123215"></a><a name="en-us_topic_0000001058948927_p8366206123215"></a>0px</p>
</td>
<td class="cellrowborder" valign="top" width="11.73%" headers="mcps1.1.6.1.4 "><p id="en-us_topic_0000001058948927_p636617633210"><a name="en-us_topic_0000001058948927_p636617633210"></a><a name="en-us_topic_0000001058948927_p636617633210"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="36.15%" headers="mcps1.1.6.1.5 "><p id="en-us_topic_0000001058948927_p123661613324"><a name="en-us_topic_0000001058948927_p123661613324"></a><a name="en-us_topic_0000001058948927_p123661613324"></a>Image width</p>
</td>
</tr>
<tr id="en-us_topic_0000001058948927_row103661365321"><td class="cellrowborder" valign="top" width="21.73%" headers="mcps1.1.6.1.1 "><p id="en-us_topic_0000001058948927_p163663610321"><a name="en-us_topic_0000001058948927_p163663610321"></a><a name="en-us_topic_0000001058948927_p163663610321"></a>height</p>
</td>
<td class="cellrowborder" valign="top" width="22.41%" headers="mcps1.1.6.1.2 "><p id="en-us_topic_0000001058948927_p03673613324"><a name="en-us_topic_0000001058948927_p03673613324"></a><a name="en-us_topic_0000001058948927_p03673613324"></a>&lt;length&gt;</p>
</td>
<td class="cellrowborder" valign="top" width="7.9799999999999995%" headers="mcps1.1.6.1.3 "><p id="en-us_topic_0000001058948927_p113674614326"><a name="en-us_topic_0000001058948927_p113674614326"></a><a name="en-us_topic_0000001058948927_p113674614326"></a>0px</p>
</td>
<td class="cellrowborder" valign="top" width="11.73%" headers="mcps1.1.6.1.4 "><p id="en-us_topic_0000001058948927_p3367566327"><a name="en-us_topic_0000001058948927_p3367566327"></a><a name="en-us_topic_0000001058948927_p3367566327"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="36.15%" headers="mcps1.1.6.1.5 "><p id="en-us_topic_0000001058948927_p43671663322"><a name="en-us_topic_0000001058948927_p43671663322"></a><a name="en-us_topic_0000001058948927_p43671663322"></a>Image height</p>
</td>
</tr>
<tr id="en-us_topic_0000001058948927_row18346152013215"><td class="cellrowborder" valign="top" width="21.73%" headers="mcps1.1.6.1.1 "><p id="en-us_topic_0000001058948927_p1033772416322"><a name="en-us_topic_0000001058948927_p1033772416322"></a><a name="en-us_topic_0000001058948927_p1033772416322"></a>onload</p>
</td>
<td class="cellrowborder" valign="top" width="22.41%" headers="mcps1.1.6.1.2 "><p id="en-us_topic_0000001058948927_p1337202419320"><a name="en-us_topic_0000001058948927_p1337202419320"></a><a name="en-us_topic_0000001058948927_p1337202419320"></a>Function</p>
</td>
<td class="cellrowborder" valign="top" width="7.9799999999999995%" headers="mcps1.1.6.1.3 "><p id="en-us_topic_0000001058948927_p137953293211"><a name="en-us_topic_0000001058948927_p137953293211"></a><a name="en-us_topic_0000001058948927_p137953293211"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="11.73%" headers="mcps1.1.6.1.4 "><p id="en-us_topic_0000001058948927_p153471320113217"><a name="en-us_topic_0000001058948927_p153471320113217"></a><a name="en-us_topic_0000001058948927_p153471320113217"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="36.15%" headers="mcps1.1.6.1.5 "><p id="en-us_topic_0000001058948927_p7337142443214"><a name="en-us_topic_0000001058948927_p7337142443214"></a><a name="en-us_topic_0000001058948927_p7337142443214"></a>Called when an image is successfully loaded. This function has no parameter.</p>
</td>
</tr>
<tr id="en-us_topic_0000001058948927_row455917203329"><td class="cellrowborder" valign="top" width="21.73%" headers="mcps1.1.6.1.1 "><p id="en-us_topic_0000001058948927_p107821651123213"><a name="en-us_topic_0000001058948927_p107821651123213"></a><a name="en-us_topic_0000001058948927_p107821651123213"></a>onerror</p>
</td>
<td class="cellrowborder" valign="top" width="22.41%" headers="mcps1.1.6.1.2 "><p id="en-us_topic_0000001058948927_p147828514328"><a name="en-us_topic_0000001058948927_p147828514328"></a><a name="en-us_topic_0000001058948927_p147828514328"></a>Function</p>
</td>
<td class="cellrowborder" valign="top" width="7.9799999999999995%" headers="mcps1.1.6.1.3 "><p id="en-us_topic_0000001058948927_p19161175419328"><a name="en-us_topic_0000001058948927_p19161175419328"></a><a name="en-us_topic_0000001058948927_p19161175419328"></a>-</p>
</td>
<td class="cellrowborder" valign="top" width="11.73%" headers="mcps1.1.6.1.4 "><p id="en-us_topic_0000001058948927_p0559142083215"><a name="en-us_topic_0000001058948927_p0559142083215"></a><a name="en-us_topic_0000001058948927_p0559142083215"></a>No</p>
</td>
<td class="cellrowborder" valign="top" width="36.15%" headers="mcps1.1.6.1.5 "><p id="en-us_topic_0000001058948927_p1778212512329"><a name="en-us_topic_0000001058948927_p1778212512329"></a><a name="en-us_topic_0000001058948927_p1778212512329"></a>Called when an image fails to be loaded. This function has no parameter.</p>
</td>
</tr>
</tbody>
</table>

## Example<a name="en-us_topic_0000001058948927_section13457717134912"></a>

```
var ctx = this.$element('drawImage').getContext('2d');
var img = new Image();
img.src = 'common/image/huawei.jpg';
img.onload = function() {
  console.log('Image load success');
  ctx.drawImage(img, 200, 200);
};
img.onerror = function() {
  console.log('Image load fail');
};
```

