# 帐号子系统<a name="ZH-CN_TOPIC_0000001123681215"></a>

-   [简介](#section11660541593)
-   [架构图](#section1412183212132)
-   [目录](#section161941989596)
-   [说明](#section1312121216216)
    -   [模块说明](#section1551164914236)
    -   [使用说明](#section1551164914237)

-   [相关仓](#section1371113476307)

## 简介<a name="section11660541593"></a>

在标准系统上，帐号子系统主要提供系统帐号生命周期管理，分布式帐号登录状态管理和应用帐号信息管理等基础能力。

## 架构图<a name="section1412183212132"></a>

**图 1**  帐号子系统架构图<a name="fig4460722185514"></a>


![](figures/zh-cn_image_account_struct.png)

## 目录<a name="section161941989596"></a>

```
/base/account/os_account
├── dfx                      
│   ├── hidumper_adapter     系统服务信息导出适配器代码          
│   ├── hisysevent_adapter   系统事件打点适配器代码          
├── figures                  README图片
├── frameworks               帐号子系统kit代码
│   ├── account_iam          账号身份认证和访问管理内部API代码
│   │   └── src              账号身份认证和访问管理内部API实现代码          
│   ├── appaccount           应用帐号内部API代码
│   │   └── native           应用帐号内部API实现代码
│   ├── common               共通模块代码
│   │   ├── account_error    错误码
│   │   ├── database         数据库基础代码
│   │   ├── file_operator    文件操作代码
│   │   ├── log              打印日志代码
│   │   ├── perf_stat        性能统计
│   │   └── test             共通模块测试代码
│   ├── ohosaccount          分布式帐号内部API代码
│   │   ├── native           分布式帐号内部API实现代码
│   │   └── test             分布式帐号内部API测试代码
│   └── osaccount            系统帐号内部API代码
│       ├── core             系统帐号ipc
│       └── native           系统帐号内部API实现代码
├── interfaces               帐号子系统对外公开的API
│   ├── innerkits            内部API头文件
│   │   ├── account_iam      账号身份认证和访问管理
│   │   ├── appaccount       应用帐号内部API头文件
│   │   ├── ohosaccount      分布式帐号内部API头文件
│   │   └── osaccount        系统帐号内部API头文件
│   └── kits                 对外API封装
│       └── napi             帐号子系统对外API封装代码
├── sa_profile               帐号子系统SA配置文件定义目录
├── services                 帐号子系统accountmgr服务代码
│   └── accountmgr           帐号子系统服务代码
│       ├── include          帐号子系统服务代码头文件
│       ├── src              帐号子系统服务代码源文件
│       └── test             帐号子系统服务测试
├── test                     测试代码
│   ├── fuzztest             模糊测试代码
│   ├── resource             测试资源文件
│   └── systemtest           系统测试代码
└── tools                    acm工具代码
    ├── acm                  acm工具代码
    │   ├── include          acm工具代码头文件
    │   └── src              acm工具代码源文件
    └── test                 acm工具测试代码
```

## 说明<a name="section1312121216216"></a>

### 模块说明<a name="section1551164914236"></a>

<table>
<thead align="left"><tr id="row175061254462">
<th class="cellrowborder" valign="top" width="20%" id="mcps1.2.3.1.1"><p id="p1250613547612"><a name="p1250613547612"></a><a name="p1250613547612"></a>模块名</p>
</th>
<th class="cellrowborder" valign="top" width="80%" id="mcps1.2.3.1.2"><p id="p85066541767"><a name="p85066541767"></a><a name="p85066541767"></a>描述</p>
</th>
</tr>
</thead>
<tbody>
<tr id="row0506185417614"><td class="cellrowborder" valign="top" width="20%" headers="mcps1.2.3.1.1 "><p id="p1561112131788"><a name="p1561112131788"></a><a name="p1561112131788"></a>系统帐号</p>
</td>
<td class="cellrowborder" valign="top" width="80%" headers="mcps1.2.3.1.2 "><p id="p1954531161115"><a name="p1954531161115"></a><a name="p1954531161115"></a>提供系统帐号的添加、删除、查询、修改、订阅和启动等功能。</p>
</td>
</tr>
<tr id="row0506185417614"><td class="cellrowborder" valign="top" width="20%" headers="mcps1.2.3.1.1 "><p id="p1561112131788"><a name="p1561112131788"></a><a name="p1561112131788"></a>分布式帐号</p>
</td>
<td class="cellrowborder" valign="top" headers="mcps1.2.3.1.2 "><p id="p1954531161115"><a name="p1954531161115"></a><a name="p1954531161115"></a>提供分布式帐号登录状态管理能力，支持在端侧对接厂商云帐号应用，提供云帐号登录状态查询和更新能力。</p>
</td>
</tr>
<tr id="row0506185417614"><td class="cellrowborder" valign="top" width="20%" headers="mcps1.2.3.1.1 "><p id="p1561112131788"><a name="p1561112131788"></a><a name="p1561112131788"></a>应用帐号</p>
</td>
<td class="cellrowborder" valign="top" width="80%" headers="mcps1.2.3.1.2 "><p id="p1954531161115"><a name="p1954531161115"></a><a name="p1954531161115"></a>提供应用帐号的添加、删除、查询、修改和鉴权等功能。</p>
</td>
</tr>
</tbody>
</table>

### 使用说明<a name="section1551164914237"></a>

[1. 系统帐号](https://gitee.com/openharmony/docs/blob/master/zh-cn/application-dev/reference/apis/js-apis-osAccount.md)

[2. 分布式帐号](https://gitee.com/openharmony/docs/blob/master/zh-cn/application-dev/reference/apis/js-apis-distributed-account.md)

[3. 应用帐号](https://gitee.com/openharmony/docs/blob/master/zh-cn/application-dev/reference/apis/js-apis-appAccount.md)

## 相关仓<a name="section1371113476307"></a>

**帐号子系统**

[account_os_account](https://gitee.com/openharmony/account_os_account)

