# OpenHarmony设备开发文档
- [设备开发导读](device-dev-guide.md)
- 快速开始
  - [快速入门概述](quick-start/quickstart-overview.md)
  - 基于IDE开发
    - 搭建开发环境
      - [搭建Windows环境](quick-start/quickstart-ide-env-win.md)
      - [搭建Ubuntu环境](quick-start/quickstart-ide-env-ubuntu.md)
      - [配置远程访问环境](quick-start/quickstart-ide-env-remote.md)
    - [创建工程并获取源码](quick-start/quickstart-ide-import-project.md)
    - 轻量系统（基于Hi3861开发板）
      - [编写“Hello World”程序](quick-start/quickstart-ide-3861-helloworld.md)
      - [编译](quick-start/quickstart-ide-3861-build.md)
      - [烧录](quick-start/quickstart-ide-3861-burn.md)
      - [运行](quick-start/quickstart-ide-3861-running.md)
    - 小型系统（基于Hi3516开发板）
      - [编写“Hello World”程序](quick-start/quickstart-ide-3516-helloworld.md)
      - [编译](quick-start/quickstart-ide-3516-build.md)
      - [烧录](quick-start/quickstart-ide-3516-burn.md)
      - [运行](quick-start/quickstart-ide-3516-running.md)
    - 标准系统（基于RK3568开发板）
      - [编写“Hello World”程序](quick-start/quickstart-ide-3568-helloworld.md)
      - [编译](quick-start/quickstart-ide-3568-build.md)
      - [烧录](quick-start/quickstart-ide-3568-burn.md)
      - [运行](quick-start/quickstart-ide-3568-running.md)
  - 基于命令行开发
    - 搭建开发环境
      - [准备开发环境](quick-start/quickstart-pkg-prepare.md)
      - [安装库和工具集](quick-start/quickstart-pkg-install-package.md)
      - [获取源码](quick-start/quickstart-pkg-sourcecode.md)
      - [安装编译工具](quick-start/quickstart-pkg-install-tool.md)
    - 轻量系统（基于Hi3861开发板）
      - [安装Hi3861开发板特有环境](quick-start/quickstart-pkg-3861-tool.md)
      - [编写“Hello World”程序](quick-start/quickstart-pkg-3861-helloworld.md)
      - [编译](quick-start/quickstart-pkg-3861-build.md)
      - [烧录](quick-start/quickstart-pkg-3861-burn.md)
      - [运行](quick-start/quickstart-pkg-3861-running.md)
    - 小型系统（基于Hi3516开发板）
      - [编写“Hello World”程序](quick-start/quickstart-pkg-3516-helloworld.md)
      - [编译](quick-start/quickstart-pkg-3516-build.md)
      - [烧录](quick-start/quickstart-pkg-3516-burn.md)
      - [运行](quick-start/quickstart-pkg-3516-running.md)
    - 标准系统（基于RK3568开发板）
      - [编写“Hello World”程序](quick-start/quickstart-pkg-3568-helloworld.md)
      - [编译](quick-start/quickstart-pkg-3568-build.md)
      - [烧录](quick-start/quickstart-pkg-3568-burn.md)
      - [运行](quick-start/quickstart-pkg-3568-running.md)
    - 常用信息
      - [配置代理](quick-start/quickstart-pkg-common-proxy.md)
      - [使用build.sh脚本编译源码](quick-start/quickstart-pkg-common-build.md)
      - [hb安装异常处理](quick-start/quickstart-pkg-common-hberr.md)
      - [编译异常处理](quick-start/quickstart-pkg-common-builderr.md)
      - [烧录异常处理](quick-start/quickstart-pkg-common-burnerr.md)
  - 附录
    - [Hi3516开发板介绍](quick-start/quickstart-appendix-hi3516.md)
    - [Hi3861开发板介绍](quick-start/quickstart-appendix-hi3861.md)
    - [RK3568开发板介绍](quick-start/quickstart-appendix-rk3568.md)
    - [编译形态整体说明](quick-start/quickstart-appendix-compiledform.md)
    - [Hi3516标准系统入门（IDE方式）](quick-start/quickstart-appendix-hi3516-ide.md)
    - [Hi3516标准系统入门（命令行方式）](quick-start/quickstart-appendix-hi3516-pkg.md)
  
  - [获取源码](get-code/sourcecode-acquire.md)
- 隐私和安全
  - [隐私保护](security/security-privacy-protection.md)
  - [安全指南](security/security-guidelines-overall.md)

- 移植

  - 轻量系统芯片移植指导

    - [概述](porting/porting-minichip-overview.md)

    - [移植准备](porting/porting-minichip-prepare.md)

    - [移植内核](porting/porting-minichip-kernel.md)

    - 移植子系统

      - [移植子系统概述](porting/porting-minichip-subsys-overview.md)

      - [移植启动恢复子系统](porting/porting-minichip-subsys-startup.md)

      - [移植文件子系统](porting/porting-minichip-subsys-filesystem.md)

      - [移植安全子系统](porting/porting-minichip-subsys-security.md)

      - [移植通信子系统](porting/porting-minichip-subsys-communication.md)

      - [移植外设驱动子系统](porting/porting-minichip-subsys-driver.md)

      - [配置其他子系统](porting/porting-minichip-subsys-others.md)

    - [移植验证](porting/porting-minichip-verification.md)

    - [常见问题](porting/porting-chip-faqs.md)

  - 小型系统芯片移植指导

    - 移植准备

      - [移植须知](porting/porting-smallchip-prepare-needs.md)

      - [编译构建](porting/porting-smallchip-prepare-building.md)

    - 移植内核

      - [LiteOS-A内核](porting/porting-smallchip-kernel-a.md)

      - [Linux内核](porting/porting-smallchip-kernel-linux.md)

    - 驱动移植

      - [移植概述](porting/porting-smallchip-driver-overview.md)

      - [平台驱动移植](porting/porting-smallchip-driver-plat.md)

      - [器件驱动移植](porting/porting-smallchip-driver-oom.md)

  - 标准系统芯片移植指导

    - [标准系统移植指南](porting/standard-system-porting-guide.md)

    - [一种快速移植OpenHarmony Linux内核的方法](porting/porting-linux-kernel.md)

  - 轻量和小型系统三方库移植指导

    - [概述](porting/porting-thirdparty-overview.md)

    - [CMake方式组织编译的库移植](porting/porting-thirdparty-cmake.md)

    - [Makefile方式组织编译的库移植](porting/porting-thirdparty-makefile.md)

  - 轻量系统芯片移植案例

      - [带屏解决方案之恒玄芯片移植案例](porting/porting-bes2600w-on-minisystem-display-demo.md)

      - [Combo解决方案之ASR芯片移植案例](porting/porting-asr582x-combo-demo.md)

      - [物联网解决方案之芯海cst85芯片移植案例](porting/porting-cst85f01-combo-demo.md)

      - [轻量系统STM32F407芯片移植案例](porting/porting-stm32f407-on-minisystem-eth.md)

      - [Combo解决方案之W800芯片移植案例](porting/porting-w800-combo-demo.md)

  - 小型系统芯片移植案例

      - [小型设备STM32MP1芯片移植案例](porting/porting-stm32mp15xx-on-smallsystem.md)

  - 标准系统芯片移植案例

      - [标准系统方案之瑞芯微RK3568移植案例](porting/porting-dayu200-on_standard-demo.md)

- 子系统开发

  -  内核
     - [内核概述](kernel/kernel-overview.md)
     - 轻量系统内核（LiteOS-M）
       - [轻量系统内核概述](kernel/kernel-mini-overview.md)
       - 基础内核
         - [中断管理](kernel/kernel-mini-basic-interrupt.md)
         - [任务管理](kernel/kernel-mini-basic-task.md)
         - [内存管理](kernel/kernel-mini-basic-memory.md)
         - 内核通信机制
           - [事件](kernel/kernel-mini-basic-ipc-event.md)
           - [互斥锁](kernel/kernel-mini-basic-ipc-mutex.md)
           - [消息队列](kernel/kernel-mini-basic-ipc-queue.md)
           - [信号量](kernel/kernel-mini-basic-ipc-sem.md)
         - [时间管理](kernel/kernel-mini-basic-time.md)
         - [软件定时器](kernel/kernel-mini-basic-soft.md)
         - [双向链表](kernel/kernel-mini-basic-list.md)
       - 扩展组件
         - [C++支持](kernel/kernel-mini-extend-support.md)
         - [CPU占用率](kernel/kernel-mini-extend-cpup.md)
         - [动态加载](kernel/kernel-mini-extend-dynamic-loading.md)
         - [文件系统](kernel/kernel-mini-extend-file.md)
       - 内核调测
         - [内存调测](kernel/kernel-mini-memory-debug.md)
         - [异常调测](kernel/kernel-mini-memory-exception.md)
         - [Trace调测](kernel/kernel-mini-memory-trace.md)
         - [LMS调测](kernel/kernel-mini-memory-lms.md)
         - [SHELL](kernel/kernel-mini-debug-shell.md)
       - 附录
         - [内核编码规范](kernel/kernel-mini-appx-code.md)
         - [标准库支持](kernel/kernel-mini-appx-lib.md)
     - 小型系统内核（LiteOS-A）
       - [小型系统内核概述](kernel/kernel-small-overview.md)
       - 内核启动
         - [内核态启动](kernel/kernel-small-start-kernel.md)
         - [用户态启动](kernel/kernel-small-start-user.md)
       - 基础内核
         - [中断及异常处理](kernel/kernel-small-basic-interrupt.md)
         - 进程管理
           - [进程](kernel/kernel-small-basic-process-process.md)
           - [任务](kernel/kernel-small-basic-process-thread.md)
           - [调度器](kernel/kernel-small-basic-process-scheduler.md)
         - 内存管理
           - [堆内存管理](kernel/kernel-small-basic-memory-heap.md)
           - [物理内存管理](kernel/kernel-small-basic-memory-physical.md)
           - [虚拟内存管理](kernel/kernel-small-basic-memory-virtual.md)
           - [虚实映射](kernel/kernel-small-basic-inner-reflect.md)
         - 内核通信机制
           - [事件](kernel/kernel-small-basic-trans-event.md)
           - [信号量](kernel/kernel-small-basic-trans-semaphore.md)
           - [互斥锁](kernel/kernel-small-basic-trans-mutex.md)
           - [消息队列](kernel/kernel-small-basic-trans-queue.md)
           - [读写锁](kernel/kernel-small-basic-trans-rwlock.md)
           - [用户态快速互斥锁](kernel/kernel-small-basic-trans-user-mutex.md)
           - [信号](kernel/kernel-small-basic-trans-user-signal.md)
         - [时间管理](kernel/kernel-small-basic-time.md)
         - [软件定时器](kernel/kernel-small-basic-softtimer.md)
         - [原子操作](kernel/kernel-small-basic-atomic.md)
       - 扩展组件
         - [系统调用](kernel/kernel-small-bundles-system.md)
         - [动态加载与链接](kernel/kernel-small-bundles-linking.md)
         - [虚拟动态共享库](kernel/kernel-small-bundles-share.md)
         - [轻量级进程间通信](kernel/kernel-small-bundles-ipc.md)
         - 文件系统
           - [虚拟文件系统](kernel/kernel-small-bundles-fs-virtual.md)
           - [支持的文件系统](kernel/kernel-small-bundles-fs-support.md)
           - [适配新的文件系统](kernel/kernel-small-bundles-fs-new.md)
           - [Plimitsfs文件系统](kernel/kernel-small-plimits.md)
       - 调测与工具
         - Shell
           - [Shell介绍](kernel/kernel-small-debug-shell-overview.md)
           - [Shell命令开发指导](kernel/kernel-small-debug-shell-guide.md)
           - [Shell命令编程实例](kernel/kernel-small-debug-shell-build.md)
           - Shell命令使用详解
             - 系统命令
               - [cpup](kernel/kernel-small-debug-shell-cmd-cpup.md)
               - [date](kernel/kernel-small-debug-shell-cmd-date.md)
               - [dmesg](kernel/kernel-small-debug-shell-cmd-dmesg.md)
               - [exec](kernel/kernel-small-debug-shell-cmd-exec.md)
               - [free](kernel/kernel-small-debug-shell-cmd-free.md)
               - [help](kernel/kernel-small-debug-shell-cmd-help.md)
               - [hwi](kernel/kernel-small-debug-shell-cmd-hwi.md)
               - [kill](kernel/kernel-small-debug-shell-cmd-kill.md)
               - [log](kernel/kernel-small-debug-shell-cmd-log.md)
               - [memcheck](kernel/kernel-small-debug-shell-cmd-memcheck.md)
               - [oom](kernel/kernel-small-debug-shell-cmd-oom.md)
               - [pmm](kernel/kernel-small-debug-shell-cmd-pmm.md)
               - [reset](kernel/kernel-small-debug-shell-cmd-reset.md)
               - [sem](kernel/kernel-small-debug-shell-cmd-sem.md)
               - [stack](kernel/kernel-small-debug-shell-cmd-stack.md)
               - [su](kernel/kernel-small-debug-shell-cmd-su.md)
               - [swtmr](kernel/kernel-small-debug-shell-cmd-swtmr.md)
               - [systeminfo](kernel/kernel-small-debug-shell-cmd-sysinfo.md)
               - [task](kernel/kernel-small-debug-shell-cmd-task.md)
               - [uname](kernel/kernel-small-debug-shell-cmd-uname.md)
               - [vmm](kernel/kernel-small-debug-shell-cmd-vmm.md)
               - [watch](kernel/kernel-small-debug-shell-cmd-watch.md)
               - [reboot](kernel/kernel-small-debug-shell-cmd-reboot.md)
               - [top](kernel/kernel-small-debug-shell-cmd-top.md)
             - 文件命令
               - [cat](kernel/kernel-small-debug-shell-file-cat.md)
               - [cd](kernel/kernel-small-debug-shell-file-cd.md)
               - [chgrp](kernel/kernel-small-debug-shell-file-chgrp.md)
               - [chmod](kernel/kernel-small-debug-shell-file-chmod.md)
               - [chown](kernel/kernel-small-debug-shell-file-chown.md)
               - [cp](kernel/kernel-small-debug-shell-file-cp.md)
               - [format](kernel/kernel-small-debug-shell-file-format.md)
               - [ls](kernel/kernel-small-debug-shell-file-ls.md)
               - [lsfd](kernel/kernel-small-debug-shell-file-lsfd.md)
               - [mkdir](kernel/kernel-small-debug-shell-file-mkdir.md)
               - [mount](kernel/kernel-small-debug-shell-file-mount.md)
               - [partinfo](kernel/kernel-small-debug-shell-file-partinfo.md)
               - [partition](kernel/kernel-small-debug-shell-file-partition.md)
               - [pwd](kernel/kernel-small-debug-shell-file-pwd.md)
               - [rm](kernel/kernel-small-debug-shell-file-rm.md)
               - [rmdir](kernel/kernel-small-debug-shell-file-rmdir.md)
               - [statfs](kernel/kernel-small-debug-shell-file-statfs.md)
               - [sync](kernel/kernel-small-debug-shell-file-sync.md)
               - [touch](kernel/kernel-small-debug-shell-file-touch.md)
               - [writeproc](kernel/kernel-small-debug-shell-file-write.md)
               - [umount](kernel/kernel-small-debug-shell-file-umount.md)
               - [du](kernel/kernel-small-debug-shell-file-du.md)
               - [mv](kernel/kernel-small-debug-shell-file-mv.md)
             - 网络命令
               - [arp](kernel/kernel-small-debug-shell-net-arp.md)
               - [dhclient](kernel/kernel-small-debug-shell-net-dhclient.md)
               - [ifconfig](kernel/kernel-small-debug-shell-net-ifconfig.md)
               - [ipdebug](kernel/kernel-small-debug-shell-net-ipdebug.md)
               - [netstat](kernel/kernel-small-debug-shell-net-netstat.md)
               - [ntpdate](kernel/kernel-small-debug-shell-net-ntpdate.md)
               - [ping](kernel/kernel-small-debug-shell-net-ping.md)
               - [ping6](kernel/kernel-small-debug-shell-net-ping6.md)
               - [telnet](kernel/kernel-small-debug-shell-net-telnet.md)
               - [tftp](kernel/kernel-small-debug-shell-net-tftp.md)
           - [魔法键使用方法](kernel/kernel-small-debug-shell-magickey.md)
           - [用户态异常信息说明](kernel/kernel-small-debug-shell-error.md)
         - [Trace调测](kernel/kernel-small-debug-trace.md)
         - [Perf调测](kernel/kernel-small-debug-perf.md)
         - [LMS调测](kernel/kernel-small-memory-lms.md)
         - [进程调测](kernel/kernel-small-debug-process-cpu.md)
         - 内核态内存调测
           - [内存信息统计](kernel/kernel-small-debug-memory-info.md)
           - [内存泄漏检测](kernel/kernel-small-debug-memory-leak.md)
           - [踩内存检测](kernel/kernel-small-debug-memory-corrupt.md)
         - [用户态内存调测](kernel/kernel-small-debug-user.md)
         - 其他内核调测手段
           - [临终遗言](kernel/kernel-small-debug-trace-other-lastwords.md)
           - [常见问题](kernel/kernel-small-debug-trace-other-faqs.md)
       - 附录
         - 基本数据结构
           - [双向链表](kernel/kernel-small-apx-dll.md)
           - [位操作](kernel/kernel-small-apx-bitwise.md)
         - [标准库](kernel/kernel-small-apx-library.md)
         - [内核编码规范](kernel/kernel-mini-appx-code.md)
     - 标准系统内核（Linux）
       - [标准系统内核概述](kernel/kernel-standard-overview.md)
       - [OpenHarmony开发板Patch使用指导](kernel/kernel-standard-patch.md)
       - [标准系统内核编译与构建指导](kernel/kernel-standard-build.md)
       - 内核增强特性
         - [Enhanced SWAP特性介绍](kernel/kernel-standard-mm-eswap.md)
         - [NewIP内核协议栈介绍](kernel/kernel-standard-newip.md)
         - 任务调度
           - [关联线程组调度](kernel/kernel-standard-sched-rtg.md)
           - [CPU轻量级隔离](kernel/kernel-standard-sched-cpuisolation.md)
  -  驱动
     - [驱动概述](driver/driver-overview-foundation.md)
     - HDF驱动框架
       - [HDF开发概述](driver/driver-hdf-overview.md)
       - [驱动开发](driver/driver-hdf-development.md)
       - [驱动加载](driver/driver-hdf-load.md)
       - [驱动服务管理](driver/driver-hdf-servicemanage.md)
       - [驱动消息机制管理](driver/driver-hdf-message-management.md)
       - [配置管理](driver/driver-hdf-manage.md)
       - [HDF开发实例](driver/driver-hdf-sample.md)
     - 平台驱动开发
       - [ADC](driver/driver-platform-adc-develop.md)
       - [DAC](driver/driver-platform-dac-develop.md)
       - [GPIO](driver/driver-platform-gpio-develop.md)
       - [HDMI](driver/driver-platform-hdmi-develop.md)
       - [I2C](driver/driver-platform-i2c-develop.md)
       - [I3C](driver/driver-platform-i3c-develop.md)
       - [MIPI CSI](driver/driver-platform-mipicsi-develop.md)
       - [MIPI DSI](driver/driver-platform-mipidsi-develop.md)
       - [MMC](driver/driver-platform-mmc-develop.md)
       - [PIN](driver/driver-platform-pin-develop.md)
       - [PWM](driver/driver-platform-pwm-develop.md)
       - [Regulator](driver/driver-platform-regulator-develop.md)
       - [RTC](driver/driver-platform-rtc-develop.md)
       - [SDIO](driver/driver-platform-sdio-develop.md)
       - [SPI](driver/driver-platform-spi-develop.md)
       - [UART](driver/driver-platform-uart-develop.md)
       - [WatchDog](driver/driver-platform-watchdog-develop.md)
     - 平台驱动使用
       - [ADC](driver/driver-platform-adc-des.md)
       - [DAC](driver/driver-platform-dac-des.md)
       - [GPIO](driver/driver-platform-gpio-des.md)
       - [HDMI](driver/driver-platform-hdmi-des.md)
       - [I2C](driver/driver-platform-i2c-des.md)
       - [I3C](driver/driver-platform-i3c-des.md)
       - [MIPI CSI](driver/driver-platform-mipicsi-des.md)
       - [MIPI DSI](driver/driver-platform-mipidsi-des.md)
       - [PIN](driver/driver-platform-pin-des.md)
       - [PWM](driver/driver-platform-pwm-des.md)
       - [Regulator](driver/driver-platform-regulator-des.md)
       - [RTC](driver/driver-platform-rtc-des.md)
       - [SDIO](driver/driver-platform-sdio-des.md)
       - [SPI](driver/driver-platform-spi-des.md)
       - [UART](driver/driver-platform-uart-des.md)
       - [WatchDog](driver/driver-platform-watchdog-des.md)
     - 外设驱动使用
       - [Audio](driver/driver-peripherals-audio-des.md)
       - [Camera](driver/driver-peripherals-camera-des.md)
       - [Codec](driver/driver-peripherals-codec-des.md)
       - [Face_auth](driver/driver-peripherals-face_auth-des.md)
       - [Fingerprint_auth](driver/driver-peripherals-fingerprint_auth-des.md)
       - [LCD](driver/driver-peripherals-lcd-des.md)
       - [Light](driver/driver-peripherals-light-des.md)
       - [Motion](driver/driver-peripherals-motion-des.md)
       - [Pin_auth](driver/driver-peripherals-pinauth-des.md)
       - [Sensor](driver/driver-peripherals-sensor-des.md)
       - [Touchscreen](driver/driver-peripherals-touch-des.md)
       - [USB](driver/driver-peripherals-usb-des.md)
       - [User_auth](driver/driver-peripherals-user-auth-des.md)
       - [Vibrator](driver/driver-peripherals-vibrator-des.md)
       - [WLAN](driver/driver-peripherals-external-des.md)
  -  编译构建
     - [编译构建指导](subsystems/subsys-build-all.md)
     - [构建系统编码规范与最佳实践](subsystems/subsys-build-gn-coding-style-and-best-practice.md)
     - [编译构建Kconfig可视化配置指导](subsystems/subsys-build-gn-kconfig-visual-config-guide.md)
     - 编译构建参考
       - [子系统配置规则](subsystems/subsys-build-subsystem.md)
       - [产品配置规则](subsystems/subsys-build-product.md)
       - [子系统配置规则](subsystems/subsys-build-subsystem.md)
       - [部件配置规则](subsystems/subsys-build-component.md)
       - [模块配置规则](subsystems/subsys-build-module.md)
       - [芯片解决方案配置规则](subsystems/subsys-build-chip_solution.md)
       - [特性配置规则](subsystems/subsys-build-feature.md)
       - [系统能力配置规则](subsystems/subsys-build-syscap.md)
       - [关于deps、external_deps的使用](subsystems/subsys-build-reference.md)
       - [开源软件Notice收集策略说明](subsystems/subsys-build-reference.md)
       - [加快本地编译的一些参数](subsystems/subsys-build-reference.md)
       - [查看NinjaTrace](subsystems/subsys-build-reference.md)
       - [HAP编译构建指导](subsystems/subsys-build-gn-hap-compilation-guide.md)
       - [常见问题](subsystems/subsys-build-FAQ.md)
  -  [分布式远程启动](subsystems/subsys-remote-start.md)
  -  图形图像
     - [图形图像概述](subsystems/subsys-graphics-overview.md)
     - [容器类组件开发指导](subsystems/subsys-graphics-container-guide.md)
     - [布局容器类组件开发指导](subsystems/subsys-graphics-layout-guide.md)
     - [普通组件开发指导](subsystems/subsys-graphics-common-guide.md)
     - [动画开发指导](subsystems/subsys-graphics-animation-guide.md)
  -  媒体
     - 相机
       - [相机开发概述](subsystems/subsys-multimedia-camera-overview.md)
       - [拍照开发指导](subsystems/subsys-multimedia-camera-photo-guide.md)
       - [录像开发指导](subsystems/subsys-multimedia-camera-record-guide.md)
       - [预览开发指导](subsystems/subsys-multimedia-camera-preview-guide.md)
     - 音视频
       - [音视频开发概述](subsystems/subsys-multimedia-video-overview.md)
       - [音视频播放开发指导](subsystems/subsys-multimedia-video-play-guide.md)
       - [音视频录制开发指导](subsystems/subsys-multimedia-video-record-guide.md)
  -  公共基础
     - [公共基础库概述](subsystems/subsys-utils-overview.md)
     - [公共基础库开发指导](subsystems/subsys-utils-guide.md)
     - [公共基础库常见问题](subsystems/subsys-utils-faqs.md)
  -  AI服务
     - [AI框架开发指导](subsystems/subsys-ai-aiframework-devguide.md)
     - [NNRt开发指导](subsystems/subsys-ai-nnrt-guide.md)
  -  Sensor服务
     - [Sensor服务概述](subsystems/subsys-sensor-overview.md)
     - [Sensor服务使用指导](subsystems/subsys-sensor-guide.md)
     - [Sensor服务使用实例](subsystems/subsys-sensor-demo.md)
  -  用户程序框架
     - [概述](subsystems/subsys-application-framework-overview.md)
     - [搭建环境](subsystems/subsys-application-framework-envbuild.md)
     - [开发指导](subsystems/subsys-application-framework-guide.md)
     - [开发实例](subsystems/subsys-application-framework-demo.md)
  -  [OTA升级](subsystems/subsys-ota-guide.md)
  -  电话服务
     - [电话服务概述](subsystems/subsys-tel-overview.md)
     - [电话服务开发指导](subsystems/subsys-tel-guide.md)
  -  安全
     - [概述](subsystems/subsys-security-overview.md)
     - [应用验签开发指导](subsystems/subsys-security-sigverify.md)
     - [应用权限管理开发指导](subsystems/subsys-security-rightmanagement.md)
     - [IPC通信鉴权开发指导](subsystems/subsys-security-communicationverify.md)
     - [设备安全等级管理开发指导](subsystems/subsys-security-devicesecuritylevel.md)
     - [OpenHarmony通用密钥库系统开发指导](subsystems/subsys-security-huks-guide.md)
     - [应用特权配置指导](subsystems/subsys-app-privilege-config-guide.md)
     - [预置应用配置指导](subsystems/subsys-preinstall-app-config-guide.md)
  -  启动恢复
     - [启动恢复子系统概述](subsystems/subsys-boot-overview.md)
     - init启动引导组件
       - [引导启动配置文件](subsystems/subsys-boot-init-cfg.md)
       - [jobs管理](subsystems/subsys-boot-init-jobs.md)
       - [服务管理](subsystems/subsys-boot-init-service.md)
       - [系统参数](subsystems/subsys-boot-init-sysparam.md)
       - [沙盒管理](subsystems/subsys-boot-init-sandbox.md)
       - [插件](subsystems/subsys-boot-init-plugin.md)
     - [appspawn应用孵化组件](subsystems/subsys-boot-appspawn.md)
     - [bootstrap服务启动组件](subsystems/subsys-boot-bootstrap.md)
     - [常见问题](subsystems/subsys-boot-faqs.md)
     - [启动恢复参考](subsystems/subsys-boot-ref.md)
  -  DFX
     - [DFX概述](subsystems/subsys-dfx-overview.md)
     - [HiLog开发指导](subsystems/subsys-dfx-hilog-rich.md)
     - [HiLog_Lite开发指导](subsystems/subsys-dfx-hilog-lite.md)
     - [HiTraceChain开发指导](subsystems/subsys-dfx-hitracechain.md)
     - [HiTraceMeter开发指导](subsystems/subsys-dfx-hitracemeter.md)
     - [HiCollie开发指导](subsystems/subsys-dfx-hicollie.md)
     - HiSysEvent开发指导
       - [HiSysEvent概述](subsystems/subsys-dfx-hisysevent-overview.md)
       - [HiSysEvent打点配置指导](subsystems/subsys-dfx-hisysevent-logging-config.md)
       - [HiSysEvent打点指导](subsystems/subsys-dfx-hisysevent-logging.md)
       - [HiSysEvent订阅指导](subsystems/subsys-dfx-hisysevent-listening.md)
       - [HiSysEvent查询指导](subsystems/subsys-dfx-hisysevent-query.md)
       - [HiSysEvent工具使用指导](subsystems/subsys-dfx-hisysevent-tool.md)
     - [HiDumper开发指导](subsystems/subsys-dfx-hidumper.md)
     - [HiChecker开发指导](subsystems/subsys-dfx-hichecker.md)
     - [Faultlogger开发指导](subsystems/subsys-dfx-faultlogger.md)
     - [Hiview开发指导](subsystems/subsys-dfx-hiview.md)

- 专题
  - HPM Part
    - [HPM Part介绍](hpm-part/hpm-part-about.md)

    - [HPM Part开发指导](hpm-part/hpm-part-development.md)

    - [HPM Part参考](hpm-part/hpm-part-reference.md)

- 设备开发示例

  - 轻量和小型系统设备
    - WLAN连接类产品
      - [LED外设控制](guide/device-wlan-led-control.md)
      - [集成三方SDK](guide/device-wlan-sdk.md)
    - 带屏摄像头类产品
      - 屏幕和摄像头控制
        - [概述](guide/device-camera-control-overview.md)
        - 示例开发
          - [拍照开发指导](guide/device-camera-control-demo-photoguide.md)
          - [录像开发指导](guide/device-camera-control-demo-videoguide.md)
          - [预览开发指导](guide/device-camera-control-demo-previewguide.md)
        - [应用实例](guide/device-camera-control-example.md)
      - 视觉应用开发
        - [概述](guide/device-camera-visual-overview.md)
        - [开发准备](guide/device-camera-visual-prepare.md)
        - [添加页面](guide/device-camera-visual-addpage.md)
        - [开发首页](guide/device-camera-visual-firstpage.md)
        - [开发详情页](guide/device-camera-visual-details.md)
        - [调试打包](guide/device-camera-visual-debug.md)
        - [真机运行](guide/device-camera-visual-run.md)
        - [常见问题](guide/device-camera-visual-faqs.md)
  - 标准系统设备
    - [时钟应用开发指导](guide/device-clock-guide.md)
    - [平台驱动开发示例](guide/device-driver-demo.md)
    - [外设驱动开发示例](guide/device-outerdriver-demo.md)


- 调测
  - [developer_test开发者自测试执行框架使用指导](device-test/developer_test.md)
  - [xdevice测试调度框架使用指导](device-test/xdevice.md)
  - 调测工具
    - [bytrace使用指导](subsystems/subsys-toolchain-bytrace-guide.md)
    - [hdc\_std 使用指导](subsystems/subsys-toolchain-hdc-guide.md)
    - [hiperf 使用指南](subsystems/subsys-toolchain-hiperf.md)
- [XTS认证](device-test/xts.md)
- 工具
  - [工具概述](get-code/gettools-overview.md)
  - [Docker编译环境](get-code/gettools-acquire.md)
  - [IDE集成开发环境](get-code/gettools-ide.md)
- 示例教程
  - [Demo示例](https://growing.openharmony.cn/mainPlay/sample)
  - [Codelabs](https://gitee.com/openharmony/codelabs/blob/master/README.md) 
- 参考
  - 常见问题
    - [常见问题概述](faqs/faqs-overview.md)
    - [环境搭建常见问题](faqs/faqs-environment-setup.md)
    - [编译构建常见问题](faqs/faqs-building.md)
    - [烧录常见问题](faqs/faqs-burning.md)
    - [内核常见问题](faqs/faqs-kernel.md)
    - [移植常见问题](faqs/faqs-porting.md)
    - [启动恢复常见问题](faqs/faqs-startup.md)
    - [系统应用常见问题](faqs/faqs-system-applications.md) 
  - HDI接口参考
    - 模块
      - [Audio](reference/hdi-apis/_audio.md)
      - [Battery](reference/hdi-apis/battery.md)
      - [Camera](reference/hdi-apis/camera.md)
      - [Codec](reference/hdi-apis/codec.md)
      - [Display](reference/hdi-apis/_display.md)
      - [HdfFaceAuth](reference/hdi-apis/_hdf_face_auth.md)
      - [HdfPinAuth](reference/hdi-apis/_hdf_pin_auth.md)
      - [HdfUserAuth](reference/hdi-apis/_hdf_user_auth.md)
      - [HdiActivityRecognition](reference/hdi-apis/activity_recognition.md)
      - [Input](reference/hdi-apis/input.md)
      - [Light](reference/hdi-apis/light.md)
      - [Motion](reference/hdi-apis/motion.md)
      - [Power](reference/hdi-apis/power.md)
      - [Sensor](reference/hdi-apis/sensor.md)
      - [Thermal](reference/hdi-apis/thermal.md)
      - [USB](reference/hdi-apis/usb.md)
      - [Vibrator](reference/hdi-apis/vibrator.md)
      - [WLAN](reference/hdi-apis/wlan.md)
    - 头文件和结构体
      - 头文件
        - [audio_adapter.h](reference/hdi-apis/audio__adapter_8h.md)
        - [audio_attribute.h](reference/hdi-apis/audio__attribute_8h.md)
        - [audio_capture.h](reference/hdi-apis/audio__capture_8h.md)
        - [audio_control.h](reference/hdi-apis/audio__control_8h.md)
        - [audio_manager.h](reference/hdi-apis/audio__manager_8h.md)
        - [audio_render.h](reference/hdi-apis/audio__render_8h.md)
        - [audio_scene.h](reference/hdi-apis/audio__scene_8h.md)
        - [audio_types.h](reference/hdi-apis/audio__types_8h.md)
        - [audio_volume.h](reference/hdi-apis/audio__volume_8h.md)
        - [codec_callback_if.h](reference/hdi-apis/codec_callback_if_h.md)
        - [codec_common_type.h](reference/hdi-apis/codec_common_type_h.md)
        - [codec_component_if.h](reference/hdi-apis/codec_component_if_h.md)
        - [codec_component_manager.h](reference/hdi-apis/codec__component__manager_h.md)
        - [codec_component_type.h](reference/hdi-apis/codec__component__type_h.md)
        - [display_device.h](reference/hdi-apis/display__device_8h.md)
        - [display_gfx.h](reference/hdi-apis/display__gfx_8h.md)
        - [display_gralloc.h](reference/hdi-apis/display__gralloc_8h.md)
        - [display_layer.h](reference/hdi-apis/display__layer_8h.md)
        - [display_type.h](reference/hdi-apis/display__type_8h.md)
        - [display_vgu.h](reference/hdi-apis/display__vgu_8h.md)
        - [input_controller.h](reference/hdi-apis/input__controller_8h.md)
        - [input_manager.h](reference/hdi-apis/input__manager_8h.md)
        - [input_reporter.h](reference/hdi-apis/input__reporter_8h.md)
        - [input_type.h](reference/hdi-apis/input__type_8h.md)
        - [ActivityRecognitionTypes.idl](reference/hdi-apis/activity_recognition_types_idl.md)
        - [Types.idl](reference/hdi-apis/battery_types_idl.md)
        - [IExecutor.idl](reference/hdi-apis/face__auth_2_i_executor_8idl.md)
        - [IExecutorCallback.idl](reference/hdi-apis/face__auth_2_i_executor_callback_8idl.md)
        - [FaceAuthTypes.idl](reference/hdi-apis/_face_auth_types_8idl.md)
        - [PinAuthTypes.idl](reference/hdi-apis/_pin_auth_types_8idl.md)
        - [IExecutor.idl](reference/hdi-apis/pin__auth_2_i_executor_8idl.md)
        - [IExecutorCallback.idl](reference/hdi-apis/pin__auth_2_i_executor_callback_8idl.md)
        - [IFaceAuthInterface.idl](reference/hdi-apis/_i_face_auth_interface_8idl.md)
        - [IPinAuthInterface.idl](reference/hdi-apis/_i_pin_auth_interface_8idl.md)
        - [IUserAuthInterface.idl](reference/hdi-apis/_i_user_auth_interface_8idl.md)
        - [UserAuthTypes.idl](reference/hdi-apis/_user_auth_types_8idl.md)
        - [IActivityChangedCallback.idl](reference/hdi-apis/_i_activity_changed_callback_8idl.md)
        - [IActivityInterface.idl](reference/hdi-apis/_i_activity_interface_8idl.md)
        - [IBatteryCallback.idl](reference/hdi-apis/_i_battery_callback_8idl.md)
        - [IBatteryInterface.idl](reference/hdi-apis/_i_battery_interface_8idl.md)
        - [ICameraDevice.idl](reference/hdi-apis/_i_camera_device_8idl.md)
        - [ICameraDeviceCallback.idl](reference/hdi-apis/_i_camera_device_callback_8idl.md)
        - [ICameraHostCallback.idl](reference/hdi-apis/_i_camera_host_callback_8idl.md)
        - [ICameraHost.idl](reference/hdi-apis/_i_camera_host_8idl.md)
        - [ILightInterface.idl](reference/hdi-apis/_i_light_interface_8idl.md)
        - [IMotionCallback.idl](reference/hdi-apis/_i_motion_callback_8idl.md)
        - [IMotionInterface.idl](reference/hdi-apis/_i_motion_interface_8idl.md)
        - [IOfflineStreamOperator.idl](reference/hdi-apis/_i_offline_stream_operator_8idl.md)
        - [IPowerHdiCallback.idl](reference/hdi-apis/_i_power_hdi_callback_8idl.md)
        - [IPowerInterface.idl](reference/hdi-apis/_i_power_interface_8idl.md)
        - [ISensorCallback.idl](reference/hdi-apis/_i_sensor_callback_8idl.md)
        - [ISensorInterface.idl](reference/hdi-apis/_i_sensor_interface_8idl.md)
        - [IStreamOperator.idl](reference/hdi-apis/_i_stream_operator_8idl.md)
        - [IStreamOperatorCallback.idl](reference/hdi-apis/_i_stream_operator_callback_8idl.md)
        - [IThermalCallback.idl](reference/hdi-apis/_i_thermal_callback_8idl.md)
        - [IThermalInterface.idl](reference/hdi-apis/_i_thermal_interface_8idl.md)
        - [IUsbdBulkCallback.idl](reference/hdi-apis/_i_usbd_bulk_callback_8idl.md)
        - [IUsbInterface.idl](reference/hdi-apis/_i_usb_interface_8idl.md)
        - [IUsbdSubscriber.idl](reference/hdi-apis/_i_usbd_subscriber_8idl.md)
        - [IVibratorInterface.idl](reference/hdi-apis/_i_vibrator_interface_8idl.md)
        - [IWlanCallback.idl](reference/hdi-apis/_i_wlan_callback_8idl.md)
        - [IWlanInterface.idl](reference/hdi-apis/_i_wlan_interface_8idl.md)
        - [LightTypes.idl](reference/hdi-apis/_light_types_8idl.md)
        - [MotionTypes.idl](reference/hdi-apis/_motion_types_8idl.md)
        - [PowerTypes.idl](reference/hdi-apis/_power_types_8idl.md)
        - [SensorTypes.idl](reference/hdi-apis/_sensor_types_8idl.md)
        - [ThermalTypes.idl](reference/hdi-apis/_thermal_types_8idl.md)
        - [Types.idl](reference/hdi-apis/camera_2v1__0_2_types_8idl.md)
        - [UsbTypes.idl](reference/hdi-apis/_usb_types_8idl.md)
        - [VibratorTypes.idl](reference/hdi-apis/_vibrator_types_8idl.md)
        - [WlanTypes.idl](reference/hdi-apis/_wlan_types_8idl.md)
      - 结构体
        - [YUVDescInfo](reference/hdi-apis/_yun_desc_info_.md)
        - [ExtDataHandle](reference/hdi-apis/_ext_data_handle.md)
        - [ActRecognitionEvent](reference/hdi-apis/_act_recognition_event.md)
        - [AllocInfo](reference/hdi-apis/_alloc_info.md)
        - [Alignment](reference/hdi-apis/_alignment.md)
        - [AudioAdapter](reference/hdi-apis/_audio_adapter.md)
        - [AudioAdapterDescriptor](reference/hdi-apis/_audio_adapter_descriptor.md)
        - [AudioAttribute](reference/hdi-apis/_audio_attribute.md)
        - [AudioCapture](reference/hdi-apis/_audio_capture.md)
        - [AudioControl](reference/hdi-apis/_audio_control.md)
        - [AudioDevExtInfo](reference/hdi-apis/_audio_dev_ext_info.md)
        - [AudioDeviceDescriptor](reference/hdi-apis/_audio_device_descriptor.md)
        - [AudioManager](reference/hdi-apis/_audio_manager.md)
        - [AudioMixExtInfo](reference/hdi-apis/_audio_mix_ext_info.md)
        - [AudioMmapBufferDescriptor](reference/hdi-apis/_audio_mmap_buffer_descriptor.md)
        - [AudioPort](reference/hdi-apis/_audio_port.md)
        - [AudioPortCap](reference/hdi-apis/audio_portcap.md)
        - [AudioPortCapability](reference/hdi-apis/_audio_port_capability.md)
        - [AudioRender](reference/hdi-apis/_audio_render.md)
        - [AudioRoute](reference/hdi-apis/_audio_route.md)
        - [AudioRouteNode](reference/hdi-apis/_audio_route_node.md)
        - [AudioSampleAttributes](reference/hdi-apis/_audio_sample_attributes.md)
        - [AudioScene](reference/hdi-apis/_audio_scene.md)
        - [AudioSceneDescriptor](reference/hdi-apis/_audio_scene_descriptor.md)
        - [AudioSceneDescriptor::SceneDesc](reference/hdi-apis/union_audio_scene_descriptor_1_1_scene_desc.md)
        - [AudioSessionExtInfo](reference/hdi-apis/_audio_session_ext_info.md)
        - [AudioSubPortCapability](reference/hdi-apis/_audio_sub_port_capability.md)
        - [AudioTimeStamp](reference/hdi-apis/_audio_time_stamp.md)
        - [AudioVolume](reference/hdi-apis/_audio_volume.md)
        - [AuthResultInfo](reference/hdi-apis/_auth_result_info.md)
        - [AuthSolution](reference/hdi-apis/_auth_solution.md)
        - [BufferData](reference/hdi-apis/_buffer_data.md)
        - [BatteryInfo](reference/hdi-apis/_battery_info.md)
        - [CaptureEndedInfo](reference/hdi-apis/_capture_ended_info.md)
        - [CaptureErrorInfo](reference/hdi-apis/_capture_error_info.md)
        - [CaptureInfo](reference/hdi-apis/_capture_info.md)
        - [CodecCallbackType](reference/hdi-apis/_codec_callback_type.md)
        - [CodecCompCapability](reference/hdi-apis/_codec_comp_capability.md)
        - [CodecComponentManager](reference/hdi-apis/_codec_component_manager.md)
        - [CodecComponentType](reference/hdi-apis/_codec_component_type.md)
        - [ColorValue](reference/hdi-apis/union_color_value.md)
        - [CompVerInfo](reference/hdi-apis/_comp_ver_info.md)
        - [CredentialInfo](reference/hdi-apis/_credential_info.md)
        - [DeviceFuncs](reference/hdi-apis/_device_funcs.md)
        - [DisplayCapability](reference/hdi-apis/_display_capability.md)
        - [DisplayInfo](reference/hdi-apis/_display_info.md)
        - [DisplayModeInfo](reference/hdi-apis/_display_mode_info.md)
        - [EnrolledInfo](reference/hdi-apis/_enrolled_info.md)
        - [EnrollParam](reference/hdi-apis/_enroll_param.md)
        - [EnrollResultInfo](reference/hdi-apis/_enroll_resultinfo.md)
        - [EventInfo](reference/hdi-apis/_event_info.md)
        - [ExecutorInfo](reference/hdi-apis/_executor_info.md)
        - [ExecutorInfo](reference/hdi-apis/_user_executor_info.md)
        - [ExecutorRegisterInfo](reference/hdi-apis/_executor_register_info.md)
        - [ExecutorSendMsg](reference/hdi-apis/_executor_send_msg.md)
        - [GetBufferHandleUsageParams](reference/hdi-apis/_get_buffer_handle_usage_params.md)
        - [GfxFuncs](reference/hdi-apis/_gfx_funcs.md)
        - [GfxOpt](reference/hdi-apis/_gfx_opt.md)
        - [GrallocFuncs](reference/hdi-apis/_gralloc_funcs.md)
        - [HdfFeatureInfo](reference/hdi-apis/_hdf_feature_info.md)
        - [HdfLightColor](reference/hdi-apis/_hdf_light_color.md)
        - [HdfLightEffect](reference/hdi-apis/_hdf_light_effect.md)
        - [HdfLightFlashEffect](reference/hdi-apis/_hdf_light_flash_effect.md)
        - [HdfLightInfo](reference/hdi-apis/_hdf_light_info.md)
        - [HdfMotionEvent](reference/hdi-apis/_hdf_motion_event.md)
        - [HdfNetDeviceInfo](reference/hdi-apis/_hdf_net_device_info.md)
        - [HdfNetDeviceInfoResult](reference/hdi-apis/_hdf_net_device_info_result.md)
        - [HdfSensorEvents](reference/hdi-apis/_hdf_sensor_events.md)
        - [HdfSensorInformation](reference/hdi-apis/_hdf_sensor_information.md)
        - [HdfStaInfo](reference/hdi-apis/_hdf_sta_info.md)
        - [HdfThermalCallbackInfo](reference/hdi-apis/_hdf_thermal_callback_info.md)
        - [HdfVibratorInfo](reference/hdi-apis/_hdf_vibrator_info.md)
        - [HdfWifiDriverScanSsid](reference/hdi-apis/_hdf_wifi_driver_scan_ssid.md)
        - [HdfWifiInfo](reference/hdi-apis/_hdf_wifi_info.md)
        - [HdfWifiScan](reference/hdi-apis/_hdf_wifi_scan.md)
        - [HdfWifiScanResult](reference/hdi-apis/_hdf_wifi_scan_result.md)
        - [HDRCapability](reference/hdi-apis/_h_d_r_capability.md)
        - [HDRMetaData](reference/hdi-apis/_h_d_r_meta_data.md)
        - [IActivityChangedCallback](reference/hdi-apis/interface_i_activity_changed_callback.md)
        - [IActivityInterface](reference/hdi-apis/interface_i_activity_interface.md)
        - [IBatteryCallback](reference/hdi-apis/interface_i_battery_callback.md)
        - [IBatteryInterface](reference/hdi-apis/interface_i_battery_interface.md)
        - [ICameraDevice](reference/hdi-apis/interface_i_camera_device.md)
        - [ICameraDeviceCallback](reference/hdi-apis/interface_i_camera_device_callback.md)
        - [ICameraHost](reference/hdi-apis/interface_i_camera_host.md)
        - [ICameraHostCallback](reference/hdi-apis/interface_i_camera_host_callback.md)
        - [ICircle](reference/hdi-apis/_i_circle.md)
        - [IdentifyResultInfo](reference/hdi-apis/_identify_result_info.md)
        - [IExecutor](reference/hdi-apis/interface_i_executor.md)
        - [IExecutor](reference/hdi-apis/interface_pin_i_executor.md)
        - [IExecutorCallback](reference/hdi-apis/interface_i_executor_callback.md)
        - [IExecutorCallback](reference/hdi-apis/interface_pin_i_executor_callback.md)
        - [IFaceAuthInterface](reference/hdi-apis/interface_i_face_auth_interface.md)
        - [ILine](reference/hdi-apis/_i_line.md)
        - [IInputInterface](reference/hdi-apis/_i_input_interface.md)
        - [ILightInterface](reference/hdi-apis/interface_i_light_interface.md)
        - [IMotionCallback](reference/hdi-apis/interface_i_motion_callback.md)
        - [IMotionInterface](reference/hdi-apis/interface_i_motion_interface.md)
        - [InputController](reference/hdi-apis/_input_controller.md)
        - [InputDevAbility](reference/hdi-apis/_input_dev_ability.md)
        - [InputDevAttr](reference/hdi-apis/_input_dev_attr.md)
        - [InputDevDesc](reference/hdi-apis/_input_dev_desc.md)
        - [InputDeviceInfo](reference/hdi-apis/_input_device_info.md)
        - [InputDevIdentify](reference/hdi-apis/_input_dev_identify.md)
        - [InputDimensionInfo](reference/hdi-apis/_input_dimension_info.md)
        - [InputEventCb](reference/hdi-apis/_input_event_cb.md)
        - [InputEventPackage](reference/hdi-apis/_input_event_package.md)
        - [IPowerHdiCallback](reference/hdi-apis/interface_i_power_hdi_callback.md)
        - [InputExtraCmd](reference/hdi-apis/_input_extra_cmd.md)
        - [InputHostCb](reference/hdi-apis/_input_host_cb.md)
        - [InputHotPlugEvent](reference/hdi-apis/_input_hot_plug_event.md)
        - [InputManager](reference/hdi-apis/_input_manager.md)
        - [InputReporter](reference/hdi-apis/_input_reporter.md)
        - [IOfflineStreamOperator](reference/hdi-apis/interface_i_offline_stream_operator.md)
        - [IPinAuthInterface](reference/hdi-apis/interface_i_pin_auth_interface.md)
        - [IPowerInterface](reference/hdi-apis/interface_i_power_interface.md)
        - [IRect](reference/hdi-apis/_i_rect.md)
        - [ISensorCallback](reference/hdi-apis/interface_i_sensor_callback.md)
        - [ISensorInterface](reference/hdi-apis/interface_i_sensor_interface.md)
        - [IStreamOperator](reference/hdi-apis/interface_i_stream_operator.md)
        - [IStreamOperatorCallback](reference/hdi-apis/interface_i_stream_operator_callback.md)
        - [ISurface](reference/hdi-apis/_i_surface.md)
        - [IThermalCallback](reference/hdi-apis/interface_i_thermal_callback.md)
        - [IThermalInterface](reference/hdi-apis/interface_i_thermal_interface.md)
        - [IUsbdBulkCallback](reference/hdi-apis/interface_i_usbd_bulk_callback.md)
        - [IUsbdSubscriber](reference/hdi-apis/interface_i_usbd_subscriber.md)
        - [IUsbInterface](reference/hdi-apis/interface_i_usb_interface.md)
        - [IUserAuthInterface](reference/hdi-apis/interface_i_user_auth_interface.md)
        - [IVibratorInterface](reference/hdi-apis/interface_i_vibrator_interface.md)
        - [IWlanCallback](reference/hdi-apis/interface_i_wlan_callback.md)
        - [IWlanInterface](reference/hdi-apis/interface_i_wlan_interface.md)
        - [LayerAlpha](reference/hdi-apis/_layer_alpha.md)
        - [LayerBuffer](reference/hdi-apis/_layer_buffer.md)
        - [LayerFuncs](reference/hdi-apis/_layer_funcs.md)
        - [LayerInfo](reference/hdi-apis/_layer_info.md)
        - [MeasChannelParam](reference/hdi-apis/_meas_channel_param.md)
        - [MeasChannelResult](reference/hdi-apis/_meas_channel_result.md)
        - [OmxCodecBuffer](reference/hdi-apis/_omx_codec_buffer.md)
        - [PortCap](reference/hdi-apis/union_port_cap.md)
        - [PortInfo](reference/hdi-apis/_port_info.md)
        - [PresentTimestamp](reference/hdi-apis/_present_timestamp.md)
        - [PropertyObject](reference/hdi-apis/_property_object.md)
        - [ProjectionScreenCmdParam](reference/hdi-apis/_projection_screen_cmd_param.md)
        - [RangeValue](reference/hdi-apis/_range_value.md)
        - [Rect](reference/hdi-apis/_rect.md)
        - [Rectangle](reference/hdi-apis/_rectangle.md)
        - [RGBColor](reference/hdi-apis/_r_g_b_color.md)
        - [ScheduleInfo](reference/hdi-apis/_schedule_info.md)
        - [StreamAttribute](reference/hdi-apis/_stream_attribute.md)
        - [StreamInfo](reference/hdi-apis/_stream_info.md)
        - [SupportBufferType](reference/hdi-apis/_support_buffer_type.md)
        - [TemplateInfo](reference/hdi-apis/_template_info.md)
        - [ThermalZoneInfo](reference/hdi-apis/_thermal_zone_info.md)
        - [UsbCtrlTransfer](reference/hdi-apis/_usb_ctrl_transfer.md)
        - [UsbDev](reference/hdi-apis/_usb_dev.md)
        - [USBDeviceInfo](reference/hdi-apis/_u_s_b_device_info.md)
        - [UsbPipe](reference/hdi-apis/_usb_pipe.md)
        - [UseBufferType](reference/hdi-apis/_use_buffer_type.md)
        - [VerifyAllocInfo](reference/hdi-apis/_verify_alloc_info.md)
        - [VGUBuffer](reference/hdi-apis/_v_g_u_buffer.md)
        - [VGUColorStop](reference/hdi-apis/_v_g_u_color_stop.md)
        - [VGUConic](reference/hdi-apis/_v_g_u_conic.md)
        - [VGUFillAttr](reference/hdi-apis/_v_g_u_fill_attr.md)
        - [VGUFuncs](reference/hdi-apis/_v_g_u_funcs.md)
        - [VGUGradient](reference/hdi-apis/_v_g_u_gradient.md)
        - [VGUImage](reference/hdi-apis/_v_g_u_image.md)
        - [VGULinear](reference/hdi-apis/_v_g_u_linear.md)
        - [VGUMaskLayer](reference/hdi-apis/_v_g_u_mask_layer.md)
        - [VGUMatrix3](reference/hdi-apis/_v_g_u_matrix3.md)
        - [VGUPaintStyle](reference/hdi-apis/_v_g_u_paint_style.md)
        - [VGUPath](reference/hdi-apis/_v_g_u_path.md)
        - [VGUPattern](reference/hdi-apis/_v_g_u_pattern.md)
        - [VGUPoint](reference/hdi-apis/_v_g_u_point.md)
        - [VGURadial](reference/hdi-apis/_v_g_u_radial.md)
        - [VGURect](reference/hdi-apis/_v_g_u_rect.md)
        - [VGUSolid](reference/hdi-apis/_v_g_u_solid.md)
        - [VGUStrokeAttr](reference/hdi-apis/_v_g_u_stroke_attr.md)
        - [VGUSurface](reference/hdi-apis/_v_g_u_surface.md)
        - [VideoPortCap](reference/hdi-apis/_video_port_cap.md)
        - [WifiStationInfo](reference/hdi-apis/_wifi_station_info.md)
        - [WRGBColor](reference/hdi-apis/_w_r_g_b_color.md)

   
  - CMSIS API参考
    - [CMSIS](reference/kernel/cmsis/_c_m_s_i_s-_r_t_o_s.md)
    - 结构体
        - [osEventFlagsAttr_t](reference/kernel/cmsis/os_event_flags_attr__t.md)
        - [osMemoryPoolAttr_t](reference/kernel/cmsis/os_memory_pool_attr__t.md)
        - [osMessageQueueAttr_t](reference/kernel/cmsis/os_message_queue_attr__t.md)
        - [osMutexAttr_t](reference/kernel/cmsis/os_mutex_attr__t.md)
        - [osSemaphoreAttr_t](reference/kernel/cmsis/os_semaphore_attr__t.md)
        - [osThreadAttr_t](reference/kernel/cmsis/os_thread_attr__t.md)
        - [osTimerAttr_t](reference/kernel/cmsis/os_timer_attr__t.md)
        - [osVersion_t](reference/kernel/cmsis/os_version__t.md)

   