# SHELL

OpenHarmony内核提供的Shell支持调试常用的基本功能，包含系统、文件、网络相关命令。同时OpenHarmony内核的Shell支持添加新的命令，可以根据需求来进行定制。

Shell功能仅供调试使用，暂不支持tab按键补全，按键回退等功能。

部分命令需要通过make menuconfig开启对应选项才可使用。

## 常用命令介绍

### cat

用于显示文本文件的内容。需开启LOSCFG_FS_VFS。

###### 命令格式

cat [FILE]

###### 参数说明

| 参数 | 参数说明   | 取值范围       |
| ---- | ---------- | -------------- |
| FILE | 文件路径。 | 已存在的文件。 |

### cd

用来改变当前目录。需开启LOSCFG_FS_VFS。

###### 命令格式

cd [path]

###### 参数说明

| 参数 | 参数说明   | 取值范围       |
| ---- | ---------- | -------------- |
| path | 文件路径。 | 已存在的路径。 |

### cp

拷贝文件，创建一份副本。需开启LOSCFG_FS_VFS。

###### 命令格式

cp [SOURCEFILE] [DESTFILE]

###### 参数说明

| 参数       | 参数说明               | 取值范围                                  |
| ---------- | ---------------------- | ----------------------------------------- |
| SOURCEFILE | 源文件路径。文件路径。 | 目前只支持文件,不支持目录；文件不可为空。 |
| DESTFILE   | 目的文件路径。         | 支持目录以及文件名；目录需有效。          |

### date

用于查询系统日期和时间。

###### 命令格式

date

###### 参数说明

无

### free

显示系统内存的使用情况。

###### 命令格式

free [ -k | -m ]

###### 参数说明

| 参数 | 参数说明          | 取值范围 |
| ---- | ----------------- | -------- |
| -k   | 以KiB为单位显示。 | N/A      |
| -m   | 以MiB为单位显示。 | N/A      |

### help

显示当前操作系统内所有操作指令。

###### 命令格式

help

###### 参数说明

无

### ifconfig

用来查询网卡的IP地址、网络掩码、网关、硬件mac地址等参数。需开启LWIP_SHELLCMD_ENABLE。

###### 命令格式

ifconfig

###### 参数说明

无

### ls

用来显示当前目录的内容。需开启LOSCFG_FS_VFS。

###### 命令格式

###### ls  [DIRECTORY]

| 参数      | 参数说明   | 取值范围                                                     |
| --------- | ---------- | ------------------------------------------------------------ |
| DIRECTORY | 文件路径。 | DIRECTORY为空时，显示当前目录的内容。<br/>DIRECTORY为有效目录路径时，会显示对应目录下的内容。<br/>当前LiteOS-M不支持根目录 "/"。 |

### memusage

用来显示内存使用水线。

###### 命令格式

###### memusage [-k/-m]

| 参数 | 参数说明          | 取值范围 |
| ---- | ----------------- | -------- |
| -k   | 以KiB为单位显示。 | N/A      |
| -m   | 以MiB为单位显示。 | N/A      |

### mkdir

用来创建一个目录。需开启LOSCFG_FS_VFS。

###### 命令格式

###### mkdir [DIRECTORY]

| 参数      | 参数说明   | 取值范围                              |
| --------- | ---------- | ------------------------------------- |
| DIRECTORY | 文件路径。 | DIRECTORY可以传入绝对路径和相对路径。 |

### ping

用来测试网络连接是否正常。需开启LWIP_SHELLCMD_ENABLE。

###### 命令格式

###### ping [ip]

| 参数 | 参数说明                       | 取值范围 |
| ---- | ------------------------------ | -------- |
| ip   | 要测试是否网络连通的IPv4地址。 | N/A      |

### pwd

用来显示当前路径。需开启LOSCFG_FS_VFS。

###### 命令格式

###### pwd

### rm

用来删除文件或文件夹。需开启LOSCFG_FS_VFS。

###### 命令格式

###### rm [FILE] or rm [-r/-R] [FILE]

| 参数  | 参数说明                        | 取值范围                         |
| ----- | ------------------------------- | -------------------------------- |
| FILE  | 文件名，可以是文件或者文件夹 。 | FILE可以传入绝对路径和相对路径。 |
| -r/-R | FILE是文件夹时需要有-r /-R。    | N/A                              |

### rmdir

用来删除文件夹。需开启LOSCFG_FS_VFS。

###### 命令格式

###### rmdir [DIRECTORY]

| 参数      | 参数说明   | 取值范围                              |
| --------- | ---------- | ------------------------------------- |
| DIRECTORY | 文件路径。 | DIRECTORY可以传入绝对路径和相对路径。 |

### task

用来显示当前各任务状态。

###### 命令格式

###### task

显示内容主要包括任务号，优先级，状态，栈信息，信号，事件，CPU占用率，任务名称等

### touch

用来创建文件。需开启LOSCFG_FS_VFS。

###### 命令格式

###### touch [FILE]

| 参数 | 参数说明 | 取值范围                         |
| ---- | -------- | -------------------------------- |
| FILE | 文件名。 | FILE可以传入绝对路径和相对路径。 |

### stack

用来查看指定任务的栈内容。需开启编译选项 LOSCFG_DEBUG_TOOLS，功能开启会影响性能。

###### 命令格式

###### stack [ID]

| 参数 | 参数说明 | 取值范围                 |
| ---- | -------- | ------------------------ |
| ID   | 任务ID。 | 任务ID对应的任务需存在。 |

### hwi

用来查看中断的占用率。需开启编译选项 LOSCFG_DEBUG_TOOLS，功能开启会影响性能。

###### 命令格式

###### hwi

### st

用来查看调度信息。需开启编译选项 LOSCFG_DEBUG_TOOLS，功能开启会影响性能。

###### 命令格式

###### st -s | st -e

| 参数 | 参数说明               | 取值范围 |
| ---- | ---------------------- | -------- |
| -s   | 开始记录调度信息       | N/A      |
| -e   | 停止记录并打印调度信息 | N/A      |

