# 常用组件说明

组件是构建页面的核心，每个组件通过对数据和方法的简单封装，实现独立的可视、可交互功能单元。组件之间相互独立，随取随用，也可以在需求相同的地方重复使用。

声明式开发范式目前可供选择的组件如下表所示。

|           组件类型           |                主要组件                                     |
| ---------------------------- | ---------------------------------------------------------- |
| [基础组件](../reference/arkui-ts/ts-basic-components-blank.md) |  Blank、Button、Checkbox、CheckboxGroup、DataPanel、DatePicker、Divider、Gauge、Image、ImageAnimator、LoadingProgress、Marquee、Navigation、PatternLock、PluginComponent、Progress、QRCode、Radio、Rating、RemoteWindow、RichText、ScrollBar、Search、Select、Slider、Span、Stepper、StepperItem、Text、TextArea、TextClock、TextInput、TextPicker、TextTimer、TimePicker、Toggle、Web、XComponent    |
| [容器组件](../reference/arkui-ts/ts-container-ability-component.md) | AbilityComponent、AlphabetIndexer、Badge、Column、ColumnSplit、Counter、Flex、FlowItem、GridContainer、GridCol、GridRow、Grid、GridItem、List、ListItem、ListItemGroup、Navigator、Panel、Refresh、RelativeContainer、Row、RowSplit、Scroll、SideBarContainer、Stack、Swiper、Tabs、TabContent、WaterFlow   |
| [媒体组件](../reference/arkui-ts/ts-media-components-video.md) |    Video    |
| [绘制组件](../reference/arkui-ts/ts-drawing-components-circle.md) | Circle、Ellipse、Line、Polyline、Polygon、Path、Rect、Shape   |
| [画布组件](../reference/arkui-ts/ts-components-canvas-canvas.md) |   Canvas     |


## 相关实例

基于ArkTS的常用组件开发，有以下相关实例可供参考：

- [`Shopping`：购物示例应用（ArkTS）（API9）](https://gitee.com/openharmony/applications_app_samples/tree/OpenHarmony-3.2-Release/AppSample/Shopping)

- [`Canvas`：画布组件（ArkTS）（API8）](https://gitee.com/openharmony/applications_app_samples/tree/OpenHarmony-3.2-Release/ETSUI/Canvas)

- [`Clock`：简单时钟（ArkTS）（API9）](https://gitee.com/openharmony/applications_app_samples/tree/OpenHarmony-3.2-Release/Preset/Clock)

- [`PatternLock`：图案密码锁组件（ArkTS）（API9）](https://gitee.com/openharmony/applications_app_samples/tree/OpenHarmony-3.2-Release/ETSUI/PatternLock)

- [`Search`：Search组件（ArkTS）（API9）](https://gitee.com/openharmony/applications_app_samples/tree/OpenHarmony-3.2-Release/ETSUI/Search)

- [`QRCode`：二维码（ArkTS）（API9）（Full SDK）](https://gitee.com/openharmony/applications_app_samples/tree/OpenHarmony-3.2-Release/ETSUI/QRCode)

- [`Gallery`：组件集合（ArkTS）（API8）](https://gitee.com/openharmony/applications_app_samples/tree/OpenHarmony-3.2-Release/ETSUI/Gallery)

- [List组件的使用之商品列表（ArkTS）（API9）](https://gitee.com/openharmony/codelabs/tree/master/ETSUI/List_HDC)

- [List组件的使用之设置项（ArkTS）（API9）](https://gitee.com/openharmony/codelabs/tree/master/ETSUI/List_HDC)
